/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYBubbleRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    public static final long serialVersionUID = -5221991598674249125L;
    public static final int SCALE_ON_BOTH_AXES = 0;
    public static final int SCALE_ON_DOMAIN_AXIS = 1;
    public static final int SCALE_ON_RANGE_AXIS = 2;
    private int scaleType;

    public XYBubbleRenderer() {
        this(0);
    }

    public XYBubbleRenderer(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Invalid 'scaleType'.");
        }
        this.scaleType = n2;
        this.setBaseLegendShape(new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
    }

    public int getScaleType() {
        return this.scaleType;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        Object object;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = Double.NaN;
        if (xYDataset instanceof XYZDataset) {
            object = (XYZDataset)xYDataset;
            d4 = object.getZValue(n2, n3);
        }
        if (!Double.isNaN(d4)) {
            EntityCollection entityCollection;
            double d5;
            double d6;
            object = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
            double d7 = valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)object);
            double d8 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge);
            switch (this.getScaleType()) {
                case 1: {
                    double d9 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)object);
                    d5 = d6 = valueAxis.valueToJava2D(d4, rectangle2D, (RectangleEdge)object) - d9;
                    break;
                }
                case 2: {
                    double d10 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d6 = d5 = d10 - valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge);
                    break;
                }
                default: {
                    double d11 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)object);
                    double d12 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d6 = valueAxis.valueToJava2D(d4, rectangle2D, (RectangleEdge)object) - d11;
                    d5 = d12 - valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge);
                }
            }
            d6 = Math.abs(d6);
            d5 = Math.abs(d5);
            Ellipse2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Ellipse2D.Double(d7 - d6 / 2.0, d8 - d5 / 2.0, d6, d5);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Ellipse2D.Double(d8 - d5 / 2.0, d7 - d6 / 2.0, d5, d6);
            } else {
                throw new IllegalStateException();
            }
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            graphics2D.fill(double_);
            graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
            graphics2D.draw(double_);
            if (this.isItemLabelVisible(n2, n3)) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d7, d8, false);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d8, d7, false);
                }
            }
            if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null && double_.intersects(rectangle2D)) {
                this.addEntity(entityCollection, double_, xYDataset, n2, n3, double_.getCenterX(), double_.getCenterY());
            }
            int n5 = xYPlot.getDomainAxisIndex(valueAxis);
            int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d2, d3, n5, n6, d7, d8, plotOrientation);
        }
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n2);
        if (xYDataset != null && this.getItemVisible(n3, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
            }
            Shape shape = this.lookupLegendShape(n3);
            Paint paint = this.lookupSeriesPaint(n3);
            Paint paint2 = this.lookupSeriesOutlinePaint(n3);
            Stroke stroke = this.lookupSeriesOutlineStroke(n3);
            legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint3 = this.lookupLegendTextPaint(n3);
            if (paint3 != null) {
                legendItem.setLabelPaint(paint3);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n2);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
            legendItem.setSeriesIndex(n3);
        }
        return legendItem;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBubbleRenderer)) {
            return false;
        }
        XYBubbleRenderer xYBubbleRenderer = (XYBubbleRenderer)object;
        if (this.scaleType != xYBubbleRenderer.scaleType) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

