/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.GradientXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements Serializable,
Cloneable,
XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = 770559577251370036L;
    private static XYBarPainter defaultBarPainter = new GradientXYBarPainter();
    private static boolean defaultShadowsVisible = true;
    private double base;
    private boolean useYInterval;
    private double margin;
    private boolean drawBarOutline;
    private GradientPaintTransformer gradientPaintTransformer;
    private transient Shape legendBar;
    private ItemLabelPosition positiveItemLabelPositionFallback;
    private ItemLabelPosition negativeItemLabelPositionFallback;
    private XYBarPainter barPainter;
    private boolean shadowsVisible;
    private double shadowXOffset;
    private double shadowYOffset;
    private double barAlignmentFactor;

    public static XYBarPainter getDefaultBarPainter() {
        return defaultBarPainter;
    }

    public static void setDefaultBarPainter(XYBarPainter xYBarPainter) {
        ParamChecks.nullNotPermitted(xYBarPainter, "painter");
        defaultBarPainter = xYBarPainter;
    }

    public static boolean getDefaultShadowsVisible() {
        return defaultShadowsVisible;
    }

    public static void setDefaultShadowsVisible(boolean bl2) {
        defaultShadowsVisible = bl2;
    }

    public XYBarRenderer() {
        this(0.0);
    }

    public XYBarRenderer(double d2) {
        this.margin = d2;
        this.base = 0.0;
        this.useYInterval = false;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
        this.drawBarOutline = false;
        this.legendBar = new Rectangle2D.Double(-3.0, -5.0, 6.0, 10.0);
        this.barPainter = XYBarRenderer.getDefaultBarPainter();
        this.shadowsVisible = XYBarRenderer.getDefaultShadowsVisible();
        this.shadowXOffset = 4.0;
        this.shadowYOffset = 4.0;
        this.barAlignmentFactor = -1.0;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d2) {
        this.base = d2;
        this.fireChangeEvent();
    }

    public boolean getUseYInterval() {
        return this.useYInterval;
    }

    public void setUseYInterval(boolean bl2) {
        if (this.useYInterval != bl2) {
            this.useYInterval = bl2;
            this.fireChangeEvent();
        }
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d2) {
        this.margin = d2;
        this.fireChangeEvent();
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl2) {
        this.drawBarOutline = bl2;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    public Shape getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "bar");
        this.legendBar = shape;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.positiveItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.negativeItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public XYBarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(XYBarPainter xYBarPainter) {
        ParamChecks.nullNotPermitted(xYBarPainter, "painter");
        this.barPainter = xYBarPainter;
        this.fireChangeEvent();
    }

    public boolean getShadowsVisible() {
        return this.shadowsVisible;
    }

    public void setShadowVisible(boolean bl2) {
        this.shadowsVisible = bl2;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d2) {
        this.shadowXOffset = d2;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d2) {
        this.shadowYOffset = d2;
        this.fireChangeEvent();
    }

    public double getBarAlignmentFactor() {
        return this.barAlignmentFactor;
    }

    public void setBarAlignmentFactor(double d2) {
        this.barAlignmentFactor = d2;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYBarRendererState xYBarRendererState = new XYBarRendererState(plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxisForDataset(xYPlot.indexOf(xYDataset));
        xYBarRendererState.setG2Base(valueAxis.valueToJava2D(this.base, rectangle2D, xYPlot.getRangeAxisEdge()));
        return xYBarRendererState;
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        String string;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n2);
        if (xYDataset == null) {
            return null;
        }
        XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
        String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n3);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
        }
        Shape shape = this.legendBar;
        Paint paint = this.lookupSeriesPaint(n3);
        Paint paint2 = this.lookupSeriesOutlinePaint(n3);
        Stroke stroke = this.lookupSeriesOutlineStroke(n3);
        LegendItem legendItem = this.drawBarOutline ? new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2) : new LegendItem(string, string2, string3, string4, shape, paint);
        legendItem.setLabelFont(this.lookupLegendTextFont(n3));
        Paint paint3 = this.lookupLegendTextPaint(n3);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(xYDataset);
        legendItem.setDatasetIndex(n2);
        legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
        legendItem.setSeriesIndex(n3);
        if (this.getGradientPaintTransformer() != null) {
            legendItem.setFillPaintTransformer(this.getGradientPaintTransformer());
        }
        return legendItem;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        double d2;
        double d3;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.useYInterval) {
            d3 = intervalXYDataset.getStartYValue(n2, n3);
            d2 = intervalXYDataset.getEndYValue(n2, n3);
        } else {
            d3 = this.base;
            d2 = intervalXYDataset.getYValue(n2, n3);
        }
        if (Double.isNaN(d3) || Double.isNaN(d2)) {
            return;
        }
        if (d3 <= d2 ? !valueAxis2.getRange().intersects(d3, d2) : !valueAxis2.getRange().intersects(d2, d3)) {
            return;
        }
        double d4 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d6 = Math.min(d4, d5);
        double d7 = Math.max(d4, d5);
        double d8 = intervalXYDataset.getStartXValue(n2, n3);
        if (Double.isNaN(d8)) {
            return;
        }
        double d9 = intervalXYDataset.getEndXValue(n2, n3);
        if (Double.isNaN(d9)) {
            return;
        }
        if (d8 <= d9 ? !valueAxis.getRange().intersects(d8, d9) : !valueAxis.getRange().intersects(d9, d8)) {
            return;
        }
        if (this.barAlignmentFactor >= 0.0 && this.barAlignmentFactor <= 1.0) {
            double d10 = intervalXYDataset.getXValue(n2, n3);
            double d11 = d9 - d8;
            d8 = d10 - d11 * this.barAlignmentFactor;
            d9 = d8 + d11;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d12 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        double d13 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
        double d14 = Math.max(1.0, Math.abs(d13 - d12));
        double d15 = Math.min(d12, d13);
        if (this.getMargin() > 0.0) {
            double d16 = d14 * this.getMargin();
            d14 -= d16;
            d15 += d16 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d6 = Math.max(d6, rectangle2D.getMinX());
            d7 = Math.min(d7, rectangle2D.getMaxX());
            double_ = new Rectangle2D.Double(d6, d15, d7 - d6, d14);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d6 = Math.max(d6, rectangle2D.getMinY());
            d7 = Math.min(d7, rectangle2D.getMaxY());
            double_ = new Rectangle2D.Double(d15, d6, d14, d7 - d6);
        }
        boolean bl2 = d2 > 0.0;
        boolean bl3 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge2 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl2 && bl3 || !bl2 && !bl3 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl2 && !bl3 || !bl2 && bl3 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (this.getShadowsVisible()) {
            this.barPainter.paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge2, !this.useYInterval);
        }
        this.barPainter.paintBar(graphics2D, this, n2, n3, double_, rectangleEdge2);
        if (this.isItemLabelVisible(n2, n3)) {
            XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
            this.drawItemLabel(graphics2D, xYDataset, n2, n3, xYPlot, xYItemLabelGenerator, double_, d2 < 0.0);
        }
        double d17 = (d8 + d9) / 2.0;
        double d18 = xYDataset.getYValue(n2, n3);
        double d19 = valueAxis.valueToJava2D(d17, rectangle2D, rectangleEdge);
        double d20 = valueAxis2.valueToJava2D(d18, rectangle2D, xYPlot.getRangeAxisEdge());
        int n5 = xYPlot.getDomainAxisIndex(valueAxis);
        int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d17, d18, n5, n6, d19, d20, xYPlot.getOrientation());
        EntityCollection entityCollection = xYItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addEntity(entityCollection, double_, xYDataset, n2, n3, 0.0, 0.0);
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, XYDataset xYDataset, int n2, int n3, XYPlot xYPlot, XYItemLabelGenerator xYItemLabelGenerator, Rectangle2D rectangle2D, boolean bl2) {
        Shape shape;
        if (xYItemLabelGenerator == null) {
            return;
        }
        String string = xYItemLabelGenerator.generateLabel(xYDataset, n2, n3);
        if (string == null) {
            return;
        }
        Font font = this.getItemLabelFont(n2, n3);
        graphics2D.setFont(font);
        Paint paint = this.getItemLabelPaint(n2, n3);
        graphics2D.setPaint(paint);
        ItemLabelPosition itemLabelPosition = !bl2 ? this.getPositiveItemLabelPosition(n2, n3) : this.getNegativeItemLabelPosition(n2, n3);
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        if (this.isInternalAnchor(itemLabelPosition.getItemLabelAnchor()) && (shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor())) != null && !rectangle2D.contains(shape.getBounds2D()) && (itemLabelPosition = !bl2 ? this.getPositiveItemLabelPositionFallback() : this.getNegativeItemLabelPositionFallback()) != null) {
            point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        }
        if (itemLabelPosition != null) {
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        double d2 = this.getItemLabelAnchorOffset();
        double d3 = rectangle2D.getX() - d2;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getX() + d2;
        double d6 = rectangle2D.getCenterX();
        double d7 = rectangle2D.getMaxX() - d2;
        double d8 = rectangle2D.getMaxX();
        double d9 = rectangle2D.getMaxX() + d2;
        double d10 = rectangle2D.getMaxY() + d2;
        double d11 = rectangle2D.getMaxY();
        double d12 = rectangle2D.getMaxY() - d2;
        double d13 = rectangle2D.getCenterY();
        double d14 = rectangle2D.getMinY() + d2;
        double d15 = rectangle2D.getMinY();
        double d16 = rectangle2D.getMinY() - d2;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d7, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d7, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d7, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d7, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d7, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d6, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d5, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d5, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d5, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d6, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d8, d16);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d9, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d9, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d9, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d8, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d6, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d4, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d3, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d3, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d3, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d4, d16);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d6, d16);
        }
        return double_;
    }

    private boolean isInternalAnchor(ItemLabelAnchor itemLabelAnchor) {
        return itemLabelAnchor == ItemLabelAnchor.CENTER || itemLabelAnchor == ItemLabelAnchor.INSIDE1 || itemLabelAnchor == ItemLabelAnchor.INSIDE2 || itemLabelAnchor == ItemLabelAnchor.INSIDE3 || itemLabelAnchor == ItemLabelAnchor.INSIDE4 || itemLabelAnchor == ItemLabelAnchor.INSIDE5 || itemLabelAnchor == ItemLabelAnchor.INSIDE6 || itemLabelAnchor == ItemLabelAnchor.INSIDE7 || itemLabelAnchor == ItemLabelAnchor.INSIDE8 || itemLabelAnchor == ItemLabelAnchor.INSIDE9 || itemLabelAnchor == ItemLabelAnchor.INSIDE10 || itemLabelAnchor == ItemLabelAnchor.INSIDE11 || itemLabelAnchor == ItemLabelAnchor.INSIDE12;
    }

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        return this.findDomainBounds(xYDataset, true);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, this.useYInterval);
    }

    @Override
    public Object clone() {
        XYBarRenderer xYBarRenderer = (XYBarRenderer)super.clone();
        if (this.gradientPaintTransformer != null) {
            xYBarRenderer.gradientPaintTransformer = (GradientPaintTransformer)ObjectUtilities.clone(this.gradientPaintTransformer);
        }
        xYBarRenderer.legendBar = ShapeUtilities.clone(this.legendBar);
        return xYBarRenderer;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBarRenderer)) {
            return false;
        }
        XYBarRenderer xYBarRenderer = (XYBarRenderer)object;
        if (this.base != xYBarRenderer.base) {
            return false;
        }
        if (this.drawBarOutline != xYBarRenderer.drawBarOutline) {
            return false;
        }
        if (this.margin != xYBarRenderer.margin) {
            return false;
        }
        if (this.useYInterval != xYBarRenderer.useYInterval) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, xYBarRenderer.gradientPaintTransformer)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendBar, xYBarRenderer.legendBar)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionFallback, xYBarRenderer.positiveItemLabelPositionFallback)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionFallback, xYBarRenderer.negativeItemLabelPositionFallback)) {
            return false;
        }
        if (!this.barPainter.equals(xYBarRenderer.barPainter)) {
            return false;
        }
        if (this.shadowsVisible != xYBarRenderer.shadowsVisible) {
            return false;
        }
        if (this.shadowXOffset != xYBarRenderer.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != xYBarRenderer.shadowYOffset) {
            return false;
        }
        if (this.barAlignmentFactor != xYBarRenderer.barAlignmentFactor) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendBar = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendBar, objectOutputStream);
    }

    protected class XYBarRendererState
    extends XYItemRendererState {
        private double g2Base;

        public XYBarRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public double getG2Base() {
            return this.g2Base;
        }

        public void setG2Base(double d2) {
            this.g2Base = d2;
        }
    }
}

