/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -4481971353973876747L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;
    private transient Shape legendArea;
    private boolean useFillPaint;
    private GradientPaintTransformer gradientTransformer;

    public XYAreaRenderer() {
        this(4);
    }

    public XYAreaRenderer(int n2) {
        this(n2, null, null);
    }

    public XYAreaRenderer(int n2, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n2 == 1) {
            this.plotShapes = true;
        }
        if (n2 == 2) {
            this.plotLines = true;
        }
        if (n2 == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n2 == 4) {
            this.plotArea = true;
        }
        if (n2 == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -4.0f);
        generalPath.lineTo(3.0f, -2.0f);
        generalPath.lineTo(4.0f, 4.0f);
        generalPath.lineTo(-4.0f, 4.0f);
        generalPath.lineTo(-3.0f, -2.0f);
        generalPath.closePath();
        this.legendArea = generalPath;
        this.useFillPaint = false;
        this.gradientTransformer = new StandardGradientPaintTransformer();
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl2) {
        this.showOutline = bl2;
        this.fireChangeEvent();
    }

    public Shape getLegendArea() {
        return this.legendArea;
    }

    public void setLegendArea(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "area");
        this.legendArea = shape;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl2) {
        this.useFillPaint = bl2;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientTransformer() {
        return this.gradientTransformer;
    }

    public void setGradientTransformer(GradientPaintTransformer gradientPaintTransformer) {
        ParamChecks.nullNotPermitted(gradientPaintTransformer, "transformer");
        this.gradientTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYAreaRendererState xYAreaRendererState = new XYAreaRendererState(plotRenderingInfo);
        xYAreaRendererState.setProcessVisibleItemsOnly(false);
        return xYAreaRendererState;
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n2)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
            }
            Paint paint = this.lookupSeriesPaint(n3);
            legendItem = new LegendItem(string, string2, string3, string4, this.legendArea, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint2 = this.lookupLegendTextPaint(n3);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n2);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
            legendItem.setSeriesIndex(n3);
        }
        return legendItem;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        Object object;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        XYAreaRendererState xYAreaRendererState = (XYAreaRendererState)xYItemRendererState;
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        int n5 = xYDataset.getItemCount(n2);
        double d6 = xYDataset.getXValue(n2, Math.max(n3 - 1, 0));
        double d7 = xYDataset.getYValue(n2, Math.max(n3 - 1, 0));
        if (Double.isNaN(d7)) {
            d7 = 0.0;
        }
        double d8 = valueAxis.valueToJava2D(d6, rectangle2D, xYPlot.getDomainAxisEdge());
        double d9 = valueAxis2.valueToJava2D(d7, rectangle2D, xYPlot.getRangeAxisEdge());
        double d10 = xYDataset.getXValue(n2, Math.min(n3 + 1, n5 - 1));
        double d11 = xYDataset.getYValue(n2, Math.min(n3 + 1, n5 - 1));
        if (Double.isNaN(d11)) {
            d11 = 0.0;
        }
        double d12 = valueAxis.valueToJava2D(d10, rectangle2D, xYPlot.getDomainAxisEdge());
        double d13 = valueAxis2.valueToJava2D(d11, rectangle2D, xYPlot.getRangeAxisEdge());
        double d14 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        GeneralPath generalPath = new GeneralPath();
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRenderer.moveTo(generalPath, d14, (d8 + d4) / 2.0);
            XYAreaRenderer.lineTo(generalPath, (d9 + d5) / 2.0, (d8 + d4) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d5, d4);
            XYAreaRenderer.lineTo(generalPath, (d5 + d13) / 2.0, (d4 + d12) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d14, (d4 + d12) / 2.0);
        } else {
            XYAreaRenderer.moveTo(generalPath, (d8 + d4) / 2.0, d14);
            XYAreaRenderer.lineTo(generalPath, (d8 + d4) / 2.0, (d9 + d5) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d4, d5);
            XYAreaRenderer.lineTo(generalPath, (d4 + d12) / 2.0, (d5 + d13) / 2.0);
            XYAreaRenderer.lineTo(generalPath, (d4 + d12) / 2.0, d14);
        }
        generalPath.closePath();
        if (n3 == 0) {
            xYAreaRendererState.area = new GeneralPath();
            double d15 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                XYAreaRenderer.moveTo(xYAreaRendererState.area, d4, d15);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                XYAreaRenderer.moveTo(xYAreaRendererState.area, d15, d4);
            }
        }
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            XYAreaRenderer.lineTo(xYAreaRendererState.area, d4, d5);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRenderer.lineTo(xYAreaRendererState.area, d5, d4);
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n2, n3);
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (this.getPlotShapes()) {
            Shape shape = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d4, d5);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d5, d4);
            }
            graphics2D.draw(shape);
        }
        if (this.getPlotLines() && n3 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYAreaRendererState.line.setLine(d8, d9, d4, d5);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYAreaRendererState.line.setLine(d9, d8, d5, d4);
            }
            graphics2D.draw(xYAreaRendererState.line);
        }
        if (this.getPlotArea() && n3 > 0 && n3 == n5 - 1) {
            Object object2;
            Object object3;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                XYAreaRenderer.lineTo(xYAreaRendererState.area, d4, d14);
                xYAreaRendererState.area.closePath();
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                XYAreaRenderer.lineTo(xYAreaRendererState.area, d14, d4);
                xYAreaRendererState.area.closePath();
            }
            if (this.useFillPaint) {
                paint = this.lookupSeriesFillPaint(n2);
            }
            if (paint instanceof GradientPaint) {
                object3 = (GradientPaint)paint;
                object2 = this.gradientTransformer.transform((GradientPaint)object3, rectangle2D);
                graphics2D.setPaint((Paint)object2);
            }
            graphics2D.fill(xYAreaRendererState.area);
            if (this.isOutline()) {
                object3 = xYAreaRendererState.area;
                object2 = this.lookupSeriesOutlineStroke(n2);
                if (object2 instanceof BasicStroke && ((BasicStroke)(object = (BasicStroke)object2)).getDashArray() != null) {
                    Area area = new Area(xYAreaRendererState.area);
                    Area area2 = new Area(new Rectangle2D.Double(rectangle2D.getX() - 5.0, rectangle2D.getY() - 5.0, rectangle2D.getWidth() + 10.0, rectangle2D.getHeight() + 10.0));
                    area.intersect(area2);
                    object3 = area;
                }
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint(this.lookupSeriesOutlinePaint(n2));
                graphics2D.draw((Shape)object3);
            }
        }
        int n6 = xYPlot.getDomainAxisIndex(valueAxis);
        int n7 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d2, d3, n6, n7, d4, d5, plotOrientation);
        object = xYItemRendererState.getEntityCollection();
        if (object != null) {
            this.addEntity((EntityCollection)object, generalPath, xYDataset, n2, n3, 0.0, 0.0);
        }
    }

    @Override
    public Object clone() {
        XYAreaRenderer xYAreaRenderer = (XYAreaRenderer)super.clone();
        xYAreaRenderer.legendArea = ShapeUtilities.clone(this.legendArea);
        return xYAreaRenderer;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYAreaRenderer)) {
            return false;
        }
        XYAreaRenderer xYAreaRenderer = (XYAreaRenderer)object;
        if (this.plotArea != xYAreaRenderer.plotArea) {
            return false;
        }
        if (this.plotLines != xYAreaRenderer.plotLines) {
            return false;
        }
        if (this.plotShapes != xYAreaRenderer.plotShapes) {
            return false;
        }
        if (this.showOutline != xYAreaRenderer.showOutline) {
            return false;
        }
        if (this.useFillPaint != xYAreaRenderer.useFillPaint) {
            return false;
        }
        if (!this.gradientTransformer.equals(xYAreaRenderer.gradientTransformer)) {
            return false;
        }
        return ShapeUtilities.equal(this.legendArea, xYAreaRenderer.legendArea);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.plotArea);
        n2 = HashUtilities.hashCode(n2, this.plotLines);
        n2 = HashUtilities.hashCode(n2, this.plotShapes);
        n2 = HashUtilities.hashCode(n2, this.useFillPaint);
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendArea = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendArea, objectOutputStream);
    }

    static class XYAreaRendererState
    extends XYItemRendererState {
        public GeneralPath area = new GeneralPath();
        public Line2D line = new Line2D.Double();

        public XYAreaRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }
}

