/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.xy.VectorXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class VectorRenderer
extends AbstractXYItemRenderer
implements Serializable,
Cloneable,
XYItemRenderer,
PublicCloneable {
    private double baseLength = 0.1;
    private double headLength = 0.14;

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        if (xYDataset instanceof VectorXYDataset) {
            VectorXYDataset vectorXYDataset = (VectorXYDataset)xYDataset;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d4;
                    double d5;
                    double d6 = vectorXYDataset.getVectorXValue(i2, i3);
                    if (d6 < 0.0) {
                        d5 = vectorXYDataset.getXValue(i2, i3);
                        d4 = d5 + d6;
                    } else {
                        d4 = vectorXYDataset.getXValue(i2, i3);
                        d5 = d4 + d6;
                    }
                    d2 = Math.min(d2, d4);
                    d3 = Math.max(d3, d5);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                int n4 = xYDataset.getItemCount(i4);
                for (int i5 = 0; i5 < n4; ++i5) {
                    double d7;
                    double d8 = d7 = xYDataset.getXValue(i4, i5);
                    d2 = Math.min(d2, d7);
                    d3 = Math.max(d3, d8);
                }
            }
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        if (xYDataset instanceof VectorXYDataset) {
            VectorXYDataset vectorXYDataset = (VectorXYDataset)xYDataset;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d4;
                    double d5;
                    double d6 = vectorXYDataset.getVectorYValue(i2, i3);
                    if (d6 < 0.0) {
                        d5 = vectorXYDataset.getYValue(i2, i3);
                        d4 = d5 + d6;
                    } else {
                        d4 = vectorXYDataset.getYValue(i2, i3);
                        d5 = d4 + d6;
                    }
                    d2 = Math.min(d2, d4);
                    d3 = Math.max(d3, d5);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                int n4 = xYDataset.getItemCount(i4);
                for (int i5 = 0; i5 < n4; ++i5) {
                    double d7;
                    double d8 = d7 = xYDataset.getYValue(i4, i5);
                    d2 = Math.min(d2, d7);
                    d3 = Math.max(d3, d8);
                }
            }
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        EntityCollection entityCollection;
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = 0.0;
        double d5 = 0.0;
        if (xYDataset instanceof VectorXYDataset) {
            d4 = ((VectorXYDataset)xYDataset).getVectorXValue(n2, n3);
            d5 = ((VectorXYDataset)xYDataset).getVectorYValue(n2, n3);
        }
        double d6 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d7 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        double d8 = valueAxis.valueToJava2D(d2 + d4, rectangle2D, xYPlot.getDomainAxisEdge());
        double d9 = valueAxis2.valueToJava2D(d3 + d5, rectangle2D, xYPlot.getRangeAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = plotOrientation.equals(PlotOrientation.HORIZONTAL) ? new Line2D.Double(d7, d6, d9, d8) : new Line2D.Double(d6, d7, d8, d9);
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        graphics2D.setStroke(this.getItemStroke(n2, n3));
        graphics2D.draw(double_);
        double d10 = d8 - d6;
        double d11 = d9 - d7;
        double d12 = d6 + (1.0 - this.baseLength) * d10;
        double d13 = d7 + (1.0 - this.baseLength) * d11;
        double d14 = d6 + (1.0 - this.headLength) * d10;
        double d15 = d7 + (1.0 - this.headLength) * d11;
        double d16 = 0.0;
        if (d10 != 0.0) {
            d16 = 1.5707963267948966 - Math.atan(d11 / d10);
        }
        double d17 = 2.0 * Math.cos(d16);
        double d18 = 2.0 * Math.sin(d16);
        double d19 = d14 + d17;
        double d20 = d15 - d18;
        double d21 = d14 - d17;
        double d22 = d15 + d18;
        GeneralPath generalPath = new GeneralPath();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            generalPath.moveTo((float)d8, (float)d9);
            generalPath.lineTo((float)d21, (float)d22);
            generalPath.lineTo((float)d12, (float)d13);
            generalPath.lineTo((float)d19, (float)d20);
        } else {
            generalPath.moveTo((float)d9, (float)d8);
            generalPath.lineTo((float)d22, (float)d21);
            generalPath.lineTo((float)d13, (float)d12);
            generalPath.lineTo((float)d20, (float)d19);
        }
        generalPath.closePath();
        graphics2D.draw(generalPath);
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            this.addEntity(entityCollection, double_.getBounds(), xYDataset, n2, n3, 0.0, 0.0);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VectorRenderer)) {
            return false;
        }
        VectorRenderer vectorRenderer = (VectorRenderer)object;
        if (this.baseLength != vectorRenderer.baseLength) {
            return false;
        }
        if (this.headLength != vectorRenderer.headLength) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

