/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements Serializable,
Cloneable,
XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -3271351259436865995L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean baseShapesVisible;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private UnitType gapThresholdType = UnitType.RELATIVE;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawSeriesLineAsPath;
    private transient Shape legendLine;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int n2) {
        this(n2, null);
    }

    public StandardXYItemRenderer(int n2, XYToolTipGenerator xYToolTipGenerator) {
        this(n2, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n2, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if ((n2 & 1) != 0) {
            this.baseShapesVisible = true;
        }
        if ((n2 & 2) != 0) {
            this.plotLines = true;
        }
        if ((n2 & 4) != 0) {
            this.plotImages = true;
        }
        if ((n2 & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.drawSeriesLineAsPath = false;
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean bl2) {
        if (this.baseShapesVisible != bl2) {
            this.baseShapesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean getItemShapeFilled(int n2, int n3) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl2 = this.seriesShapesFilled.getBoolean(n2);
        if (bl2 != null) {
            return bl2;
        }
        return this.baseShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean bl2) {
        this.setShapesFilled(BooleanUtilities.valueOf(bl2));
    }

    public void setShapesFilled(Boolean bl2) {
        this.shapesFilled = bl2;
        this.fireChangeEvent();
    }

    public Boolean getSeriesShapesFilled(int n2) {
        return this.seriesShapesFilled.getBoolean(n2);
    }

    public void setSeriesShapesFilled(int n2, Boolean bl2) {
        this.seriesShapesFilled.setBoolean(n2, bl2);
        this.fireChangeEvent();
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl2) {
        this.baseShapesFilled = bl2;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl2) {
        if (this.plotLines != bl2) {
            this.plotLines = bl2;
            this.fireChangeEvent();
        }
    }

    public UnitType getGapThresholdType() {
        return this.gapThresholdType;
    }

    public void setGapThresholdType(UnitType unitType) {
        ParamChecks.nullNotPermitted(unitType, "thresholdType");
        this.gapThresholdType = unitType;
        this.fireChangeEvent();
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d2) {
        this.gapThreshold = d2;
        this.fireChangeEvent();
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl2) {
        if (this.plotImages != bl2) {
            this.plotImages = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public void setPlotDiscontinuous(boolean bl2) {
        if (this.plotDiscontinuous != bl2) {
            this.plotDiscontinuous = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl2) {
        this.drawSeriesLineAsPath = bl2;
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "line");
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        LegendItem legendItem = null;
        XYDataset xYDataset = xYPlot.getDataset(n2);
        if (xYDataset != null && this.getItemVisible(n3, 0)) {
            Paint paint;
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
            }
            Shape shape = this.lookupLegendShape(n3);
            boolean bl2 = this.getItemShapeFilled(n3, 0);
            Paint paint2 = paint = this.lookupSeriesPaint(n3);
            Stroke stroke = this.lookupSeriesStroke(n3);
            legendItem = new LegendItem(string, string2, string3, string4, this.baseShapesVisible, shape, bl2, paint, !bl2, paint, stroke, this.plotLines, this.legendLine, stroke, paint2);
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint3 = this.lookupLegendTextPaint(n3);
            if (paint3 != null) {
                legendItem.setLabelPaint(paint3);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n2);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
            legendItem.setSeriesIndex(n3);
        }
        return legendItem;
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.seriesIndex = -1;
        return state;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        int n5;
        int n6;
        Object object;
        boolean bl2 = this.getItemVisible(n2, n3);
        Object object2 = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n2, n3);
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            bl2 = false;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (this.getPlotLines()) {
            if (this.drawSeriesLineAsPath) {
                object = (State)xYItemRendererState;
                if (((State)object).getSeriesIndex() != n2) {
                    ((State)object).seriesPath.reset();
                    ((State)object).lastPointGood = false;
                    ((State)object).setSeriesIndex(n2);
                }
                if (bl2 && !Double.isNaN(d4) && !Double.isNaN(d5)) {
                    float f2 = (float)d4;
                    float f3 = (float)d5;
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        f2 = (float)d5;
                        f3 = (float)d4;
                    }
                    if (((State)object).isLastPointGood()) {
                        ((State)object).seriesPath.lineTo(f2, f3);
                    } else {
                        ((State)object).seriesPath.moveTo(f2, f3);
                    }
                    ((State)object).setLastPointGood(true);
                } else {
                    ((State)object).setLastPointGood(false);
                }
                if (n3 == xYDataset.getItemCount(n2) - 1 && ((State)object).seriesIndex == n2) {
                    graphics2D.setStroke(this.lookupSeriesStroke(n2));
                    graphics2D.setPaint(this.lookupSeriesPaint(n2));
                    graphics2D.draw(((State)object).seriesPath);
                }
            } else if (n3 != 0 && bl2) {
                double d6 = xYDataset.getXValue(n2, n3 - 1);
                double d7 = xYDataset.getYValue(n2, n3 - 1);
                if (!Double.isNaN(d6) && !Double.isNaN(d7)) {
                    n6 = 1;
                    if (this.getPlotDiscontinuous()) {
                        n5 = xYDataset.getItemCount(n2);
                        double d8 = xYDataset.getXValue(n2, 0);
                        double d9 = xYDataset.getXValue(n2, n5 - 1);
                        if (this.gapThresholdType == UnitType.ABSOLUTE) {
                            n6 = Math.abs(d2 - d6) <= this.gapThreshold ? 1 : 0;
                        } else {
                            int n7 = n6 = Math.abs(d2 - d6) <= (d9 - d8) / (double)n5 * this.getGapThreshold() ? 1 : 0;
                        }
                    }
                    if (n6 != 0) {
                        double d10 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
                        double d11 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge2);
                        if (Double.isNaN(d10) || Double.isNaN(d11) || Double.isNaN(d4) || Double.isNaN(d5)) {
                            return;
                        }
                        if (plotOrientation == PlotOrientation.HORIZONTAL) {
                            xYItemRendererState.workingLine.setLine(d11, d10, d5, d4);
                        } else if (plotOrientation == PlotOrientation.VERTICAL) {
                            xYItemRendererState.workingLine.setLine(d10, d11, d4, d5);
                        }
                        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                            graphics2D.draw(xYItemRendererState.workingLine);
                        }
                    }
                }
            }
        }
        if (!bl2) {
            return;
        }
        if (this.getBaseShapesVisible()) {
            object = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d5, d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d4, d5);
            }
            if (object.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n2, n3)) {
                    graphics2D.fill((Shape)object);
                } else {
                    graphics2D.draw((Shape)object);
                }
            }
            object2 = object;
        }
        if (this.getPlotImages() && (object = this.getImage(xYPlot, n2, n3, d4, d5)) != null) {
            Point point = this.getImageHotspot(xYPlot, n2, n3, d4, d5, (Image)object);
            graphics2D.drawImage((Image)object, (int)(d4 - point.getX()), (int)(d5 - point.getY()), null);
            object2 = new Rectangle2D.Double(d4 - point.getX(), d5 - point.getY(), ((Image)object).getWidth(null), ((Image)object).getHeight(null));
        }
        double d12 = d4;
        double d13 = d5;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d12 = d5;
            d13 = d4;
        }
        if (this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d12, d13, d3 < 0.0);
        }
        n6 = xYPlot.getDomainAxisIndex(valueAxis);
        n5 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d2, d3, n6, n5, d4, d5, plotOrientation);
        if (entityCollection != null && StandardXYItemRenderer.isPointInRect(rectangle2D, d12, d13)) {
            this.addEntity(entityCollection, (Shape)object2, xYDataset, n2, n3, d12, d13);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYItemRenderer)) {
            return false;
        }
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
        if (this.baseShapesVisible != standardXYItemRenderer.baseShapesVisible) {
            return false;
        }
        if (this.plotLines != standardXYItemRenderer.plotLines) {
            return false;
        }
        if (this.plotImages != standardXYItemRenderer.plotImages) {
            return false;
        }
        if (this.plotDiscontinuous != standardXYItemRenderer.plotDiscontinuous) {
            return false;
        }
        if (this.gapThresholdType != standardXYItemRenderer.gapThresholdType) {
            return false;
        }
        if (this.gapThreshold != standardXYItemRenderer.gapThreshold) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesFilled, standardXYItemRenderer.shapesFilled)) {
            return false;
        }
        if (!this.seriesShapesFilled.equals(standardXYItemRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != standardXYItemRenderer.baseShapesFilled) {
            return false;
        }
        if (this.drawSeriesLineAsPath != standardXYItemRenderer.drawSeriesLineAsPath) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, standardXYItemRenderer.legendLine)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)super.clone();
        standardXYItemRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        standardXYItemRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        return standardXYItemRenderer;
    }

    protected Image getImage(Plot plot, int n2, int n3, double d2, double d3) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n2, int n3, double d2, double d3, Image image) {
        int n4 = image.getHeight(null);
        int n5 = image.getWidth(null);
        return new Point(n5 / 2, n4 / 2);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    public static class State
    extends XYItemRendererState {
        public GeneralPath seriesPath;
        private int seriesIndex;
        private boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean bl2) {
            this.lastPointGood = bl2;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public void setSeriesIndex(int n2) {
            this.seriesIndex = n2;
        }
    }
}

