/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class StackedXYBarRenderer
extends XYBarRenderer {
    private static final long serialVersionUID = -7049101055533436444L;
    private boolean renderAsPercentages = false;

    public StackedXYBarRenderer() {
        this(0.0);
    }

    public StackedXYBarRenderer(double d2) {
        super(d2);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl2) {
        this.renderAsPercentages = bl2;
        this.fireChangeEvent();
    }

    @Override
    public int getPassCount() {
        return 3;
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new XYBarRenderer.XYBarRendererState(this, plotRenderingInfo);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            if (this.renderAsPercentages) {
                return new Range(0.0, 1.0);
            }
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)xYDataset);
        }
        return null;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        double d2;
        double d3;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        if (!(xYDataset instanceof IntervalXYDataset) || !(xYDataset instanceof TableXYDataset)) {
            String string = "dataset (type " + xYDataset.getClass().getName() + ") has wrong type:";
            boolean bl2 = false;
            if (!IntervalXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                string = string + " it is no IntervalXYDataset";
                bl2 = true;
            }
            if (!TableXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                if (bl2) {
                    string = string + " and";
                }
                string = string + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(string);
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        double d4 = intervalXYDataset.getYValue(n2, n3);
        if (Double.isNaN(d4)) {
            return;
        }
        double d5 = 0.0;
        if (this.renderAsPercentages) {
            d5 = DatasetUtilities.calculateStackTotal((TableXYDataset)xYDataset, n3);
            d4 /= d5;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d8 = xYDataset.getYValue(i2, n3);
            if (Double.isNaN(d8) || !this.isSeriesVisible(i2)) continue;
            if (this.renderAsPercentages) {
                d8 /= d5;
            }
            if (d8 > 0.0) {
                d6 += d8;
                continue;
            }
            d7 += d8;
        }
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        if (d4 > 0.0) {
            d3 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge);
            d2 = valueAxis2.valueToJava2D(d6 + d4, rectangle2D, rectangleEdge);
        } else {
            d3 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge);
            d2 = valueAxis2.valueToJava2D(d7 + d4, rectangle2D, rectangleEdge);
        }
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d9 = intervalXYDataset.getStartXValue(n2, n3);
        if (Double.isNaN(d9)) {
            return;
        }
        double d10 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge2);
        double d11 = intervalXYDataset.getEndXValue(n2, n3);
        if (Double.isNaN(d11)) {
            return;
        }
        double d12 = valueAxis.valueToJava2D(d11, rectangle2D, rectangleEdge2);
        double d13 = Math.max(1.0, Math.abs(d12 - d10));
        double d14 = Math.abs(d2 - d3);
        if (this.getMargin() > 0.0) {
            double d15 = d13 * this.getMargin();
            d13 -= d15;
            d10 += d15 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d3, d2), Math.min(d12, d10), d14, d13);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(Math.min(d10, d12), Math.min(d3, d2), d13, d14);
        } else {
            throw new IllegalStateException();
        }
        boolean bl3 = d4 > 0.0;
        boolean bl4 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge3 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl3 && bl4 || !bl3 && !bl4 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl3 && !bl4 || !bl3 && bl4 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (n4 == 0) {
            if (this.getShadowsVisible()) {
                this.getBarPainter().paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge3, false);
            }
        } else if (n4 == 1) {
            EntityCollection entityCollection;
            this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge3);
            if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                this.addEntity(entityCollection, double_, xYDataset, n2, n3, double_.getCenterX(), double_.getCenterY());
            }
        } else if (n4 == 2 && this.isItemLabelVisible(n2, n3)) {
            XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
            this.drawItemLabel(graphics2D, xYDataset, n2, n3, xYPlot, xYItemLabelGenerator, double_, d4 < 0.0);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYBarRenderer)) {
            return false;
        }
        StackedXYBarRenderer stackedXYBarRenderer = (StackedXYBarRenderer)object;
        if (this.renderAsPercentages != stackedXYBarRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 37 + (this.renderAsPercentages ? 1 : 0);
        return n2;
    }
}

