/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedXYAreaRenderer2
extends XYAreaRenderer2
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 7752676509764539182L;
    private boolean roundXCoordinates = true;

    public StackedXYAreaRenderer2() {
        this(null, null);
    }

    public StackedXYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public boolean getRoundXCoordinates() {
        return this.roundXCoordinates;
    }

    public void setRoundXCoordinates(boolean bl2) {
        this.roundXCoordinates = bl2;
        this.fireChangeEvent();
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n2 = tableXYDataset.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] dArray = this.getStackValues((TableXYDataset)xYDataset, tableXYDataset.getSeriesCount(), i2);
            d2 = Math.min(d2, dArray[0]);
            d3 = Math.max(d3, dArray[1]);
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        float f2;
        float f3;
        float f4;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        double[] dArray = this.getStackValues(tableXYDataset, n2, n3);
        double d4 = xYDataset.getXValue(n2, Math.max(n3 - 1, 0));
        double d5 = xYDataset.getYValue(n2, Math.max(n3 - 1, 0));
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        double[] dArray2 = this.getStackValues(tableXYDataset, n2, Math.max(n3 - 1, 0));
        int n5 = xYDataset.getItemCount(n2);
        double d6 = xYDataset.getXValue(n2, Math.min(n3 + 1, n5 - 1));
        double d7 = xYDataset.getYValue(n2, Math.min(n3 + 1, n5 - 1));
        if (Double.isNaN(d7)) {
            d7 = 0.0;
        }
        double[] dArray3 = this.getStackValues(tableXYDataset, n2, Math.min(n3 + 1, n5 - 1));
        double d8 = (d4 + d2) / 2.0;
        double d9 = (d2 + d6) / 2.0;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        float f5 = (float)valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        float f6 = (float)valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        float f7 = (float)valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
        if (this.roundXCoordinates) {
            f5 = Math.round(f5);
            f6 = Math.round(f6);
            f7 = Math.round(f7);
        }
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        if (d3 >= 0.0) {
            f4 = (float)valueAxis2.valueToJava2D(d3 + dArray[1], rectangle2D, rectangleEdge2);
            f3 = (float)valueAxis2.valueToJava2D(dArray[1], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge2);
            if (d5 >= 0.0) {
                double d10 = (d5 + d3) / 2.0 + dArray4[1];
                float f8 = (float)valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath.moveTo(f5, f4);
                    generalPath.lineTo(f5, f3);
                    generalPath.lineTo(f6, f2);
                    generalPath.lineTo(f6, f8);
                } else {
                    generalPath.moveTo(f4, f5);
                    generalPath.lineTo(f3, f5);
                    generalPath.lineTo(f2, f6);
                    generalPath.lineTo(f8, f6);
                }
                generalPath.closePath();
            } else {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath.moveTo(f5, f3);
                    generalPath.lineTo(f5, f4);
                    generalPath.lineTo(f6, f2);
                } else {
                    generalPath.moveTo(f3, f5);
                    generalPath.lineTo(f4, f5);
                    generalPath.lineTo(f2, f6);
                }
                generalPath.closePath();
            }
            float f9 = (float)valueAxis2.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge2);
            if (d7 >= 0.0) {
                double d11 = (d3 + d7) / 2.0 + dArray5[1];
                float f10 = (float)valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f5, f3);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f7, f10);
                    generalPath2.lineTo(f7, f9);
                } else {
                    generalPath2.moveTo(f3, f5);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f10, f7);
                    generalPath2.lineTo(f9, f7);
                }
                generalPath2.closePath();
            } else {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f5, f3);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f7, f9);
                } else {
                    generalPath2.moveTo(f3, f5);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f9, f7);
                }
                generalPath2.closePath();
            }
        } else {
            f4 = (float)valueAxis2.valueToJava2D(d3 + dArray[0], rectangle2D, rectangleEdge2);
            f3 = (float)valueAxis2.valueToJava2D(dArray[0], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge2);
            if (d5 >= 0.0) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath.moveTo(f5, f3);
                    generalPath.lineTo(f5, f4);
                    generalPath.lineTo(f6, f2);
                } else {
                    generalPath.moveTo(f3, f5);
                    generalPath.lineTo(f4, f5);
                    generalPath.lineTo(f2, f6);
                }
                generalPath.clone();
            } else {
                double d12 = (d5 + d3) / 2.0 + dArray4[0];
                float f11 = (float)valueAxis2.valueToJava2D(d12, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath.moveTo(f5, f4);
                    generalPath.lineTo(f5, f3);
                    generalPath.lineTo(f6, f2);
                    generalPath.lineTo(f6, f11);
                } else {
                    generalPath.moveTo(f4, f5);
                    generalPath.lineTo(f3, f5);
                    generalPath.lineTo(f2, f6);
                    generalPath.lineTo(f11, f6);
                }
                generalPath.closePath();
            }
            float f12 = (float)valueAxis2.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge2);
            if (d7 >= 0.0) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f5, f3);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f7, f12);
                } else {
                    generalPath2.moveTo(f3, f5);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f12, f7);
                }
                generalPath2.closePath();
            } else {
                double d13 = (d3 + d7) / 2.0 + dArray5[0];
                float f13 = (float)valueAxis2.valueToJava2D(d13, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f5, f3);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f7, f13);
                    generalPath2.lineTo(f7, f12);
                } else {
                    generalPath2.moveTo(f3, f5);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f13, f7);
                    generalPath2.lineTo(f12, f7);
                }
                generalPath2.closePath();
            }
        }
        Paint paint = this.getItemPaint(n2, n3);
        if (n4 == 0) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
        }
        if (entityCollection != null) {
            GeneralPath generalPath3 = new GeneralPath(generalPath);
            generalPath3.append(generalPath2, false);
            GeneralPath generalPath4 = generalPath3;
            this.addEntity(entityCollection, generalPath4, xYDataset, n2, n3, f5, f4);
        }
    }

    private double[] getStackValues(TableXYDataset tableXYDataset, int n2, int n3) {
        double[] dArray = new double[2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = tableXYDataset.getYValue(i2, n3);
            if (Double.isNaN(d2)) continue;
            if (d2 >= 0.0) {
                dArray[1] = dArray[1] + d2;
                continue;
            }
            dArray[0] = dArray[0] + d2;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYAreaRenderer2)) {
            return false;
        }
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = (StackedXYAreaRenderer2)object;
        if (this.roundXCoordinates != stackedXYAreaRenderer2.roundXCoordinates) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

