/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class SamplingXYLineRenderer
extends AbstractXYItemRenderer
implements Serializable,
Cloneable,
XYItemRenderer,
PublicCloneable {
    private transient Shape legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);

    public SamplingXYLineRenderer() {
        this.setBaseLegendShape(this.legendLine);
        this.setTreatLegendShapeAsLine(true);
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "line");
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        double d2 = 72.0;
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.intervalPath = new GeneralPath();
        state.dX = 72.0 / d2;
        return state;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        State state = (State)xYItemRendererState;
        if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
            float f2 = (float)d4;
            float f3 = (float)d5;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                f2 = (float)d5;
                f3 = (float)d4;
            }
            if (state.lastPointGood) {
                if (Math.abs((double)f2 - state.lastX) > state.dX) {
                    state.seriesPath.lineTo(f2, f3);
                    if (state.lowY < state.highY) {
                        state.intervalPath.moveTo((float)state.lastX, (float)state.lowY);
                        state.intervalPath.lineTo((float)state.lastX, (float)state.highY);
                    }
                    state.lastX = f2;
                    state.openY = f3;
                    state.highY = f3;
                    state.lowY = f3;
                    state.closeY = f3;
                } else {
                    state.highY = Math.max(state.highY, (double)f3);
                    state.lowY = Math.min(state.lowY, (double)f3);
                    state.closeY = f3;
                }
            } else {
                state.seriesPath.moveTo(f2, f3);
                state.lastX = f2;
                state.openY = f3;
                state.highY = f3;
                state.lowY = f3;
                state.closeY = f3;
            }
            state.lastPointGood = true;
        } else {
            state.lastPointGood = false;
        }
        if (n3 == state.getLastItemIndex()) {
            PathIterator pathIterator = state.seriesPath.getPathIterator(null);
            int n5 = 0;
            while (!pathIterator.isDone()) {
                ++n5;
                pathIterator.next();
            }
            graphics2D.setStroke(this.getItemStroke(n2, n3));
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            graphics2D.draw(state.seriesPath);
            graphics2D.draw(state.intervalPath);
        }
    }

    @Override
    public Object clone() {
        SamplingXYLineRenderer samplingXYLineRenderer = (SamplingXYLineRenderer)super.clone();
        if (this.legendLine != null) {
            samplingXYLineRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        }
        return samplingXYLineRenderer;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SamplingXYLineRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SamplingXYLineRenderer samplingXYLineRenderer = (SamplingXYLineRenderer)object;
        return ShapeUtilities.equal(this.legendLine, samplingXYLineRenderer.legendLine);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    public static class State
    extends XYItemRendererState {
        GeneralPath seriesPath;
        GeneralPath intervalPath;
        double dX = 1.0;
        double lastX;
        double openY = 0.0;
        double highY = 0.0;
        double lowY = 0.0;
        double closeY = 0.0;
        boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        @Override
        public void startSeriesPass(XYDataset xYDataset, int n2, int n3, int n4, int n5, int n6) {
            this.seriesPath.reset();
            this.intervalPath.reset();
            this.lastPointGood = false;
            super.startSeriesPass(xYDataset, n2, n3, n4, n5, n6);
        }
    }
}

