/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class DeviationRenderer
extends XYLineAndShapeRenderer {
    private float alpha;

    public DeviationRenderer() {
        this(true, true);
    }

    public DeviationRenderer(boolean bl2, boolean bl3) {
        super(bl2, bl3);
        super.setDrawSeriesLineAsPath(true);
        this.alpha = 0.5f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Requires 'alpha' in the range 0.0 to 1.0.");
        }
        this.alpha = f2;
        this.fireChangeEvent();
    }

    @Override
    public void setDrawSeriesLineAsPath(boolean bl2) {
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    @Override
    public int getPassCount() {
        return 3;
    }

    @Override
    protected boolean isItemPass(int n2) {
        return n2 == 2;
    }

    @Override
    protected boolean isLinePass(int n2) {
        return n2 == 1;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        Object object;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        if (n4 == 0) {
            object = (IntervalXYDataset)xYDataset;
            State state = (State)xYItemRendererState;
            double d2 = object.getXValue(n2, n3);
            double d3 = object.getStartYValue(n2, n3);
            double d4 = object.getEndYValue(n2, n3);
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d5 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            double d7 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                state.lowerCoordinates.add(new double[]{d6, d5});
                state.upperCoordinates.add(new double[]{d7, d5});
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                state.lowerCoordinates.add(new double[]{d5, d6});
                state.upperCoordinates.add(new double[]{d5, d7});
            }
            if (n3 == xYDataset.getItemCount(n2) - 1) {
                int n5;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                graphics2D.setPaint(this.getItemFillPaint(n2, n3));
                GeneralPath generalPath = new GeneralPath(1, state.lowerCoordinates.size() + state.upperCoordinates.size());
                double[] dArray = (double[])state.lowerCoordinates.get(0);
                generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                for (n5 = 1; n5 < state.lowerCoordinates.size(); ++n5) {
                    dArray = (double[])state.lowerCoordinates.get(n5);
                    generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                }
                n5 = state.upperCoordinates.size();
                dArray = (double[])state.upperCoordinates.get(n5 - 1);
                generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                for (int i2 = n5 - 2; i2 >= 0; --i2) {
                    dArray = (double[])state.upperCoordinates.get(i2);
                    generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                }
                generalPath.closePath();
                graphics2D.fill(generalPath);
                graphics2D.setComposite(composite);
                state.lowerCoordinates.clear();
                state.upperCoordinates.clear();
            }
        }
        if (this.isLinePass(n4)) {
            if (n3 == 0) {
                object = (State)xYItemRendererState;
                ((State)object).seriesPath.reset();
                ((XYLineAndShapeRenderer.State)object).setLastPointGood(false);
            }
            if (this.getItemLineVisible(n2, n3)) {
                this.drawPrimaryLineAsPath(xYItemRendererState, graphics2D, xYPlot, xYDataset, n4, n2, n3, valueAxis, valueAxis2, rectangle2D);
            }
        } else if (this.isItemPass(n4)) {
            object = null;
            if (plotRenderingInfo != null) {
                object = plotRenderingInfo.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(graphics2D, xYPlot, xYDataset, n4, n2, n3, valueAxis, rectangle2D, valueAxis2, crosshairState, (EntityCollection)object);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DeviationRenderer)) {
            return false;
        }
        DeviationRenderer deviationRenderer = (DeviationRenderer)object;
        if (this.alpha != deviationRenderer.alpha) {
            return false;
        }
        return super.equals(object);
    }

    public static class State
    extends XYLineAndShapeRenderer.State {
        public List upperCoordinates;
        public List lowerCoordinates = new ArrayList();

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
            this.upperCoordinates = new ArrayList();
        }
    }
}

