/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;

public class CyclicXYItemRenderer
extends StandardXYItemRenderer
implements Serializable {
    private static final long serialVersionUID = 4035912243303764892L;

    public CyclicXYItemRenderer() {
    }

    public CyclicXYItemRenderer(int n2) {
        super(n2);
    }

    public CyclicXYItemRenderer(int n2, XYToolTipGenerator xYToolTipGenerator) {
        super(n2, xYToolTipGenerator);
    }

    public CyclicXYItemRenderer(int n2, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n2, xYToolTipGenerator, xYURLGenerator);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        double[] dArray;
        Object object;
        if (!this.getPlotLines() || !(valueAxis instanceof CyclicNumberAxis) && !(valueAxis2 instanceof CyclicNumberAxis) || n3 <= 0) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState, n4);
            return;
        }
        double d2 = xYDataset.getXValue(n2, n3 - 1);
        double d3 = xYDataset.getYValue(n2, n3 - 1);
        if (Double.isNaN(d3)) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState, n4);
            return;
        }
        Object object2 = new double[2];
        double[] dArray2 = new double[2];
        object2[0] = d2;
        dArray2[0] = d3;
        d2 = xYDataset.getXValue(n2, n3);
        d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d3)) {
            return;
        }
        object2[1] = d2;
        dArray2[1] = d3;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        boolean bl2 = false;
        boolean bl3 = false;
        CyclicNumberAxis cyclicNumberAxis = null;
        CyclicNumberAxis cyclicNumberAxis2 = null;
        if (valueAxis instanceof CyclicNumberAxis) {
            cyclicNumberAxis = (CyclicNumberAxis)valueAxis;
            d4 = cyclicNumberAxis.getCycleBound();
            bl2 = cyclicNumberAxis.isBoundMappedToLastCycle();
            if (object2[0] != object2[1] && (d4 >= object2[0] && d4 <= object2[1] || d4 >= object2[1] && d4 <= object2[0])) {
                object = new double[3];
                dArray = new double[3];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                object[1] = d4;
                dArray[1] = (dArray2[1] - dArray2[0]) * (d4 - object2[0]) / (object2[1] - object2[0]) + dArray2[0];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (valueAxis2 instanceof CyclicNumberAxis) {
            cyclicNumberAxis2 = (CyclicNumberAxis)valueAxis2;
            d5 = cyclicNumberAxis2.getCycleBound();
            bl3 = cyclicNumberAxis2.isBoundMappedToLastCycle();
            if (dArray2[0] != dArray2[1] && (d5 >= dArray2[0] && d5 <= dArray2[1] || d5 >= dArray2[1] && d5 <= dArray2[0])) {
                object = new double[((double[])object2).length + 1];
                dArray = new double[dArray2.length + 1];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                dArray[1] = d5;
                object[1] = (object2[1] - object2[0]) * (d5 - dArray2[0]) / (dArray2[1] - dArray2[0]) + object2[0];
                if (((double[])object2).length == 3) {
                    object[3] = object2[2];
                    dArray[3] = dArray2[2];
                }
                object2 = object;
                dArray2 = dArray;
            } else if (((double[])object2).length == 3 && dArray2[1] != dArray2[2] && (d5 >= dArray2[1] && d5 <= dArray2[2] || d5 >= dArray2[2] && d5 <= dArray2[1])) {
                object = new double[4];
                dArray = new double[4];
                object[0] = object2[0];
                object[1] = object2[1];
                object[3] = object2[2];
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                dArray[3] = dArray2[2];
                dArray[2] = d5;
                object[2] = (object2[2] - object2[1]) * (d5 - dArray2[1]) / (dArray2[2] - dArray2[1]) + object2[1];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (((double[])object2).length == 2) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState, n4);
            return;
        }
        object = new OverwriteDataSet((double[])object2, dArray2, xYDataset);
        if (cyclicNumberAxis != null) {
            if (d4 == object2[0]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d4);
            }
            if (d4 == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[0] <= d4);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d5 == dArray2[0]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d5);
            }
            if (d5 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[0] <= d5);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n2, 1, crosshairState, n4);
        if (cyclicNumberAxis != null) {
            if (d4 == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d4);
            }
            if (d4 == object2[2]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d4);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d5 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d5);
            }
            if (d5 == dArray2[2]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d5);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n2, 2, crosshairState, n4);
        if (((double[])object2).length == 4) {
            if (cyclicNumberAxis != null) {
                if (d4 == object2[2]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[3] <= d4);
                }
                if (d4 == object2[3]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d4);
                }
            }
            if (cyclicNumberAxis2 != null) {
                if (d5 == dArray2[2]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[3] <= d5);
                }
                if (d5 == dArray2[3]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d5);
                }
            }
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n2, 3, crosshairState, n4);
        }
        if (cyclicNumberAxis != null) {
            cyclicNumberAxis.setBoundMappedToLastCycle(bl2);
        }
        if (cyclicNumberAxis2 != null) {
            cyclicNumberAxis2.setBoundMappedToLastCycle(bl3);
        }
    }

    protected static class OverwriteDataSet
    implements XYDataset {
        protected XYDataset delegateSet;
        Double[] x;
        Double[] y;

        public OverwriteDataSet(double[] dArray, double[] dArray2, XYDataset xYDataset) {
            this.delegateSet = xYDataset;
            this.x = new Double[dArray.length];
            this.y = new Double[dArray2.length];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.x[i2] = new Double(dArray[i2]);
                this.y[i2] = new Double(dArray2[i2]);
            }
        }

        @Override
        public DomainOrder getDomainOrder() {
            return DomainOrder.NONE;
        }

        @Override
        public int getItemCount(int n2) {
            return this.x.length;
        }

        @Override
        public Number getX(int n2, int n3) {
            return this.x[n3];
        }

        @Override
        public double getXValue(int n2, int n3) {
            double d2 = Double.NaN;
            Number number = this.getX(n2, n3);
            if (number != null) {
                d2 = number.doubleValue();
            }
            return d2;
        }

        @Override
        public Number getY(int n2, int n3) {
            return this.y[n3];
        }

        @Override
        public double getYValue(int n2, int n3) {
            double d2 = Double.NaN;
            Number number = this.getY(n2, n3);
            if (number != null) {
                d2 = number.doubleValue();
            }
            return d2;
        }

        @Override
        public int getSeriesCount() {
            return this.delegateSet.getSeriesCount();
        }

        @Override
        public Comparable getSeriesKey(int n2) {
            return this.delegateSet.getSeriesKey(n2);
        }

        @Override
        public int indexOf(Comparable comparable) {
            return this.delegateSet.indexOf(comparable);
        }

        @Override
        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        @Override
        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        @Override
        public DatasetGroup getGroup() {
            return this.delegateSet.getGroup();
        }

        @Override
        public void setGroup(DatasetGroup datasetGroup) {
        }
    }
}

