/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 5864462149177133147L;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d2, boolean bl2) {
        super(d2);
        this.centerBarAtStartValue = bl2;
    }

    @Override
    public int getPassCount() {
        return 2;
    }

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        if (this.centerBarAtStartValue) {
            return this.findDomainBoundsWithOffset((IntervalXYDataset)xYDataset);
        }
        return super.findDomainBounds(xYDataset);
    }

    protected Range findDomainBoundsWithOffset(IntervalXYDataset intervalXYDataset) {
        ParamChecks.nullNotPermitted(intervalXYDataset, "dataset");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = intervalXYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = intervalXYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = intervalXYDataset.getStartXValue(i2, i3);
                double d5 = intervalXYDataset.getEndXValue(i2, i3);
                double d6 = (d5 - d4) / 2.0;
                d2 = Math.min(d2, d4 -= d6);
                d3 = Math.max(d3, d5 -= d6);
            }
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.getUseYInterval()) {
            d7 = intervalXYDataset.getStartYValue(n2, n3);
            d6 = intervalXYDataset.getEndYValue(n2, n3);
        } else {
            d7 = this.getBase();
            d6 = intervalXYDataset.getYValue(n2, n3);
        }
        if (Double.isNaN(d7) || Double.isNaN(d6)) {
            return;
        }
        double d8 = valueAxis2.valueToJava2D(d7, rectangle2D, xYPlot.getRangeAxisEdge());
        double d9 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d10 = intervalXYDataset.getStartXValue(n2, n3);
        double d11 = valueAxis.valueToJava2D(d10, rectangle2D, rectangleEdge);
        double d12 = intervalXYDataset.getEndXValue(n2, n3);
        double d13 = valueAxis.valueToJava2D(d12, rectangle2D, rectangleEdge);
        double d14 = d13 - d11;
        double d15 = d11;
        if (this.centerBarAtStartValue) {
            d15 -= d14 / 2.0;
        }
        if ((d5 = this.getMargin()) > 0.0) {
            d4 = d14 * this.getMargin();
            d14 -= d4;
            d15 += d4 / 2.0;
        }
        d4 = Math.abs(d8 - d9);
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        int n5 = xYDataset.getSeriesCount();
        double d16 = d14 / (double)n5;
        Rectangle2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = d15 + d16 * (double)n2;
            d2 = d3 + d16;
            double d17 = Math.min(d8, d9);
            double d18 = d4;
            double d19 = Math.min(d3, d2);
            double d20 = Math.abs(d2 - d3);
            double_ = new Rectangle2D.Double(d17, d19, d18, d20);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = d15 + d16 * (double)n2;
            d2 = d3 + d16;
            double d21 = Math.min(d3, d2);
            double d22 = Math.abs(d2 - d3);
            double d23 = Math.min(d8, d9);
            double d24 = d4;
            double_ = new Rectangle2D.Double(d21, d23, d22, d24);
        } else {
            throw new IllegalStateException();
        }
        boolean bl2 = d6 > 0.0;
        boolean bl3 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge2 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl2 && bl3 || !bl2 && !bl3 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl2 && !bl3 || !bl2 && bl3 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (n4 == 0 && this.getShadowsVisible()) {
            this.getBarPainter().paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge2, !this.getUseYInterval());
        }
        if (n4 == 1) {
            Object object;
            this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge2);
            if (this.isItemLabelVisible(n2, n3)) {
                object = this.getItemLabelGenerator(n2, n3);
                this.drawItemLabel(graphics2D, xYDataset, n2, n3, xYPlot, (XYItemLabelGenerator)object, double_, d6 < 0.0);
            }
            if (plotRenderingInfo != null && (object = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                this.addEntity((EntityCollection)object, double_, xYDataset, n2, n3, double_.getCenterX(), double_.getCenterY());
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClusteredXYBarRenderer)) {
            return false;
        }
        ClusteredXYBarRenderer clusteredXYBarRenderer = (ClusteredXYBarRenderer)object;
        if (this.centerBarAtStartValue != clusteredXYBarRenderer.centerBarAtStartValue) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

