/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements Serializable,
Cloneable,
AnnotationChangeListener,
XYItemRenderer {
    private static final long serialVersionUID = 8019124836026607990L;
    private XYPlot plot;
    private Map<Integer, XYItemLabelGenerator> itemLabelGeneratorMap = new HashMap<Integer, XYItemLabelGenerator>();
    private XYItemLabelGenerator baseItemLabelGenerator;
    private Map<Integer, XYToolTipGenerator> toolTipGeneratorMap = new HashMap<Integer, XYToolTipGenerator>();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private List backgroundAnnotations = new ArrayList();
    private List foregroundAnnotations = new ArrayList();
    private XYSeriesLabelGenerator legendItemLabelGenerator = new StandardXYSeriesLabelGenerator("{0}");
    private XYSeriesLabelGenerator legendItemToolTipGenerator;
    private XYSeriesLabelGenerator legendItemURLGenerator;
    private XYItemLabelGenerator itemLabelGenerator = null;
    private XYToolTipGenerator toolTipGenerator = null;

    protected AbstractXYItemRenderer() {
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public XYPlot getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new XYItemRendererState(plotRenderingInfo);
    }

    @Override
    public XYItemLabelGenerator getItemLabelGenerator(int n2, int n3) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        XYItemLabelGenerator xYItemLabelGenerator = this.itemLabelGeneratorMap.get(n2);
        if (xYItemLabelGenerator == null) {
            xYItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return xYItemLabelGenerator;
    }

    @Override
    public XYItemLabelGenerator getSeriesItemLabelGenerator(int n2) {
        return this.itemLabelGeneratorMap.get(n2);
    }

    @Override
    public void setSeriesItemLabelGenerator(int n2, XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGeneratorMap.put(n2, xYItemLabelGenerator);
        this.fireChangeEvent();
    }

    @Override
    public XYItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    @Override
    public void setBaseItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.baseItemLabelGenerator = xYItemLabelGenerator;
        this.fireChangeEvent();
    }

    @Override
    public XYToolTipGenerator getToolTipGenerator(int n2, int n3) {
        if (this.toolTipGenerator != null) {
            return this.toolTipGenerator;
        }
        XYToolTipGenerator xYToolTipGenerator = this.toolTipGeneratorMap.get(n2);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    @Override
    public XYToolTipGenerator getSeriesToolTipGenerator(int n2) {
        return this.toolTipGeneratorMap.get(n2);
    }

    @Override
    public void setSeriesToolTipGenerator(int n2, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorMap.put(n2, xYToolTipGenerator);
        this.fireChangeEvent();
    }

    @Override
    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    @Override
    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    @Override
    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    @Override
    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.fireChangeEvent();
    }

    @Override
    public void addAnnotation(XYAnnotation xYAnnotation) {
        this.addAnnotation(xYAnnotation, Layer.FOREGROUND);
    }

    @Override
    public void addAnnotation(XYAnnotation xYAnnotation, Layer layer) {
        ParamChecks.nullNotPermitted(xYAnnotation, "annotation");
        if (layer.equals(Layer.FOREGROUND)) {
            this.foregroundAnnotations.add(xYAnnotation);
            xYAnnotation.addChangeListener(this);
            this.fireChangeEvent();
        } else if (layer.equals(Layer.BACKGROUND)) {
            this.backgroundAnnotations.add(xYAnnotation);
            xYAnnotation.addChangeListener(this);
            this.fireChangeEvent();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
    }

    @Override
    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        boolean bl2 = this.foregroundAnnotations.remove(xYAnnotation);
        xYAnnotation.removeChangeListener(this);
        this.fireChangeEvent();
        return bl2 &= this.backgroundAnnotations.remove(xYAnnotation);
    }

    @Override
    public void removeAnnotations() {
        XYAnnotation xYAnnotation;
        int n2;
        for (n2 = 0; n2 < this.foregroundAnnotations.size(); ++n2) {
            xYAnnotation = (XYAnnotation)this.foregroundAnnotations.get(n2);
            xYAnnotation.removeChangeListener(this);
        }
        for (n2 = 0; n2 < this.backgroundAnnotations.size(); ++n2) {
            xYAnnotation = (XYAnnotation)this.backgroundAnnotations.get(n2);
            xYAnnotation.removeChangeListener(this);
        }
        this.foregroundAnnotations.clear();
        this.backgroundAnnotations.clear();
        this.fireChangeEvent();
    }

    @Override
    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        this.fireChangeEvent();
    }

    public Collection getAnnotations() {
        ArrayList arrayList = new ArrayList(this.foregroundAnnotations);
        arrayList.addAll(this.backgroundAnnotations);
        return arrayList;
    }

    @Override
    public XYSeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    @Override
    public void setLegendItemLabelGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        ParamChecks.nullNotPermitted(xYSeriesLabelGenerator, "generator");
        this.legendItemLabelGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemToolTipGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemURLGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        return this.findDomainBounds(xYDataset, false);
    }

    protected Range findDomainBounds(XYDataset xYDataset, boolean bl2) {
        if (xYDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n2 = xYDataset.getSeriesCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.isSeriesVisible(i2)) continue;
                arrayList.add(xYDataset.getSeriesKey(i2));
            }
            return DatasetUtilities.findDomainBounds(xYDataset, arrayList, bl2);
        }
        return DatasetUtilities.findDomainBounds(xYDataset, bl2);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, false);
    }

    protected Range findRangeBounds(XYDataset xYDataset, boolean bl2) {
        if (xYDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n2 = xYDataset.getSeriesCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.isSeriesVisible(i2)) continue;
                arrayList.add(xYDataset.getSeriesKey(i2));
            }
            Range range = null;
            XYPlot xYPlot = this.getPlot();
            if (xYPlot != null) {
                ValueAxis valueAxis = null;
                int n3 = xYPlot.getIndexOf(this);
                if (n3 >= 0) {
                    valueAxis = this.plot.getDomainAxisForDataset(n3);
                }
                if (valueAxis != null) {
                    range = valueAxis.getRange();
                }
            }
            if (range == null) {
                range = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
            return DatasetUtilities.findRangeBounds(xYDataset, arrayList, range, bl2);
        }
        return DatasetUtilities.findRangeBounds(xYDataset, bl2);
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n2 = this.plot.getIndexOf(this);
        XYDataset xYDataset = this.plot.getDataset(n2);
        if (xYDataset != null) {
            int n3 = xYDataset.getSeriesCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i2) || (legendItem = this.getLegendItem(n2, i2)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        String string;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n2);
        if (xYDataset == null) {
            return null;
        }
        String string2 = string = this.legendItemLabelGenerator.generateLabel(xYDataset, n3);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
        }
        Shape shape = this.lookupLegendShape(n3);
        Paint paint = this.lookupSeriesPaint(n3);
        LegendItem legendItem = new LegendItem(string, paint);
        legendItem.setToolTipText(string3);
        legendItem.setURLText(string4);
        legendItem.setLabelFont(this.lookupLegendTextFont(n3));
        Paint paint2 = this.lookupLegendTextPaint(n3);
        if (paint2 != null) {
            legendItem.setLabelPaint(paint2);
        }
        legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
        legendItem.setSeriesIndex(n3);
        legendItem.setDataset(xYDataset);
        legendItem.setDatasetIndex(n2);
        if (this.getTreatLegendShapeAsLine()) {
            legendItem.setLineVisible(true);
            legendItem.setLine(shape);
            legendItem.setLinePaint(paint);
            legendItem.setShapeVisible(false);
        } else {
            Paint paint3 = this.lookupSeriesOutlinePaint(n3);
            Stroke stroke = this.lookupSeriesOutlineStroke(n3);
            legendItem.setOutlinePaint(paint3);
            legendItem.setOutlineStroke(stroke);
        }
        return legendItem;
    }

    @Override
    public void fillDomainGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2, double d3) {
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = xYPlot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight()) : new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d5 - d4));
        Paint paint = xYPlot.getDomainTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    @Override
    public void fillRangeGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2, double d3) {
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        Rectangle2D.Double double_ = xYPlot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d5 - d4)) : new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight());
        Paint paint = xYPlot.getRangeTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    @Override
    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2) {
        Range range = valueAxis.getRange();
        if (!range.contains(d2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        }
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    public void drawDomainLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        if (plotOrientation.isHorizontal()) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        } else if (plotOrientation.isVertical()) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    @Override
    public void drawRangeLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    @Override
    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d2 = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d2)) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
            } else {
                throw new IllegalStateException();
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d4 = intervalMarker.getStartValue();
            double d5 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d4, d5)) {
                return;
            }
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, xYPlot.getDomainAxisEdge());
            double d7 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getDomainAxisEdge());
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d8 = Math.max(d8, rectangle2D.getMinY());
                d9 = Math.min(d9, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d8, rectangle2D.getWidth(), d9 - d8);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d8 = Math.max(d8, rectangle2D.getMinX());
                d9 = Math.min(d9, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d8, rectangle2D.getMinY(), d9 - d8, rectangle2D.getHeight());
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d10;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d11 = rectangle2D.getMinY();
                    d10 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d6, d11, d6, d10);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d7, d11, d7, d10);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d12 = rectangle2D.getMinX();
                    d10 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d12, d6, d10, d6);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d12, d7, d10, d7);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    @Override
    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d2 = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d2)) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            } else {
                throw new IllegalStateException("Unknown orientation.");
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d4 = intervalMarker.getStartValue();
            double d5 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d4, d5)) {
                return;
            }
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, xYPlot.getRangeAxisEdge());
            double d7 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getRangeAxisEdge());
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d8 = Math.max(d8, rectangle2D.getMinX());
                d9 = Math.min(d9, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d8, rectangle2D.getMinY(), d9 - d8, rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d8 = Math.max(d8, rectangle2D.getMinY());
                d9 = Math.min(d9, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d8, rectangle2D.getWidth(), d9 - d8);
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d10;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d11 = rectangle2D.getMinX();
                    d10 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d11, d6, d10, d6);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d11, d7, d10, d7);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d12 = rectangle2D.getMinY();
                    d10 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d6, d12, d6, d10);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d7, d12, d7, d10);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    private Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    @Override
    protected Object clone() {
        PublicCloneable publicCloneable;
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)super.clone();
        if (this.itemLabelGenerator != null && this.itemLabelGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.itemLabelGenerator);
            abstractXYItemRenderer.itemLabelGenerator = (XYItemLabelGenerator)publicCloneable.clone();
        }
        abstractXYItemRenderer.itemLabelGeneratorMap = CloneUtils.cloneMapValues(this.itemLabelGeneratorMap);
        if (this.baseItemLabelGenerator != null && this.baseItemLabelGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.baseItemLabelGenerator);
            abstractXYItemRenderer.baseItemLabelGenerator = (XYItemLabelGenerator)publicCloneable.clone();
        }
        if (this.toolTipGenerator != null && this.toolTipGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.toolTipGenerator);
            abstractXYItemRenderer.toolTipGenerator = (XYToolTipGenerator)publicCloneable.clone();
        }
        abstractXYItemRenderer.toolTipGeneratorMap = CloneUtils.cloneMapValues(this.toolTipGeneratorMap);
        if (this.baseToolTipGenerator != null && this.baseToolTipGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.baseToolTipGenerator);
            abstractXYItemRenderer.baseToolTipGenerator = (XYToolTipGenerator)publicCloneable.clone();
        }
        if (this.legendItemLabelGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemLabelGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemLabelGenerator);
        }
        if (this.legendItemToolTipGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemToolTipGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (this.legendItemURLGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemURLGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        abstractXYItemRenderer.foregroundAnnotations = (List)ObjectUtilities.deepClone(this.foregroundAnnotations);
        abstractXYItemRenderer.backgroundAnnotations = (List)ObjectUtilities.deepClone(this.backgroundAnnotations);
        return abstractXYItemRenderer;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object;
        if (!ObjectUtilities.equal(this.itemLabelGenerator, abstractXYItemRenderer.itemLabelGenerator)) {
            return false;
        }
        if (!this.itemLabelGeneratorMap.equals(abstractXYItemRenderer.itemLabelGeneratorMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelGenerator, abstractXYItemRenderer.baseItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, abstractXYItemRenderer.toolTipGenerator)) {
            return false;
        }
        if (!this.toolTipGeneratorMap.equals(abstractXYItemRenderer.toolTipGeneratorMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, abstractXYItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlGenerator, abstractXYItemRenderer.urlGenerator)) {
            return false;
        }
        if (!this.foregroundAnnotations.equals(abstractXYItemRenderer.foregroundAnnotations)) {
            return false;
        }
        if (!this.backgroundAnnotations.equals(abstractXYItemRenderer.backgroundAnnotations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemLabelGenerator, abstractXYItemRenderer.legendItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, abstractXYItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, abstractXYItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null) {
            drawingSupplier = xYPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d2, double d3, int n2, int n3, double d4, double d5, PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(d2, d3, n2, n3, d4, d5, plotOrientation);
                } else {
                    crosshairState.updateCrosshairX(d2, n2);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(d3, n3);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, XYDataset xYDataset, int n2, int n3, double d2, double d3, boolean bl2) {
        XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
        if (xYItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n2, n3);
            Paint paint = this.getItemLabelPaint(n2, n3);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = xYItemLabelGenerator.generateLabel(xYDataset, n2, n3);
            ItemLabelPosition itemLabelPosition = !bl2 ? this.getPositiveItemLabelPosition(n2, n3) : this.getNegativeItemLabelPosition(n2, n3);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d2, d3, plotOrientation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    @Override
    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, Layer layer, PlotRenderingInfo plotRenderingInfo) {
        Iterator iterator = null;
        if (layer.equals(Layer.FOREGROUND)) {
            iterator = this.foregroundAnnotations.iterator();
        } else if (layer.equals(Layer.BACKGROUND)) {
            iterator = this.backgroundAnnotations.iterator();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
        while (iterator.hasNext()) {
            XYAnnotation xYAnnotation = (XYAnnotation)iterator.next();
            int n2 = this.plot.getIndexOf(this);
            xYAnnotation.draw(graphics2D, this.plot, rectangle2D, valueAxis, valueAxis2, n2, plotRenderingInfo);
        }
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n2, int n3, double d2, double d3) {
        if (!this.getItemCreateEntity(n2, n3)) {
            return;
        }
        Shape shape2 = shape;
        if (shape2 == null) {
            double d4 = this.getDefaultEntityRadius();
            double d5 = d4 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d2 - d4, d3 - d4, d5, d5) : new Ellipse2D.Double(d3 - d4, d2 - d4, d5, d5);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n2, n3);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n2, n3);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape2, xYDataset, n2, n3, string, string2);
        entityCollection.add(xYItemEntity);
    }

    public static boolean isPointInRect(Rectangle2D rectangle2D, double d2, double d3) {
        return d2 >= rectangle2D.getMinX() && d2 <= rectangle2D.getMaxX() && d3 >= rectangle2D.getMinY() && d3 <= rectangle2D.getMaxY();
    }

    protected static void moveTo(GeneralPath generalPath, double d2, double d3) {
        generalPath.moveTo((float)d2, (float)d3);
    }

    protected static void lineTo(GeneralPath generalPath, double d2, double d3) {
        generalPath.lineTo((float)d2, (float)d3);
    }

    public XYItemLabelGenerator getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    @Override
    public void setItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGenerator = xYItemLabelGenerator;
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    @Override
    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d2, double d3, double d4, double d5, PlotOrientation plotOrientation) {
        this.updateCrosshairValues(crosshairState, d2, d3, 0, 0, d4, d5, plotOrientation);
    }
}

