/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.PaintUtilities;

public class WaterfallBarRenderer
extends BarRenderer {
    private static final long serialVersionUID = -2482910643727230911L;
    private transient Paint firstBarPaint;
    private transient Paint lastBarPaint;
    private transient Paint positiveBarPaint;
    private transient Paint negativeBarPaint;

    public WaterfallBarRenderer() {
        this(new GradientPaint(0.0f, 0.0f, new Color(34, 34, 255), 0.0f, 0.0f, new Color(102, 102, 255)), new GradientPaint(0.0f, 0.0f, new Color(34, 255, 34), 0.0f, 0.0f, new Color(102, 255, 102)), new GradientPaint(0.0f, 0.0f, new Color(255, 34, 34), 0.0f, 0.0f, new Color(255, 102, 102)), new GradientPaint(0.0f, 0.0f, new Color(255, 255, 34), 0.0f, 0.0f, new Color(255, 255, 102)));
    }

    public WaterfallBarRenderer(Paint paint, Paint paint2, Paint paint3, Paint paint4) {
        ParamChecks.nullNotPermitted(paint, "firstBarPaint");
        ParamChecks.nullNotPermitted(paint2, "positiveBarPaint");
        ParamChecks.nullNotPermitted(paint3, "negativeBarPaint");
        ParamChecks.nullNotPermitted(paint4, "lastBarPaint");
        this.firstBarPaint = paint;
        this.lastBarPaint = paint4;
        this.positiveBarPaint = paint2;
        this.negativeBarPaint = paint3;
        this.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        this.setMinimumBarLength(1.0);
    }

    public Paint getFirstBarPaint() {
        return this.firstBarPaint;
    }

    public void setFirstBarPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.firstBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLastBarPaint() {
        return this.lastBarPaint;
    }

    public void setLastBarPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.lastBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getPositiveBarPaint() {
        return this.positiveBarPaint;
    }

    public void setPositiveBarPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.positiveBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getNegativeBarPaint() {
        return this.negativeBarPaint;
    }

    public void setNegativeBarPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.negativeBarPaint = paint;
        this.fireChangeEvent();
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        boolean bl2 = true;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < categoryDataset.getRowCount(); ++i2) {
            double d4 = 0.0;
            for (int i3 = 0; i3 <= n2 - 1; ++i3) {
                Number number = categoryDataset.getValue(i2, i3);
                if (number == null) continue;
                bl2 = false;
                double d5 = number.doubleValue();
                d4 = i3 == n2 - 1 ? d5 : (d4 += d5);
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
        }
        if (!bl2) {
            return new Range(d2, d3);
        }
        return null;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        Object object;
        Object object2;
        double d2;
        double d3 = categoryItemRendererState.getSeriesRunningTotal();
        if (n3 == categoryDataset.getColumnCount() - 1) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            d4 = d3 + number.doubleValue();
        }
        categoryItemRendererState.setSeriesRunningTotal(d4);
        int n5 = this.getColumnCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = 0.0;
        double d6 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d8 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d9 = d4 - d3;
        if (d8 < d7) {
            d2 = d8;
            d8 = d7;
            d7 = d2;
        }
        d2 = categoryItemRendererState.getBarWidth();
        double d10 = Math.max(this.getMinimumBarLength(), Math.abs(d8 - d7));
        Comparable comparable = categoryDataset.getRowKey(n2);
        Comparable comparable2 = categoryDataset.getColumnKey(n3);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d6 = categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, RectangleEdge.LEFT);
            d5 = d7;
            d10 = categoryItemRendererState.getBarWidth();
            d6 -= d10 / 2.0;
            d2 = Math.max(this.getMinimumBarLength(), Math.abs(d8 - d7));
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d5 = categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, RectangleEdge.TOP);
            d5 -= d2 / 2.0;
            d6 = d7;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d2, d10);
        Paint paint = n3 == 0 ? this.getFirstBarPaint() : (n3 == n5 - 1 ? this.getLastBarPaint() : (d9 >= 0.0 ? this.getPositiveBarPaint() : this.getNegativeBarPaint()));
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            object2 = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform((GradientPaint)object2, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n2, n3);
            object = this.getItemOutlinePaint(n2, n3);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n2, n3)) != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, categoryDataset, n2, n3, categoryPlot, (CategoryItemLabelGenerator)object2, double_, d9 < 0.0);
        }
        if ((object = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity((EntityCollection)object, categoryDataset, n2, n3, double_);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof WaterfallBarRenderer)) {
            return false;
        }
        WaterfallBarRenderer waterfallBarRenderer = (WaterfallBarRenderer)object;
        if (!PaintUtilities.equal(this.firstBarPaint, waterfallBarRenderer.firstBarPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.lastBarPaint, waterfallBarRenderer.lastBarPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.positiveBarPaint, waterfallBarRenderer.positiveBarPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.negativeBarPaint, waterfallBarRenderer.negativeBarPaint);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.firstBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.lastBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.positiveBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.negativeBarPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.firstBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.lastBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.positiveBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.negativeBarPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

