/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class StatisticalLineAndShapeRenderer
extends LineAndShapeRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -3557517173697777579L;
    private transient Paint errorIndicatorPaint = null;
    private transient Stroke errorIndicatorStroke = null;

    public StatisticalLineAndShapeRenderer() {
        this(true, true);
    }

    public StatisticalLineAndShapeRenderer(boolean bl2, boolean bl3) {
        super(bl2, bl3);
    }

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        this.errorIndicatorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorIndicatorStroke() {
        return this.errorIndicatorStroke;
    }

    public void setErrorIndicatorStroke(Stroke stroke) {
        this.errorIndicatorStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        EntityCollection entityCollection;
        Number number;
        Object object;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n2, n3, n4);
            return;
        }
        int n5 = categoryItemRendererState.getVisibleSeriesIndex(n2);
        if (n5 < 0) {
            return;
        }
        int n6 = categoryItemRendererState.getVisibleSeriesCount();
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        Number number2 = statisticalCategoryDataset.getMeanValue(n2, n3);
        if (number2 == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = this.getUseSeriesOffset() ? categoryAxis.getCategorySeriesMiddle(n3, categoryDataset.getColumnCount(), n5, n6, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d3 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        Number number3 = statisticalCategoryDataset.getStdDevValue(n2, n3);
        if (n4 == 1 && number3 != null) {
            object = categoryPlot.getRangeAxisEdge();
            double d4 = number3.doubleValue();
            double d5 = number2.doubleValue() + d4 > valueAxis.getRange().getUpperBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getUpperBound(), rectangle2D, (RectangleEdge)object) : valueAxis.valueToJava2D(number2.doubleValue() + d4, rectangle2D, (RectangleEdge)object);
            double d6 = number2.doubleValue() + d4 < valueAxis.getRange().getLowerBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getLowerBound(), rectangle2D, (RectangleEdge)object) : valueAxis.valueToJava2D(number2.doubleValue() - d4, rectangle2D, (RectangleEdge)object);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemPaint(n2, n3));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            }
            Line2D.Double double_ = new Line2D.Double();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                ((Line2D)double_).setLine(d6, d2, d5, d2);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d6, d2 - 5.0, d6, d2 + 5.0);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d5, d2 - 5.0, d5, d2 + 5.0);
                graphics2D.draw(double_);
            } else {
                ((Line2D)double_).setLine(d2, d6, d2, d5);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d2 - 5.0, d5, d2 + 5.0, d5);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d2 - 5.0, d6, d2 + 5.0, d6);
                graphics2D.draw(double_);
            }
        }
        object = null;
        if (n4 == 1 && this.getItemShapeVisible(n2, n3)) {
            Shape shape = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d3, d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d2, d3);
            }
            object = shape;
            if (this.getItemShapeFilled(n2, n3)) {
                if (this.getUseFillPaint()) {
                    graphics2D.setPaint(this.getItemFillPaint(n2, n3));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n2, n3));
                }
                graphics2D.fill(shape);
            }
            if (this.getDrawOutlines()) {
                if (this.getUseOutlinePaint()) {
                    graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n2, n3));
                }
                graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
                graphics2D.draw(shape);
            }
            if (this.isItemLabelVisible(n2, n3)) {
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n2, n3, d3, d2, number2.doubleValue() < 0.0);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n2, n3, d2, d3, number2.doubleValue() < 0.0);
                }
            }
        }
        if (n4 == 0 && this.getItemLineVisible(n2, n3) && n3 != 0 && (number = statisticalCategoryDataset.getValue(n2, n3 - 1)) != null) {
            double d7 = number.doubleValue();
            double d8 = this.getUseSeriesOffset() ? categoryAxis.getCategorySeriesMiddle(n3 - 1, categoryDataset.getColumnCount(), n5, n6, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n3 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d9 = valueAxis.valueToJava2D(d7, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d9, d8, d3, d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d8, d9, d2, d3);
            }
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            graphics2D.setStroke(this.getItemStroke(n2, n3));
            graphics2D.draw(double_);
        }
        if (n4 == 1 && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addEntity(entityCollection, (Shape)object, categoryDataset, n2, n3, d2, d3);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalLineAndShapeRenderer)) {
            return false;
        }
        StatisticalLineAndShapeRenderer statisticalLineAndShapeRenderer = (StatisticalLineAndShapeRenderer)object;
        if (!PaintUtilities.equal(this.errorIndicatorPaint, statisticalLineAndShapeRenderer.errorIndicatorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorIndicatorStroke, statisticalLineAndShapeRenderer.errorIndicatorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.errorIndicatorPaint);
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorIndicatorStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

