/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StatisticalBarRenderer
extends BarRenderer
implements Serializable,
Cloneable,
CategoryItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -4986038395414039117L;
    private transient Paint errorIndicatorPaint = Color.gray;
    private transient Stroke errorIndicatorStroke = new BasicStroke(1.0f);

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        this.errorIndicatorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorIndicatorStroke() {
        return this.errorIndicatorStroke;
    }

    public void setErrorIndicatorStroke(Stroke stroke) {
        this.errorIndicatorStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        int n5 = categoryItemRendererState.getVisibleSeriesIndex(n2);
        if (n5 < 0) {
            return;
        }
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("Requires StatisticalCategoryDataset.");
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n5, n2, n3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n5, n2, n3);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n2, int n3, int n4) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        double d2 = this.calculateBarW0(categoryPlot, PlotOrientation.HORIZONTAL, rectangle2D, categoryAxis, categoryItemRendererState, n2, n4);
        Number number = statisticalCategoryDataset.getMeanValue(n3, n4);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        double d4 = 0.0;
        double d5 = this.getLowerClip();
        double d6 = this.getUpperClip();
        if (d6 <= 0.0) {
            if (d3 >= d6) {
                return;
            }
            d4 = d6;
            if (d3 <= d5) {
                d3 = d5;
            }
        } else if (d5 <= 0.0) {
            if (d3 >= d6) {
                d3 = d6;
            } else if (d3 <= d5) {
                d3 = d5;
            }
        } else {
            if (d3 <= d5) {
                return;
            }
            d4 = this.getLowerClip();
            if (d3 >= d6) {
                d3 = d6;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d8 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d9 = Math.min(d8, d7);
        double d10 = categoryItemRendererState.getBarWidth();
        double d11 = Math.abs(d8 - d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d9, d2, d11, d10);
        Paint paint = this.getItemPaint(n3, n4);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n3, n4);
            object = this.getItemOutlinePaint(n3, n4);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = statisticalCategoryDataset.getStdDevValue(n3, n4)) != null) {
            double d12 = ((Number)object2).doubleValue();
            double d13 = valueAxis.valueToJava2D(number.doubleValue() + d12, rectangle2D, rectangleEdge);
            double d14 = valueAxis.valueToJava2D(number.doubleValue() - d12, rectangle2D, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemOutlinePaint(n3, n4));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n3, n4));
            }
            Line2D.Double double_2 = new Line2D.Double(d14, d2 + d10 / 2.0, d13, d2 + d10 / 2.0);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d13, d2 + d10 * 0.25, d13, d2 + d10 * 0.75);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d14, d2 + d10 * 0.25, d14, d2 + d10 * 0.75);
            graphics2D.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(n3, n4)) != null && this.isItemLabelVisible(n3, n4)) {
            this.drawItemLabel(graphics2D, statisticalCategoryDataset, n3, n4, categoryPlot, (CategoryItemLabelGenerator)object, double_, d3 < 0.0);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, statisticalCategoryDataset, n3, n4, double_);
        }
    }

    protected void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n2, int n3, int n4) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        double d2 = this.calculateBarW0(categoryPlot, PlotOrientation.VERTICAL, rectangle2D, categoryAxis, categoryItemRendererState, n2, n4);
        Number number = statisticalCategoryDataset.getMeanValue(n3, n4);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        double d4 = 0.0;
        double d5 = this.getLowerClip();
        double d6 = this.getUpperClip();
        if (d6 <= 0.0) {
            if (d3 >= d6) {
                return;
            }
            d4 = d6;
            if (d3 <= d5) {
                d3 = d5;
            }
        } else if (d5 <= 0.0) {
            if (d3 >= d6) {
                d3 = d6;
            } else if (d3 <= d5) {
                d3 = d5;
            }
        } else {
            if (d3 <= d5) {
                return;
            }
            d4 = this.getLowerClip();
            if (d3 >= d6) {
                d3 = d6;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d8 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d9 = Math.min(d8, d7);
        double d10 = categoryItemRendererState.getBarWidth();
        double d11 = Math.abs(d8 - d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d9, d10, d11);
        Paint paint = this.getItemPaint(n3, n4);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n3, n4);
            object = this.getItemOutlinePaint(n3, n4);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = statisticalCategoryDataset.getStdDevValue(n3, n4)) != null) {
            double d12 = ((Number)object2).doubleValue();
            double d13 = valueAxis.valueToJava2D(number.doubleValue() + d12, rectangle2D, rectangleEdge);
            double d14 = valueAxis.valueToJava2D(number.doubleValue() - d12, rectangle2D, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemOutlinePaint(n3, n4));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n3, n4));
            }
            Line2D.Double double_2 = new Line2D.Double(d2 + d10 / 2.0, d14, d2 + d10 / 2.0, d13);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d2 + d10 / 2.0 - 5.0, d13, d2 + d10 / 2.0 + 5.0, d13);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d2 + d10 / 2.0 - 5.0, d14, d2 + d10 / 2.0 + 5.0, d14);
            graphics2D.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(n3, n4)) != null && this.isItemLabelVisible(n3, n4)) {
            this.drawItemLabel(graphics2D, statisticalCategoryDataset, n3, n4, categoryPlot, (CategoryItemLabelGenerator)object, double_, d3 < 0.0);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, statisticalCategoryDataset, n3, n4, double_);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalBarRenderer)) {
            return false;
        }
        StatisticalBarRenderer statisticalBarRenderer = (StatisticalBarRenderer)object;
        if (!PaintUtilities.equal(this.errorIndicatorPaint, statisticalBarRenderer.errorIndicatorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorIndicatorStroke, statisticalBarRenderer.errorIndicatorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorIndicatorStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

