/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;

public class StandardBarPainter
implements Serializable,
BarPainter {
    @Override
    public void paintBar(Graphics2D graphics2D, BarRenderer barRenderer, int n2, int n3, RectangularShape rectangularShape, RectangleEdge rectangleEdge) {
        Paint paint = barRenderer.getItemPaint(n2, n3);
        GradientPaintTransformer gradientPaintTransformer = barRenderer.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, rectangularShape);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(rectangularShape);
        if (barRenderer.isDrawBarOutline()) {
            Stroke stroke = barRenderer.getItemOutlineStroke(n2, n3);
            Paint paint2 = barRenderer.getItemOutlinePaint(n2, n3);
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    @Override
    public void paintBarShadow(Graphics2D graphics2D, BarRenderer barRenderer, int n2, int n3, RectangularShape rectangularShape, RectangleEdge rectangleEdge, boolean bl2) {
        Object object;
        Paint paint = barRenderer.getItemPaint(n2, n3);
        if (paint instanceof Color && ((Color)(object = (Color)paint)).getAlpha() == 0) {
            return;
        }
        object = this.createShadow(rectangularShape, barRenderer.getShadowXOffset(), barRenderer.getShadowYOffset(), rectangleEdge, bl2);
        graphics2D.setPaint(barRenderer.getShadowPaint());
        graphics2D.fill((Shape)object);
    }

    private Rectangle2D createShadow(RectangularShape rectangularShape, double d2, double d3, RectangleEdge rectangleEdge, boolean bl2) {
        double d4 = rectangularShape.getMinX();
        double d5 = rectangularShape.getMaxX();
        double d6 = rectangularShape.getMinY();
        double d7 = rectangularShape.getMaxY();
        if (rectangleEdge == RectangleEdge.TOP) {
            d4 += d2;
            d5 += d2;
            if (!bl2) {
                d6 += d3;
            }
            d7 += d3;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d4 += d2;
            d5 += d2;
            d6 += d3;
            if (!bl2) {
                d7 += d3;
            }
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            if (!bl2) {
                d4 += d2;
            }
            d5 += d2;
            d6 += d3;
            d7 += d3;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d4 += d2;
            if (!bl2) {
                d5 += d2;
            }
            d6 += d3;
            d7 += d3;
        }
        return new Rectangle2D.Double(d4, d6, d5 - d4, d7 - d6);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof StandardBarPainter;
    }

    public int hashCode() {
        int n2 = 37;
        return n2;
    }
}

