/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    static final long serialVersionUID = 6402943811500067531L;
    private boolean renderAsPercentages;

    public StackedBarRenderer() {
        this(false);
    }

    public StackedBarRenderer(boolean bl2) {
        this.renderAsPercentages = bl2;
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl2) {
        this.renderAsPercentages = bl2;
        this.fireChangeEvent();
    }

    @Override
    public int getPassCount() {
        return 3;
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, this.getBase());
    }

    @Override
    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n2, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n2);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d2 = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d2 = rectangle2D.getWidth();
            }
            double d3 = d2 * this.getMaximumBarWidth();
            int n3 = categoryDataset.getColumnCount();
            double d4 = 0.0;
            if (n3 > 1) {
                d4 = categoryAxis.getCategoryMargin();
            }
            double d5 = d2 * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d4);
            if (n3 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)n3, d3));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d3));
            }
        }
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        double d3;
        double d4;
        if (!this.isSeriesVisible(n2)) {
            return;
        }
        Number number = categoryDataset.getValue(n2, n3);
        if (number == null) {
            return;
        }
        double d5 = number.doubleValue();
        double d6 = 0.0;
        if (this.renderAsPercentages) {
            d6 = DataUtilities.calculateColumnTotal(categoryDataset, n3, categoryItemRendererState.getVisibleSeriesArray());
            d5 /= d6;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d7 = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d8 = d4 = this.getBase();
        for (int i2 = 0; i2 < n2; ++i2) {
            Number number2 = categoryDataset.getValue(i2, n3);
            if (number2 == null || !this.isSeriesVisible(i2)) continue;
            d3 = number2.doubleValue();
            if (this.renderAsPercentages) {
                d3 /= d6;
            }
            if (d3 > 0.0) {
                d4 += d3;
                continue;
            }
            d8 += d3;
        }
        boolean bl2 = d5 > 0.0;
        boolean bl3 = valueAxis.isInverted();
        RectangleEdge rectangleEdge = plotOrientation == PlotOrientation.HORIZONTAL ? (bl2 && bl3 || !bl2 && !bl3 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl2 && !bl3 || !bl2 && bl3 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        if (bl2) {
            d2 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge2);
            d3 = valueAxis.valueToJava2D(d4 + d5, rectangle2D, rectangleEdge2);
        } else {
            d2 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge2);
            d3 = valueAxis.valueToJava2D(d8 + d5, rectangle2D, rectangleEdge2);
        }
        double d9 = Math.min(d2, d3);
        double d10 = Math.max(Math.abs(d3 - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d9, d7, d10, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d7, d9, categoryItemRendererState.getBarWidth(), d10);
        if (n4 == 0) {
            if (this.getShadowsVisible()) {
                boolean bl4 = bl2 && d4 == this.getBase() || !bl2 && d8 == this.getBase();
                this.getBarPainter().paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge, bl4);
            }
        } else if (n4 == 1) {
            this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge);
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection != null) {
                this.addItemEntity(entityCollection, categoryDataset, n2, n3, double_);
            }
        } else if (n4 == 2 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n2, n3)) != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, categoryDataset, n2, n3, categoryPlot, categoryItemLabelGenerator, double_, d5 < 0.0);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedBarRenderer)) {
            return false;
        }
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)object;
        if (this.renderAsPercentages != stackedBarRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }
}

