/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedAreaRenderer
extends AreaRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -3595635038460823663L;
    private boolean renderAsPercentages;

    public StackedAreaRenderer() {
        this(false);
    }

    public StackedAreaRenderer(boolean bl2) {
        this.renderAsPercentages = bl2;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl2) {
        this.renderAsPercentages = bl2;
        this.fireChangeEvent();
    }

    @Override
    public int getPassCount() {
        return 2;
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        float f2;
        float f3;
        float f4;
        if (!this.isSeriesVisible(n2)) {
            return;
        }
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        double d2 = 0.0;
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
            if (this.renderAsPercentages) {
                double d3 = DataUtilities.calculateColumnTotal(categoryDataset, n3, categoryItemRendererState.getVisibleSeriesArray());
                d2 /= d3;
            }
        }
        double[] dArray = this.getStackValues(categoryDataset, n2, n3, categoryItemRendererState.getVisibleSeriesArray());
        double d4 = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d5 = 0.0;
        number = categoryDataset.getValue(n2, Math.max(n3 - 1, 0));
        if (number != null) {
            d5 = number.doubleValue();
            if (this.renderAsPercentages) {
                double d6 = DataUtilities.calculateColumnTotal(categoryDataset, Math.max(n3 - 1, 0), categoryItemRendererState.getVisibleSeriesArray());
                d5 /= d6;
            }
        }
        double[] dArray2 = this.getStackValues(categoryDataset, n2, Math.max(n3 - 1, 0), categoryItemRendererState.getVisibleSeriesArray());
        double d7 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n5 = categoryDataset.getColumnCount();
        double d8 = 0.0;
        number = categoryDataset.getValue(n2, Math.min(n3 + 1, n5 - 1));
        if (number != null) {
            d8 = number.doubleValue();
            if (this.renderAsPercentages) {
                double d9 = DataUtilities.calculateColumnTotal(categoryDataset, Math.min(n3 + 1, n5 - 1), categoryItemRendererState.getVisibleSeriesArray());
                d8 /= d9;
            }
        }
        double[] dArray3 = this.getStackValues(categoryDataset, n2, Math.min(n3 + 1, n5 - 1), categoryItemRendererState.getVisibleSeriesArray());
        double d10 = categoryAxis.getCategoryEnd(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d11 = d7;
        double d12 = d10;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        if (d2 >= 0.0) {
            f4 = (float)valueAxis.valueToJava2D(d2 + dArray[1], rectangle2D, rectangleEdge);
            f3 = (float)valueAxis.valueToJava2D(dArray[1], rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge);
            if (d5 >= 0.0) {
                double d13 = (d5 + d2) / 2.0 + dArray4[1];
                float f5 = (float)valueAxis.valueToJava2D(d13, rectangle2D, rectangleEdge);
                generalPath.moveTo((float)d4, f4);
                generalPath.lineTo((float)d4, f3);
                generalPath.lineTo((float)d11, f2);
                generalPath.lineTo((float)d11, f5);
                generalPath.closePath();
            } else {
                generalPath.moveTo((float)d4, f3);
                generalPath.lineTo((float)d4, f4);
                generalPath.lineTo((float)d11, f2);
                generalPath.closePath();
            }
            float f6 = (float)valueAxis.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge);
            if (d8 >= 0.0) {
                double d14 = (d2 + d8) / 2.0 + dArray5[1];
                float f7 = (float)valueAxis.valueToJava2D(d14, rectangle2D, rectangleEdge);
                generalPath2.moveTo((float)d4, f3);
                generalPath2.lineTo((float)d4, f4);
                generalPath2.lineTo((float)d12, f7);
                generalPath2.lineTo((float)d12, f6);
                generalPath2.closePath();
            } else {
                generalPath2.moveTo((float)d4, f3);
                generalPath2.lineTo((float)d4, f4);
                generalPath2.lineTo((float)d12, f6);
                generalPath2.closePath();
            }
        } else {
            f4 = (float)valueAxis.valueToJava2D(d2 + dArray[0], rectangle2D, rectangleEdge);
            f3 = (float)valueAxis.valueToJava2D(dArray[0], rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge);
            if (d5 >= 0.0) {
                generalPath.moveTo((float)d4, f3);
                generalPath.lineTo((float)d4, f4);
                generalPath.lineTo((float)d11, f2);
                generalPath.clone();
            } else {
                double d15 = (d5 + d2) / 2.0 + dArray4[0];
                float f8 = (float)valueAxis.valueToJava2D(d15, rectangle2D, rectangleEdge);
                generalPath.moveTo((float)d4, f4);
                generalPath.lineTo((float)d4, f3);
                generalPath.lineTo((float)d11, f2);
                generalPath.lineTo((float)d11, f8);
                generalPath.closePath();
            }
            float f9 = (float)valueAxis.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge);
            if (d8 >= 0.0) {
                generalPath2.moveTo((float)d4, f3);
                generalPath2.lineTo((float)d4, f4);
                generalPath2.lineTo((float)d12, f9);
                generalPath2.closePath();
            } else {
                double d16 = (d2 + d8) / 2.0 + dArray5[0];
                float f10 = (float)valueAxis.valueToJava2D(d16, rectangle2D, rectangleEdge);
                generalPath2.moveTo((float)d4, f3);
                generalPath2.lineTo((float)d4, f4);
                generalPath2.lineTo((float)d12, f10);
                generalPath2.lineTo((float)d12, f9);
                generalPath2.closePath();
            }
        }
        if (n4 == 0) {
            Paint paint = this.getItemPaint(n2, n3);
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
            if (entityCollection != null) {
                GeneralPath generalPath3 = new GeneralPath(generalPath);
                generalPath3.append(generalPath2, false);
                GeneralPath generalPath4 = generalPath3;
                this.addItemEntity(entityCollection, categoryDataset, n2, n3, generalPath4);
            }
        } else if (n4 == 1) {
            this.drawItemLabel(graphics2D, categoryPlot.getOrientation(), categoryDataset, n2, n3, d4, f4, d2 < 0.0);
        }
    }

    protected double[] getStackValues(CategoryDataset categoryDataset, int n2, int n3, int[] nArray) {
        double[] dArray = new double[2];
        double d2 = 0.0;
        if (this.renderAsPercentages) {
            d2 = DataUtilities.calculateColumnTotal(categoryDataset, n3, nArray);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.isSeriesVisible(i2)) continue;
            double d3 = 0.0;
            Number number = categoryDataset.getValue(i2, n3);
            if (number != null) {
                d3 = number.doubleValue();
                if (this.renderAsPercentages) {
                    d3 /= d2;
                }
            }
            if (Double.isNaN(d3)) continue;
            if (d3 >= 0.0) {
                dArray[1] = dArray[1] + d3;
                continue;
            }
            dArray[0] = dArray[0] + d3;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedAreaRenderer)) {
            return false;
        }
        StackedAreaRenderer stackedAreaRenderer = (StackedAreaRenderer)object;
        if (this.renderAsPercentages != stackedAreaRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.renderAsPercentages) {
            d3 = DataUtilities.calculateColumnTotal(categoryDataset, n3);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Number number = categoryDataset.getValue(i2, n3);
            if (number == null) continue;
            double d4 = number.doubleValue();
            if (this.renderAsPercentages) {
                d4 /= d3;
            }
            d2 += d4;
        }
        return d2;
    }
}

