/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.MultiValueCategoryDataset;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class ScatterRenderer
extends AbstractCategoryItemRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private BooleanList seriesShapesFilled = new BooleanList();
    private boolean baseShapesFilled = true;
    private boolean useFillPaint = false;
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = false;
    private boolean useSeriesOffset = true;
    private double itemMargin = 0.2;

    public boolean getUseSeriesOffset() {
        return this.useSeriesOffset;
    }

    public void setUseSeriesOffset(boolean bl2) {
        this.useSeriesOffset = bl2;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d2) {
        if (d2 < 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Requires 0.0 <= margin < 1.0.");
        }
        this.itemMargin = d2;
        this.fireChangeEvent();
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl2) {
        this.drawOutlines = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl2) {
        this.useOutlinePaint = bl2;
        this.fireChangeEvent();
    }

    public boolean getItemShapeFilled(int n2, int n3) {
        return this.getSeriesShapesFilled(n2);
    }

    public boolean getSeriesShapesFilled(int n2) {
        Boolean bl2 = this.seriesShapesFilled.getBoolean(n2);
        if (bl2 != null) {
            return bl2;
        }
        return this.baseShapesFilled;
    }

    public void setSeriesShapesFilled(int n2, Boolean bl2) {
        this.seriesShapesFilled.setBoolean(n2, bl2);
        this.fireChangeEvent();
    }

    public void setSeriesShapesFilled(int n2, boolean bl2) {
        this.seriesShapesFilled.setBoolean(n2, BooleanUtilities.valueOf(bl2));
        this.fireChangeEvent();
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl2) {
        this.baseShapesFilled = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl2) {
        this.useFillPaint = bl2;
        this.fireChangeEvent();
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        int n5 = categoryItemRendererState.getVisibleSeriesIndex(n2);
        if (n5 < 0) {
            return;
        }
        int n6 = categoryItemRendererState.getVisibleSeriesCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        MultiValueCategoryDataset multiValueCategoryDataset = (MultiValueCategoryDataset)categoryDataset;
        List list = multiValueCategoryDataset.getValues(n2, n3);
        if (list == null) {
            return;
        }
        int n7 = list.size();
        for (int i2 = 0; i2 < n7; ++i2) {
            double d2 = this.useSeriesOffset ? categoryAxis.getCategorySeriesMiddle(n3, categoryDataset.getColumnCount(), n5, n6, this.itemMargin, rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Number number = (Number)list.get(i2);
            double d3 = number.doubleValue();
            double d4 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            Shape shape = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d4, d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d2, d4);
            }
            if (this.getItemShapeFilled(n2, n3)) {
                if (this.useFillPaint) {
                    graphics2D.setPaint(this.getItemFillPaint(n2, n3));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n2, n3));
                }
                graphics2D.fill(shape);
            }
            if (!this.drawOutlines) continue;
            if (this.useOutlinePaint) {
                graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
            } else {
                graphics2D.setPaint(this.getItemPaint(n2, n3));
            }
            graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            graphics2D.draw(shape);
        }
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (this.isSeriesVisible(n3) && this.isSeriesVisibleInLegend(n3)) {
            String string;
            CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n3);
            }
            Shape shape = this.lookupLegendShape(n3);
            Paint paint = this.lookupSeriesPaint(n3);
            Paint paint2 = this.useFillPaint ? this.getItemFillPaint(n3, 0) : paint;
            boolean bl2 = this.drawOutlines;
            Paint paint3 = this.useOutlinePaint ? this.getItemOutlinePaint(n3, 0) : paint;
            Stroke stroke = this.lookupSeriesOutlineStroke(n3);
            LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, this.getItemShapeFilled(n3, 0), paint2, bl2, paint3, stroke, false, (Shape)new Line2D.Double(-7.0, 0.0, 7.0, 0.0), this.getItemStroke(n3, 0), this.getItemPaint(n3, 0));
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint4 = this.lookupLegendTextPaint(n3);
            if (paint4 != null) {
                legendItem.setLabelPaint(paint4);
            }
            legendItem.setDataset(categoryDataset);
            legendItem.setDatasetIndex(n2);
            legendItem.setSeriesKey(categoryDataset.getRowKey(n3));
            legendItem.setSeriesIndex(n3);
            return legendItem;
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ScatterRenderer)) {
            return false;
        }
        ScatterRenderer scatterRenderer = (ScatterRenderer)object;
        if (!ObjectUtilities.equal(this.seriesShapesFilled, scatterRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != scatterRenderer.baseShapesFilled) {
            return false;
        }
        if (this.useFillPaint != scatterRenderer.useFillPaint) {
            return false;
        }
        if (this.drawOutlines != scatterRenderer.drawOutlines) {
            return false;
        }
        if (this.useOutlinePaint != scatterRenderer.useOutlinePaint) {
            return false;
        }
        if (this.useSeriesOffset != scatterRenderer.useSeriesOffset) {
            return false;
        }
        if (this.itemMargin != scatterRenderer.itemMargin) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        ScatterRenderer scatterRenderer = (ScatterRenderer)super.clone();
        scatterRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        return scatterRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
    }
}

