/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;

public class MinMaxCategoryRenderer
extends AbstractCategoryItemRenderer {
    private static final long serialVersionUID = 2935615937671064911L;
    private boolean plotLines = false;
    private transient Paint groupPaint = Color.black;
    private transient Stroke groupStroke = new BasicStroke(1.0f);
    private transient Icon minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    private int lastCategory = -1;
    private double min;
    private double max;

    public boolean isDrawLines() {
        return this.plotLines;
    }

    public void setDrawLines(boolean bl2) {
        if (this.plotLines != bl2) {
            this.plotLines = bl2;
            this.fireChangeEvent();
        }
    }

    public Paint getGroupPaint() {
        return this.groupPaint;
    }

    public void setGroupPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.groupPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getGroupStroke() {
        return this.groupStroke;
    }

    public void setGroupStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.groupStroke = stroke;
        this.fireChangeEvent();
    }

    public Icon getObjectIcon() {
        return this.objectIcon;
    }

    public void setObjectIcon(Icon icon) {
        ParamChecks.nullNotPermitted(icon, "icon");
        this.objectIcon = icon;
        this.fireChangeEvent();
    }

    public Icon getMaxIcon() {
        return this.maxIcon;
    }

    public void setMaxIcon(Icon icon) {
        ParamChecks.nullNotPermitted(icon, "icon");
        this.maxIcon = icon;
        this.fireChangeEvent();
    }

    public Icon getMinIcon() {
        return this.minIcon;
    }

    public void setMinIcon(Icon icon) {
        ParamChecks.nullNotPermitted(icon, "icon");
        this.minIcon = icon;
        this.fireChangeEvent();
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            EntityCollection entityCollection;
            Number number2;
            double d2 = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - 4.0, d3 - 4.0, 8.0, 8.0);
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            graphics2D.setStroke(this.getItemStroke(n2, n3));
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.VERTICAL) {
                this.objectIcon.paintIcon(null, graphics2D, (int)d2, (int)d3);
            } else {
                this.objectIcon.paintIcon(null, graphics2D, (int)d3, (int)d2);
            }
            if (this.lastCategory == n3) {
                if (this.min > number.doubleValue()) {
                    this.min = number.doubleValue();
                }
                if (this.max < number.doubleValue()) {
                    this.max = number.doubleValue();
                }
                if (categoryDataset.getRowCount() - 1 == n2) {
                    graphics2D.setPaint(this.groupPaint);
                    graphics2D.setStroke(this.groupStroke);
                    double d4 = valueAxis.valueToJava2D(this.min, rectangle2D, categoryPlot.getRangeAxisEdge());
                    double d5 = valueAxis.valueToJava2D(this.max, rectangle2D, categoryPlot.getRangeAxisEdge());
                    if (plotOrientation == PlotOrientation.VERTICAL) {
                        graphics2D.draw(new Line2D.Double(d2, d4, d2, d5));
                        this.minIcon.paintIcon(null, graphics2D, (int)d2, (int)d4);
                        this.maxIcon.paintIcon(null, graphics2D, (int)d2, (int)d5);
                    } else {
                        graphics2D.draw(new Line2D.Double(d4, d2, d5, d2));
                        this.minIcon.paintIcon(null, graphics2D, (int)d4, (int)d2);
                        this.maxIcon.paintIcon(null, graphics2D, (int)d5, (int)d2);
                    }
                }
            } else {
                this.lastCategory = n3;
                this.min = number.doubleValue();
                this.max = number.doubleValue();
            }
            if (this.plotLines && n3 != 0 && (number2 = categoryDataset.getValue(n2, n3 - 1)) != null) {
                double d6 = number2.doubleValue();
                double d7 = categoryAxis.getCategoryMiddle(n3 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
                double d8 = valueAxis.valueToJava2D(d6, rectangle2D, categoryPlot.getRangeAxisEdge());
                graphics2D.setPaint(this.getItemPaint(n2, n3));
                graphics2D.setStroke(this.getItemStroke(n2, n3));
                Line2D.Double double_2 = plotOrientation == PlotOrientation.VERTICAL ? new Line2D.Double(d7, d8, d2, d3) : new Line2D.Double(d8, d7, d3, d2);
                graphics2D.draw(double_2);
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, categoryDataset, n2, n3, double_);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MinMaxCategoryRenderer)) {
            return false;
        }
        MinMaxCategoryRenderer minMaxCategoryRenderer = (MinMaxCategoryRenderer)object;
        if (this.plotLines != minMaxCategoryRenderer.plotLines) {
            return false;
        }
        if (!PaintUtilities.equal(this.groupPaint, minMaxCategoryRenderer.groupPaint)) {
            return false;
        }
        if (!this.groupStroke.equals(minMaxCategoryRenderer.groupStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private Icon getIcon(Shape shape, final Paint paint, final Paint paint2) {
        final int n2 = shape.getBounds().width;
        final int n3 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n22, int n32) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n22, n32));
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(generalPath);
                }
                if (paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n22, -n32));
            }

            @Override
            public int getIconWidth() {
                return n2;
            }

            @Override
            public int getIconHeight() {
                return n3;
            }
        };
    }

    private Icon getIcon(Shape shape, final boolean bl2, final boolean bl3) {
        final int n2 = shape.getBounds().width;
        final int n3 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n22, int n32) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n22, n32));
                if (bl2) {
                    graphics2D.fill(generalPath);
                }
                if (bl3) {
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n22, -n32));
            }

            @Override
            public int getIconWidth() {
                return n2;
            }

            @Override
            public int getIconHeight() {
                return n3;
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.groupStroke, objectOutputStream);
        SerialUtilities.writePaint(this.groupPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.groupStroke = SerialUtilities.readStroke(objectInputStream);
        this.groupPaint = SerialUtilities.readPaint(objectInputStream);
        this.minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    }
}

