/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class LevelRenderer
extends AbstractCategoryItemRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -8204856624355025117L;
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    private double itemMargin = 0.2;
    private double maxItemWidth = 1.0;

    public LevelRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Float(-5.0f, -1.0f, 10.0f, 2.0f));
        this.setBaseOutlinePaint(new Color(0, 0, 0, 0));
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d2) {
        this.itemMargin = d2;
        this.fireChangeEvent();
    }

    public double getMaximumItemWidth() {
        return this.getMaxItemWidth();
    }

    public void setMaximumItemWidth(double d2) {
        this.setMaxItemWidth(d2);
    }

    @Override
    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n2, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n2, plotRenderingInfo);
        this.calculateItemWidth(categoryPlot, rectangle2D, n2, categoryItemRendererState);
        return categoryItemRendererState;
    }

    protected void calculateItemWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n2, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n2);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        if (categoryDataset != null) {
            int n3 = categoryDataset.getColumnCount();
            int n4 = categoryItemRendererState.getVisibleSeriesCount() >= 0 ? categoryItemRendererState.getVisibleSeriesCount() : categoryDataset.getRowCount();
            double d2 = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d2 = rectangle2D.getWidth();
            }
            double d3 = d2 * this.getMaximumItemWidth();
            double d4 = 0.0;
            double d5 = 0.0;
            if (n3 > 1) {
                d4 = categoryAxis.getCategoryMargin();
            }
            if (n4 > 1) {
                d5 = this.getItemMargin();
            }
            double d6 = d2 * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d4 - d5);
            if (n4 * n3 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d6 / (double)(n4 * n3), d3));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d6, d3));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n2, int n3) {
        double d2 = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d3 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n4 = categoryItemRendererState.getVisibleSeriesCount();
        if (n4 < 0) {
            n4 = this.getRowCount();
        }
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            double d4 = d2 * this.getItemMargin() / (double)(n5 * (n4 - 1));
            double d5 = this.calculateSeriesWidth(d2, categoryAxis, n5, n4);
            d3 = d3 + (double)n2 * (d5 + d4) + d5 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d3 = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d3;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        Line2D.Double double_;
        double d2;
        double d3;
        int n5 = categoryItemRendererState.getVisibleSeriesIndex(n2);
        if (n5 < 0) {
            return;
        }
        Number number = categoryDataset.getValue(n2, n3);
        if (number == null) {
            return;
        }
        double d4 = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n5, n3);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = d6;
            d2 = d5 + categoryItemRendererState.getBarWidth() / 2.0;
            double_ = new Line2D.Double(d6, d5, d6, d5 + categoryItemRendererState.getBarWidth());
        } else {
            d3 = d5 + categoryItemRendererState.getBarWidth() / 2.0;
            d2 = d6;
            double_ = new Line2D.Double(d5, d6, d5 + categoryItemRendererState.getBarWidth(), d6);
        }
        Stroke stroke = this.getItemStroke(n2, n3);
        Paint paint = this.getItemPaint(n2, n3);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n2, n3, d3, d2, d4 < 0.0);
        }
        int n6 = categoryPlot.indexOf(categoryDataset);
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), categoryDataset.getRowKey(n2), categoryDataset.getColumnKey(n3), d4, n6, d5, d6, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, categoryDataset, n2, n3, double_.getBounds());
        }
    }

    protected double calculateSeriesWidth(double d2, CategoryAxis categoryAxis, int n2, int n3) {
        double d3 = 1.0 - this.getItemMargin() - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin();
        if (n2 > 1) {
            d3 -= categoryAxis.getCategoryMargin();
        }
        return d2 * d3 / (double)(n2 * n3);
    }

    @Override
    public double getItemMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, CategoryAxis categoryAxis, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.itemMargin, rectangle2D, rectangleEdge);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LevelRenderer)) {
            return false;
        }
        LevelRenderer levelRenderer = (LevelRenderer)object;
        if (this.itemMargin != levelRenderer.itemMargin) {
            return false;
        }
        if (this.maxItemWidth != levelRenderer.maxItemWidth) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.itemMargin);
        n2 = HashUtilities.hashCode(n2, this.maxItemWidth);
        return n2;
    }

    public double getMaxItemWidth() {
        return this.maxItemWidth;
    }

    public void setMaxItemWidth(double d2) {
        this.maxItemWidth = d2;
        this.fireChangeEvent();
    }
}

