/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class IntervalBarRenderer
extends BarRenderer {
    private static final long serialVersionUID = -5068857361615528725L;

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            this.drawInterval(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, intervalCategoryDataset, n2, n3);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n2, n3, n4);
        }
    }

    protected void drawInterval(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, IntervalCategoryDataset intervalCategoryDataset, int n2, int n3) {
        EntityCollection entityCollection;
        double d2;
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n2);
        if (n4 < 0) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d3 = 0.0;
        double d4 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = intervalCategoryDataset.getEndValue(n2, n3);
        if (number == null) {
            return;
        }
        double d5 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = intervalCategoryDataset.getStartValue(n2, n3);
        if (number2 == null) {
            return;
        }
        double d6 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d6 < d5) {
            d2 = d6;
            d6 = d5;
            d5 = d2;
        }
        d2 = categoryItemRendererState.getBarWidth();
        double d7 = Math.abs(d6 - d5);
        RectangleEdge rectangleEdge2 = RectangleEdge.LEFT;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = d5;
            d4 = this.calculateBarW0(this.getPlot(), plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n4, n3);
            d7 = categoryItemRendererState.getBarWidth();
            d2 = Math.abs(d6 - d5);
            rectangleEdge2 = RectangleEdge.LEFT;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = this.calculateBarW0(this.getPlot(), plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n4, n3);
            d4 = d5;
            rectangleEdge2 = RectangleEdge.BOTTOM;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d2, d7);
        BarPainter barPainter = this.getBarPainter();
        if (this.getShadowsVisible()) {
            barPainter.paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge2, false);
        }
        this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge2);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, intervalCategoryDataset, n2, n3, categoryPlot, categoryItemLabelGenerator, double_, false);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, intervalCategoryDataset, n2, n3, double_);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalBarRenderer)) {
            return false;
        }
        return super.equals(object);
    }
}

