/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.ui.RectangleEdge;

public class GradientBarPainter
implements Serializable,
BarPainter {
    private double g1;
    private double g2;
    private double g3;

    public GradientBarPainter() {
        this(0.1, 0.2, 0.8);
    }

    public GradientBarPainter(double d2, double d3, double d4) {
        this.g1 = d2;
        this.g2 = d3;
        this.g3 = d4;
    }

    @Override
    public void paintBar(Graphics2D graphics2D, BarRenderer barRenderer, int n2, int n3, RectangularShape rectangularShape, RectangleEdge rectangleEdge) {
        Paint paint;
        Object object;
        Color color;
        Color color2;
        Paint paint2 = barRenderer.getItemPaint(n2, n3);
        if (paint2 instanceof Color) {
            color2 = (Color)paint2;
            color = color2.brighter();
        } else if (paint2 instanceof GradientPaint) {
            object = (Rectangle2D[])paint2;
            color2 = object.getColor1();
            color = object.getColor2();
        } else {
            color2 = Color.BLUE;
            color = Color.BLUE.brighter();
        }
        if (color2.getAlpha() == 0) {
            return;
        }
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            object = this.splitVerticalBar(rectangularShape, this.g1, this.g2, this.g3);
            paint = new GradientPaint((float)object[0].getMinX(), 0.0f, color2, (float)object[0].getMaxX(), 0.0f, Color.WHITE);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[0]);
            paint = new GradientPaint((float)object[1].getMinX(), 0.0f, Color.WHITE, (float)object[1].getMaxX(), 0.0f, color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[1]);
            paint = new GradientPaint((float)object[2].getMinX(), 0.0f, color2, (float)object[2].getMaxX(), 0.0f, color);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[2]);
            paint = new GradientPaint((float)object[3].getMinX(), 0.0f, color, (float)object[3].getMaxX(), 0.0f, color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[3]);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            object = this.splitHorizontalBar(rectangularShape, this.g1, this.g2, this.g3);
            paint = new GradientPaint(0.0f, (float)object[0].getMinY(), color2, 0.0f, (float)object[0].getMaxY(), Color.WHITE);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[0]);
            paint = new GradientPaint(0.0f, (float)object[1].getMinY(), Color.WHITE, 0.0f, (float)object[1].getMaxY(), color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[1]);
            paint = new GradientPaint(0.0f, (float)object[2].getMinY(), color2, 0.0f, (float)object[2].getMaxY(), color);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[2]);
            paint = new GradientPaint(0.0f, (float)object[3].getMinY(), color, 0.0f, (float)object[3].getMaxY(), color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[3]);
        }
        if (barRenderer.isDrawBarOutline()) {
            object = barRenderer.getItemOutlineStroke(n2, n3);
            paint = barRenderer.getItemOutlinePaint(n2, n3);
            if (object != null && paint != null) {
                graphics2D.setStroke((Stroke)object);
                graphics2D.setPaint(paint);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    @Override
    public void paintBarShadow(Graphics2D graphics2D, BarRenderer barRenderer, int n2, int n3, RectangularShape rectangularShape, RectangleEdge rectangleEdge, boolean bl2) {
        Object object;
        Paint paint = barRenderer.getItemPaint(n2, n3);
        if (paint instanceof Color && ((Color)(object = (Color)paint)).getAlpha() == 0) {
            return;
        }
        object = this.createShadow(rectangularShape, barRenderer.getShadowXOffset(), barRenderer.getShadowYOffset(), rectangleEdge, bl2);
        graphics2D.setPaint(barRenderer.getShadowPaint());
        graphics2D.fill((Shape)object);
    }

    private Rectangle2D createShadow(RectangularShape rectangularShape, double d2, double d3, RectangleEdge rectangleEdge, boolean bl2) {
        double d4 = rectangularShape.getMinX();
        double d5 = rectangularShape.getMaxX();
        double d6 = rectangularShape.getMinY();
        double d7 = rectangularShape.getMaxY();
        if (rectangleEdge == RectangleEdge.TOP) {
            d4 += d2;
            d5 += d2;
            if (!bl2) {
                d6 += d3;
            }
            d7 += d3;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d4 += d2;
            d5 += d2;
            d6 += d3;
            if (!bl2) {
                d7 += d3;
            }
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            if (!bl2) {
                d4 += d2;
            }
            d5 += d2;
            d6 += d3;
            d7 += d3;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d4 += d2;
            if (!bl2) {
                d5 += d2;
            }
            d6 += d3;
            d7 += d3;
        }
        return new Rectangle2D.Double(d4, d6, d5 - d4, d7 - d6);
    }

    private Rectangle2D[] splitVerticalBar(RectangularShape rectangularShape, double d2, double d3, double d4) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d5 = rectangularShape.getMinX();
        double d6 = Math.rint(d5 + rectangularShape.getWidth() * d2);
        double d7 = Math.rint(d5 + rectangularShape.getWidth() * d3);
        double d8 = Math.rint(d5 + rectangularShape.getWidth() * d4);
        rectangle2DArray[0] = new Rectangle2D.Double(rectangularShape.getMinX(), rectangularShape.getMinY(), d6 - d5, rectangularShape.getHeight());
        rectangle2DArray[1] = new Rectangle2D.Double(d6, rectangularShape.getMinY(), d7 - d6, rectangularShape.getHeight());
        rectangle2DArray[2] = new Rectangle2D.Double(d7, rectangularShape.getMinY(), d8 - d7, rectangularShape.getHeight());
        rectangle2DArray[3] = new Rectangle2D.Double(d8, rectangularShape.getMinY(), rectangularShape.getMaxX() - d8, rectangularShape.getHeight());
        return rectangle2DArray;
    }

    private Rectangle2D[] splitHorizontalBar(RectangularShape rectangularShape, double d2, double d3, double d4) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d5 = rectangularShape.getMinY();
        double d6 = Math.rint(d5 + rectangularShape.getHeight() * d2);
        double d7 = Math.rint(d5 + rectangularShape.getHeight() * d3);
        double d8 = Math.rint(d5 + rectangularShape.getHeight() * d4);
        rectangle2DArray[0] = new Rectangle2D.Double(rectangularShape.getMinX(), rectangularShape.getMinY(), rectangularShape.getWidth(), d6 - d5);
        rectangle2DArray[1] = new Rectangle2D.Double(rectangularShape.getMinX(), d6, rectangularShape.getWidth(), d7 - d6);
        rectangle2DArray[2] = new Rectangle2D.Double(rectangularShape.getMinX(), d7, rectangularShape.getWidth(), d8 - d7);
        rectangle2DArray[3] = new Rectangle2D.Double(rectangularShape.getMinX(), d8, rectangularShape.getWidth(), rectangularShape.getMaxY() - d8);
        return rectangle2DArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GradientBarPainter)) {
            return false;
        }
        GradientBarPainter gradientBarPainter = (GradientBarPainter)object;
        if (this.g1 != gradientBarPainter.g1) {
            return false;
        }
        if (this.g2 != gradientBarPainter.g2) {
            return false;
        }
        return this.g3 == gradientBarPainter.g3;
    }

    public int hashCode() {
        int n2 = 37;
        n2 = HashUtilities.hashCode(n2, this.g1);
        n2 = HashUtilities.hashCode(n2, this.g2);
        n2 = HashUtilities.hashCode(n2, this.g3);
        return n2;
    }
}

