/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;

public class GanttRenderer
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -4010349116350119512L;
    private transient Paint completePaint;
    private transient Paint incompletePaint;
    private double startPercent;
    private double endPercent;

    public GanttRenderer() {
        this.setIncludeBaseInRange(false);
        this.completePaint = Color.green;
        this.incompletePaint = Color.red;
        this.startPercent = 0.35;
        this.endPercent = 0.65;
    }

    public Paint getCompletePaint() {
        return this.completePaint;
    }

    public void setCompletePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.completePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getIncompletePaint() {
        return this.incompletePaint;
    }

    public void setIncompletePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.incompletePaint = paint;
        this.fireChangeEvent();
    }

    public double getStartPercent() {
        return this.startPercent;
    }

    public void setStartPercent(double d2) {
        this.startPercent = d2;
        this.fireChangeEvent();
    }

    public double getEndPercent() {
        return this.endPercent;
    }

    public void setEndPercent(double d2) {
        this.endPercent = d2;
        this.fireChangeEvent();
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        if (categoryDataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)categoryDataset;
            this.drawTasks(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n2, n3);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n2, n3, n4);
        }
    }

    protected void drawTasks(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n2, int n3) {
        int n4 = ganttCategoryDataset.getSubIntervalCount(n2, n3);
        if (n4 == 0) {
            this.drawTask(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n2, n3);
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        for (int i2 = 0; i2 < n4; ++i2) {
            EntityCollection entityCollection;
            double d2;
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getStartValue(n2, n3, i2);
            if (number == null) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            Number number2 = ganttCategoryDataset.getEndValue(n2, n3, i2);
            if (number2 == null) {
                return;
            }
            double d4 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            if (d4 < d3) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d2 = this.calculateBarW0(categoryPlot, categoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n2, n3);
            double d5 = Math.abs(d4 - d3);
            double d6 = categoryItemRendererState.getBarWidth();
            Rectangle2D.Double double_ = null;
            RectangleEdge rectangleEdge2 = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d3, d2, d5, d6);
                rectangleEdge2 = RectangleEdge.LEFT;
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d2, d3, d6, d5);
                rectangleEdge2 = RectangleEdge.BOTTOM;
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number3 = ganttCategoryDataset.getPercentComplete(n2, n3, i2);
            double d7 = this.getStartPercent();
            double d8 = this.getEndPercent();
            if (number3 != null) {
                double d9 = number3.doubleValue();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d3, d2 + d7 * d6, d5 * d9, d6 * (d8 - d7));
                    double_3 = new Rectangle2D.Double(d3 + d5 * d9, d2 + d7 * d6, d5 * (1.0 - d9), d6 * (d8 - d7));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d2 + d7 * d6, d3 + d5 * (1.0 - d9), d6 * (d8 - d7), d5 * d9);
                    double_3 = new Rectangle2D.Double(d2 + d7 * d6, d3, d6 * (d8 - d7), d5 * (1.0 - d9));
                }
            }
            if (this.getShadowsVisible()) {
                this.getBarPainter().paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge2, true);
            }
            this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge2);
            if (double_2 != null) {
                graphics2D.setPaint(this.getCompletePaint());
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.getIncompletePaint());
                graphics2D.fill(double_3);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                graphics2D.draw(double_);
            }
            if (i2 == n4 - 1) {
                int n5 = categoryPlot.indexOf(ganttCategoryDataset);
                Comparable comparable = ganttCategoryDataset.getColumnKey(n3);
                Comparable comparable2 = ganttCategoryDataset.getRowKey(n2);
                double d10 = categoryAxis.getCategorySeriesMiddle(comparable, comparable2, ganttCategoryDataset, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge());
                this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), ganttCategoryDataset.getRowKey(n2), ganttCategoryDataset.getColumnKey(n3), number2.doubleValue(), n5, d10, d4, plotOrientation);
            }
            if (categoryItemRendererState.getInfo() == null || (entityCollection = categoryItemRendererState.getEntityCollection()) == null) continue;
            this.addItemEntity(entityCollection, ganttCategoryDataset, n2, n3, double_);
        }
    }

    protected void drawTask(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = ganttCategoryDataset.getEndValue(n2, n3);
        if (number == null) {
            return;
        }
        double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = ganttCategoryDataset.getStartValue(n2, n3);
        if (number2 == null) {
            return;
        }
        double d4 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d4 < d3) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
            number2 = number;
        }
        d2 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n2, n3);
        double d5 = categoryItemRendererState.getBarWidth();
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_ = null;
        RectangleEdge rectangleEdge2 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(d3, d2, d6, d5);
            rectangleEdge2 = RectangleEdge.LEFT;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d2, d4, d5, d6);
            rectangleEdge2 = RectangleEdge.BOTTOM;
        }
        Rectangle2D.Double double_2 = null;
        Rectangle2D.Double double_3 = null;
        Number number3 = ganttCategoryDataset.getPercentComplete(n2, n3);
        double d7 = this.getStartPercent();
        double d8 = this.getEndPercent();
        if (number3 != null) {
            double d9 = number3.doubleValue();
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_2 = new Rectangle2D.Double(d3, d2 + d7 * d5, d6 * d9, d5 * (d8 - d7));
                double_3 = new Rectangle2D.Double(d3 + d6 * d9, d2 + d7 * d5, d6 * (1.0 - d9), d5 * (d8 - d7));
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_2 = new Rectangle2D.Double(d2 + d7 * d5, d4 + d6 * (1.0 - d9), d5 * (d8 - d7), d6 * d9);
                double_3 = new Rectangle2D.Double(d2 + d7 * d5, d4, d5 * (d8 - d7), d6 * (1.0 - d9));
            }
        }
        if (this.getShadowsVisible()) {
            this.getBarPainter().paintBarShadow(graphics2D, this, n2, n3, double_, rectangleEdge2, true);
        }
        this.getBarPainter().paintBar(graphics2D, this, n2, n3, double_, rectangleEdge2);
        if (double_2 != null) {
            graphics2D.setPaint(this.getCompletePaint());
            graphics2D.fill(double_2);
        }
        if (double_3 != null) {
            graphics2D.setPaint(this.getIncompletePaint());
            graphics2D.fill(double_3);
        }
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(n2, n3);
            Paint paint = this.getItemOutlinePaint(n2, n3);
            if (stroke != null && paint != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint);
                graphics2D.draw(double_);
            }
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n2, n3)) != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, ganttCategoryDataset, n2, n3, categoryPlot, categoryItemLabelGenerator, double_, false);
        }
        int n4 = categoryPlot.indexOf(ganttCategoryDataset);
        Comparable comparable = ganttCategoryDataset.getColumnKey(n3);
        Comparable comparable2 = ganttCategoryDataset.getRowKey(n2);
        double d10 = categoryAxis.getCategorySeriesMiddle(comparable, comparable2, ganttCategoryDataset, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge());
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), ganttCategoryDataset.getRowKey(n2), ganttCategoryDataset.getColumnKey(n3), number2.doubleValue(), n4, d10, d4, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, ganttCategoryDataset, n2, n3, double_);
        }
    }

    @Override
    public double getItemMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, CategoryAxis categoryAxis, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, rectangleEdge);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GanttRenderer)) {
            return false;
        }
        GanttRenderer ganttRenderer = (GanttRenderer)object;
        if (!PaintUtilities.equal(this.completePaint, ganttRenderer.completePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.incompletePaint, ganttRenderer.incompletePaint)) {
            return false;
        }
        if (this.startPercent != ganttRenderer.startPercent) {
            return false;
        }
        if (this.endPercent != ganttRenderer.endPercent) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.completePaint, objectOutputStream);
        SerialUtilities.writePaint(this.incompletePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.completePaint = SerialUtilities.readPaint(objectInputStream);
        this.incompletePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

