/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 632027470694481177L;
    private transient Paint artifactPaint = Color.black;
    private boolean fillBox = true;
    private double itemMargin = 0.2;
    private double maximumBarWidth = 1.0;
    private boolean medianVisible = true;
    private boolean meanVisible = true;
    private boolean useOutlinePaintForWhiskers = false;
    private double whiskerWidth = 1.0;

    public BoxAndWhiskerRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
    }

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.artifactPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean bl2) {
        this.fillBox = bl2;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d2) {
        this.itemMargin = d2;
        this.fireChangeEvent();
    }

    public double getMaximumBarWidth() {
        return this.maximumBarWidth;
    }

    public void setMaximumBarWidth(double d2) {
        this.maximumBarWidth = d2;
        this.fireChangeEvent();
    }

    public boolean isMeanVisible() {
        return this.meanVisible;
    }

    public void setMeanVisible(boolean bl2) {
        if (this.meanVisible == bl2) {
            return;
        }
        this.meanVisible = bl2;
        this.fireChangeEvent();
    }

    public boolean isMedianVisible() {
        return this.medianVisible;
    }

    public void setMedianVisible(boolean bl2) {
        if (this.medianVisible == bl2) {
            return;
        }
        this.medianVisible = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaintForWhiskers() {
        return this.useOutlinePaintForWhiskers;
    }

    public void setUseOutlinePaintForWhiskers(boolean bl2) {
        if (this.useOutlinePaintForWhiskers == bl2) {
            return;
        }
        this.useOutlinePaintForWhiskers = bl2;
        this.fireChangeEvent();
    }

    public double getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public void setWhiskerWidth(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Value for whisker width out of range");
        }
        if (d2 == this.whiskerWidth) {
            return;
        }
        this.whiskerWidth = d2;
        this.fireChangeEvent();
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n3) || !this.isSeriesVisibleInLegend(n3)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n3);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n3);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n3);
        }
        Shape shape = this.lookupLegendShape(n3);
        Paint paint = this.lookupSeriesPaint(n3);
        Paint paint2 = this.lookupSeriesOutlinePaint(n3);
        Stroke stroke = this.lookupSeriesOutlineStroke(n3);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n3));
        Paint paint3 = this.lookupLegendTextPaint(n3);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n2);
        legendItem.setSeriesKey(categoryDataset.getRowKey(n3));
        legendItem.setSeriesIndex(n3);
        return legendItem;
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return super.findRangeBounds(categoryDataset, true);
    }

    @Override
    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n2, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n2, plotRenderingInfo);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n2);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        if (categoryDataset != null) {
            int n3 = categoryDataset.getColumnCount();
            int n4 = categoryDataset.getRowCount();
            double d2 = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d2 = rectangle2D.getWidth();
            }
            double d3 = d2 * this.getMaximumBarWidth();
            double d4 = 0.0;
            double d5 = 0.0;
            if (n3 > 1) {
                d4 = categoryAxis.getCategoryMargin();
            }
            if (n4 > 1) {
                d5 = this.getItemMargin();
            }
            double d6 = d2 * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d4 - d5);
            if (n4 * n3 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d6 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()), d3));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d6, d3));
            }
        }
        return categoryItemRendererState;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n2, n3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n2, n3);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3) {
        EntityCollection entityCollection;
        Number number;
        double d2;
        Number number2;
        double d3;
        double d4;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d5 = categoryAxis.getCategoryEnd(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d6 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d7 = Math.abs(d5 - d6);
        double d8 = d6;
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            d4 = rectangle2D.getHeight() * this.getItemMargin() / (double)(n5 * (n4 - 1));
            double d9 = categoryItemRendererState.getBarWidth() * (double)n4 + d4 * (double)(n4 - 1);
            double d10 = (d7 - d9) / 2.0;
            d8 = d8 + d10 + (double)n2 * (categoryItemRendererState.getBarWidth() + d4);
        } else {
            d4 = (d7 - categoryItemRendererState.getBarWidth()) / 2.0;
            d8 += d4;
        }
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setStroke(stroke);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number3 = boxAndWhiskerCategoryDataset.getQ1Value(n2, n3);
        Number number4 = boxAndWhiskerCategoryDataset.getQ3Value(n2, n3);
        Number number5 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n2, n3);
        Number number6 = boxAndWhiskerCategoryDataset.getMinRegularValue(n2, n3);
        Rectangle2D.Double double_ = null;
        if (number3 != null && number4 != null && number5 != null && number6 != null) {
            d3 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            double d11 = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            double d12 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            double d13 = valueAxis.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            double d14 = d8 + categoryItemRendererState.getBarWidth() / 2.0;
            double d15 = categoryItemRendererState.getBarWidth() / 2.0 * this.whiskerWidth;
            double_ = new Rectangle2D.Double(Math.min(d3, d11), d8, Math.abs(d3 - d11), categoryItemRendererState.getBarWidth());
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            Paint paint = this.getItemOutlinePaint(n2, n3);
            if (this.useOutlinePaintForWhiskers) {
                graphics2D.setPaint(paint);
            }
            graphics2D.draw(new Line2D.Double(d12, d14, d11, d14));
            graphics2D.draw(new Line2D.Double(d12, d14 - d15, d12, d14 + d15));
            graphics2D.draw(new Line2D.Double(d13, d14, d3, d14));
            graphics2D.draw(new Line2D.Double(d13, d14 - d15, d13, d8 + d15));
            graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        if (this.meanVisible && (number2 = boxAndWhiskerCategoryDataset.getMeanValue(n2, n3)) != null) {
            d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d3 = categoryItemRendererState.getBarWidth() / 4.0;
            if (d2 > rectangle2D.getMinX() - d3 && d2 < rectangle2D.getMaxX() + d3) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(d2 - d3, d8 + d3, d3 * 2.0, d3 * 2.0);
                graphics2D.fill(double_2);
                graphics2D.draw(double_2);
            }
        }
        if (this.medianVisible && (number = boxAndWhiskerCategoryDataset.getMedianValue(n2, n3)) != null) {
            d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d2, d8, d2, d8 + categoryItemRendererState.getBarWidth()));
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, categoryDataset, n2, n3, double_);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3) {
        Object object;
        Number number;
        Number number2;
        Object object2;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d8 = categoryAxis.getCategoryEnd(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d9 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d10 = d8 - d9;
        double d11 = d9;
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            d7 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n5 * (n4 - 1));
            d6 = categoryItemRendererState.getBarWidth() * (double)n4 + d7 * (double)(n4 - 1);
            double d12 = (d10 - d6) / 2.0;
            d11 = d11 + d12 + (double)n2 * (categoryItemRendererState.getBarWidth() + d7);
        } else {
            d7 = (d10 - categoryItemRendererState.getBarWidth()) / 2.0;
            d11 += d7;
        }
        Paint paint = this.getItemPaint(n2, n3);
        graphics2D.setPaint(paint);
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setStroke(stroke);
        double d13 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number3 = boxAndWhiskerCategoryDataset.getQ1Value(n2, n3);
        Number number4 = boxAndWhiskerCategoryDataset.getQ3Value(n2, n3);
        Number number5 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n2, n3);
        Number number6 = boxAndWhiskerCategoryDataset.getMinRegularValue(n2, n3);
        Rectangle2D.Double double_ = null;
        if (number3 != null && number4 != null && number5 != null && number6 != null) {
            d5 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d4 = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            double d14 = valueAxis.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            double d15 = d11 + categoryItemRendererState.getBarWidth() / 2.0;
            d2 = categoryItemRendererState.getBarWidth() / 2.0 * this.whiskerWidth;
            double_ = new Rectangle2D.Double(d11, Math.min(d5, d4), categoryItemRendererState.getBarWidth(), Math.abs(d5 - d4));
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            object2 = this.getItemOutlinePaint(n2, n3);
            if (this.useOutlinePaintForWhiskers) {
                graphics2D.setPaint((Paint)object2);
            }
            graphics2D.draw(new Line2D.Double(d15, d3, d15, d4));
            graphics2D.draw(new Line2D.Double(d15 - d2, d3, d15 + d2, d3));
            graphics2D.draw(new Line2D.Double(d15, d14, d15, d5));
            graphics2D.draw(new Line2D.Double(d15 - d2, d14, d15 + d2, d14));
            graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            graphics2D.setPaint((Paint)object2);
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        if (this.meanVisible && (number2 = boxAndWhiskerCategoryDataset.getMeanValue(n2, n3)) != null) {
            d7 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d13 = categoryItemRendererState.getBarWidth() / 4.0;
            if (d7 > rectangle2D.getMinY() - d13 && d7 < rectangle2D.getMaxY() + d13) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(d11 + d13, d7 - d13, d13 * 2.0, d13 * 2.0);
                graphics2D.fill(double_2);
                graphics2D.draw(double_2);
            }
        }
        if (this.medianVisible && (number = boxAndWhiskerCategoryDataset.getMedianValue(n2, n3)) != null) {
            double d16 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d11, d16, d11 + categoryItemRendererState.getBarWidth(), d16));
        }
        d5 = valueAxis.valueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d13;
        d4 = valueAxis.valueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d13;
        graphics2D.setPaint(paint);
        d3 = categoryItemRendererState.getBarWidth() / 3.0;
        ArrayList<Outlier> arrayList = new ArrayList<Outlier>();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = boxAndWhiskerCategoryDataset.getOutliers(n2, n3);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                d2 = ((Number)list.get(i2)).doubleValue();
                object2 = boxAndWhiskerCategoryDataset.getMinOutlier(n2, n3);
                Number number7 = boxAndWhiskerCategoryDataset.getMaxOutlier(n2, n3);
                Number number8 = boxAndWhiskerCategoryDataset.getMinRegularValue(n2, n3);
                Number number9 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n2, n3);
                if (d2 > number7.doubleValue()) {
                    outlierListCollection.setHighFarOut(true);
                } else if (d2 < ((Number)object2).doubleValue()) {
                    outlierListCollection.setLowFarOut(true);
                } else if (d2 > number9.doubleValue()) {
                    d6 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d11 + categoryItemRendererState.getBarWidth() / 2.0, d6, d3));
                } else if (d2 < number8.doubleValue()) {
                    d6 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d11 + categoryItemRendererState.getBarWidth() / 2.0, d6, d3));
                }
                Collections.sort(arrayList);
            }
            for (Outlier outlier : arrayList) {
                outlierListCollection.add(outlier);
            }
            object = outlierListCollection.iterator();
            while (object.hasNext()) {
                OutlierList outlierList = (OutlierList)object.next();
                Outlier outlier = outlierList.getAveragedOutlier();
                object2 = outlier.getPoint();
                if (outlierList.isMultiple()) {
                    this.drawMultipleEllipse((Point2D)object2, categoryItemRendererState.getBarWidth(), d3, graphics2D);
                    continue;
                }
                this.drawEllipse((Point2D)object2, d3, graphics2D);
            }
            if (outlierListCollection.isHighFarOut()) {
                this.drawHighFarOut(d13 / 2.0, graphics2D, d11 + categoryItemRendererState.getBarWidth() / 2.0, d5);
            }
            if (outlierListCollection.isLowFarOut()) {
                this.drawLowFarOut(d13 / 2.0, graphics2D, d11 + categoryItemRendererState.getBarWidth() / 2.0, d4);
            }
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity((EntityCollection)object, categoryDataset, n2, n3, double_);
        }
    }

    private void drawEllipse(Point2D point2D, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d2 / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d2, double d3, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d2 / 2.0 + d3, point2D.getY(), d3, d3);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d2 / 2.0, point2D.getY(), d3, d3);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d2, Graphics2D graphics2D, double d3, double d4) {
        double d5 = d2 * 2.0;
        graphics2D.draw(new Line2D.Double(d3 - d5, d4 + d5, d3 + d5, d4 + d5));
        graphics2D.draw(new Line2D.Double(d3 - d5, d4 + d5, d3, d4));
        graphics2D.draw(new Line2D.Double(d3 + d5, d4 + d5, d3, d4));
    }

    private void drawLowFarOut(double d2, Graphics2D graphics2D, double d3, double d4) {
        double d5 = d2 * 2.0;
        graphics2D.draw(new Line2D.Double(d3 - d5, d4 - d5, d3 + d5, d4 - d5));
        graphics2D.draw(new Line2D.Double(d3 - d5, d4 - d5, d3, d4));
        graphics2D.draw(new Line2D.Double(d3 + d5, d4 - d5, d3, d4));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BoxAndWhiskerRenderer)) {
            return false;
        }
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = (BoxAndWhiskerRenderer)object;
        if (this.fillBox != boxAndWhiskerRenderer.fillBox) {
            return false;
        }
        if (this.itemMargin != boxAndWhiskerRenderer.itemMargin) {
            return false;
        }
        if (this.maximumBarWidth != boxAndWhiskerRenderer.maximumBarWidth) {
            return false;
        }
        if (this.meanVisible != boxAndWhiskerRenderer.meanVisible) {
            return false;
        }
        if (this.medianVisible != boxAndWhiskerRenderer.medianVisible) {
            return false;
        }
        if (this.useOutlinePaintForWhiskers != boxAndWhiskerRenderer.useOutlinePaintForWhiskers) {
            return false;
        }
        if (this.whiskerWidth != boxAndWhiskerRenderer.whiskerWidth) {
            return false;
        }
        if (!PaintUtilities.equal(this.artifactPaint, boxAndWhiskerRenderer.artifactPaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.artifactPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.artifactPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

