/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AreaRendererEndType;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class AreaRenderer
extends AbstractCategoryItemRenderer
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -4231878281385812757L;
    private AreaRendererEndType endType = AreaRendererEndType.TAPER;

    public AreaRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
    }

    public AreaRendererEndType getEndType() {
        return this.endType;
    }

    public void setEndType(AreaRendererEndType areaRendererEndType) {
        ParamChecks.nullNotPermitted(areaRendererEndType, "type");
        this.endType = areaRendererEndType;
        this.fireChangeEvent();
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n3) || !this.isSeriesVisibleInLegend(n3)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n3);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n3);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n3);
        }
        Shape shape = this.lookupLegendShape(n3);
        Paint paint = this.lookupSeriesPaint(n3);
        Paint paint2 = this.lookupSeriesOutlinePaint(n3);
        Stroke stroke = this.lookupSeriesOutlineStroke(n3);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n3));
        Paint paint3 = this.lookupLegendTextPaint(n3);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n2);
        legendItem.setSeriesKey(categoryDataset.getRowKey(n3));
        legendItem.setSeriesIndex(n3);
        return legendItem;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n2, int n3, int n4) {
        Serializable serializable;
        Number number;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        Number number2 = categoryDataset.getValue(n2, n3);
        if (number2 == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        int n5 = categoryDataset.getColumnCount();
        float f2 = (float)categoryAxis.getCategoryStart(n3, n5, rectangle2D, rectangleEdge);
        float f3 = (float)categoryAxis.getCategoryMiddle(n3, n5, rectangle2D, rectangleEdge);
        float f4 = (float)categoryAxis.getCategoryEnd(n3, n5, rectangle2D, rectangleEdge);
        f2 = Math.round(f2);
        f3 = Math.round(f3);
        f4 = Math.round(f4);
        if (this.endType == AreaRendererEndType.TRUNCATE) {
            if (n3 == 0) {
                f2 = f3;
            } else if (n3 == this.getColumnCount() - 1) {
                f4 = f3;
            }
        }
        double d2 = number2.doubleValue();
        double d3 = 0.0;
        if (this.endType == AreaRendererEndType.LEVEL) {
            d3 = d2;
        }
        if (n3 > 0 && (number = categoryDataset.getValue(n2, n3 - 1)) != null) {
            d3 = (number.doubleValue() + d2) / 2.0;
        }
        double d4 = 0.0;
        if (n3 < categoryDataset.getColumnCount() - 1) {
            serializable = categoryDataset.getValue(n2, n3 + 1);
            if (serializable != null) {
                d4 = (((Number)serializable).doubleValue() + d2) / 2.0;
            }
        } else if (this.endType == AreaRendererEndType.LEVEL) {
            d4 = d2;
        }
        serializable = categoryPlot.getRangeAxisEdge();
        float f5 = (float)valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)serializable);
        float f6 = (float)valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)serializable);
        float f7 = (float)valueAxis.valueToJava2D(d4, rectangle2D, (RectangleEdge)serializable);
        float f8 = (float)valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)serializable);
        double d5 = f3;
        double d6 = f6;
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        graphics2D.setStroke(this.getItemStroke(n2, n3));
        GeneralPath generalPath = new GeneralPath();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            generalPath.moveTo(f2, f8);
            generalPath.lineTo(f2, f5);
            generalPath.lineTo(f3, f6);
            generalPath.lineTo(f4, f7);
            generalPath.lineTo(f4, f8);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            generalPath.moveTo(f8, f2);
            generalPath.lineTo(f5, f2);
            generalPath.lineTo(f6, f3);
            generalPath.lineTo(f7, f4);
            generalPath.lineTo(f8, f4);
            double d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        generalPath.closePath();
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        graphics2D.fill(generalPath);
        if (this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n2, n3, d5, d6, number2.doubleValue() < 0.0);
        }
        int n6 = categoryPlot.indexOf(categoryDataset);
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), categoryDataset.getRowKey(n2), categoryDataset.getColumnKey(n3), d2, n6, f3, f6, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, categoryDataset, n2, n3, generalPath);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AreaRenderer)) {
            return false;
        }
        AreaRenderer areaRenderer = (AreaRenderer)object;
        if (!this.endType.equals(areaRenderer.endType)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

