/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategorySeriesLabelGenerator;
import org.jfree.chart.plot.CategoryCrosshairState;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.TextUtils;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements Serializable,
Cloneable,
CategoryItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = 1247553218442497391L;
    private CategoryPlot plot;
    private Map<Integer, CategoryItemLabelGenerator> itemLabelGeneratorMap = new HashMap<Integer, CategoryItemLabelGenerator>();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private Map<Integer, CategoryToolTipGenerator> toolTipGeneratorMap = new HashMap<Integer, CategoryToolTipGenerator>();
    private CategoryToolTipGenerator baseToolTipGenerator;
    private Map<Integer, CategoryURLGenerator> itemURLGeneratorMap = new HashMap<Integer, CategoryURLGenerator>();
    private CategoryURLGenerator baseItemURLGenerator;
    private CategorySeriesLabelGenerator legendItemLabelGenerator = new StandardCategorySeriesLabelGenerator();
    private CategorySeriesLabelGenerator legendItemToolTipGenerator;
    private CategorySeriesLabelGenerator legendItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private CategoryItemLabelGenerator itemLabelGenerator = null;
    private CategoryToolTipGenerator toolTipGenerator = null;
    private CategoryURLGenerator itemURLGenerator = null;

    protected AbstractCategoryItemRenderer() {
    }

    @Override
    public int getPassCount() {
        return 1;
    }

    @Override
    public CategoryPlot getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(CategoryPlot categoryPlot) {
        ParamChecks.nullNotPermitted(categoryPlot, "plot");
        this.plot = categoryPlot;
    }

    @Override
    public CategoryItemLabelGenerator getItemLabelGenerator(int n2, int n3) {
        return this.getSeriesItemLabelGenerator(n2);
    }

    @Override
    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int n2) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.itemLabelGeneratorMap.get(n2);
        if (categoryItemLabelGenerator == null) {
            categoryItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return categoryItemLabelGenerator;
    }

    @Override
    public void setSeriesItemLabelGenerator(int n2, CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGeneratorMap.put(n2, categoryItemLabelGenerator);
        this.fireChangeEvent();
    }

    @Override
    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    @Override
    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.baseItemLabelGenerator = categoryItemLabelGenerator;
        this.fireChangeEvent();
    }

    @Override
    public CategoryToolTipGenerator getToolTipGenerator(int n2, int n3) {
        CategoryToolTipGenerator categoryToolTipGenerator;
        if (this.toolTipGenerator != null) {
            categoryToolTipGenerator = this.toolTipGenerator;
        } else {
            categoryToolTipGenerator = this.getSeriesToolTipGenerator(n2);
            if (categoryToolTipGenerator == null) {
                categoryToolTipGenerator = this.baseToolTipGenerator;
            }
        }
        return categoryToolTipGenerator;
    }

    @Override
    public CategoryToolTipGenerator getSeriesToolTipGenerator(int n2) {
        return this.toolTipGeneratorMap.get(n2);
    }

    @Override
    public void setSeriesToolTipGenerator(int n2, CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGeneratorMap.put(n2, categoryToolTipGenerator);
        this.fireChangeEvent();
    }

    @Override
    public CategoryToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    @Override
    public void setBaseToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.baseToolTipGenerator = categoryToolTipGenerator;
        this.fireChangeEvent();
    }

    @Override
    public CategoryURLGenerator getItemURLGenerator(int n2, int n3) {
        return this.getSeriesItemURLGenerator(n2);
    }

    @Override
    public CategoryURLGenerator getSeriesItemURLGenerator(int n2) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator categoryURLGenerator = this.itemURLGeneratorMap.get(n2);
        if (categoryURLGenerator == null) {
            categoryURLGenerator = this.baseItemURLGenerator;
        }
        return categoryURLGenerator;
    }

    @Override
    public void setSeriesItemURLGenerator(int n2, CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGeneratorMap.put(n2, categoryURLGenerator);
        this.fireChangeEvent();
    }

    @Override
    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    @Override
    public void setBaseItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.baseItemURLGenerator = categoryURLGenerator;
        this.fireChangeEvent();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected CategoryItemRendererState createState(PlotRenderingInfo plotRenderingInfo) {
        return new CategoryItemRendererState(plotRenderingInfo);
    }

    @Override
    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n2, PlotRenderingInfo plotRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        CategoryItemRendererState categoryItemRendererState = this.createState(plotRenderingInfo);
        int[] nArray = new int[this.rowCount];
        int n3 = 0;
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            if (!this.isSeriesVisible(i2)) continue;
            nArray[n3] = i2;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        categoryItemRendererState.setVisibleSeriesArray(nArray2);
        return categoryItemRendererState;
    }

    @Override
    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, false);
    }

    protected Range findRangeBounds(CategoryDataset categoryDataset, boolean bl2) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n2 = categoryDataset.getRowCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.isSeriesVisible(i2)) continue;
                arrayList.add(categoryDataset.getRowKey(i2));
            }
            return DatasetUtilities.findRangeBounds(categoryDataset, arrayList, bl2);
        }
        return DatasetUtilities.findRangeBounds(categoryDataset, bl2);
    }

    @Override
    public double getItemMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, CategoryAxis categoryAxis, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return categoryAxis.getCategoryMiddle(comparable2, categoryDataset.getColumnKeys(), rectangle2D, rectangleEdge);
    }

    @Override
    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    @Override
    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    @Override
    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d2) {
        Line2D.Double double_ = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    @Override
    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2) {
        Range range = valueAxis.getRange();
        if (!range.contains(d2)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeLine(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d2, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d2)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        Line2D.Double double_ = null;
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    @Override
    public void drawDomainMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, CategoryMarker categoryMarker, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        double d2;
        Comparable comparable = categoryMarker.getKey();
        CategoryDataset categoryDataset = categoryPlot.getDataset(categoryPlot.getIndexOf(this));
        int n2 = categoryDataset.getColumnIndex(comparable);
        if (n2 < 0) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, categoryMarker.getAlpha()));
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (categoryMarker.getDrawAsLine()) {
            d2 = categoryAxis.getCategoryMiddle(n2, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else {
                throw new IllegalStateException();
            }
            graphics2D.setPaint(categoryMarker.getPaint());
            graphics2D.setStroke(categoryMarker.getStroke());
            graphics2D.draw(double_);
            rectangle2D2 = double_.getBounds2D();
        } else {
            d2 = categoryAxis.getCategoryStart(n2, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d3 = categoryAxis.getCategoryEnd(n2, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getWidth(), d3 - d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d2, rectangle2D.getMinY(), d3 - d2, rectangle2D.getHeight());
            }
            graphics2D.setPaint(categoryMarker.getPaint());
            graphics2D.fill(double_);
            rectangle2D2 = double_;
        }
        String string = categoryMarker.getLabel();
        RectangleAnchor rectangleAnchor = categoryMarker.getLabelAnchor();
        if (string != null) {
            Font font = categoryMarker.getLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(categoryMarker.getLabelPaint());
            Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, rectangle2D2, categoryMarker.getLabelOffset(), categoryMarker.getLabelOffsetType(), rectangleAnchor);
            TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryMarker.getLabelTextAnchor());
        }
        graphics2D.setComposite(composite);
    }

    @Override
    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d2 = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d2)) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            } else {
                throw new IllegalStateException();
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                Rectangle2D rectangle2D2 = TextUtils.calcAlignedStringBounds(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
                graphics2D.setPaint(marker.getLabelBackgroundColor());
                graphics2D.fill(rectangle2D2);
                graphics2D.setPaint(marker.getLabelPaint());
                TextUtils.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d4 = intervalMarker.getStartValue();
            double d5 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d4, d5)) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d7 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d8 = Math.max(d8, rectangle2D.getMinX());
                d9 = Math.min(d9, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d8, rectangle2D.getMinY(), d9 - d8, rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d8 = Math.max(d8, rectangle2D.getMinY());
                d9 = Math.min(d9, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d8, rectangle2D.getWidth(), d9 - d8);
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d10;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d11 = rectangle2D.getMinX();
                    d10 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d11, d6, d10, d6);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d11, d7, d10, d7);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d12 = rectangle2D.getMinY();
                    d10 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d4)) {
                        ((Line2D)object2).setLine(d6, d12, d6, d10);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d5)) {
                        ((Line2D)object2).setLine(d7, d12, d7, d10);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    protected Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n3) || !this.isSeriesVisibleInLegend(n3)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n2);
        String string2 = string = this.legendItemLabelGenerator.generateLabel(categoryDataset, n3);
        String string3 = null;
        if (this.legendItemToolTipGenerator != null) {
            string3 = this.legendItemToolTipGenerator.generateLabel(categoryDataset, n3);
        }
        String string4 = null;
        if (this.legendItemURLGenerator != null) {
            string4 = this.legendItemURLGenerator.generateLabel(categoryDataset, n3);
        }
        Shape shape = this.lookupLegendShape(n3);
        Paint paint = this.lookupSeriesPaint(n3);
        Paint paint2 = this.lookupSeriesOutlinePaint(n3);
        Stroke stroke = this.lookupSeriesOutlineStroke(n3);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n3));
        Paint paint3 = this.lookupLegendTextPaint(n3);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setSeriesKey(categoryDataset.getRowKey(n3));
        legendItem.setSeriesIndex(n3);
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n2);
        return legendItem;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractCategoryItemRenderer)) {
            return false;
        }
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)object;
        if (!ObjectUtilities.equal(this.itemLabelGenerator, abstractCategoryItemRenderer.itemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelGeneratorMap, abstractCategoryItemRenderer.itemLabelGeneratorMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelGenerator, abstractCategoryItemRenderer.baseItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, abstractCategoryItemRenderer.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGeneratorMap, abstractCategoryItemRenderer.toolTipGeneratorMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, abstractCategoryItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemURLGenerator, abstractCategoryItemRenderer.itemURLGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemURLGeneratorMap, abstractCategoryItemRenderer.itemURLGeneratorMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemURLGenerator, abstractCategoryItemRenderer.baseItemURLGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemLabelGenerator, abstractCategoryItemRenderer.legendItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, abstractCategoryItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, abstractCategoryItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        return n2;
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot != null) {
            drawingSupplier = categoryPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CategoryCrosshairState categoryCrosshairState, Comparable comparable, Comparable comparable2, double d2, int n2, double d3, double d4, PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        if (categoryCrosshairState != null) {
            if (this.plot.isRangeCrosshairLockedOnData()) {
                categoryCrosshairState.updateCrosshairPoint(comparable, comparable2, d2, n2, d3, d4, plotOrientation);
            } else {
                categoryCrosshairState.updateCrosshairX(comparable, comparable2, n2, d3, plotOrientation);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, CategoryDataset categoryDataset, int n2, int n3, double d2, double d3, boolean bl2) {
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n2, n3);
        if (categoryItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n2, n3);
            Paint paint = this.getItemLabelPaint(n2, n3);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = categoryItemLabelGenerator.generateLabel(categoryDataset, n2, n3);
            ItemLabelPosition itemLabelPosition = !bl2 ? this.getPositiveItemLabelPosition(n2, n3) : this.getNegativeItemLabelPosition(n2, n3);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d2, d3, plotOrientation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    @Override
    public Object clone() {
        PublicCloneable publicCloneable;
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)super.clone();
        if (this.itemLabelGenerator != null) {
            if (this.itemLabelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.itemLabelGenerator);
                abstractCategoryItemRenderer.itemLabelGenerator = (CategoryItemLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.itemLabelGeneratorMap != null) {
            abstractCategoryItemRenderer.itemLabelGeneratorMap = CloneUtils.cloneMapValues(this.itemLabelGeneratorMap);
        }
        if (this.baseItemLabelGenerator != null) {
            if (this.baseItemLabelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseItemLabelGenerator);
                abstractCategoryItemRenderer.baseItemLabelGenerator = (CategoryItemLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.toolTipGenerator != null) {
            if (this.toolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.toolTipGenerator);
                abstractCategoryItemRenderer.toolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Tool tip generator not cloneable.");
            }
        }
        if (this.toolTipGeneratorMap != null) {
            abstractCategoryItemRenderer.toolTipGeneratorMap = CloneUtils.cloneMapValues(this.toolTipGeneratorMap);
        }
        if (this.baseToolTipGenerator != null) {
            if (this.baseToolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseToolTipGenerator);
                abstractCategoryItemRenderer.baseToolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base tool tip generator not cloneable.");
            }
        }
        if (this.itemURLGenerator != null) {
            if (this.itemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.itemURLGenerator);
                abstractCategoryItemRenderer.itemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Item URL generator not cloneable.");
            }
        }
        if (this.itemURLGeneratorMap != null) {
            abstractCategoryItemRenderer.itemURLGeneratorMap = CloneUtils.cloneMapValues(this.itemURLGeneratorMap);
        }
        if (this.baseItemURLGenerator != null) {
            if (this.baseItemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseItemURLGenerator);
                abstractCategoryItemRenderer.baseItemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base item URL generator not cloneable.");
            }
        }
        if (this.legendItemLabelGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemLabelGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemLabelGenerator);
        }
        if (this.legendItemToolTipGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemToolTipGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (this.legendItemURLGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemURLGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        return abstractCategoryItemRenderer;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot categoryPlot, int n2) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis(n2);
        if (categoryAxis == null) {
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    protected ValueAxis getRangeAxis(CategoryPlot categoryPlot, int n2) {
        ValueAxis valueAxis = categoryPlot.getRangeAxis(n2);
        if (valueAxis == null) {
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.plot == null) {
            return legendItemCollection;
        }
        int n2 = this.plot.getIndexOf(this);
        CategoryDataset categoryDataset = this.plot.getDataset(n2);
        if (categoryDataset == null) {
            return legendItemCollection;
        }
        int n3 = categoryDataset.getRowCount();
        if (this.plot.getRowRenderingOrder().equals(SortOrder.ASCENDING)) {
            for (int i2 = 0; i2 < n3; ++i2) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i2) || (legendItem = this.getLegendItem(n2, i2)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        } else {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i3) || (legendItem = this.getLegendItem(n2, i3)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public CategorySeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        ParamChecks.nullNotPermitted(categorySeriesLabelGenerator, "generator");
        this.legendItemLabelGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public CategorySeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        this.legendItemToolTipGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public CategorySeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        this.legendItemURLGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    protected void addItemEntity(EntityCollection entityCollection, CategoryDataset categoryDataset, int n2, int n3, Shape shape) {
        ParamChecks.nullNotPermitted(shape, "hotspot");
        if (!this.getItemCreateEntity(n2, n3)) {
            return;
        }
        String string = null;
        CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n2, n3);
        if (categoryToolTipGenerator != null) {
            string = categoryToolTipGenerator.generateToolTip(categoryDataset, n2, n3);
        }
        String string2 = null;
        CategoryURLGenerator categoryURLGenerator = this.getItemURLGenerator(n2, n3);
        if (categoryURLGenerator != null) {
            string2 = categoryURLGenerator.generateURL(categoryDataset, n2, n3);
        }
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, categoryDataset.getRowKey(n2), categoryDataset.getColumnKey(n3));
        entityCollection.add(categoryItemEntity);
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, CategoryDataset categoryDataset, int n2, int n3, double d2, double d3) {
        if (!this.getItemCreateEntity(n2, n3)) {
            return;
        }
        Shape shape2 = shape;
        if (shape == null) {
            double d4 = this.getDefaultEntityRadius();
            double d5 = d4 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d2 - d4, d3 - d4, d5, d5) : new Ellipse2D.Double(d3 - d4, d2 - d4, d5, d5);
        }
        String string = null;
        CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n2, n3);
        if (categoryToolTipGenerator != null) {
            string = categoryToolTipGenerator.generateToolTip(categoryDataset, n2, n3);
        }
        String string2 = null;
        CategoryURLGenerator categoryURLGenerator = this.getItemURLGenerator(n2, n3);
        if (categoryURLGenerator != null) {
            string2 = categoryURLGenerator.generateURL(categoryDataset, n2, n3);
        }
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape2, string, string2, categoryDataset, categoryDataset.getRowKey(n2), categoryDataset.getColumnKey(n3));
        entityCollection.add(categoryItemEntity);
    }

    @Override
    public void setItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGenerator = categoryItemLabelGenerator;
        this.fireChangeEvent();
    }

    @Override
    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    @Override
    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.fireChangeEvent();
    }

    @Override
    public void setItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGenerator = categoryURLGenerator;
        this.fireChangeEvent();
    }
}

