/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainOrder;
import org.jfree.data.xy.XYDataset;

public class RendererUtilities {
    public static int findLiveItemsLowerBound(XYDataset xYDataset, int n2, double d2, double d3) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires xLow < xHigh.");
        }
        int n3 = xYDataset.getItemCount(n2);
        if (n3 <= 1) {
            return 0;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n4 = 0;
            int n5 = n3 - 1;
            double d4 = xYDataset.getXValue(n2, n4);
            if (d4 >= d2) {
                return n4;
            }
            double d5 = xYDataset.getXValue(n2, n5);
            if (d5 < d2) {
                return n5;
            }
            while (n5 - n4 > 1) {
                int n6 = (n4 + n5) / 2;
                double d6 = xYDataset.getXValue(n2, n6);
                if (d6 >= d2) {
                    n5 = n6;
                    continue;
                }
                n4 = n6;
            }
            return n5;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n7 = 0;
            int n8 = n3 - 1;
            double d7 = xYDataset.getXValue(n2, n7);
            if (d7 <= d3) {
                return n7;
            }
            double d8 = xYDataset.getXValue(n2, n8);
            if (d8 > d3) {
                return n8;
            }
            while (n8 - n7 > 1) {
                int n9 = (n7 + n8) / 2;
                double d9 = xYDataset.getXValue(n2, n9);
                if (d9 > d3) {
                    n7 = n9;
                    continue;
                }
                n8 = n9;
            }
            return n8;
        }
        int n10 = 0;
        double d10 = xYDataset.getXValue(n2, n10);
        while (n10 < n3 && d10 < d2) {
            if (++n10 >= n3) continue;
            d10 = xYDataset.getXValue(n2, n10);
        }
        return Math.min(Math.max(0, n10), n3 - 1);
    }

    public static int findLiveItemsUpperBound(XYDataset xYDataset, int n2, double d2, double d3) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires xLow < xHigh.");
        }
        int n3 = xYDataset.getItemCount(n2);
        if (n3 <= 1) {
            return 0;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n4 = 0;
            int n5 = n3 - 1;
            double d4 = xYDataset.getXValue(n2, n4);
            if (d4 > d3) {
                return n4;
            }
            double d5 = xYDataset.getXValue(n2, n5);
            if (d5 <= d3) {
                return n5;
            }
            int n6 = (n4 + n5) / 2;
            while (n5 - n4 > 1) {
                double d6 = xYDataset.getXValue(n2, n6);
                if (d6 <= d3) {
                    n4 = n6;
                } else {
                    n5 = n6;
                }
                n6 = (n4 + n5) / 2;
            }
            return n6;
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n7 = 0;
            int n8 = n3 - 1;
            int n9 = (n7 + n8) / 2;
            double d7 = xYDataset.getXValue(n2, n7);
            if (d7 < d2) {
                return n7;
            }
            double d8 = xYDataset.getXValue(n2, n8);
            if (d8 >= d2) {
                return n8;
            }
            while (n8 - n7 > 1) {
                double d9 = xYDataset.getXValue(n2, n9);
                if (d9 >= d2) {
                    n7 = n9;
                } else {
                    n8 = n9;
                }
                n9 = (n7 + n8) / 2;
            }
            return n9;
        }
        int n10 = n3 - 1;
        double d10 = xYDataset.getXValue(n2, n10);
        while (n10 >= 0 && d10 > d3) {
            if (--n10 < 0) continue;
            d10 = xYDataset.getXValue(n2, n10);
        }
        return Math.max(n10, 0);
    }

    public static int[] findLiveItems(XYDataset xYDataset, int n2, double d2, double d3) {
        int n3;
        int n4 = RendererUtilities.findLiveItemsLowerBound(xYDataset, n2, d2, d3);
        if (n4 > (n3 = RendererUtilities.findLiveItemsUpperBound(xYDataset, n2, d2, d3))) {
            n4 = n3;
        }
        return new int[]{n4, n3};
    }
}

