/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class LookupPaintScale
implements Serializable,
PaintScale,
PublicCloneable {
    static final long serialVersionUID = -5239384246251042006L;
    private double lowerBound;
    private double upperBound;
    private transient Paint defaultPaint;
    private List lookupTable;

    public LookupPaintScale() {
        this(0.0, 1.0, Color.lightGray);
    }

    public LookupPaintScale(double d2, double d3, Paint paint) {
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        ParamChecks.nullNotPermitted(paint, "defaultPaint");
        this.lowerBound = d2;
        this.upperBound = d3;
        this.defaultPaint = paint;
        this.lookupTable = new ArrayList();
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    public void add(Number number, Paint paint) {
        this.add(number.doubleValue(), paint);
    }

    public void add(double d2, Paint paint) {
        PaintItem paintItem = new PaintItem(d2, paint);
        int n2 = Collections.binarySearch(this.lookupTable, paintItem);
        if (n2 >= 0) {
            this.lookupTable.set(n2, paintItem);
        } else {
            this.lookupTable.add(-(n2 + 1), paintItem);
        }
    }

    @Override
    public Paint getPaint(double d2) {
        if (d2 < this.lowerBound) {
            return this.defaultPaint;
        }
        if (d2 > this.upperBound) {
            return this.defaultPaint;
        }
        int n2 = this.lookupTable.size();
        if (n2 == 0) {
            return this.defaultPaint;
        }
        PaintItem paintItem = (PaintItem)this.lookupTable.get(0);
        if (d2 < paintItem.value) {
            return this.defaultPaint;
        }
        int n3 = 0;
        int n4 = this.lookupTable.size() - 1;
        while (n4 - n3 > 1) {
            int n5 = (n3 + n4) / 2;
            paintItem = (PaintItem)this.lookupTable.get(n5);
            if (d2 >= paintItem.value) {
                n3 = n5;
                continue;
            }
            n4 = n5;
        }
        if (n4 > n3) {
            paintItem = (PaintItem)this.lookupTable.get(n4);
            if (d2 < paintItem.value) {
                paintItem = (PaintItem)this.lookupTable.get(n3);
            }
        }
        return paintItem != null ? paintItem.paint : this.defaultPaint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LookupPaintScale)) {
            return false;
        }
        LookupPaintScale lookupPaintScale = (LookupPaintScale)object;
        if (this.lowerBound != lookupPaintScale.lowerBound) {
            return false;
        }
        if (this.upperBound != lookupPaintScale.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal(this.defaultPaint, lookupPaintScale.defaultPaint)) {
            return false;
        }
        return this.lookupTable.equals(lookupPaintScale.lookupTable);
    }

    @Override
    public Object clone() {
        LookupPaintScale lookupPaintScale = (LookupPaintScale)super.clone();
        lookupPaintScale.lookupTable = new ArrayList(this.lookupTable);
        return lookupPaintScale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.defaultPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.defaultPaint = SerialUtilities.readPaint(objectInputStream);
    }

    static class PaintItem
    implements Serializable,
    Comparable {
        static final long serialVersionUID = 698920578512361570L;
        double value;
        transient Paint paint;

        public PaintItem(double d2, Paint paint) {
            this.value = d2;
            this.paint = paint;
        }

        public int compareTo(Object object) {
            PaintItem paintItem = (PaintItem)object;
            double d2 = this.value;
            double d3 = paintItem.value;
            if (d2 > d3) {
                return 1;
            }
            if (d2 < d3) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PaintItem)) {
                return false;
            }
            PaintItem paintItem = (PaintItem)object;
            if (this.value != paintItem.value) {
                return false;
            }
            return PaintUtilities.equal(this.paint, paintItem.paint);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.paint, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) {
            objectInputStream.defaultReadObject();
            this.paint = SerialUtilities.readPaint(objectInputStream);
        }
    }
}

