/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.util.PublicCloneable;

public class GrayPaintScale
implements Serializable,
PaintScale,
PublicCloneable {
    private double lowerBound;
    private double upperBound;
    private int alpha;

    public GrayPaintScale() {
        this(0.0, 1.0);
    }

    public GrayPaintScale(double d2, double d3) {
        this(d2, d3, 255);
    }

    public GrayPaintScale(double d2, double d3, int n2) {
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("Requires alpha in the range 0 to 255.");
        }
        this.lowerBound = d2;
        this.upperBound = d3;
        this.alpha = n2;
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public Paint getPaint(double d2) {
        double d3 = Math.max(d2, this.lowerBound);
        d3 = Math.min(d3, this.upperBound);
        int n2 = (int)((d3 - this.lowerBound) / (this.upperBound - this.lowerBound) * 255.0);
        return new Color(n2, n2, n2, this.alpha);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GrayPaintScale)) {
            return false;
        }
        GrayPaintScale grayPaintScale = (GrayPaintScale)object;
        if (this.lowerBound != grayPaintScale.lowerBound) {
            return false;
        }
        if (this.upperBound != grayPaintScale.upperBound) {
            return false;
        }
        return this.alpha == grayPaintScale.alpha;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = HashUtilities.hashCode(n2, this.lowerBound);
        n2 = HashUtilities.hashCode(n2, this.upperBound);
        n2 = 43 * n2 + this.alpha;
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

