/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class DefaultPolarItemRenderer
extends AbstractRenderer
implements PolarItemRenderer {
    private PolarPlot plot;
    private BooleanList seriesFilled = new BooleanList();
    private boolean drawOutlineWhenFilled = true;
    private transient Composite fillComposite = AlphaComposite.getInstance(3, 0.3f);
    private boolean useFillPaint = false;
    private transient Shape legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
    private boolean shapesVisible = true;
    private boolean connectFirstAndLastPoint = true;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private XYSeriesLabelGenerator legendItemToolTipGenerator = null;
    private XYSeriesLabelGenerator legendItemURLGenerator = null;

    @Override
    public void setPlot(PolarPlot polarPlot) {
        this.plot = polarPlot;
    }

    @Override
    public PolarPlot getPlot() {
        return this.plot;
    }

    public boolean getDrawOutlineWhenFilled() {
        return this.drawOutlineWhenFilled;
    }

    public void setDrawOutlineWhenFilled(boolean bl2) {
        this.drawOutlineWhenFilled = bl2;
        this.fireChangeEvent();
    }

    public Composite getFillComposite() {
        return this.fillComposite;
    }

    public void setFillComposite(Composite composite) {
        ParamChecks.nullNotPermitted(composite, "composite");
        this.fillComposite = composite;
        this.fireChangeEvent();
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl2) {
        this.shapesVisible = bl2;
        this.fireChangeEvent();
    }

    public boolean getConnectFirstAndLastPoint() {
        return this.connectFirstAndLastPoint;
    }

    public void setConnectFirstAndLastPoint(boolean bl2) {
        this.connectFirstAndLastPoint = bl2;
        this.fireChangeEvent();
    }

    @Override
    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot != null) {
            drawingSupplier = polarPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    public boolean isSeriesFilled(int n2) {
        boolean bl2 = false;
        Boolean bl3 = this.seriesFilled.getBoolean(n2);
        if (bl3 != null) {
            bl2 = bl3;
        }
        return bl2;
    }

    public void setSeriesFilled(int n2, boolean bl2) {
        this.seriesFilled.setBoolean(n2, BooleanUtilities.valueOf(bl2));
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl2) {
        this.useFillPaint = bl2;
        this.fireChangeEvent();
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "line");
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n2, int n3, double d2, double d3) {
        if (!this.getItemCreateEntity(n2, n3)) {
            return;
        }
        Shape shape2 = shape;
        if (shape2 == null) {
            double d4 = this.getDefaultEntityRadius();
            double d5 = d4 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d2 - d4, d3 - d4, d5, d5) : new Ellipse2D.Double(d3 - d4, d2 - d4, d5, d5);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n2, n3);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n2, n3);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape2, xYDataset, n2, n3, string, string2);
        entityCollection.add(xYItemEntity);
    }

    @Override
    public void drawSeries(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, PolarPlot polarPlot, XYDataset xYDataset, int n2) {
        int n3 = xYDataset.getItemCount(n2);
        if (n3 == 0) {
            return;
        }
        Path2D path2D = null;
        ValueAxis valueAxis = polarPlot.getAxisForDataset(polarPlot.indexOf(xYDataset));
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2 = xYDataset.getXValue(n2, i2);
            double d3 = xYDataset.getYValue(n2, i2);
            Point point = polarPlot.translateToJava2D(d2, d3, valueAxis, rectangle2D);
            if (path2D == null) {
                path2D = new GeneralPath();
                ((Path2D.Float)path2D).moveTo(point.x, point.y);
                continue;
            }
            ((Path2D.Float)path2D).lineTo(point.x, point.y);
        }
        assert (path2D != null);
        if (this.getConnectFirstAndLastPoint()) {
            path2D.closePath();
        }
        graphics2D.setPaint(this.lookupSeriesPaint(n2));
        graphics2D.setStroke(this.lookupSeriesStroke(n2));
        if (this.isSeriesFilled(n2)) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(this.fillComposite);
            graphics2D.fill(path2D);
            graphics2D.setComposite(composite);
            if (this.drawOutlineWhenFilled) {
                graphics2D.setPaint(this.lookupSeriesOutlinePaint(n2));
                graphics2D.draw(path2D);
            }
        } else {
            graphics2D.draw(path2D);
        }
        if (this.shapesVisible) {
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            PathIterator pathIterator = ((Path2D.Float)path2D).getPathIterator(null);
            int n4 = 0;
            while (!pathIterator.isDone()) {
                float[] fArray = new float[6];
                int n5 = pathIterator.currentSegment(fArray);
                pathIterator.next();
                if (n5 != 1 && n5 != 0) continue;
                int n6 = Math.round(fArray[0]);
                int n7 = Math.round(fArray[1]);
                Shape shape = ShapeUtilities.createTranslatedShape(this.getItemShape(n2, n4++), n6, n7);
                Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(n2) : this.lookupSeriesPaint(n2);
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
                if (this.isSeriesFilled(n2) && this.drawOutlineWhenFilled) {
                    graphics2D.setPaint(this.lookupSeriesOutlinePaint(n2));
                    graphics2D.setStroke(this.lookupSeriesOutlineStroke(n2));
                    graphics2D.draw(shape);
                }
                if (entityCollection == null || !AbstractXYItemRenderer.isPointInRect(rectangle2D, n6, n7)) continue;
                this.addEntity(entityCollection, shape, xYDataset, n2, n4 - 1, n6, n7);
            }
        }
    }

    @Override
    public void drawAngularGridLines(Graphics2D graphics2D, PolarPlot polarPlot, List list, Rectangle2D rectangle2D) {
        double d2;
        double d3;
        graphics2D.setFont(polarPlot.getAngleLabelFont());
        graphics2D.setStroke(polarPlot.getAngleGridlineStroke());
        graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
        ValueAxis valueAxis = polarPlot.getAxis();
        if (valueAxis.isInverted()) {
            d3 = valueAxis.getLowerBound();
            d2 = valueAxis.getUpperBound();
        } else {
            d3 = valueAxis.getUpperBound();
            d2 = valueAxis.getLowerBound();
        }
        Point point = polarPlot.translateToJava2D(0.0, d2, valueAxis, rectangle2D);
        for (NumberTick numberTick : list) {
            double d4 = numberTick.getNumber().doubleValue();
            Point point2 = polarPlot.translateToJava2D(d4, d3, valueAxis, rectangle2D);
            graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            if (!polarPlot.isAngleLabelsVisible()) continue;
            int n2 = point2.x;
            int n3 = point2.y;
            graphics2D.setPaint(polarPlot.getAngleLabelPaint());
            TextUtilities.drawAlignedString(numberTick.getText(), graphics2D, n2, n3, numberTick.getTextAnchor());
        }
    }

    @Override
    public void drawRadialGridLines(Graphics2D graphics2D, PolarPlot polarPlot, ValueAxis valueAxis, List list, Rectangle2D rectangle2D) {
        ParamChecks.nullNotPermitted(valueAxis, "radialAxis");
        graphics2D.setFont(valueAxis.getTickLabelFont());
        graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
        graphics2D.setStroke(polarPlot.getRadiusGridlineStroke());
        double d2 = valueAxis.isInverted() ? valueAxis.getUpperBound() : valueAxis.getLowerBound();
        Point point = polarPlot.translateToJava2D(0.0, d2, valueAxis, rectangle2D);
        for (NumberTick numberTick : list) {
            double d3 = polarPlot.isCounterClockwise() ? polarPlot.getAngleOffset() : -polarPlot.getAngleOffset();
            Point point2 = polarPlot.translateToJava2D(d3, numberTick.getNumber().doubleValue(), valueAxis, rectangle2D);
            int n2 = point2.x - point.x;
            int n3 = point.x - n2;
            int n4 = point.y - n2;
            int n5 = 2 * n2;
            Ellipse2D.Double double_ = new Ellipse2D.Double(n3, n4, n5, n5);
            graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
            graphics2D.draw(double_);
        }
    }

    @Override
    public LegendItem getLegendItem(int n2) {
        String string;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot == null) {
            return null;
        }
        XYDataset xYDataset = polarPlot.getDataset(polarPlot.getIndexOf(this));
        if (xYDataset == null) {
            return null;
        }
        String string2 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string2 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
        }
        String string3 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string3 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
        }
        Comparable comparable = xYDataset.getSeriesKey(n2);
        String string4 = string = comparable.toString();
        Shape shape = this.lookupSeriesShape(n2);
        Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(n2) : this.lookupSeriesPaint(n2);
        Stroke stroke = this.lookupSeriesStroke(n2);
        Paint paint2 = this.lookupSeriesOutlinePaint(n2);
        Stroke stroke2 = this.lookupSeriesOutlineStroke(n2);
        boolean bl2 = this.isSeriesFilled(n2) && this.drawOutlineWhenFilled;
        LegendItem legendItem = new LegendItem(string, string4, string2, string3, this.getShapesVisible(), shape, true, paint, bl2, paint2, stroke2, true, this.legendLine, stroke, paint);
        legendItem.setToolTipText(string2);
        legendItem.setURLText(string3);
        legendItem.setDataset(xYDataset);
        legendItem.setSeriesKey(comparable);
        legendItem.setSeriesIndex(n2);
        return legendItem;
    }

    @Override
    public XYToolTipGenerator getToolTipGenerator(int n2, int n3) {
        XYToolTipGenerator xYToolTipGenerator = (XYToolTipGenerator)this.toolTipGeneratorList.get(n2);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    @Override
    public XYToolTipGenerator getSeriesToolTipGenerator(int n2) {
        return (XYToolTipGenerator)this.toolTipGeneratorList.get(n2);
    }

    @Override
    public void setSeriesToolTipGenerator(int n2, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorList.set(n2, xYToolTipGenerator);
        this.fireChangeEvent();
    }

    @Override
    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    @Override
    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    @Override
    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    @Override
    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemToolTipGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemURLGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DefaultPolarItemRenderer)) {
            return false;
        }
        DefaultPolarItemRenderer defaultPolarItemRenderer = (DefaultPolarItemRenderer)object;
        if (!this.seriesFilled.equals(defaultPolarItemRenderer.seriesFilled)) {
            return false;
        }
        if (this.drawOutlineWhenFilled != defaultPolarItemRenderer.drawOutlineWhenFilled) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillComposite, defaultPolarItemRenderer.fillComposite)) {
            return false;
        }
        if (this.useFillPaint != defaultPolarItemRenderer.useFillPaint) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, defaultPolarItemRenderer.legendLine)) {
            return false;
        }
        if (this.shapesVisible != defaultPolarItemRenderer.shapesVisible) {
            return false;
        }
        if (this.connectFirstAndLastPoint != defaultPolarItemRenderer.connectFirstAndLastPoint) {
            return false;
        }
        if (!this.toolTipGeneratorList.equals(defaultPolarItemRenderer.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, defaultPolarItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlGenerator, defaultPolarItemRenderer.urlGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, defaultPolarItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, defaultPolarItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        DefaultPolarItemRenderer defaultPolarItemRenderer = (DefaultPolarItemRenderer)super.clone();
        if (this.legendLine != null) {
            defaultPolarItemRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        }
        defaultPolarItemRenderer.seriesFilled = (BooleanList)this.seriesFilled.clone();
        defaultPolarItemRenderer.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        if (defaultPolarItemRenderer.baseToolTipGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.baseToolTipGenerator = (XYToolTipGenerator)ObjectUtilities.clone(this.baseToolTipGenerator);
        }
        if (defaultPolarItemRenderer.urlGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.urlGenerator = (XYURLGenerator)ObjectUtilities.clone(this.urlGenerator);
        }
        if (defaultPolarItemRenderer.legendItemToolTipGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.legendItemToolTipGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (defaultPolarItemRenderer.legendItemURLGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.legendItemURLGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        return defaultPolarItemRenderer;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
        this.fillComposite = SerialUtilities.readComposite(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
        SerialUtilities.writeComposite(this.fillComposite, objectOutputStream);
    }
}

