/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintList;
import org.jfree.util.PaintUtilities;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.StrokeList;

public abstract class AbstractRenderer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -828267569428206075L;
    public static final Double ZERO = new Double(0.0);
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = Color.black;
    private BooleanList seriesVisibleList = new BooleanList();
    private boolean baseSeriesVisible = true;
    private BooleanList seriesVisibleInLegendList = new BooleanList();
    private boolean baseSeriesVisibleInLegend = true;
    private PaintList paintList = new PaintList();
    private boolean autoPopulateSeriesPaint = true;
    private transient Paint basePaint = DEFAULT_PAINT;
    private PaintList fillPaintList = new PaintList();
    private boolean autoPopulateSeriesFillPaint = false;
    private transient Paint baseFillPaint = Color.white;
    private PaintList outlinePaintList = new PaintList();
    private boolean autoPopulateSeriesOutlinePaint = false;
    private transient Paint baseOutlinePaint = DEFAULT_OUTLINE_PAINT;
    private StrokeList strokeList = new StrokeList();
    private boolean autoPopulateSeriesStroke = true;
    private transient Stroke baseStroke = DEFAULT_STROKE;
    private StrokeList outlineStrokeList = new StrokeList();
    private transient Stroke baseOutlineStroke = DEFAULT_OUTLINE_STROKE;
    private boolean autoPopulateSeriesOutlineStroke = false;
    private ShapeList shapeList = new ShapeList();
    private boolean autoPopulateSeriesShape = true;
    private transient Shape baseShape = DEFAULT_SHAPE;
    private BooleanList itemLabelsVisibleList = new BooleanList();
    private Boolean baseItemLabelsVisible = Boolean.FALSE;
    private Map<Integer, Font> itemLabelFontMap = new HashMap<Integer, Font>();
    private Font baseItemLabelFont = new Font("SansSerif", 0, 10);
    private PaintList itemLabelPaintList = new PaintList();
    private transient Paint baseItemLabelPaint = Color.black;
    private Map<Integer, ItemLabelPosition> positiveItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition basePositiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
    private Map<Integer, ItemLabelPosition> negativeItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition baseNegativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
    private double itemLabelAnchorOffset = 2.0;
    private BooleanList createEntitiesList = new BooleanList();
    private boolean baseCreateEntities = true;
    private ShapeList legendShapeList = new ShapeList();
    private transient Shape baseLegendShape = null;
    private boolean treatLegendShapeAsLine = false;
    private Map<Integer, Font> legendTextFontMap = new HashMap<Integer, Font>();
    private Font baseLegendTextFont = null;
    private PaintList legendTextPaint = new PaintList();
    private transient Paint baseLegendTextPaint = null;
    private boolean dataBoundsIncludesVisibleSeriesOnly = true;
    private int defaultEntityRadius = 3;
    private transient EventListenerList listenerList = new EventListenerList();
    private transient RendererChangeEvent event;
    private static final double ADJ = Math.cos(0.5235987755982988);
    private static final double OPP = Math.sin(0.5235987755982988);
    private Boolean seriesVisible = null;
    private Boolean seriesVisibleInLegend = null;
    private transient Paint paint = null;
    private transient Paint fillPaint = null;
    private transient Paint outlinePaint = null;
    private transient Stroke stroke = null;
    private transient Stroke outlineStroke = null;
    private transient Shape shape = null;
    private Boolean itemLabelsVisible = null;
    private Font itemLabelFont = null;
    private transient Paint itemLabelPaint = null;
    private ItemLabelPosition positiveItemLabelPosition = null;
    private ItemLabelPosition negativeItemLabelPosition = null;
    private Boolean createEntities = null;

    public abstract DrawingSupplier getDrawingSupplier();

    public boolean getItemVisible(int n2, int n3) {
        return this.isSeriesVisible(n2);
    }

    public boolean isSeriesVisible(int n2) {
        boolean bl2 = this.baseSeriesVisible;
        if (this.seriesVisible != null) {
            bl2 = this.seriesVisible;
        } else {
            Boolean bl3 = this.seriesVisibleList.getBoolean(n2);
            if (bl3 != null) {
                bl2 = bl3;
            }
        }
        return bl2;
    }

    public Boolean getSeriesVisible(int n2) {
        return this.seriesVisibleList.getBoolean(n2);
    }

    public void setSeriesVisible(int n2, Boolean bl2) {
        this.setSeriesVisible(n2, bl2, true);
    }

    public void setSeriesVisible(int n2, Boolean bl2, boolean bl3) {
        this.seriesVisibleList.setBoolean(n2, bl2);
        if (bl3) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public boolean getBaseSeriesVisible() {
        return this.baseSeriesVisible;
    }

    public void setBaseSeriesVisible(boolean bl2) {
        this.setBaseSeriesVisible(bl2, true);
    }

    public void setBaseSeriesVisible(boolean bl2, boolean bl3) {
        this.baseSeriesVisible = bl2;
        if (bl3) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public boolean isSeriesVisibleInLegend(int n2) {
        boolean bl2 = this.baseSeriesVisibleInLegend;
        if (this.seriesVisibleInLegend != null) {
            bl2 = this.seriesVisibleInLegend;
        } else {
            Boolean bl3 = this.seriesVisibleInLegendList.getBoolean(n2);
            if (bl3 != null) {
                bl2 = bl3;
            }
        }
        return bl2;
    }

    public Boolean getSeriesVisibleInLegend(int n2) {
        return this.seriesVisibleInLegendList.getBoolean(n2);
    }

    public void setSeriesVisibleInLegend(int n2, Boolean bl2) {
        this.setSeriesVisibleInLegend(n2, bl2, true);
    }

    public void setSeriesVisibleInLegend(int n2, Boolean bl2, boolean bl3) {
        this.seriesVisibleInLegendList.setBoolean(n2, bl2);
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public boolean getBaseSeriesVisibleInLegend() {
        return this.baseSeriesVisibleInLegend;
    }

    public void setBaseSeriesVisibleInLegend(boolean bl2) {
        this.setBaseSeriesVisibleInLegend(bl2, true);
    }

    public void setBaseSeriesVisibleInLegend(boolean bl2, boolean bl3) {
        this.baseSeriesVisibleInLegend = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemPaint(int n2, int n3) {
        return this.lookupSeriesPaint(n2);
    }

    public Paint lookupSeriesPaint(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.paint != null) {
            return this.paint;
        }
        Paint paint = this.getSeriesPaint(n2);
        if (paint == null && this.autoPopulateSeriesPaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextPaint();
            this.setSeriesPaint(n2, paint, false);
        }
        if (paint == null) {
            paint = this.basePaint;
        }
        return paint;
    }

    public Paint getSeriesPaint(int n2) {
        return this.paintList.getPaint(n2);
    }

    public void setSeriesPaint(int n2, Paint paint) {
        this.setSeriesPaint(n2, paint, true);
    }

    public void setSeriesPaint(int n2, Paint paint, boolean bl2) {
        this.paintList.setPaint(n2, paint);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesPaints(boolean bl2) {
        this.paintList.clear();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBasePaint() {
        return this.basePaint;
    }

    public void setBasePaint(Paint paint) {
        this.setBasePaint(paint, true);
    }

    public void setBasePaint(Paint paint, boolean bl2) {
        this.basePaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesPaint() {
        return this.autoPopulateSeriesPaint;
    }

    public void setAutoPopulateSeriesPaint(boolean bl2) {
        this.autoPopulateSeriesPaint = bl2;
    }

    public Paint getItemFillPaint(int n2, int n3) {
        return this.lookupSeriesFillPaint(n2);
    }

    public Paint lookupSeriesFillPaint(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.fillPaint != null) {
            return this.fillPaint;
        }
        Paint paint = this.getSeriesFillPaint(n2);
        if (paint == null && this.autoPopulateSeriesFillPaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextFillPaint();
            this.setSeriesFillPaint(n2, paint, false);
        }
        if (paint == null) {
            paint = this.baseFillPaint;
        }
        return paint;
    }

    public Paint getSeriesFillPaint(int n2) {
        return this.fillPaintList.getPaint(n2);
    }

    public void setSeriesFillPaint(int n2, Paint paint) {
        this.setSeriesFillPaint(n2, paint, true);
    }

    public void setSeriesFillPaint(int n2, Paint paint, boolean bl2) {
        this.fillPaintList.setPaint(n2, paint);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseFillPaint() {
        return this.baseFillPaint;
    }

    public void setBaseFillPaint(Paint paint) {
        this.setBaseFillPaint(paint, true);
    }

    public void setBaseFillPaint(Paint paint, boolean bl2) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseFillPaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesFillPaint() {
        return this.autoPopulateSeriesFillPaint;
    }

    public void setAutoPopulateSeriesFillPaint(boolean bl2) {
        this.autoPopulateSeriesFillPaint = bl2;
    }

    public Paint getItemOutlinePaint(int n2, int n3) {
        return this.lookupSeriesOutlinePaint(n2);
    }

    public Paint lookupSeriesOutlinePaint(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.outlinePaint != null) {
            return this.outlinePaint;
        }
        Paint paint = this.getSeriesOutlinePaint(n2);
        if (paint == null && this.autoPopulateSeriesOutlinePaint && (drawingSupplier = this.getDrawingSupplier()) != null) {
            paint = drawingSupplier.getNextOutlinePaint();
            this.setSeriesOutlinePaint(n2, paint, false);
        }
        if (paint == null) {
            paint = this.baseOutlinePaint;
        }
        return paint;
    }

    public Paint getSeriesOutlinePaint(int n2) {
        return this.outlinePaintList.getPaint(n2);
    }

    public void setSeriesOutlinePaint(int n2, Paint paint) {
        this.setSeriesOutlinePaint(n2, paint, true);
    }

    public void setSeriesOutlinePaint(int n2, Paint paint, boolean bl2) {
        this.outlinePaintList.setPaint(n2, paint);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseOutlinePaint() {
        return this.baseOutlinePaint;
    }

    public void setBaseOutlinePaint(Paint paint) {
        this.setBaseOutlinePaint(paint, true);
    }

    public void setBaseOutlinePaint(Paint paint, boolean bl2) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseOutlinePaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlinePaint() {
        return this.autoPopulateSeriesOutlinePaint;
    }

    public void setAutoPopulateSeriesOutlinePaint(boolean bl2) {
        this.autoPopulateSeriesOutlinePaint = bl2;
    }

    public Stroke getItemStroke(int n2, int n3) {
        return this.lookupSeriesStroke(n2);
    }

    public Stroke lookupSeriesStroke(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.stroke != null) {
            return this.stroke;
        }
        Stroke stroke = this.getSeriesStroke(n2);
        if (stroke == null && this.autoPopulateSeriesStroke && (drawingSupplier = this.getDrawingSupplier()) != null) {
            stroke = drawingSupplier.getNextStroke();
            this.setSeriesStroke(n2, stroke, false);
        }
        if (stroke == null) {
            stroke = this.baseStroke;
        }
        return stroke;
    }

    public Stroke getSeriesStroke(int n2) {
        return this.strokeList.getStroke(n2);
    }

    public void setSeriesStroke(int n2, Stroke stroke) {
        this.setSeriesStroke(n2, stroke, true);
    }

    public void setSeriesStroke(int n2, Stroke stroke, boolean bl2) {
        this.strokeList.setStroke(n2, stroke);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesStrokes(boolean bl2) {
        this.strokeList.clear();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke stroke) {
        this.setBaseStroke(stroke, true);
    }

    public void setBaseStroke(Stroke stroke, boolean bl2) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.baseStroke = stroke;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesStroke() {
        return this.autoPopulateSeriesStroke;
    }

    public void setAutoPopulateSeriesStroke(boolean bl2) {
        this.autoPopulateSeriesStroke = bl2;
    }

    public Stroke getItemOutlineStroke(int n2, int n3) {
        return this.lookupSeriesOutlineStroke(n2);
    }

    public Stroke lookupSeriesOutlineStroke(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.outlineStroke != null) {
            return this.outlineStroke;
        }
        Stroke stroke = this.getSeriesOutlineStroke(n2);
        if (stroke == null && this.autoPopulateSeriesOutlineStroke && (drawingSupplier = this.getDrawingSupplier()) != null) {
            stroke = drawingSupplier.getNextOutlineStroke();
            this.setSeriesOutlineStroke(n2, stroke, false);
        }
        if (stroke == null) {
            stroke = this.baseOutlineStroke;
        }
        return stroke;
    }

    public Stroke getSeriesOutlineStroke(int n2) {
        return this.outlineStrokeList.getStroke(n2);
    }

    public void setSeriesOutlineStroke(int n2, Stroke stroke) {
        this.setSeriesOutlineStroke(n2, stroke, true);
    }

    public void setSeriesOutlineStroke(int n2, Stroke stroke, boolean bl2) {
        this.outlineStrokeList.setStroke(n2, stroke);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseOutlineStroke() {
        return this.baseOutlineStroke;
    }

    public void setBaseOutlineStroke(Stroke stroke) {
        this.setBaseOutlineStroke(stroke, true);
    }

    public void setBaseOutlineStroke(Stroke stroke, boolean bl2) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.baseOutlineStroke = stroke;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlineStroke() {
        return this.autoPopulateSeriesOutlineStroke;
    }

    public void setAutoPopulateSeriesOutlineStroke(boolean bl2) {
        this.autoPopulateSeriesOutlineStroke = bl2;
    }

    public Shape getItemShape(int n2, int n3) {
        return this.lookupSeriesShape(n2);
    }

    public Shape lookupSeriesShape(int n2) {
        DrawingSupplier drawingSupplier;
        if (this.shape != null) {
            return this.shape;
        }
        Shape shape = this.getSeriesShape(n2);
        if (shape == null && this.autoPopulateSeriesShape && (drawingSupplier = this.getDrawingSupplier()) != null) {
            shape = drawingSupplier.getNextShape();
            this.setSeriesShape(n2, shape, false);
        }
        if (shape == null) {
            shape = this.baseShape;
        }
        return shape;
    }

    public Shape getSeriesShape(int n2) {
        return this.shapeList.getShape(n2);
    }

    public void setSeriesShape(int n2, Shape shape) {
        this.setSeriesShape(n2, shape, true);
    }

    public void setSeriesShape(int n2, Shape shape, boolean bl2) {
        this.shapeList.setShape(n2, shape);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape shape) {
        this.setBaseShape(shape, true);
    }

    public void setBaseShape(Shape shape, boolean bl2) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.baseShape = shape;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesShape() {
        return this.autoPopulateSeriesShape;
    }

    public void setAutoPopulateSeriesShape(boolean bl2) {
        this.autoPopulateSeriesShape = bl2;
    }

    public boolean isItemLabelVisible(int n2, int n3) {
        return this.isSeriesItemLabelsVisible(n2);
    }

    public boolean isSeriesItemLabelsVisible(int n2) {
        if (this.itemLabelsVisible != null) {
            return this.itemLabelsVisible;
        }
        Boolean bl2 = this.itemLabelsVisibleList.getBoolean(n2);
        if (bl2 == null) {
            bl2 = this.baseItemLabelsVisible;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        return bl2;
    }

    public void setSeriesItemLabelsVisible(int n2, boolean bl2) {
        this.setSeriesItemLabelsVisible(n2, (Boolean)bl2);
    }

    public void setSeriesItemLabelsVisible(int n2, Boolean bl2) {
        this.setSeriesItemLabelsVisible(n2, bl2, true);
    }

    public void setSeriesItemLabelsVisible(int n2, Boolean bl2, boolean bl3) {
        this.itemLabelsVisibleList.setBoolean(n2, bl2);
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public Boolean getBaseItemLabelsVisible() {
        return this.baseItemLabelsVisible;
    }

    public void setBaseItemLabelsVisible(boolean bl2) {
        this.setBaseItemLabelsVisible((Boolean)bl2);
    }

    public void setBaseItemLabelsVisible(Boolean bl2) {
        this.setBaseItemLabelsVisible(bl2, true);
    }

    public void setBaseItemLabelsVisible(Boolean bl2, boolean bl3) {
        this.baseItemLabelsVisible = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public Font getItemLabelFont(int n2, int n3) {
        Font font = this.itemLabelFont;
        if (font == null && (font = this.getSeriesItemLabelFont(n2)) == null) {
            font = this.baseItemLabelFont;
        }
        return font;
    }

    public Font getSeriesItemLabelFont(int n2) {
        return this.itemLabelFontMap.get(n2);
    }

    public void setSeriesItemLabelFont(int n2, Font font) {
        this.setSeriesItemLabelFont(n2, font, true);
    }

    public void setSeriesItemLabelFont(int n2, Font font, boolean bl2) {
        this.itemLabelFontMap.put(n2, font);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Font getBaseItemLabelFont() {
        return this.baseItemLabelFont;
    }

    public void setBaseItemLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.setBaseItemLabelFont(font, true);
    }

    public void setBaseItemLabelFont(Font font, boolean bl2) {
        this.baseItemLabelFont = font;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemLabelPaint(int n2, int n3) {
        Paint paint = this.itemLabelPaint;
        if (paint == null && (paint = this.getSeriesItemLabelPaint(n2)) == null) {
            paint = this.baseItemLabelPaint;
        }
        return paint;
    }

    public Paint getSeriesItemLabelPaint(int n2) {
        return this.itemLabelPaintList.getPaint(n2);
    }

    public void setSeriesItemLabelPaint(int n2, Paint paint) {
        this.setSeriesItemLabelPaint(n2, paint, true);
    }

    public void setSeriesItemLabelPaint(int n2, Paint paint, boolean bl2) {
        this.itemLabelPaintList.setPaint(n2, paint);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseItemLabelPaint() {
        return this.baseItemLabelPaint;
    }

    public void setBaseItemLabelPaint(Paint paint) {
        this.setBaseItemLabelPaint(paint, true);
    }

    public void setBaseItemLabelPaint(Paint paint, boolean bl2) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseItemLabelPaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition(int n2, int n3) {
        return this.getSeriesPositiveItemLabelPosition(n2);
    }

    public ItemLabelPosition getSeriesPositiveItemLabelPosition(int n2) {
        if (this.positiveItemLabelPosition != null) {
            return this.positiveItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = this.positiveItemLabelPositionMap.get(n2);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.basePositiveItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public void setSeriesPositiveItemLabelPosition(int n2, ItemLabelPosition itemLabelPosition) {
        this.setSeriesPositiveItemLabelPosition(n2, itemLabelPosition, true);
    }

    public void setSeriesPositiveItemLabelPosition(int n2, ItemLabelPosition itemLabelPosition, boolean bl2) {
        this.positiveItemLabelPositionMap.put(n2, itemLabelPosition);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getBasePositiveItemLabelPosition() {
        return this.basePositiveItemLabelPosition;
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBasePositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl2) {
        ParamChecks.nullNotPermitted(itemLabelPosition, "position");
        this.basePositiveItemLabelPosition = itemLabelPosition;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition(int n2, int n3) {
        return this.getSeriesNegativeItemLabelPosition(n2);
    }

    public ItemLabelPosition getSeriesNegativeItemLabelPosition(int n2) {
        if (this.negativeItemLabelPosition != null) {
            return this.negativeItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = this.negativeItemLabelPositionMap.get(n2);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.baseNegativeItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public void setSeriesNegativeItemLabelPosition(int n2, ItemLabelPosition itemLabelPosition) {
        this.setSeriesNegativeItemLabelPosition(n2, itemLabelPosition, true);
    }

    public void setSeriesNegativeItemLabelPosition(int n2, ItemLabelPosition itemLabelPosition, boolean bl2) {
        this.negativeItemLabelPositionMap.put(n2, itemLabelPosition);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getBaseNegativeItemLabelPosition() {
        return this.baseNegativeItemLabelPosition;
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBaseNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl2) {
        ParamChecks.nullNotPermitted(itemLabelPosition, "position");
        this.baseNegativeItemLabelPosition = itemLabelPosition;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double d2) {
        this.itemLabelAnchorOffset = d2;
        this.fireChangeEvent();
    }

    public boolean getItemCreateEntity(int n2, int n3) {
        if (this.createEntities != null) {
            return this.createEntities;
        }
        Boolean bl2 = this.getSeriesCreateEntities(n2);
        if (bl2 != null) {
            return bl2;
        }
        return this.baseCreateEntities;
    }

    public Boolean getSeriesCreateEntities(int n2) {
        return this.createEntitiesList.getBoolean(n2);
    }

    public void setSeriesCreateEntities(int n2, Boolean bl2) {
        this.setSeriesCreateEntities(n2, bl2, true);
    }

    public void setSeriesCreateEntities(int n2, Boolean bl2, boolean bl3) {
        this.createEntitiesList.setBoolean(n2, bl2);
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public boolean getBaseCreateEntities() {
        return this.baseCreateEntities;
    }

    public void setBaseCreateEntities(boolean bl2) {
        this.setBaseCreateEntities(bl2, true);
    }

    public void setBaseCreateEntities(boolean bl2, boolean bl3) {
        this.baseCreateEntities = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int n2) {
        this.defaultEntityRadius = n2;
    }

    public Shape lookupLegendShape(int n2) {
        Shape shape = this.getLegendShape(n2);
        if (shape == null) {
            shape = this.baseLegendShape;
        }
        if (shape == null) {
            shape = this.lookupSeriesShape(n2);
        }
        return shape;
    }

    public Shape getLegendShape(int n2) {
        return this.legendShapeList.getShape(n2);
    }

    public void setLegendShape(int n2, Shape shape) {
        this.legendShapeList.setShape(n2, shape);
        this.fireChangeEvent();
    }

    public Shape getBaseLegendShape() {
        return this.baseLegendShape;
    }

    public void setBaseLegendShape(Shape shape) {
        this.baseLegendShape = shape;
        this.fireChangeEvent();
    }

    protected boolean getTreatLegendShapeAsLine() {
        return this.treatLegendShapeAsLine;
    }

    protected void setTreatLegendShapeAsLine(boolean bl2) {
        if (this.treatLegendShapeAsLine != bl2) {
            this.treatLegendShapeAsLine = bl2;
            this.fireChangeEvent();
        }
    }

    public Font lookupLegendTextFont(int n2) {
        Font font = this.getLegendTextFont(n2);
        if (font == null) {
            font = this.baseLegendTextFont;
        }
        return font;
    }

    public Font getLegendTextFont(int n2) {
        return this.legendTextFontMap.get(n2);
    }

    public void setLegendTextFont(int n2, Font font) {
        this.legendTextFontMap.put(n2, font);
        this.fireChangeEvent();
    }

    public Font getBaseLegendTextFont() {
        return this.baseLegendTextFont;
    }

    public void setBaseLegendTextFont(Font font) {
        this.baseLegendTextFont = font;
        this.fireChangeEvent();
    }

    public Paint lookupLegendTextPaint(int n2) {
        Paint paint = this.getLegendTextPaint(n2);
        if (paint == null) {
            paint = this.baseLegendTextPaint;
        }
        return paint;
    }

    public Paint getLegendTextPaint(int n2) {
        return this.legendTextPaint.getPaint(n2);
    }

    public void setLegendTextPaint(int n2, Paint paint) {
        this.legendTextPaint.setPaint(n2, paint);
        this.fireChangeEvent();
    }

    public Paint getBaseLegendTextPaint() {
        return this.baseLegendTextPaint;
    }

    public void setBaseLegendTextPaint(Paint paint) {
        this.baseLegendTextPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getDataBoundsIncludesVisibleSeriesOnly() {
        return this.dataBoundsIncludesVisibleSeriesOnly;
    }

    public void setDataBoundsIncludesVisibleSeriesOnly(boolean bl2) {
        this.dataBoundsIncludesVisibleSeriesOnly = bl2;
        this.notifyListeners(new RendererChangeEvent((Object)this, true));
    }

    protected Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d2, double d3, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d2, d3);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d2 + OPP * this.itemLabelAnchorOffset, d3 - ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d2 + ADJ * this.itemLabelAnchorOffset, d3 - OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d2 + this.itemLabelAnchorOffset, d3);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d2 + ADJ * this.itemLabelAnchorOffset, d3 + OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d2 + OPP * this.itemLabelAnchorOffset, d3 + ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d2, d3 + this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d2 - OPP * this.itemLabelAnchorOffset, d3 + ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d2 - ADJ * this.itemLabelAnchorOffset, d3 + OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d2 - this.itemLabelAnchorOffset, d3);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d2 - ADJ * this.itemLabelAnchorOffset, d3 - OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d2 - OPP * this.itemLabelAnchorOffset, d3 - ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d2, d3 - this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d2 + 2.0 * OPP * this.itemLabelAnchorOffset, d3 - 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d2 + 2.0 * ADJ * this.itemLabelAnchorOffset, d3 - 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d2 + 2.0 * this.itemLabelAnchorOffset, d3);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d2 + 2.0 * ADJ * this.itemLabelAnchorOffset, d3 + 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d2 + 2.0 * OPP * this.itemLabelAnchorOffset, d3 + 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d2, d3 + 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d2 - 2.0 * OPP * this.itemLabelAnchorOffset, d3 + 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d2 - 2.0 * ADJ * this.itemLabelAnchorOffset, d3 + 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d2 - 2.0 * this.itemLabelAnchorOffset, d3);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d2 - 2.0 * ADJ * this.itemLabelAnchorOffset, d3 - 2.0 * OPP * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d2 - 2.0 * OPP * this.itemLabelAnchorOffset, d3 - 2.0 * ADJ * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d2, d3 - 2.0 * this.itemLabelAnchorOffset);
        }
        return double_;
    }

    public void addChangeListener(RendererChangeListener rendererChangeListener) {
        ParamChecks.nullNotPermitted(rendererChangeListener, "listener");
        this.listenerList.add(RendererChangeListener.class, rendererChangeListener);
    }

    public void removeChangeListener(RendererChangeListener rendererChangeListener) {
        ParamChecks.nullNotPermitted(rendererChangeListener, "listener");
        this.listenerList.remove(RendererChangeListener.class, rendererChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void notifyListeners(RendererChangeEvent rendererChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != RendererChangeListener.class) continue;
            ((RendererChangeListener)objectArray[i2 + 1]).rendererChanged(rendererChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractRenderer)) {
            return false;
        }
        AbstractRenderer abstractRenderer = (AbstractRenderer)object;
        if (this.dataBoundsIncludesVisibleSeriesOnly != abstractRenderer.dataBoundsIncludesVisibleSeriesOnly) {
            return false;
        }
        if (this.treatLegendShapeAsLine != abstractRenderer.treatLegendShapeAsLine) {
            return false;
        }
        if (this.defaultEntityRadius != abstractRenderer.defaultEntityRadius) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesVisible, abstractRenderer.seriesVisible)) {
            return false;
        }
        if (!this.seriesVisibleList.equals(abstractRenderer.seriesVisibleList)) {
            return false;
        }
        if (this.baseSeriesVisible != abstractRenderer.baseSeriesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesVisibleInLegend, abstractRenderer.seriesVisibleInLegend)) {
            return false;
        }
        if (!this.seriesVisibleInLegendList.equals(abstractRenderer.seriesVisibleInLegendList)) {
            return false;
        }
        if (this.baseSeriesVisibleInLegend != abstractRenderer.baseSeriesVisibleInLegend) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, abstractRenderer.paint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.paintList, abstractRenderer.paintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.basePaint, abstractRenderer.basePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, abstractRenderer.fillPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillPaintList, abstractRenderer.fillPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseFillPaint, abstractRenderer.baseFillPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, abstractRenderer.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlinePaintList, abstractRenderer.outlinePaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseOutlinePaint, abstractRenderer.baseOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, abstractRenderer.stroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.strokeList, abstractRenderer.strokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseStroke, abstractRenderer.baseStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, abstractRenderer.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStrokeList, abstractRenderer.outlineStrokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseOutlineStroke, abstractRenderer.baseOutlineStroke)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, abstractRenderer.shape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapeList, abstractRenderer.shapeList)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseShape, abstractRenderer.baseShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelsVisible, abstractRenderer.itemLabelsVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelsVisibleList, abstractRenderer.itemLabelsVisibleList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelsVisible, abstractRenderer.baseItemLabelsVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelFont, abstractRenderer.itemLabelFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelFontMap, abstractRenderer.itemLabelFontMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelFont, abstractRenderer.baseItemLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.itemLabelPaint, abstractRenderer.itemLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelPaintList, abstractRenderer.itemLabelPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseItemLabelPaint, abstractRenderer.baseItemLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPosition, abstractRenderer.positiveItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionMap, abstractRenderer.positiveItemLabelPositionMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.basePositiveItemLabelPosition, abstractRenderer.basePositiveItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPosition, abstractRenderer.negativeItemLabelPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionMap, abstractRenderer.negativeItemLabelPositionMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseNegativeItemLabelPosition, abstractRenderer.baseNegativeItemLabelPosition)) {
            return false;
        }
        if (this.itemLabelAnchorOffset != abstractRenderer.itemLabelAnchorOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(this.createEntities, abstractRenderer.createEntities)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.createEntitiesList, abstractRenderer.createEntitiesList)) {
            return false;
        }
        if (this.baseCreateEntities != abstractRenderer.baseCreateEntities) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendShapeList, abstractRenderer.legendShapeList)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.baseLegendShape, abstractRenderer.baseLegendShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextFontMap, abstractRenderer.legendTextFontMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseLegendTextFont, abstractRenderer.baseLegendTextFont)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendTextPaint, abstractRenderer.legendTextPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.baseLegendTextPaint, abstractRenderer.baseLegendTextPaint);
    }

    public int hashCode() {
        int n2 = 193;
        n2 = HashUtilities.hashCode(n2, this.seriesVisibleList);
        n2 = HashUtilities.hashCode(n2, this.baseSeriesVisible);
        n2 = HashUtilities.hashCode(n2, this.seriesVisibleInLegendList);
        n2 = HashUtilities.hashCode(n2, this.baseSeriesVisibleInLegend);
        n2 = HashUtilities.hashCode(n2, this.paintList);
        n2 = HashUtilities.hashCode(n2, this.basePaint);
        n2 = HashUtilities.hashCode(n2, this.fillPaintList);
        n2 = HashUtilities.hashCode(n2, this.baseFillPaint);
        n2 = HashUtilities.hashCode(n2, this.outlinePaintList);
        n2 = HashUtilities.hashCode(n2, this.baseOutlinePaint);
        n2 = HashUtilities.hashCode(n2, this.strokeList);
        n2 = HashUtilities.hashCode(n2, this.baseStroke);
        n2 = HashUtilities.hashCode(n2, this.outlineStrokeList);
        n2 = HashUtilities.hashCode(n2, this.baseOutlineStroke);
        n2 = HashUtilities.hashCode(n2, this.itemLabelsVisibleList);
        n2 = HashUtilities.hashCode(n2, this.baseItemLabelsVisible);
        return n2;
    }

    protected Object clone() {
        AbstractRenderer abstractRenderer = (AbstractRenderer)super.clone();
        if (this.seriesVisibleList != null) {
            abstractRenderer.seriesVisibleList = (BooleanList)this.seriesVisibleList.clone();
        }
        if (this.seriesVisibleInLegendList != null) {
            abstractRenderer.seriesVisibleInLegendList = (BooleanList)this.seriesVisibleInLegendList.clone();
        }
        if (this.paintList != null) {
            abstractRenderer.paintList = (PaintList)this.paintList.clone();
        }
        if (this.fillPaintList != null) {
            abstractRenderer.fillPaintList = (PaintList)this.fillPaintList.clone();
        }
        if (this.outlinePaintList != null) {
            abstractRenderer.outlinePaintList = (PaintList)this.outlinePaintList.clone();
        }
        if (this.strokeList != null) {
            abstractRenderer.strokeList = (StrokeList)this.strokeList.clone();
        }
        if (this.outlineStrokeList != null) {
            abstractRenderer.outlineStrokeList = (StrokeList)this.outlineStrokeList.clone();
        }
        if (this.shape != null) {
            abstractRenderer.shape = ShapeUtilities.clone(this.shape);
        }
        if (this.shapeList != null) {
            abstractRenderer.shapeList = (ShapeList)this.shapeList.clone();
        }
        if (this.baseShape != null) {
            abstractRenderer.baseShape = ShapeUtilities.clone(this.baseShape);
        }
        if (this.itemLabelsVisibleList != null) {
            abstractRenderer.itemLabelsVisibleList = (BooleanList)this.itemLabelsVisibleList.clone();
        }
        if (this.itemLabelFontMap != null) {
            abstractRenderer.itemLabelFontMap = CloneUtils.cloneMapValues(this.itemLabelFontMap);
        }
        if (this.itemLabelPaintList != null) {
            abstractRenderer.itemLabelPaintList = (PaintList)this.itemLabelPaintList.clone();
        }
        if (this.positiveItemLabelPositionMap != null) {
            abstractRenderer.positiveItemLabelPositionMap = CloneUtils.cloneMapValues(this.positiveItemLabelPositionMap);
        }
        if (this.negativeItemLabelPositionMap != null) {
            abstractRenderer.negativeItemLabelPositionMap = CloneUtils.cloneMapValues(this.negativeItemLabelPositionMap);
        }
        if (this.createEntitiesList != null) {
            abstractRenderer.createEntitiesList = (BooleanList)this.createEntitiesList.clone();
        }
        if (this.legendShapeList != null) {
            abstractRenderer.legendShapeList = (ShapeList)this.legendShapeList.clone();
        }
        if (this.legendTextFontMap != null) {
            abstractRenderer.legendTextFontMap = CloneUtils.cloneMapValues(this.legendTextFontMap);
        }
        if (this.legendTextPaint != null) {
            abstractRenderer.legendTextPaint = (PaintList)this.legendTextPaint.clone();
        }
        abstractRenderer.listenerList = new EventListenerList();
        abstractRenderer.event = null;
        return abstractRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.basePaint, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseFillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseOutlineStroke, objectOutputStream);
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writeShape(this.baseShape, objectOutputStream);
        SerialUtilities.writePaint(this.itemLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseItemLabelPaint, objectOutputStream);
        SerialUtilities.writeShape(this.baseLegendShape, objectOutputStream);
        SerialUtilities.writePaint(this.baseLegendTextPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.basePaint = SerialUtilities.readPaint(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseFillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.baseOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.baseStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.baseOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.baseShape = SerialUtilities.readShape(objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseItemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseLegendShape = SerialUtilities.readShape(objectInputStream);
        this.baseLegendTextPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }

    public Boolean getSeriesVisible() {
        return this.seriesVisible;
    }

    public void setSeriesVisible(Boolean bl2) {
        this.setSeriesVisible(bl2, true);
    }

    public void setSeriesVisible(Boolean bl2, boolean bl3) {
        this.seriesVisible = bl2;
        if (bl3) {
            RendererChangeEvent rendererChangeEvent = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(rendererChangeEvent);
        }
    }

    public Boolean getSeriesVisibleInLegend() {
        return this.seriesVisibleInLegend;
    }

    public void setSeriesVisibleInLegend(Boolean bl2) {
        this.setSeriesVisibleInLegend(bl2, true);
    }

    public void setSeriesVisibleInLegend(Boolean bl2, boolean bl3) {
        this.seriesVisibleInLegend = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public void setPaint(Paint paint) {
        this.setPaint(paint, true);
    }

    public void setPaint(Paint paint, boolean bl2) {
        this.paint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setFillPaint(Paint paint) {
        this.setFillPaint(paint, true);
    }

    public void setFillPaint(Paint paint, boolean bl2) {
        this.fillPaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setOutlinePaint(Paint paint) {
        this.setOutlinePaint(paint, true);
    }

    public void setOutlinePaint(Paint paint, boolean bl2) {
        this.outlinePaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setStroke(Stroke stroke) {
        this.setStroke(stroke, true);
    }

    public void setStroke(Stroke stroke, boolean bl2) {
        this.stroke = stroke;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setOutlineStroke(Stroke stroke) {
        this.setOutlineStroke(stroke, true);
    }

    public void setOutlineStroke(Stroke stroke, boolean bl2) {
        this.outlineStroke = stroke;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setShape(Shape shape) {
        this.setShape(shape, true);
    }

    public void setShape(Shape shape, boolean bl2) {
        this.shape = shape;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setItemLabelsVisible(boolean bl2) {
        this.setItemLabelsVisible((Boolean)bl2);
    }

    public void setItemLabelsVisible(Boolean bl2) {
        this.setItemLabelsVisible(bl2, true);
    }

    public void setItemLabelsVisible(Boolean bl2, boolean bl3) {
        this.itemLabelsVisible = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public Font getItemLabelFont() {
        return this.itemLabelFont;
    }

    public void setItemLabelFont(Font font) {
        this.setItemLabelFont(font, true);
    }

    public void setItemLabelFont(Font font, boolean bl2) {
        this.itemLabelFont = font;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemLabelPaint() {
        return this.itemLabelPaint;
    }

    public void setItemLabelPaint(Paint paint) {
        this.setItemLabelPaint(paint, true);
    }

    public void setItemLabelPaint(Paint paint, boolean bl2) {
        this.itemLabelPaint = paint;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition() {
        return this.positiveItemLabelPosition;
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setPositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl2) {
        this.positiveItemLabelPosition = itemLabelPosition;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition() {
        return this.negativeItemLabelPosition;
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl2) {
        this.negativeItemLabelPosition = itemLabelPosition;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Boolean getCreateEntities() {
        return this.createEntities;
    }

    public void setCreateEntities(Boolean bl2) {
        this.setCreateEntities(bl2, true);
    }

    public void setCreateEntities(Boolean bl2, boolean bl3) {
        this.createEntities = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }
}

