/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StandardDialScale
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialScale,
PublicCloneable {
    static final long serialVersionUID = 3715644629665918516L;
    private double lowerBound;
    private double upperBound;
    private double startAngle;
    private double extent;
    private double tickRadius;
    private double majorTickIncrement;
    private double majorTickLength;
    private transient Paint majorTickPaint;
    private transient Stroke majorTickStroke;
    private int minorTickCount;
    private double minorTickLength;
    private transient Paint minorTickPaint;
    private transient Stroke minorTickStroke;
    private double tickLabelOffset;
    private Font tickLabelFont;
    private boolean tickLabelsVisible;
    private NumberFormat tickLabelFormatter;
    private boolean firstTickLabelVisible;
    private transient Paint tickLabelPaint;

    public StandardDialScale() {
        this(0.0, 100.0, 175.0, -170.0, 10.0, 4);
    }

    public StandardDialScale(double d2, double d3, double d4, double d5, double d6, int n2) {
        if (d6 <= 0.0) {
            throw new IllegalArgumentException("Requires 'majorTickIncrement' > 0.");
        }
        this.startAngle = d4;
        this.extent = d5;
        this.lowerBound = d2;
        this.upperBound = d3;
        this.tickRadius = 0.7;
        this.tickLabelsVisible = true;
        this.tickLabelFormatter = new DecimalFormat("0.0");
        this.firstTickLabelVisible = true;
        this.tickLabelFont = new Font("Dialog", 1, 16);
        this.tickLabelPaint = Color.blue;
        this.tickLabelOffset = 0.1;
        this.majorTickIncrement = d6;
        this.majorTickLength = 0.04;
        this.majorTickPaint = Color.black;
        this.majorTickStroke = new BasicStroke(3.0f);
        this.minorTickCount = n2;
        this.minorTickLength = 0.02;
        this.minorTickPaint = Color.black;
        this.minorTickStroke = new BasicStroke(1.0f);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d2) {
        this.lowerBound = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d2) {
        this.upperBound = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d2) {
        this.startAngle = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double d2) {
        this.extent = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickRadius() {
        return this.tickRadius;
    }

    public void setTickRadius(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The 'radius' must be positive.");
        }
        this.tickRadius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickIncrement() {
        return this.majorTickIncrement;
    }

    public void setMajorTickIncrement(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The 'increment' must be positive.");
        }
        this.majorTickIncrement = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickLength() {
        return this.majorTickLength;
    }

    public void setMajorTickLength(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.majorTickLength = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMajorTickPaint() {
        return this.majorTickPaint;
    }

    public void setMajorTickPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.majorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getMajorTickStroke() {
        return this.majorTickStroke;
    }

    public void setMajorTickStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.majorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The 'count' cannot be negative.");
        }
        this.minorTickCount = n2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMinorTickLength() {
        return this.minorTickLength;
    }

    public void setMinorTickLength(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.minorTickLength = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMinorTickPaint() {
        return this.minorTickPaint;
    }

    public void setMinorTickPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.minorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getMinorTickStroke() {
        return this.minorTickStroke;
    }

    public void setMinorTickStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.minorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double d2) {
        this.tickLabelOffset = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.tickLabelFont = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.tickLabelPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl2) {
        this.tickLabelsVisible = bl2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public NumberFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.tickLabelFormatter = numberFormat;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getFirstTickLabelVisible() {
        return this.firstTickLabelVisible;
    }

    public void setFirstTickLabelVisible(boolean bl2) {
        this.firstTickLabelVisible = bl2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius, this.tickRadius);
        Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.majorTickLength, this.tickRadius - this.majorTickLength);
        Rectangle2D rectangle2D5 = rectangle2D3;
        if (this.minorTickCount > 0 && this.minorTickLength > 0.0) {
            rectangle2D5 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.minorTickLength, this.tickRadius - this.minorTickLength);
        }
        Rectangle2D rectangle2D6 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.tickLabelOffset, this.tickRadius - this.tickLabelOffset);
        boolean bl2 = true;
        Arc2D.Double double_ = new Arc2D.Double();
        Line2D.Double double_2 = new Line2D.Double();
        for (double d2 = this.lowerBound; d2 <= this.upperBound; d2 += this.majorTickIncrement) {
            double d3;
            double_.setArc(rectangle2D3, this.startAngle, this.valueToAngle(d2) - this.startAngle, 0);
            Point2D point2D = double_.getEndPoint();
            double_.setArc(rectangle2D4, this.startAngle, this.valueToAngle(d2) - this.startAngle, 0);
            Point2D point2D2 = double_.getEndPoint();
            graphics2D.setPaint(this.majorTickPaint);
            graphics2D.setStroke(this.majorTickStroke);
            double_2.setLine(point2D, point2D2);
            graphics2D.draw(double_2);
            double_.setArc(rectangle2D6, this.startAngle, this.valueToAngle(d2) - this.startAngle, 0);
            Point2D point2D3 = double_.getEndPoint();
            if (this.tickLabelsVisible && (!bl2 || this.firstTickLabelVisible)) {
                graphics2D.setFont(this.tickLabelFont);
                graphics2D.setPaint(this.tickLabelPaint);
                TextUtilities.drawAlignedString(this.tickLabelFormatter.format(d2), graphics2D, (float)point2D3.getX(), (float)point2D3.getY(), TextAnchor.CENTER);
            }
            bl2 = false;
            if (this.minorTickCount <= 0 || !(this.minorTickLength > 0.0)) continue;
            double d4 = this.majorTickIncrement / (double)(this.minorTickCount + 1);
            for (int i2 = 0; i2 < this.minorTickCount && !((d3 = d2 + (double)(i2 + 1) * d4) >= this.upperBound); ++i2) {
                double d5 = this.valueToAngle(d3);
                double_.setArc(rectangle2D3, this.startAngle, d5 - this.startAngle, 0);
                point2D = double_.getEndPoint();
                double_.setArc(rectangle2D5, this.startAngle, d5 - this.startAngle, 0);
                Point2D point2D4 = double_.getEndPoint();
                graphics2D.setStroke(this.minorTickStroke);
                graphics2D.setPaint(this.minorTickPaint);
                double_2.setLine(point2D, point2D4);
                graphics2D.draw(double_2);
            }
        }
    }

    @Override
    public double valueToAngle(double d2) {
        double d3 = this.upperBound - this.lowerBound;
        double d4 = this.extent / d3;
        return this.startAngle + d4 * (d2 - this.lowerBound);
    }

    @Override
    public double angleToValue(double d2) {
        double d3 = this.upperBound - this.lowerBound;
        double d4 = d3 / this.extent;
        return (d2 - this.startAngle) * d4;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialScale)) {
            return false;
        }
        StandardDialScale standardDialScale = (StandardDialScale)object;
        if (this.lowerBound != standardDialScale.lowerBound) {
            return false;
        }
        if (this.upperBound != standardDialScale.upperBound) {
            return false;
        }
        if (this.startAngle != standardDialScale.startAngle) {
            return false;
        }
        if (this.extent != standardDialScale.extent) {
            return false;
        }
        if (this.tickRadius != standardDialScale.tickRadius) {
            return false;
        }
        if (this.majorTickIncrement != standardDialScale.majorTickIncrement) {
            return false;
        }
        if (this.majorTickLength != standardDialScale.majorTickLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.majorTickPaint, standardDialScale.majorTickPaint)) {
            return false;
        }
        if (!this.majorTickStroke.equals(standardDialScale.majorTickStroke)) {
            return false;
        }
        if (this.minorTickCount != standardDialScale.minorTickCount) {
            return false;
        }
        if (this.minorTickLength != standardDialScale.minorTickLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.minorTickPaint, standardDialScale.minorTickPaint)) {
            return false;
        }
        if (!this.minorTickStroke.equals(standardDialScale.minorTickStroke)) {
            return false;
        }
        if (this.tickLabelsVisible != standardDialScale.tickLabelsVisible) {
            return false;
        }
        if (this.tickLabelOffset != standardDialScale.tickLabelOffset) {
            return false;
        }
        if (!this.tickLabelFont.equals(standardDialScale.tickLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, standardDialScale.tickLabelPaint)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        long l2 = Double.doubleToLongBits(this.lowerBound);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.upperBound);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.startAngle);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.extent);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.tickRadius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.majorTickPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.majorTickStroke, objectOutputStream);
        SerialUtilities.writePaint(this.minorTickPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.minorTickStroke, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.majorTickPaint = SerialUtilities.readPaint(objectInputStream);
        this.majorTickStroke = SerialUtilities.readStroke(objectInputStream);
        this.minorTickPaint = SerialUtilities.readPaint(objectInputStream);
        this.minorTickStroke = SerialUtilities.readStroke(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

