/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StandardDialRange
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    static final long serialVersionUID = 345515648249364904L;
    private int scaleIndex;
    private double lowerBound;
    private double upperBound;
    private transient Paint paint;
    private double innerRadius;
    private double outerRadius;

    public StandardDialRange() {
        this(0.0, 100.0, Color.white);
    }

    public StandardDialRange(double d2, double d3, Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.scaleIndex = 0;
        this.lowerBound = d2;
        this.upperBound = d3;
        this.innerRadius = 0.48;
        this.outerRadius = 0.52;
        this.paint = paint;
    }

    public int getScaleIndex() {
        return this.scaleIndex;
    }

    public void setScaleIndex(int n2) {
        this.scaleIndex = n2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d2) {
        if (d2 >= this.upperBound) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.lowerBound = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d2) {
        if (d2 <= this.lowerBound) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.upperBound = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public void setBounds(double d2, double d3) {
        if (d2 >= d3) {
            throw new IllegalArgumentException("Lower must be less than upper.");
        }
        this.lowerBound = d2;
        this.upperBound = d3;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d2) {
        this.innerRadius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d2) {
        this.outerRadius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius, this.innerRadius);
        Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius, this.outerRadius);
        DialScale dialScale = dialPlot.getScale(this.scaleIndex);
        if (dialScale == null) {
            throw new RuntimeException("No scale for scaleIndex = " + this.scaleIndex);
        }
        double d2 = dialScale.valueToAngle(this.lowerBound);
        double d3 = dialScale.valueToAngle(this.upperBound);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d2, d3 - d2, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D4, d3, d2 - d3, 0);
        graphics2D.setPaint(this.paint);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialRange)) {
            return false;
        }
        StandardDialRange standardDialRange = (StandardDialRange)object;
        if (this.scaleIndex != standardDialRange.scaleIndex) {
            return false;
        }
        if (this.lowerBound != standardDialRange.lowerBound) {
            return false;
        }
        if (this.upperBound != standardDialRange.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, standardDialRange.paint)) {
            return false;
        }
        if (this.innerRadius != standardDialRange.innerRadius) {
            return false;
        }
        if (this.outerRadius != standardDialRange.outerRadius) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        long l2 = Double.doubleToLongBits(this.lowerBound);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.upperBound);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.innerRadius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.outerRadius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.paint);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

