/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StandardDialFrame
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialFrame,
PublicCloneable {
    static final long serialVersionUID = 1016585407507121596L;
    private double radius = 0.95;
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = Color.black;
    private transient Stroke stroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("The 'radius' must be positive.");
        }
        this.radius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public Shape getWindow(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        return new Ellipse2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
    }

    @Override
    public boolean isClippedToWindow() {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Shape shape = this.getWindow(rectangle2D);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius + 0.02, this.radius + 0.02);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
        Area area = new Area(double_);
        Area area2 = new Area(shape);
        area.subtract(area2);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fill(area);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.foregroundPaint);
        graphics2D.draw(shape);
        graphics2D.draw(double_);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialFrame)) {
            return false;
        }
        StandardDialFrame standardDialFrame = (StandardDialFrame)object;
        if (!PaintUtilities.equal(this.backgroundPaint, standardDialFrame.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.foregroundPaint, standardDialFrame.foregroundPaint)) {
            return false;
        }
        if (this.radius != standardDialFrame.radius) {
            return false;
        }
        if (!this.stroke.equals(standardDialFrame.stroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        long l2 = Double.doubleToLongBits(this.radius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.foregroundPaint);
        n2 = 37 * n2 + this.stroke.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.foregroundPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.foregroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
    }
}

