/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class DialValueIndicator
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    static final long serialVersionUID = 803094354130942585L;
    private int datasetIndex;
    private double angle;
    private double radius;
    private RectangleAnchor frameAnchor;
    private Number templateValue;
    private Number maxTemplateValue;
    private NumberFormat formatter;
    private Font font;
    private transient Paint paint;
    private transient Paint backgroundPaint;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private RectangleInsets insets;
    private RectangleAnchor valueAnchor;
    private TextAnchor textAnchor;

    public DialValueIndicator() {
        this(0);
    }

    public DialValueIndicator(int n2) {
        this.datasetIndex = n2;
        this.angle = -90.0;
        this.radius = 0.3;
        this.frameAnchor = RectangleAnchor.CENTER;
        this.templateValue = new Double(100.0);
        this.maxTemplateValue = null;
        this.formatter = new DecimalFormat("0.0");
        this.font = new Font("Dialog", 1, 14);
        this.paint = Color.black;
        this.backgroundPaint = Color.white;
        this.outlineStroke = new BasicStroke(1.0f);
        this.outlinePaint = Color.blue;
        this.insets = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.valueAnchor = RectangleAnchor.RIGHT;
        this.textAnchor = TextAnchor.CENTER_RIGHT;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n2) {
        this.datasetIndex = n2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d2) {
        this.angle = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        this.radius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleAnchor getFrameAnchor() {
        return this.frameAnchor;
    }

    public void setFrameAnchor(RectangleAnchor rectangleAnchor) {
        ParamChecks.nullNotPermitted(rectangleAnchor, "anchor");
        this.frameAnchor = rectangleAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Number getTemplateValue() {
        return this.templateValue;
    }

    public void setTemplateValue(Number number) {
        ParamChecks.nullNotPermitted(number, "value");
        this.templateValue = number;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Number getMaxTemplateValue() {
        return this.maxTemplateValue;
    }

    public void setMaxTemplateValue(Number number) {
        this.maxTemplateValue = number;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public NumberFormat getNumberFormat() {
        return this.formatter;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.formatter = numberFormat;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.font = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.outlineStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.outlinePaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "insets");
        this.insets = rectangleInsets;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleAnchor getValueAnchor() {
        return this.valueAnchor;
    }

    public void setValueAnchor(RectangleAnchor rectangleAnchor) {
        ParamChecks.nullNotPermitted(rectangleAnchor, "anchor");
        this.valueAnchor = rectangleAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(TextAnchor textAnchor) {
        ParamChecks.nullNotPermitted(textAnchor, "anchor");
        this.textAnchor = textAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.angle, 0.0, 0);
        Point2D point2D = double_.getStartPoint();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        double d2 = dialPlot.getValue(this.datasetIndex);
        String string = this.formatter.format(d2);
        Rectangle2D rectangle2D4 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        String string2 = this.formatter.format(this.templateValue);
        Rectangle2D rectangle2D5 = TextUtilities.getTextBounds(string2, graphics2D, fontMetrics);
        double d3 = rectangle2D5.getWidth();
        double d4 = rectangle2D5.getHeight();
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MAX_VALUE;
        if (this.maxTemplateValue != null) {
            string2 = this.formatter.format(this.maxTemplateValue);
            rectangle2D5 = TextUtilities.getTextBounds(string2, graphics2D, fontMetrics);
            d5 = Math.max(rectangle2D5.getWidth(), d3);
            d6 = Math.max(rectangle2D5.getHeight(), d4);
        }
        double d7 = this.fixToRange(rectangle2D4.getWidth(), d3, d5);
        double d8 = this.fixToRange(rectangle2D4.getHeight(), d4, d6);
        Rectangle2D rectangle2D6 = RectangleAnchor.createRectangle(new Size2D(d7, d8), point2D.getX(), point2D.getY(), this.frameAnchor);
        Rectangle2D rectangle2D7 = this.insets.createOutsetRectangle(rectangle2D6);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fill(rectangle2D7);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.draw(rectangle2D7);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D7);
        Point2D point2D2 = RectangleAnchor.coordinates(rectangle2D6, this.valueAnchor);
        graphics2D.setPaint(this.paint);
        graphics2D.setFont(this.font);
        TextUtilities.drawAlignedString(string, graphics2D, (float)point2D2.getX(), (float)point2D2.getY(), this.textAnchor);
        graphics2D.setClip(shape);
    }

    private double fixToRange(double d2, double d3, double d4) {
        if (d3 > d4) {
            throw new IllegalArgumentException("Requires 'minX' <= 'maxX'.");
        }
        if (d2 < d3) {
            return d3;
        }
        if (d2 > d4) {
            return d4;
        }
        return d2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialValueIndicator)) {
            return false;
        }
        DialValueIndicator dialValueIndicator = (DialValueIndicator)object;
        if (this.datasetIndex != dialValueIndicator.datasetIndex) {
            return false;
        }
        if (this.angle != dialValueIndicator.angle) {
            return false;
        }
        if (this.radius != dialValueIndicator.radius) {
            return false;
        }
        if (!this.frameAnchor.equals(dialValueIndicator.frameAnchor)) {
            return false;
        }
        if (!this.templateValue.equals(dialValueIndicator.templateValue)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.maxTemplateValue, dialValueIndicator.maxTemplateValue)) {
            return false;
        }
        if (!this.font.equals(dialValueIndicator.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, dialValueIndicator.paint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, dialValueIndicator.backgroundPaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(dialValueIndicator.outlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, dialValueIndicator.outlinePaint)) {
            return false;
        }
        if (!this.insets.equals(dialValueIndicator.insets)) {
            return false;
        }
        if (!this.valueAnchor.equals(dialValueIndicator.valueAnchor)) {
            return false;
        }
        if (!this.textAnchor.equals(dialValueIndicator.textAnchor)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.paint);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.outlinePaint);
        n2 = 37 * n2 + this.outlineStroke.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

