/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class DialTextAnnotation
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    static final long serialVersionUID = 3065267524054428071L;
    private String label;
    private Font font;
    private transient Paint paint;
    private double angle;
    private double radius;
    private TextAnchor anchor;

    public DialTextAnnotation(String string) {
        ParamChecks.nullNotPermitted(string, "label");
        this.angle = -90.0;
        this.radius = 0.3;
        this.font = new Font("Dialog", 1, 14);
        this.paint = Color.black;
        this.label = string;
        this.anchor = TextAnchor.TOP_CENTER;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        ParamChecks.nullNotPermitted(string, "label");
        this.label = string;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.font = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d2) {
        this.angle = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The 'radius' cannot be negative.");
        }
        this.radius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public TextAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(TextAnchor textAnchor) {
        ParamChecks.nullNotPermitted(textAnchor, "anchor");
        this.anchor = textAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.angle, 0.0, 0);
        Point2D point2D = double_.getStartPoint();
        graphics2D.setPaint(this.paint);
        graphics2D.setFont(this.font);
        TextUtilities.drawAlignedString(this.label, graphics2D, (float)point2D.getX(), (float)point2D.getY(), this.anchor);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialTextAnnotation)) {
            return false;
        }
        DialTextAnnotation dialTextAnnotation = (DialTextAnnotation)object;
        if (!this.label.equals(dialTextAnnotation.label)) {
            return false;
        }
        if (!this.font.equals(dialTextAnnotation.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, dialTextAnnotation.paint)) {
            return false;
        }
        if (this.radius != dialTextAnnotation.radius) {
            return false;
        }
        if (this.angle != dialTextAnnotation.angle) {
            return false;
        }
        if (!this.anchor.equals(dialTextAnnotation.anchor)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.paint);
        n2 = 37 * n2 + this.font.hashCode();
        n2 = 37 * n2 + this.label.hashCode();
        n2 = 37 * n2 + this.anchor.hashCode();
        long l2 = Double.doubleToLongBits(this.angle);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.radius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

