/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public abstract class DialPointer
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    double radius = 0.9;
    int datasetIndex;

    protected DialPointer() {
        this(0);
    }

    protected DialPointer(int n2) {
        this.datasetIndex = n2;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n2) {
        this.datasetIndex = n2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        this.radius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialPointer)) {
            return false;
        }
        DialPointer dialPointer = (DialPointer)object;
        if (this.datasetIndex != dialPointer.datasetIndex) {
            return false;
        }
        if (this.radius != dialPointer.radius) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 23;
        n2 = HashUtilities.hashCode(n2, this.radius);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public static class Pointer
    extends DialPointer {
        static final long serialVersionUID = -4180500011963176960L;
        private double widthRadius = 0.05;
        private transient Paint fillPaint = Color.gray;
        private transient Paint outlinePaint = Color.black;

        public Pointer() {
            this(0);
        }

        public Pointer(int n2) {
            super(n2);
        }

        public double getWidthRadius() {
            return this.widthRadius;
        }

        public void setWidthRadius(double d2) {
            this.widthRadius = d2;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Paint getFillPaint() {
            return this.fillPaint;
        }

        public void setFillPaint(Paint paint) {
            ParamChecks.nullNotPermitted(paint, "paint");
            this.fillPaint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Paint getOutlinePaint() {
            return this.outlinePaint;
        }

        public void setOutlinePaint(Paint paint) {
            ParamChecks.nullNotPermitted(paint, "paint");
            this.outlinePaint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        @Override
        public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            graphics2D.setPaint(Color.blue);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
            Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.widthRadius, this.widthRadius);
            double d2 = dialPlot.getValue(this.datasetIndex);
            DialScale dialScale = dialPlot.getScaleForDataset(this.datasetIndex);
            double d3 = dialScale.valueToAngle(d2);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d3, 0.0, 0);
            Point2D point2D = double_.getEndPoint();
            Arc2D.Double double_2 = new Arc2D.Double(rectangle2D4, d3 - 90.0, 180.0, 0);
            Point2D point2D2 = double_2.getStartPoint();
            Point2D point2D3 = double_2.getEndPoint();
            Arc2D.Double double_3 = new Arc2D.Double(rectangle2D4, d3 - 180.0, 0.0, 0);
            Point2D point2D4 = double_3.getStartPoint();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.closePath();
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(generalPath);
            graphics2D.setPaint(this.outlinePaint);
            Line2D.Double double_4 = new Line2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY(), point2D.getX(), point2D.getY());
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D3);
            graphics2D.draw(double_4);
            double_4.setLine(point2D3, point2D);
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D);
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D4);
            graphics2D.draw(double_4);
            double_4.setLine(point2D3, point2D4);
            graphics2D.draw(double_4);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)object;
            if (this.widthRadius != pointer.widthRadius) {
                return false;
            }
            if (!PaintUtilities.equal(this.fillPaint, pointer.fillPaint)) {
                return false;
            }
            if (!PaintUtilities.equal(this.outlinePaint, pointer.outlinePaint)) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = super.hashCode();
            n2 = HashUtilities.hashCode(n2, this.widthRadius);
            n2 = HashUtilities.hashCode(n2, this.fillPaint);
            n2 = HashUtilities.hashCode(n2, this.outlinePaint);
            return n2;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
            SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) {
            objectInputStream.defaultReadObject();
            this.fillPaint = SerialUtilities.readPaint(objectInputStream);
            this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        }
    }

    public static class Pin
    extends DialPointer {
        static final long serialVersionUID = -8445860485367689750L;
        private transient Paint paint = Color.red;
        private transient Stroke stroke = new BasicStroke(3.0f, 1, 2);

        public Pin() {
            this(0);
        }

        public Pin(int n2) {
            super(n2);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            ParamChecks.nullNotPermitted(paint, "paint");
            this.paint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setStroke(Stroke stroke) {
            ParamChecks.nullNotPermitted(stroke, "stroke");
            this.stroke = stroke;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        @Override
        public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            graphics2D.setPaint(this.paint);
            graphics2D.setStroke(this.stroke);
            Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
            double d2 = dialPlot.getValue(this.datasetIndex);
            DialScale dialScale = dialPlot.getScaleForDataset(this.datasetIndex);
            double d3 = dialScale.valueToAngle(d2);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d3, 0.0, 0);
            Point2D point2D = double_.getEndPoint();
            Line2D.Double double_2 = new Line2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY(), point2D.getX(), point2D.getY());
            graphics2D.draw(double_2);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Pin)) {
                return false;
            }
            Pin pin = (Pin)object;
            if (!PaintUtilities.equal(this.paint, pin.paint)) {
                return false;
            }
            if (!this.stroke.equals(pin.stroke)) {
                return false;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = super.hashCode();
            n2 = HashUtilities.hashCode(n2, this.paint);
            n2 = HashUtilities.hashCode(n2, this.stroke);
            return n2;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.paint, objectOutputStream);
            SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) {
            objectInputStream.defaultReadObject();
            this.paint = SerialUtilities.readPaint(objectInputStream);
            this.stroke = SerialUtilities.readStroke(objectInputStream);
        }
    }
}

