/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.ArcDialFrame;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialLayerChangeListener;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.ValueDataset;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;

public class DialPlot
extends Plot
implements DialLayerChangeListener {
    private DialLayer background = null;
    private DialLayer cap = null;
    private DialFrame dialFrame = new ArcDialFrame();
    private ObjectList datasets = new ObjectList();
    private ObjectList scales;
    private ObjectList datasetToScaleMap;
    private List layers;
    private List pointers;
    private double viewX;
    private double viewY;
    private double viewW;
    private double viewH;

    public DialPlot() {
        this(null);
    }

    public DialPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.setDataset(valueDataset);
        }
        this.scales = new ObjectList();
        this.datasetToScaleMap = new ObjectList();
        this.layers = new ArrayList();
        this.pointers = new ArrayList();
        this.viewX = 0.0;
        this.viewY = 0.0;
        this.viewW = 1.0;
        this.viewH = 1.0;
    }

    public DialLayer getBackground() {
        return this.background;
    }

    public void setBackground(DialLayer dialLayer) {
        if (this.background != null) {
            this.background.removeChangeListener(this);
        }
        this.background = dialLayer;
        if (dialLayer != null) {
            dialLayer.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public DialLayer getCap() {
        return this.cap;
    }

    public void setCap(DialLayer dialLayer) {
        if (this.cap != null) {
            this.cap.removeChangeListener(this);
        }
        this.cap = dialLayer;
        if (dialLayer != null) {
            dialLayer.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public DialFrame getDialFrame() {
        return this.dialFrame;
    }

    public void setDialFrame(DialFrame dialFrame) {
        ParamChecks.nullNotPermitted(dialFrame, "frame");
        this.dialFrame.removeChangeListener(this);
        this.dialFrame = dialFrame;
        dialFrame.addChangeListener(this);
        this.fireChangeEvent();
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    public double getViewWidth() {
        return this.viewW;
    }

    public double getViewHeight() {
        return this.viewH;
    }

    public void setView(double d2, double d3, double d4, double d5) {
        this.viewX = d2;
        this.viewY = d3;
        this.viewW = d4;
        this.viewH = d5;
        this.fireChangeEvent();
    }

    public void addLayer(DialLayer dialLayer) {
        ParamChecks.nullNotPermitted(dialLayer, "layer");
        this.layers.add(dialLayer);
        dialLayer.addChangeListener(this);
        this.fireChangeEvent();
    }

    public int getLayerIndex(DialLayer dialLayer) {
        ParamChecks.nullNotPermitted(dialLayer, "layer");
        return this.layers.indexOf(dialLayer);
    }

    public void removeLayer(int n2) {
        DialLayer dialLayer = (DialLayer)this.layers.get(n2);
        if (dialLayer != null) {
            dialLayer.removeChangeListener(this);
        }
        this.layers.remove(n2);
        this.fireChangeEvent();
    }

    public void removeLayer(DialLayer dialLayer) {
        this.removeLayer(this.getLayerIndex(dialLayer));
    }

    public void addPointer(DialPointer dialPointer) {
        ParamChecks.nullNotPermitted(dialPointer, "pointer");
        this.pointers.add(dialPointer);
        dialPointer.addChangeListener(this);
        this.fireChangeEvent();
    }

    public int getPointerIndex(DialPointer dialPointer) {
        ParamChecks.nullNotPermitted(dialPointer, "pointer");
        return this.pointers.indexOf(dialPointer);
    }

    public void removePointer(int n2) {
        DialPointer dialPointer = (DialPointer)this.pointers.get(n2);
        if (dialPointer != null) {
            dialPointer.removeChangeListener(this);
        }
        this.pointers.remove(n2);
        this.fireChangeEvent();
    }

    public void removePointer(DialPointer dialPointer) {
        this.removeLayer(this.getPointerIndex(dialPointer));
    }

    public DialPointer getPointerForDataset(int n2) {
        DialPointer dialPointer = null;
        for (DialPointer dialPointer2 : this.pointers) {
            if (dialPointer2.getDatasetIndex() != n2) continue;
            return dialPointer2;
        }
        return dialPointer;
    }

    public ValueDataset getDataset() {
        return this.getDataset(0);
    }

    public ValueDataset getDataset(int n2) {
        ValueDataset valueDataset = null;
        if (this.datasets.size() > n2) {
            valueDataset = (ValueDataset)this.datasets.get(n2);
        }
        return valueDataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        this.setDataset(0, valueDataset);
    }

    public void setDataset(int n2, ValueDataset valueDataset) {
        ValueDataset valueDataset2 = (ValueDataset)this.datasets.get(n2);
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.datasets.set(n2, valueDataset);
        if (valueDataset != null) {
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Shape shape;
        Shape shape2 = graphics2D.getClip();
        graphics2D.setClip(rectangle2D);
        Rectangle2D rectangle2D2 = this.viewToFrame(rectangle2D);
        if (this.background != null && this.background.isVisible()) {
            if (this.background.isClippedToWindow()) {
                Iterator iterator = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                this.background.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip((Shape)((Object)iterator));
            } else {
                this.background.draw(graphics2D, this, rectangle2D2, rectangle2D);
            }
        }
        for (Object object : this.layers) {
            if (!object.isVisible()) continue;
            if (object.isClippedToWindow()) {
                shape = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                object.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip(shape);
                continue;
            }
            object.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        for (Object object : this.pointers) {
            if (!((AbstractDialLayer)object).isVisible()) continue;
            if (((DialPointer)object).isClippedToWindow()) {
                shape = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                object.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip(shape);
                continue;
            }
            object.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        if (this.cap != null && this.cap.isVisible()) {
            if (this.cap.isClippedToWindow()) {
                Object object;
                object = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                this.cap.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip((Shape)object);
            } else {
                this.cap.draw(graphics2D, this, rectangle2D2, rectangle2D);
            }
        }
        if (this.dialFrame.isVisible()) {
            this.dialFrame.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        graphics2D.setClip(shape2);
    }

    private Rectangle2D viewToFrame(Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getWidth() / this.viewW;
        double d3 = rectangle2D.getHeight() / this.viewH;
        double d4 = rectangle2D.getX() - d2 * this.viewX;
        double d5 = rectangle2D.getY() - d3 * this.viewY;
        return new Rectangle2D.Double(d4, d5, d2, d3);
    }

    public double getValue(int n2) {
        Number number;
        double d2 = Double.NaN;
        ValueDataset valueDataset = this.getDataset(n2);
        if (valueDataset != null && (number = valueDataset.getValue()) != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public void addScale(int n2, DialScale dialScale) {
        ParamChecks.nullNotPermitted(dialScale, "scale");
        DialScale dialScale2 = (DialScale)this.scales.get(n2);
        if (dialScale2 != null) {
            this.removeLayer(dialScale2);
        }
        this.layers.add(dialScale);
        this.scales.set(n2, dialScale);
        dialScale.addChangeListener(this);
        this.fireChangeEvent();
    }

    public DialScale getScale(int n2) {
        DialScale dialScale = null;
        if (this.scales.size() > n2) {
            dialScale = (DialScale)this.scales.get(n2);
        }
        return dialScale;
    }

    public void mapDatasetToScale(int n2, int n3) {
        this.datasetToScaleMap.set(n2, new Integer(n3));
        this.fireChangeEvent();
    }

    public DialScale getScaleForDataset(int n2) {
        DialScale dialScale = (DialScale)this.scales.get(0);
        Integer n3 = (Integer)this.datasetToScaleMap.get(n2);
        if (n3 != null) {
            dialScale = this.getScale(n3);
        }
        return dialScale;
    }

    public static Rectangle2D rectangleByRadius(Rectangle2D rectangle2D, double d2, double d3) {
        ParamChecks.nullNotPermitted(rectangle2D, "rect");
        double d4 = rectangle2D.getCenterX();
        double d5 = rectangle2D.getCenterY();
        double d6 = rectangle2D.getWidth() * d2;
        double d7 = rectangle2D.getHeight() * d3;
        return new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7);
    }

    @Override
    public void dialLayerChanged(DialLayerChangeEvent dialLayerChangeEvent) {
        this.fireChangeEvent();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialPlot)) {
            return false;
        }
        DialPlot dialPlot = (DialPlot)object;
        if (!ObjectUtilities.equal(this.background, dialPlot.background)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.cap, dialPlot.cap)) {
            return false;
        }
        if (!this.dialFrame.equals(dialPlot.dialFrame)) {
            return false;
        }
        if (this.viewX != dialPlot.viewX) {
            return false;
        }
        if (this.viewY != dialPlot.viewY) {
            return false;
        }
        if (this.viewW != dialPlot.viewW) {
            return false;
        }
        if (this.viewH != dialPlot.viewH) {
            return false;
        }
        if (!this.layers.equals(dialPlot.layers)) {
            return false;
        }
        if (!this.pointers.equals(dialPlot.pointers)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + ObjectUtilities.hashCode(this.background);
        n2 = 37 * n2 + ObjectUtilities.hashCode(this.cap);
        n2 = 37 * n2 + this.dialFrame.hashCode();
        long l2 = Double.doubleToLongBits(this.viewX);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.viewY);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.viewW);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.viewH);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    @Override
    public String getPlotType() {
        return "DialPlot";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
    }
}

