/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class DialCap
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    static final long serialVersionUID = -2929484264982524463L;
    private double radius = 0.05;
    private transient Paint fillPaint = Color.white;
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Requires radius > 0.0.");
        }
        this.radius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.fillPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.outlinePaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.outlineStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        graphics2D.setPaint(this.fillPaint);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
        graphics2D.fill(double_);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.draw(double_);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialCap)) {
            return false;
        }
        DialCap dialCap = (DialCap)object;
        if (this.radius != dialCap.radius) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, dialCap.fillPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, dialCap.outlinePaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(dialCap.outlineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.fillPaint);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.outlinePaint);
        n2 = 37 * n2 + this.outlineStroke.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

