/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class DialBackground
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialLayer,
PublicCloneable {
    static final long serialVersionUID = -9019069533317612375L;
    private transient Paint paint;
    private GradientPaintTransformer gradientPaintTransformer;

    public DialBackground() {
        this(Color.white);
    }

    public DialBackground(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        ParamChecks.nullNotPermitted(gradientPaintTransformer, "t");
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Paint paint = this.paint;
        if (paint instanceof GradientPaint) {
            paint = this.gradientPaintTransformer.transform((GradientPaint)paint, rectangle2D2);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(rectangle2D2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialBackground)) {
            return false;
        }
        DialBackground dialBackground = (DialBackground)object;
        if (!PaintUtilities.equal(this.paint, dialBackground.paint)) {
            return false;
        }
        if (!this.gradientPaintTransformer.equals(dialBackground.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.paint);
        n2 = 37 * n2 + this.gradientPaintTransformer.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

