/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.AbstractDialLayer;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class ArcDialFrame
extends AbstractDialLayer
implements Serializable,
Cloneable,
DialFrame,
PublicCloneable {
    static final long serialVersionUID = -4089176959553523499L;
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = new Color(100, 100, 150);
    private transient Stroke stroke = new BasicStroke(2.0f);
    private double startAngle;
    private double extent;
    private double innerRadius = 0.25;
    private double outerRadius = 0.75;

    public ArcDialFrame() {
        this(0.0, 180.0);
    }

    public ArcDialFrame(double d2, double d3) {
        this.startAngle = d2;
        this.extent = d3;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.innerRadius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.outerRadius = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d2) {
        this.startAngle = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double d2) {
        this.extent = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public Shape getWindow(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius, this.innerRadius);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius, this.outerRadius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, this.startAngle, this.extent, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, this.startAngle + this.extent, -this.extent, 0);
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D = double_.getStartPoint();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.append(double_, true);
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    protected Shape getOuterWindow(Rectangle2D rectangle2D) {
        double d2 = 0.02;
        double d3 = 1.5;
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius - d2, this.innerRadius - d2);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius + d2, this.outerRadius + d2);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, this.startAngle - d3, this.extent + 2.0 * d3, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, this.startAngle + d3 + this.extent, -this.extent - 2.0 * d3, 0);
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D = double_.getStartPoint();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.append(double_, true);
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Shape shape = this.getWindow(rectangle2D);
        Shape shape2 = this.getOuterWindow(rectangle2D);
        Area area = new Area(shape2);
        Area area2 = new Area(shape);
        area.subtract(area2);
        graphics2D.setPaint(Color.lightGray);
        graphics2D.fill(area);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.foregroundPaint);
        graphics2D.draw(shape);
        graphics2D.draw(shape2);
    }

    @Override
    public boolean isClippedToWindow() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArcDialFrame)) {
            return false;
        }
        ArcDialFrame arcDialFrame = (ArcDialFrame)object;
        if (!PaintUtilities.equal(this.backgroundPaint, arcDialFrame.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.foregroundPaint, arcDialFrame.foregroundPaint)) {
            return false;
        }
        if (this.startAngle != arcDialFrame.startAngle) {
            return false;
        }
        if (this.extent != arcDialFrame.extent) {
            return false;
        }
        if (this.innerRadius != arcDialFrame.innerRadius) {
            return false;
        }
        if (this.outerRadius != arcDialFrame.outerRadius) {
            return false;
        }
        if (!this.stroke.equals(arcDialFrame.stroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        long l2 = Double.doubleToLongBits(this.startAngle);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.extent);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.innerRadius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.outerRadius);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n2 = 37 * n2 + HashUtilities.hashCodeForPaint(this.foregroundPaint);
        n2 = 37 * n2 + this.stroke.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.foregroundPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.foregroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
    }
}

