/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.dial;

import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.chart.plot.dial.DialLayerChangeListener;

public abstract class AbstractDialLayer
implements DialLayer {
    private boolean visible = true;
    private transient EventListenerList listenerList = new EventListenerList();

    protected AbstractDialLayer() {
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractDialLayer)) {
            return false;
        }
        AbstractDialLayer abstractDialLayer = (AbstractDialLayer)object;
        return this.visible == abstractDialLayer.visible;
    }

    public int hashCode() {
        int n2 = 23;
        n2 = HashUtilities.hashCode(n2, this.visible);
        return n2;
    }

    public Object clone() {
        AbstractDialLayer abstractDialLayer = (AbstractDialLayer)super.clone();
        abstractDialLayer.listenerList = new EventListenerList();
        return abstractDialLayer;
    }

    @Override
    public void addChangeListener(DialLayerChangeListener dialLayerChangeListener) {
        this.listenerList.add(DialLayerChangeListener.class, dialLayerChangeListener);
    }

    @Override
    public void removeChangeListener(DialLayerChangeListener dialLayerChangeListener) {
        this.listenerList.remove(DialLayerChangeListener.class, dialLayerChangeListener);
    }

    @Override
    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void notifyListeners(DialLayerChangeEvent dialLayerChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DialLayerChangeListener.class) continue;
            ((DialLayerChangeListener)objectArray[i2 + 1]).dialLayerChanged(dialLayerChangeEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

