/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYAnnotationBoundsInfo;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.RendererUtilities;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class XYPlot
extends Plot
implements Serializable,
Cloneable,
RendererChangeListener,
Pannable,
ValueAxisPlot,
Zoomable,
PublicCloneable {
    private static final long serialVersionUID = 7044148245716569264L;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private Map<Integer, ValueAxis> domainAxes;
    private Map<Integer, AxisLocation> domainAxisLocations;
    private Map<Integer, ValueAxis> rangeAxes;
    private Map<Integer, AxisLocation> rangeAxisLocations;
    private Map<Integer, XYDataset> datasets;
    private Map<Integer, XYItemRenderer> renderers;
    private Map<Integer, List<Integer>> datasetToDomainAxesMap;
    private Map<Integer, List<Integer>> datasetToRangeAxesMap;
    private transient Point2D quadrantOrigin = new Point2D.Double(0.0, 0.0);
    private transient Paint[] quadrantPaint = new Paint[]{null, null, null, null};
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainMinorGridlinesVisible;
    private transient Stroke domainMinorGridlineStroke;
    private transient Paint domainMinorGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient Stroke rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private boolean domainZeroBaselineVisible;
    private transient Stroke domainZeroBaselineStroke;
    private transient Paint domainZeroBaselinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Stroke rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List<XYAnnotation> annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private DatasetRenderingOrder datasetRenderingOrder = DatasetRenderingOrder.REVERSE;
    private SeriesRenderingOrder seriesRenderingOrder = SeriesRenderingOrder.REVERSE;
    private int weight = 1;
    private LegendItemCollection fixedLegendItems;
    private boolean domainPannable;
    private boolean rangePannable;
    private ShadowGenerator shadowGenerator;

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.domainAxes = new HashMap<Integer, ValueAxis>();
        this.domainAxisLocations = new HashMap<Integer, AxisLocation>();
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.rangeAxes = new HashMap<Integer, ValueAxis>();
        this.rangeAxisLocations = new HashMap<Integer, AxisLocation>();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.datasets = new HashMap<Integer, XYDataset>();
        this.renderers = new HashMap<Integer, XYItemRenderer>();
        this.datasetToDomainAxesMap = new TreeMap<Integer, List<Integer>>();
        this.datasetToRangeAxesMap = new TreeMap<Integer, List<Integer>>();
        this.annotations = new ArrayList<XYAnnotation>();
        this.datasets.put(0, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.renderers.put(0, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.domainAxes.put(0, valueAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainAxisLocations.put(0, AxisLocation.BOTTOM_OR_LEFT);
        this.rangeAxes.put(0, valueAxis2);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.rangeAxisLocations.put(0, AxisLocation.BOTTOM_OR_LEFT);
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainMinorGridlinesVisible = false;
        this.domainMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainMinorGridlinePaint = Color.white;
        this.domainZeroBaselineVisible = false;
        this.domainZeroBaselinePaint = Color.black;
        this.domainZeroBaselineStroke = new BasicStroke(0.5f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeMinorGridlinePaint = Color.white;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = Color.black;
        this.rangeZeroBaselineStroke = new BasicStroke(0.5f);
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.shadowGenerator = null;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("XY_Plot");
    }

    @Override
    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.fireChangeEvent();
        }
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "offset");
        this.axisOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public ValueAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public ValueAxis getDomainAxis(int n2) {
        Plot plot;
        ValueAxis valueAxis = this.domainAxes.get(n2);
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getDomainAxis(n2);
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        this.setDomainAxis(0, valueAxis);
    }

    public void setDomainAxis(int n2, ValueAxis valueAxis) {
        this.setDomainAxis(n2, valueAxis, true);
    }

    public void setDomainAxis(int n2, ValueAxis valueAxis, boolean bl2) {
        ValueAxis valueAxis2 = this.getDomainAxis(n2);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.domainAxes.put(n2, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setDomainAxes(ValueAxis[] valueAxisArray) {
        for (int i2 = 0; i2 < valueAxisArray.length; ++i2) {
            this.setDomainAxis(i2, valueAxisArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocations.get(0);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(0, axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl2) {
        this.setDomainAxisLocation(0, axisLocation, bl2);
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        for (ValueAxis valueAxis : this.domainAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.domainAxes.clear();
        this.fireChangeEvent();
    }

    public void configureDomainAxes() {
        for (ValueAxis valueAxis : this.domainAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getDomainAxisLocation(int n2) {
        AxisLocation axisLocation = this.domainAxisLocations.get(n2);
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation());
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(int n2, AxisLocation axisLocation) {
        this.setDomainAxisLocation(n2, axisLocation, true);
    }

    public void setDomainAxisLocation(int n2, AxisLocation axisLocation, boolean bl2) {
        if (n2 == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.put(n2, axisLocation);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getDomainAxisEdge(int n2) {
        AxisLocation axisLocation = this.getDomainAxisLocation(n2);
        return Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        ValueAxis valueAxis2;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        if ((valueAxis2 = this.getRangeAxis()) != null) {
            valueAxis2.removeChangeListener(this);
        }
        this.rangeAxes.put(0, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocations.get(0);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(0, axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl2) {
        this.setRangeAxisLocation(0, axisLocation, bl2);
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
    }

    public ValueAxis getRangeAxis(int n2) {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxes.get(n2);
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getRangeAxis(n2);
        }
        return valueAxis;
    }

    public void setRangeAxis(int n2, ValueAxis valueAxis) {
        this.setRangeAxis(n2, valueAxis, true);
    }

    public void setRangeAxis(int n2, ValueAxis valueAxis, boolean bl2) {
        ValueAxis valueAxis2 = this.getRangeAxis(n2);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.put(n2, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        for (int i2 = 0; i2 < valueAxisArray.length; ++i2) {
            this.setRangeAxis(i2, valueAxisArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.rangeAxes.clear();
        this.fireChangeEvent();
    }

    public void configureRangeAxes() {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getRangeAxisLocation(int n2) {
        AxisLocation axisLocation = this.rangeAxisLocations.get(n2);
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation());
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(int n2, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n2, axisLocation, true);
    }

    public void setRangeAxisLocation(int n2, AxisLocation axisLocation, boolean bl2) {
        if (n2 == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.put(n2, axisLocation);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getRangeAxisEdge(int n2) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n2);
        return Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int n2) {
        return this.datasets.get(n2);
    }

    public void setDataset(XYDataset xYDataset) {
        this.setDataset(0, xYDataset);
    }

    public void setDataset(int n2, XYDataset xYDataset) {
        XYDataset xYDataset2 = this.getDataset(n2);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.datasets.put(n2, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset xYDataset) {
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            if (xYDataset != entry.getValue()) continue;
            return entry.getKey();
        }
        return -1;
    }

    public void mapDatasetToDomainAxis(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n3));
        this.mapDatasetToDomainAxes(n2, arrayList);
    }

    public void mapDatasetToDomainAxes(int n2, List list) {
        ParamChecks.requireNonNegative(n2, "index");
        this.checkAxisIndices(list);
        Integer n3 = new Integer(n2);
        this.datasetToDomainAxesMap.put(n3, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n2)));
    }

    public void mapDatasetToRangeAxis(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n3));
        this.mapDatasetToRangeAxes(n2, arrayList);
    }

    public void mapDatasetToRangeAxes(int n2, List list) {
        ParamChecks.requireNonNegative(n2, "index");
        this.checkAxisIndices(list);
        Integer n3 = new Integer(n2);
        this.datasetToRangeAxesMap.put(n3, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n2)));
    }

    private void checkAxisIndices(List<Integer> list) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Integer n3 : list) {
            if (hashSet.contains(n3)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(n3);
        }
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public XYItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public XYItemRenderer getRenderer(int n2) {
        return this.renderers.get(n2);
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        this.setRenderer(0, xYItemRenderer);
    }

    public void setRenderer(int n2, XYItemRenderer xYItemRenderer) {
        this.setRenderer(n2, xYItemRenderer, true);
    }

    public void setRenderer(int n2, XYItemRenderer xYItemRenderer, boolean bl2) {
        XYItemRenderer xYItemRenderer2 = this.getRenderer(n2);
        if (xYItemRenderer2 != null) {
            xYItemRenderer2.removeChangeListener(this);
        }
        this.renderers.put(n2, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setRenderers(XYItemRenderer[] xYItemRendererArray) {
        for (int i2 = 0; i2 < xYItemRendererArray.length; ++i2) {
            this.setRenderer(i2, xYItemRendererArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.datasetRenderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        ParamChecks.nullNotPermitted(datasetRenderingOrder, "order");
        this.datasetRenderingOrder = datasetRenderingOrder;
        this.fireChangeEvent();
    }

    public SeriesRenderingOrder getSeriesRenderingOrder() {
        return this.seriesRenderingOrder;
    }

    public void setSeriesRenderingOrder(SeriesRenderingOrder seriesRenderingOrder) {
        ParamChecks.nullNotPermitted(seriesRenderingOrder, "order");
        this.seriesRenderingOrder = seriesRenderingOrder;
        this.fireChangeEvent();
    }

    public int getIndexOf(XYItemRenderer xYItemRenderer) {
        for (Map.Entry<Integer, XYItemRenderer> entry : this.renderers.entrySet()) {
            if (entry.getValue() != xYItemRenderer) continue;
            return entry.getKey();
        }
        return -1;
    }

    public XYItemRenderer getRendererForDataset(XYDataset xYDataset) {
        int n2 = this.indexOf(xYDataset);
        if (n2 < 0) {
            return null;
        }
        XYItemRenderer xYItemRenderer = this.renderers.get(n2);
        if (xYItemRenderer == null) {
            xYItemRenderer = this.getRenderer();
        }
        return xYItemRenderer;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n2) {
        this.weight = n2;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl2) {
        if (this.domainGridlinesVisible != bl2) {
            this.domainGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isDomainMinorGridlinesVisible() {
        return this.domainMinorGridlinesVisible;
    }

    public void setDomainMinorGridlinesVisible(boolean bl2) {
        if (this.domainMinorGridlinesVisible != bl2) {
            this.domainMinorGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Stroke getDomainMinorGridlineStroke() {
        return this.domainMinorGridlineStroke;
    }

    public void setDomainMinorGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getDomainMinorGridlinePaint() {
        return this.domainMinorGridlinePaint;
    }

    public void setDomainMinorGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl2) {
        if (this.rangeGridlinesVisible != bl2) {
            this.rangeGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean bl2) {
        if (this.rangeMinorGridlinesVisible != bl2) {
            this.rangeMinorGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isDomainZeroBaselineVisible() {
        return this.domainZeroBaselineVisible;
    }

    public void setDomainZeroBaselineVisible(boolean bl2) {
        this.domainZeroBaselineVisible = bl2;
        this.fireChangeEvent();
    }

    public Stroke getDomainZeroBaselineStroke() {
        return this.domainZeroBaselineStroke;
    }

    public void setDomainZeroBaselineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainZeroBaselinePaint() {
        return this.domainZeroBaselinePaint;
    }

    public void setDomainZeroBaselinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean bl2) {
        this.rangeZeroBaselineVisible = bl2;
        this.fireChangeEvent();
    }

    public Stroke getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
        this.fireChangeEvent();
    }

    public Point2D getQuadrantOrigin() {
        return this.quadrantOrigin;
    }

    public void setQuadrantOrigin(Point2D point2D) {
        ParamChecks.nullNotPermitted(point2D, "origin");
        this.quadrantOrigin = point2D;
        this.fireChangeEvent();
    }

    public Paint getQuadrantPaint(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("The index value (" + n2 + ") should be in the range 0 to 3.");
        }
        return this.quadrantPaint[n2];
    }

    public void setQuadrantPaint(int n2, Paint paint) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("The index value (" + n2 + ") should be in the range 0 to 3.");
        }
        this.quadrantPaint[n2] = paint;
        this.fireChangeEvent();
    }

    public void addDomainMarker(Marker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(Marker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void clearDomainMarkers() {
        Set set;
        if (this.backgroundDomainMarkers != null) {
            set = this.backgroundDomainMarkers.keySet();
            for (Integer n2 : set) {
                this.clearDomainMarkers(n2);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            set = this.foregroundDomainMarkers.keySet();
            for (Integer n2 : set) {
                this.clearDomainMarkers(n2);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public void clearDomainMarkers(int n2) {
        Collection collection;
        Integer n3 = new Integer(n2);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public void addDomainMarker(int n2, Marker marker, Layer layer) {
        this.addDomainMarker(n2, marker, layer, true);
    }

    public void addDomainMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        ParamChecks.nullNotPermitted(marker, "marker");
        ParamChecks.nullNotPermitted(layer, "layer");
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundDomainMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundDomainMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundDomainMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundDomainMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int n2, Marker marker, Layer layer) {
        return this.removeDomainMarker(n2, marker, layer, true);
    }

    public boolean removeDomainMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(n2)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(n2));
        if (arrayList == null) {
            return false;
        }
        boolean bl3 = arrayList.remove(marker);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void clearRangeMarkers() {
        Set set;
        if (this.backgroundRangeMarkers != null) {
            set = this.backgroundRangeMarkers.keySet();
            for (Integer n2 : set) {
                this.clearRangeMarkers(n2);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            set = this.foregroundRangeMarkers.keySet();
            for (Integer n2 : set) {
                this.clearRangeMarkers(n2);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public void addRangeMarker(int n2, Marker marker, Layer layer) {
        this.addRangeMarker(n2, marker, layer, true);
    }

    public void addRangeMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearRangeMarkers(int n2) {
        Collection collection;
        Integer n3 = new Integer(n2);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int n2, Marker marker, Layer layer) {
        return this.removeRangeMarker(n2, marker, layer, true);
    }

    public boolean removeRangeMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        ParamChecks.nullNotPermitted(marker, "marker");
        ParamChecks.nullNotPermitted(layer, "layer");
        List list = layer == Layer.FOREGROUND ? (List)this.foregroundRangeMarkers.get(new Integer(n2)) : (List)this.backgroundRangeMarkers.get(new Integer(n2));
        if (list == null) {
            return false;
        }
        boolean bl3 = list.remove(marker);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        this.addAnnotation(xYAnnotation, true);
    }

    public void addAnnotation(XYAnnotation xYAnnotation, boolean bl2) {
        ParamChecks.nullNotPermitted(xYAnnotation, "annotation");
        this.annotations.add(xYAnnotation);
        xYAnnotation.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        return this.removeAnnotation(xYAnnotation, true);
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation, boolean bl2) {
        ParamChecks.nullNotPermitted(xYAnnotation, "annotation");
        boolean bl3 = this.annotations.remove(xYAnnotation);
        xYAnnotation.removeChangeListener(this);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public List getAnnotations() {
        return new ArrayList<XYAnnotation>(this.annotations);
    }

    public void clearAnnotations() {
        for (XYAnnotation xYAnnotation : this.annotations) {
            xYAnnotation.removeChangeListener(this);
        }
        this.annotations.clear();
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D2, axisSpace);
        return axisSpace;
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block4;
            }
            for (ValueAxis valueAxis : this.domainAxes.values()) {
                if (valueAxis == null) continue;
                RectangleEdge rectangleEdge = this.getDomainAxisEdge(this.findDomainAxisIndex(valueAxis));
                axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block4;
            }
            for (ValueAxis valueAxis : this.rangeAxes.values()) {
                if (valueAxis == null) continue;
                RectangleEdge rectangleEdge = this.getRangeAxisEdge(this.findRangeAxisIndex(valueAxis));
                axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    private Rectangle integerise(Rectangle2D rectangle2D) {
        int n2 = (int)Math.ceil(rectangle2D.getMinX());
        int n3 = (int)Math.ceil(rectangle2D.getMinY());
        int n4 = (int)Math.floor(rectangle2D.getMaxX());
        int n5 = (int)Math.floor(rectangle2D.getMaxY());
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        Serializable serializable;
        ValueAxis valueAxis3;
        Object object2;
        int n2;
        AxisState axisState;
        Object object4;
        Object object5;
        boolean bl2;
        boolean bl3 = rectangle2D.getWidth() <= 10.0;
        boolean bl4 = bl2 = rectangle2D.getHeight() <= 10.0;
        if (bl3 || bl2) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        rectangle2D2 = this.integerise(rectangle2D2);
        if (rectangle2D2.isEmpty()) {
            return;
        }
        this.createAndAddEntity((Rectangle2D)rectangle2D2.clone(), plotRenderingInfo, null, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        Map<Axis, AxisState> map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        PlotOrientation plotOrientation = this.getOrientation();
        if (point2D != null && !rectangle2D2.contains(point2D)) {
            point2D = null;
        }
        CrosshairState crosshairState = new CrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(point2D);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (point2D != null) {
            object5 = this.getDomainAxis();
            if (object5 != null) {
                double d2 = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object5).java2DToValue(point2D.getX(), rectangle2D2, this.getDomainAxisEdge()) : ((ValueAxis)object5).java2DToValue(point2D.getY(), rectangle2D2, this.getDomainAxisEdge());
                crosshairState.setAnchorX(d2);
            }
            if ((object4 = this.getRangeAxis()) != null) {
                double d3 = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object4).java2DToValue(point2D.getY(), rectangle2D2, this.getRangeAxisEdge()) : ((ValueAxis)object4).java2DToValue(point2D.getX(), rectangle2D2, this.getRangeAxisEdge());
                crosshairState.setAnchorY(d3);
            }
        }
        crosshairState.setCrosshairX(this.getDomainCrosshairValue());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        object5 = graphics2D.getClip();
        object4 = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        AxisState axisState2 = map.get(this.getDomainAxis());
        if (axisState2 == null && plotState != null) {
            axisState2 = (AxisState)plotState.getSharedAxisStates().get(this.getDomainAxis());
        }
        if ((axisState = map.get(this.getRangeAxis())) == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState2 != null) {
            this.drawDomainTickBands(graphics2D, rectangle2D2, axisState2.getTicks());
        }
        if (axisState != null) {
            this.drawRangeTickBands(graphics2D, rectangle2D2, axisState.getTicks());
        }
        if (axisState2 != null) {
            this.drawDomainGridlines(graphics2D, rectangle2D2, axisState2.getTicks());
            this.drawZeroDomainBaseline(graphics2D, rectangle2D2);
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
            this.drawZeroRangeBaseline(graphics2D, rectangle2D2);
        }
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        boolean bl5 = Boolean.TRUE.equals(graphics2D.getRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION));
        if (this.shadowGenerator != null && !bl5) {
            bufferedImage = new BufferedImage((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
        }
        for (XYDataset object32 : this.datasets.values()) {
            n2 = this.indexOf(object32);
            this.drawDomainMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        for (XYDataset xYDataset : this.datasets.values()) {
            n2 = this.indexOf(xYDataset);
            this.drawRangeMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        boolean bl6 = false;
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        List<Integer> list = this.getRendererIndices(datasetRenderingOrder);
        List<Integer> list2 = this.getDatasetIndices(datasetRenderingOrder);
        for (int n3 : list) {
            object2 = this.getRenderer(n3);
            if (object2 == null) continue;
            valueAxis3 = this.getDomainAxisForDataset(n3);
            serializable = this.getRangeAxisForDataset(n3);
            object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis3, (ValueAxis)serializable, Layer.BACKGROUND, plotRenderingInfo);
        }
        for (int n3 : list2) {
            object2 = this.getDataset(n3);
            bl6 = this.render(graphics2D, rectangle2D2, n3, plotRenderingInfo, crosshairState) || bl6;
        }
        for (int n3 : list) {
            object2 = this.getRenderer(n3);
            if (object2 == null) continue;
            valueAxis3 = this.getDomainAxisForDataset(n3);
            serializable = this.getRangeAxisForDataset(n3);
            object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis3, (ValueAxis)serializable, Layer.FOREGROUND, plotRenderingInfo);
        }
        int n4 = crosshairState.getDatasetIndex();
        ValueAxis valueAxis = this.getDomainAxisForDataset(n4);
        object2 = this.getDomainAxisEdge(this.getDomainAxisIndex(valueAxis));
        if (!this.domainCrosshairLockedOnData && point2D != null) {
            double d2 = plotOrientation == PlotOrientation.VERTICAL ? valueAxis.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object2) : valueAxis.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object2);
            crosshairState.setCrosshairX(d2);
        }
        this.setDomainCrosshairValue(crosshairState.getCrosshairX(), false);
        if (this.isDomainCrosshairVisible()) {
            double d3 = this.getDomainCrosshairValue();
            object = this.getDomainCrosshairPaint();
            Stroke stroke = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(graphics2D, rectangle2D2, plotOrientation, d3, valueAxis, stroke, (Paint)object);
        }
        ValueAxis valueAxis2 = this.getRangeAxisForDataset(n4);
        serializable = this.getRangeAxisEdge(this.getRangeAxisIndex(valueAxis2));
        if (!this.rangeCrosshairLockedOnData && point2D != null) {
            double d4 = plotOrientation == PlotOrientation.VERTICAL ? valueAxis2.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)serializable) : valueAxis2.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)serializable);
            crosshairState.setCrosshairY(d4);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double d5 = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            Stroke stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(graphics2D, rectangle2D2, plotOrientation, d5, valueAxis2, stroke, paint);
        }
        if (!bl6) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        object = list.iterator();
        while (object.hasNext()) {
            int n5 = (Integer)object.next();
            this.drawDomainMarkers(graphics2D, rectangle2D2, n5, Layer.FOREGROUND);
        }
        object = list.iterator();
        while (object.hasNext()) {
            int n6 = object.next();
            this.drawRangeMarkers(graphics2D, rectangle2D2, n6, Layer.FOREGROUND);
        }
        this.drawAnnotations(graphics2D, rectangle2D2, plotRenderingInfo);
        if (this.shadowGenerator != null && !bl5) {
            object = this.shadowGenerator.createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)object, (int)rectangle2D2.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D2.getY() + this.shadowGenerator.calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D2.getX(), (int)rectangle2D2.getY(), null);
        }
        graphics2D.setClip((Shape)object5);
        graphics2D.setComposite((Composite)object4);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    private List<Integer> getDatasetIndices(DatasetRenderingOrder datasetRenderingOrder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayList.add(entry.getKey());
        }
        Collections.sort(arrayList);
        if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private List<Integer> getRendererIndices(DatasetRenderingOrder datasetRenderingOrder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, XYItemRenderer> entry : this.renderers.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayList.add(entry.getKey());
        }
        Collections.sort(arrayList);
        if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    @Override
    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D, this.orientation);
        this.drawQuadrants(graphics2D, rectangle2D);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected void drawQuadrants(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        boolean bl2 = false;
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis == null) {
            return;
        }
        double d2 = valueAxis.getRange().constrain(this.quadrantOrigin.getX());
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, this.getDomainAxisEdge());
        ValueAxis valueAxis2 = this.getRangeAxis();
        if (valueAxis2 == null) {
            return;
        }
        double d4 = valueAxis2.getRange().constrain(this.quadrantOrigin.getY());
        double d5 = valueAxis2.valueToJava2D(d4, rectangle2D, this.getRangeAxisEdge());
        double d6 = valueAxis.getLowerBound();
        double d7 = valueAxis.valueToJava2D(d6, rectangle2D, this.getDomainAxisEdge());
        double d8 = valueAxis.getUpperBound();
        double d9 = valueAxis.valueToJava2D(d8, rectangle2D, this.getDomainAxisEdge());
        double d10 = valueAxis2.getLowerBound();
        double d11 = valueAxis2.valueToJava2D(d10, rectangle2D, this.getRangeAxisEdge());
        double d12 = valueAxis2.getUpperBound();
        double d13 = valueAxis2.valueToJava2D(d12, rectangle2D, this.getRangeAxisEdge());
        Rectangle2D[] rectangle2DArray = new Rectangle2D[]{null, null, null, null};
        if (this.quadrantPaint[0] != null && d2 > d6 && d4 < d12) {
            rectangle2DArray[0] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d13, d5), Math.min(d7, d3), Math.abs(d5 - d13), Math.abs(d3 - d7)) : new Rectangle2D.Double(Math.min(d7, d3), Math.min(d13, d5), Math.abs(d3 - d7), Math.abs(d5 - d13));
            bl2 = true;
        }
        if (this.quadrantPaint[1] != null && d2 < d8 && d4 < d12) {
            rectangle2DArray[1] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d13, d5), Math.min(d9, d3), Math.abs(d5 - d13), Math.abs(d3 - d9)) : new Rectangle2D.Double(Math.min(d3, d9), Math.min(d13, d5), Math.abs(d3 - d9), Math.abs(d5 - d13));
            bl2 = true;
        }
        if (this.quadrantPaint[2] != null && d2 > d6 && d4 > d10) {
            rectangle2DArray[2] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d11, d5), Math.min(d7, d3), Math.abs(d5 - d11), Math.abs(d3 - d7)) : new Rectangle2D.Double(Math.min(d7, d3), Math.min(d11, d5), Math.abs(d3 - d7), Math.abs(d5 - d11));
            bl2 = true;
        }
        if (this.quadrantPaint[3] != null && d2 < d8 && d4 > d10) {
            rectangle2DArray[3] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d11, d5), Math.min(d9, d3), Math.abs(d5 - d11), Math.abs(d3 - d9)) : new Rectangle2D.Double(Math.min(d3, d9), Math.min(d11, d5), Math.abs(d3 - d9), Math.abs(d5 - d11));
            bl2 = true;
        }
        if (bl2) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getBackgroundAlpha()));
            for (int i2 = 0; i2 < 4; ++i2) {
                if (this.quadrantPaint[i2] == null || rectangle2DArray[i2] == null) continue;
                graphics2D.setPaint(this.quadrantPaint[i2]);
                graphics2D.fill(rectangle2DArray[i2]);
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawDomainTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getDomainTickBandPaint();
        if (paint != null) {
            boolean bl2 = false;
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d3 = valueTick.getValue();
                if (bl2) {
                    this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d2, d3);
                }
                d2 = d3;
                bl2 = !bl2;
            }
            double d4 = valueAxis.getUpperBound();
            if (bl2) {
                this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d2, d4);
            }
        }
    }

    public void drawRangeTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getRangeTickBandPaint();
        if (paint != null) {
            boolean bl2 = false;
            ValueAxis valueAxis = this.getRangeAxis();
            double d2 = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d3 = valueTick.getValue();
                if (bl2) {
                    this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d2, d3);
                }
                d2 = d3;
                bl2 = !bl2;
            }
            double d4 = valueAxis.getUpperBound();
            if (bl2) {
                this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d2, d4);
            }
        }
    }

    protected Map<Axis, AxisState> drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        int n2;
        AxisCollection axisCollection = new AxisCollection();
        for (ValueAxis valueAxis : this.domainAxes.values()) {
            if (valueAxis == null) continue;
            n2 = this.findDomainAxisIndex(valueAxis);
            axisCollection.add(valueAxis, this.getDomainAxisEdge(n2));
        }
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            n2 = this.findRangeAxisIndex(valueAxis);
            axisCollection.add(valueAxis, this.getRangeAxisEdge(n2));
        }
        HashMap hashMap = new HashMap();
        double d2 = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis : axisCollection.getAxesAtTop()) {
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(valueAxis, axisState);
        }
        d2 = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis : axisCollection.getAxesAtBottom()) {
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(valueAxis, axisState);
        }
        d2 = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis : axisCollection.getAxesAtLeft()) {
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(valueAxis, axisState);
        }
        d2 = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis : axisCollection.getAxesAtRight()) {
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(valueAxis, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        boolean bl2;
        block12: {
            bl2 = false;
            XYDataset xYDataset = this.getDataset(n2);
            if (DatasetUtilities.isEmptyOrNull(xYDataset)) break block12;
            bl2 = true;
            ValueAxis valueAxis = this.getDomainAxisForDataset(n2);
            ValueAxis valueAxis2 = this.getRangeAxisForDataset(n2);
            if (valueAxis == null || valueAxis2 == null) {
                return bl2;
            }
            XYItemRenderer xYItemRenderer = this.getRenderer(n2);
            if (xYItemRenderer == null && (xYItemRenderer = this.getRenderer()) == null) {
                return bl2;
            }
            XYItemRendererState xYItemRendererState = xYItemRenderer.initialise(graphics2D, rectangle2D, this, xYDataset, plotRenderingInfo);
            int n3 = xYItemRenderer.getPassCount();
            SeriesRenderingOrder seriesRenderingOrder = this.getSeriesRenderingOrder();
            if (seriesRenderingOrder == SeriesRenderingOrder.REVERSE) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = xYDataset.getSeriesCount();
                    for (int i3 = n4 - 1; i3 >= 0; --i3) {
                        int n5 = 0;
                        int n6 = xYDataset.getItemCount(i3) - 1;
                        if (n6 == -1) continue;
                        if (xYItemRendererState.getProcessVisibleItemsOnly()) {
                            int[] nArray = RendererUtilities.findLiveItems(xYDataset, i3, valueAxis.getLowerBound(), valueAxis.getUpperBound());
                            n5 = Math.max(nArray[0] - 1, 0);
                            n6 = Math.min(nArray[1] + 1, n6);
                        }
                        xYItemRendererState.startSeriesPass(xYDataset, i3, n5, n6, i2, n3);
                        for (int i4 = n5; i4 <= n6; ++i4) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, i3, i4, crosshairState, i2);
                        }
                        xYItemRendererState.endSeriesPass(xYDataset, i3, n5, n6, i2, n3);
                    }
                }
            } else {
                for (int i5 = 0; i5 < n3; ++i5) {
                    int n7 = xYDataset.getSeriesCount();
                    for (int i6 = 0; i6 < n7; ++i6) {
                        int n8 = 0;
                        int n9 = xYDataset.getItemCount(i6) - 1;
                        if (xYItemRendererState.getProcessVisibleItemsOnly()) {
                            int[] nArray = RendererUtilities.findLiveItems(xYDataset, i6, valueAxis.getLowerBound(), valueAxis.getUpperBound());
                            n8 = Math.max(nArray[0] - 1, 0);
                            n9 = Math.min(nArray[1] + 1, n9);
                        }
                        xYItemRendererState.startSeriesPass(xYDataset, i6, n8, n9, i5, n3);
                        for (int i7 = n8; i7 <= n9; ++i7) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, i6, i7, crosshairState, i5);
                        }
                        xYItemRendererState.endSeriesPass(xYDataset, i6, n8, n9, i5, n3);
                    }
                }
            }
        }
        return bl2;
    }

    public ValueAxis getDomainAxisForDataset(int n2) {
        ValueAxis valueAxis;
        ParamChecks.requireNonNegative(n2, "index");
        List<Integer> list = this.datasetToDomainAxesMap.get(new Integer(n2));
        if (list != null) {
            Integer n3 = list.get(0);
            valueAxis = this.getDomainAxis(n3);
        } else {
            valueAxis = this.getDomainAxis(0);
        }
        return valueAxis;
    }

    public ValueAxis getRangeAxisForDataset(int n2) {
        ValueAxis valueAxis;
        ParamChecks.requireNonNegative(n2, "index");
        List<Integer> list = this.datasetToRangeAxesMap.get(new Integer(n2));
        if (list != null) {
            Integer n3 = list.get(0);
            valueAxis = this.getRangeAxis(n3);
        } else {
            valueAxis = this.getRangeAxis(0);
        }
        return valueAxis;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isDomainGridlinesVisible() || this.isDomainMinorGridlinesVisible()) {
            Stroke stroke = null;
            Paint paint = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XYItemRenderer xYItemRenderer;
                boolean bl2 = false;
                ValueTick valueTick = (ValueTick)iterator.next();
                if (valueTick.getTickType() == TickType.MINOR && this.isDomainMinorGridlinesVisible()) {
                    stroke = this.getDomainMinorGridlineStroke();
                    paint = this.getDomainMinorGridlinePaint();
                    bl2 = true;
                } else if (valueTick.getTickType() == TickType.MAJOR && this.isDomainGridlinesVisible()) {
                    stroke = this.getDomainGridlineStroke();
                    paint = this.getDomainGridlinePaint();
                    bl2 = true;
                }
                if (!((xYItemRenderer = this.getRenderer()) instanceof AbstractXYItemRenderer) || !bl2) continue;
                ((AbstractXYItemRenderer)xYItemRenderer).drawDomainLine(graphics2D, this, this.getDomainAxis(), rectangle2D, valueTick.getValue(), paint, stroke);
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isRangeGridlinesVisible() || this.isRangeMinorGridlinesVisible()) {
            Stroke stroke = null;
            Paint paint = null;
            ValueAxis valueAxis = this.getRangeAxis();
            if (valueAxis != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    boolean bl2 = false;
                    ValueTick valueTick = (ValueTick)iterator.next();
                    if (valueTick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                        stroke = this.getRangeMinorGridlineStroke();
                        paint = this.getRangeMinorGridlinePaint();
                        bl2 = true;
                    } else if (valueTick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                        stroke = this.getRangeGridlineStroke();
                        paint = this.getRangeGridlinePaint();
                        bl2 = true;
                    }
                    if (valueTick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !bl2) continue;
                    this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue(), paint, stroke);
                }
            }
        }
    }

    protected void drawZeroDomainBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        XYItemRenderer xYItemRenderer;
        if (this.isDomainZeroBaselineVisible() && (xYItemRenderer = this.getRenderer()) instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)xYItemRenderer;
            abstractXYItemRenderer.drawDomainLine(graphics2D, this, this.getDomainAxis(), rectangle2D, 0.0, this.domainZeroBaselinePaint, this.domainZeroBaselineStroke);
        }
    }

    protected void drawZeroRangeBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isRangeZeroBaselineVisible()) {
            this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        for (XYAnnotation xYAnnotation : this.annotations) {
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            xYAnnotation.draw(graphics2D, this, rectangle2D, valueAxis, valueAxis2, 0, plotRenderingInfo);
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n2);
        if (xYItemRenderer == null) {
            return;
        }
        if (n2 >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getDomainMarkers(n2, layer);
        ValueAxis valueAxis = this.getDomainAxisForDataset(n2);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawDomainMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n2);
        if (xYItemRenderer == null) {
            return;
        }
        if (n2 >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getRangeMarkers(n2, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n2);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n2, Layer layer) {
        Collection collection = null;
        Integer n3 = new Integer(n2);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n3);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n3);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public Collection getRangeMarkers(int n2, Layer layer) {
        Collection collection = null;
        Integer n3 = new Integer(n2);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n3);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n3);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getDomainAxis();
        }
        if (valueAxis.getRange().contains(d2)) {
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.LEFT);
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawDomainCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d2, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        Line2D.Double double_;
        double d3;
        if (!valueAxis.getRange().contains(d2)) {
            return;
        }
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else {
            d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getDomainAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getRangeAxis();
        }
        if (valueAxis.getRange().contains(d2)) {
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM);
            Line2D.Double double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawRangeCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d2, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        Line2D.Double double_;
        if (!valueAxis.getRange().contains(d2)) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else {
            double d4 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getMaxX(), d4);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    @Override
    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n2, n3)) {
            ValueAxis valueAxis;
            ValueAxis valueAxis2 = this.getDomainAxis();
            if (valueAxis2 != null) {
                double d2 = valueAxis2.java2DToValue(n2, plotRenderingInfo.getDataArea(), this.getDomainAxisEdge());
                this.setDomainCrosshairValue(d2);
            }
            if ((valueAxis = this.getRangeAxis()) != null) {
                double d3 = valueAxis.java2DToValue(n3, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                this.setRangeCrosshairValue(d3);
            }
        }
    }

    private List<XYDataset> getDatasetsMappedToDomainAxis(Integer n2) {
        ParamChecks.nullNotPermitted(n2, "axisIndex");
        ArrayList<XYDataset> arrayList = new ArrayList<XYDataset>();
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            int n3 = entry.getKey();
            List<Integer> list = this.datasetToDomainAxesMap.get(n3);
            if (list == null) {
                if (!n2.equals(ZERO)) continue;
                arrayList.add(entry.getValue());
                continue;
            }
            if (!list.contains(n2)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private List<XYDataset> getDatasetsMappedToRangeAxis(Integer n2) {
        ParamChecks.nullNotPermitted(n2, "axisIndex");
        ArrayList<XYDataset> arrayList = new ArrayList<XYDataset>();
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            int n3 = entry.getKey();
            List<Integer> list = this.datasetToRangeAxesMap.get(n3);
            if (list == null) {
                if (!n2.equals(ZERO)) continue;
                arrayList.add(entry.getValue());
                continue;
            }
            if (!list.contains(n2)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public int getDomainAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n2 = this.findDomainAxisIndex(valueAxis);
        if (n2 < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n2 = xYPlot.getDomainAxisIndex(valueAxis);
        }
        return n2;
    }

    private int findDomainAxisIndex(ValueAxis valueAxis) {
        for (Map.Entry<Integer, ValueAxis> entry : this.domainAxes.entrySet()) {
            if (entry.getValue() != valueAxis) continue;
            return entry.getKey();
        }
        return -1;
    }

    public int getRangeAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n2 = this.findRangeAxisIndex(valueAxis);
        if (n2 < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n2 = xYPlot.getRangeAxisIndex(valueAxis);
        }
        return n2;
    }

    private int findRangeAxisIndex(ValueAxis valueAxis) {
        for (Map.Entry<Integer, ValueAxis> entry : this.rangeAxes.entrySet()) {
            if (entry.getValue() != valueAxis) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        int n2;
        Range range = null;
        ArrayList<XYDataset> arrayList = new ArrayList<XYDataset>();
        ArrayList<XYAnnotation> arrayList2 = new ArrayList<XYAnnotation>();
        boolean bl2 = true;
        int n3 = this.getDomainAxisIndex(valueAxis);
        if (n3 >= 0) {
            bl2 = true;
            arrayList.addAll(this.getDatasetsMappedToDomainAxis(n3));
            if (n3 == 0) {
                for (XYAnnotation object : this.annotations) {
                    if (!(object instanceof XYAnnotationBoundsInfo)) continue;
                    arrayList2.add(object);
                }
            }
        }
        if ((n2 = this.getRangeAxisIndex(valueAxis)) >= 0) {
            bl2 = false;
            arrayList.addAll(this.getDatasetsMappedToRangeAxis(n2));
            if (n2 == 0) {
                for (XYAnnotation xYAnnotation : this.annotations) {
                    if (!(xYAnnotation instanceof XYAnnotationBoundsInfo)) continue;
                    arrayList2.add(xYAnnotation);
                }
            }
        }
        for (XYDataset xYDataset : arrayList) {
            if (xYDataset == null) continue;
            XYItemRenderer xYItemRenderer = this.getRendererForDataset(xYDataset);
            range = bl2 ? (xYItemRenderer != null ? Range.combine(range, xYItemRenderer.findDomainBounds(xYDataset)) : Range.combine(range, DatasetUtilities.findDomainBounds(xYDataset))) : (xYItemRenderer != null ? Range.combine(range, xYItemRenderer.findRangeBounds(xYDataset)) : Range.combine(range, DatasetUtilities.findRangeBounds(xYDataset)));
            if (!(xYItemRenderer instanceof AbstractXYItemRenderer)) continue;
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)xYItemRenderer;
            Collection collection = abstractXYItemRenderer.getAnnotations();
            for (XYAnnotation xYAnnotation : collection) {
                if (!(xYAnnotation instanceof XYAnnotationBoundsInfo)) continue;
                arrayList2.add(xYAnnotation);
            }
        }
        for (XYAnnotationBoundsInfo xYAnnotationBoundsInfo : arrayList2) {
            if (!xYAnnotationBoundsInfo.getIncludeInDataBounds()) continue;
            if (bl2) {
                range = Range.combine(range, xYAnnotationBoundsInfo.getXRange());
                continue;
            }
            range = Range.combine(range, xYAnnotationBoundsInfo.getYRange());
        }
        return range;
    }

    @Override
    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        if (this.getParent() != null) {
            this.getParent().annotationChanged(annotationChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    @Override
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        if (rendererChangeEvent.getSeriesVisibilityChanged()) {
            this.configureDomainAxes();
            this.configureRangeAxes();
        }
        this.fireChangeEvent();
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl2) {
        if (this.domainCrosshairVisible != bl2) {
            this.domainCrosshairVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl2) {
        if (this.domainCrosshairLockedOnData != bl2) {
            this.domainCrosshairLockedOnData = bl2;
            this.fireChangeEvent();
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d2) {
        this.setDomainCrosshairValue(d2, true);
    }

    public void setDomainCrosshairValue(double d2, boolean bl2) {
        this.domainCrosshairValue = d2;
        if (this.isDomainCrosshairVisible() && bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl2) {
        if (this.rangeCrosshairVisible != bl2) {
            this.rangeCrosshairVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl2) {
        if (this.rangeCrosshairLockedOnData != bl2) {
            this.rangeCrosshairLockedOnData = bl2;
            this.fireChangeEvent();
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d2) {
        this.setRangeCrosshairValue(d2, true);
    }

    public void setRangeCrosshairValue(double d2, boolean bl2) {
        this.rangeCrosshairValue = d2;
        if (this.isRangeCrosshairVisible() && bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.setFixedDomainAxisSpace(axisSpace, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace, boolean bl2) {
        this.fixedDomainAxisSpace = axisSpace;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.setFixedRangeAxisSpace(axisSpace, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace, boolean bl2) {
        this.fixedRangeAxisSpace = axisSpace;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isDomainPannable() {
        return this.domainPannable;
    }

    public void setDomainPannable(boolean bl2) {
        this.domainPannable = bl2;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean bl2) {
        this.rangePannable = bl2;
    }

    @Override
    public void panDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isDomainPannable()) {
            return;
        }
        int n2 = this.getDomainAxisCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueAxis valueAxis = this.getDomainAxis(i2);
            if (valueAxis == null) continue;
            if (valueAxis.isInverted()) {
                d2 = -d2;
            }
            valueAxis.pan(d2);
        }
    }

    @Override
    public void panRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isRangePannable()) {
            return;
        }
        int n2 = this.getRangeAxisCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueAxis valueAxis = this.getRangeAxis(i2);
            if (valueAxis == null) continue;
            if (valueAxis.isInverted()) {
                d2 = -d2;
            }
            valueAxis.pan(d2);
        }
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomDomainAxes(d2, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        for (ValueAxis valueAxis : this.domainAxes.values()) {
            if (valueAxis == null) continue;
            if (bl2) {
                double d3 = point2D.getX();
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    d3 = point2D.getY();
                }
                double d4 = valueAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), this.getDomainAxisEdge());
                valueAxis.resizeRange2(d2, d4);
                continue;
            }
            valueAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (ValueAxis valueAxis : this.domainAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d2, d3);
        }
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d2, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            if (bl2) {
                double d3 = point2D.getY();
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    d3 = point2D.getX();
                }
                double d4 = valueAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                valueAxis.resizeRange2(d2, d4);
                continue;
            }
            valueAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d2, d3);
        }
    }

    @Override
    public boolean isDomainZoomable() {
        return true;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    public int getSeriesCount() {
        int n2 = 0;
        XYDataset xYDataset = this.getDataset();
        if (xYDataset != null) {
            n2 = xYDataset.getSeriesCount();
        }
        return n2;
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        for (XYDataset xYDataset : this.datasets.values()) {
            if (xYDataset == null) continue;
            int n2 = this.indexOf(xYDataset);
            XYItemRenderer xYItemRenderer = this.getRenderer(n2);
            if (xYItemRenderer == null) {
                xYItemRenderer = this.getRenderer(0);
            }
            if (xYItemRenderer == null) continue;
            int n3 = xYDataset.getSeriesCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                LegendItem legendItem;
                if (!xYItemRenderer.isSeriesVisible(i2) || !xYItemRenderer.isSeriesVisibleInLegend(i2) || (legendItem = xYItemRenderer.getLegendItem(n2, i2)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYPlot)) {
            return false;
        }
        XYPlot xYPlot = (XYPlot)object;
        if (this.weight != xYPlot.weight) {
            return false;
        }
        if (this.orientation != xYPlot.orientation) {
            return false;
        }
        if (!this.domainAxes.equals(xYPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(xYPlot.domainAxisLocations)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != xYPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (this.domainGridlinesVisible != xYPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.rangeGridlinesVisible != xYPlot.rangeGridlinesVisible) {
            return false;
        }
        if (this.domainMinorGridlinesVisible != xYPlot.domainMinorGridlinesVisible) {
            return false;
        }
        if (this.rangeMinorGridlinesVisible != xYPlot.rangeMinorGridlinesVisible) {
            return false;
        }
        if (this.domainZeroBaselineVisible != xYPlot.domainZeroBaselineVisible) {
            return false;
        }
        if (this.rangeZeroBaselineVisible != xYPlot.rangeZeroBaselineVisible) {
            return false;
        }
        if (this.domainCrosshairVisible != xYPlot.domainCrosshairVisible) {
            return false;
        }
        if (this.domainCrosshairValue != xYPlot.domainCrosshairValue) {
            return false;
        }
        if (this.domainCrosshairLockedOnData != xYPlot.domainCrosshairLockedOnData) {
            return false;
        }
        if (this.rangeCrosshairVisible != xYPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != xYPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, xYPlot.axisOffset)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, xYPlot.renderers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxes, xYPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(xYPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxesMap, xYPlot.datasetToDomainAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxesMap, xYPlot.datasetToRangeAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, xYPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, xYPlot.domainGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, xYPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, xYPlot.rangeGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainMinorGridlineStroke, xYPlot.domainMinorGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainMinorGridlinePaint, xYPlot.domainMinorGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeMinorGridlineStroke, xYPlot.rangeMinorGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeMinorGridlinePaint, xYPlot.rangeMinorGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainZeroBaselinePaint, xYPlot.domainZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainZeroBaselineStroke, xYPlot.domainZeroBaselineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeZeroBaselinePaint, xYPlot.rangeZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeZeroBaselineStroke, xYPlot.rangeZeroBaselineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairStroke, xYPlot.domainCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainCrosshairPaint, xYPlot.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, xYPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, xYPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, xYPlot.annotations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, xYPlot.fixedLegendItems)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainTickBandPaint, xYPlot.domainTickBandPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeTickBandPaint, xYPlot.rangeTickBandPaint)) {
            return false;
        }
        if (!this.quadrantOrigin.equals(xYPlot.quadrantOrigin)) {
            return false;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (PaintUtilities.equal(this.quadrantPaint[i2], xYPlot.quadrantPaint[i2])) continue;
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowGenerator, xYPlot.shadowGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        XYPlot xYPlot = (XYPlot)super.clone();
        xYPlot.domainAxes = CloneUtils.cloneMapValues(this.domainAxes);
        for (ValueAxis object : xYPlot.domainAxes.values()) {
            if (object == null) continue;
            object.setPlot(xYPlot);
            object.addChangeListener(xYPlot);
        }
        xYPlot.rangeAxes = CloneUtils.cloneMapValues(this.rangeAxes);
        for (ValueAxis valueAxis : xYPlot.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.setPlot(xYPlot);
            valueAxis.addChangeListener(xYPlot);
        }
        xYPlot.domainAxisLocations = new HashMap<Integer, AxisLocation>(this.domainAxisLocations);
        xYPlot.rangeAxisLocations = new HashMap<Integer, AxisLocation>(this.rangeAxisLocations);
        xYPlot.datasets = new HashMap<Integer, XYDataset>(this.datasets);
        for (XYDataset xYDataset : xYPlot.datasets.values()) {
            if (xYDataset == null) continue;
            xYDataset.addChangeListener(xYPlot);
        }
        xYPlot.datasetToDomainAxesMap = new TreeMap<Integer, List<Integer>>();
        xYPlot.datasetToDomainAxesMap.putAll(this.datasetToDomainAxesMap);
        xYPlot.datasetToRangeAxesMap = new TreeMap<Integer, List<Integer>>();
        xYPlot.datasetToRangeAxesMap.putAll(this.datasetToRangeAxesMap);
        xYPlot.renderers = CloneUtils.cloneMapValues(this.renderers);
        for (XYItemRenderer xYItemRenderer : xYPlot.renderers.values()) {
            if (xYItemRenderer == null) continue;
            xYItemRenderer.setPlot(xYPlot);
            xYItemRenderer.addChangeListener(xYPlot);
        }
        xYPlot.foregroundDomainMarkers = (Map)ObjectUtilities.clone(this.foregroundDomainMarkers);
        xYPlot.backgroundDomainMarkers = (Map)ObjectUtilities.clone(this.backgroundDomainMarkers);
        xYPlot.foregroundRangeMarkers = (Map)ObjectUtilities.clone(this.foregroundRangeMarkers);
        xYPlot.backgroundRangeMarkers = (Map)ObjectUtilities.clone(this.backgroundRangeMarkers);
        xYPlot.annotations = (List)ObjectUtilities.deepClone(this.annotations);
        if (this.fixedDomainAxisSpace != null) {
            xYPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            xYPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        if (this.fixedLegendItems != null) {
            xYPlot.fixedLegendItems = (LegendItemCollection)this.fixedLegendItems.clone();
        }
        xYPlot.quadrantOrigin = (Point2D)ObjectUtilities.clone(this.quadrantOrigin);
        xYPlot.quadrantPaint = (Paint[])this.quadrantPaint.clone();
        return xYPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeZeroBaselinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
        SerialUtilities.writePaint(this.domainTickBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.rangeTickBandPaint, objectOutputStream);
        SerialUtilities.writePoint2D(this.quadrantOrigin, objectOutputStream);
        for (int i2 = 0; i2 < 4; ++i2) {
            SerialUtilities.writePaint(this.quadrantPaint[i2], objectOutputStream);
        }
        SerialUtilities.writeStroke(this.domainZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainZeroBaselinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.domainTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.quadrantOrigin = SerialUtilities.readPoint2D(objectInputStream);
        this.quadrantPaint = new Paint[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.quadrantPaint[i2] = SerialUtilities.readPaint(objectInputStream);
        }
        this.domainZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        for (ValueAxis object : this.domainAxes.values()) {
            if (object == null) continue;
            object.setPlot(this);
            object.addChangeListener(this);
        }
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        for (XYDataset xYDataset : this.datasets.values()) {
            if (xYDataset == null) continue;
            xYDataset.addChangeListener(this);
        }
        for (XYItemRenderer xYItemRenderer : this.renderers.values()) {
            if (xYItemRenderer == null) continue;
            xYItemRenderer.addChangeListener(this);
        }
    }
}

