/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.UnitType;

public class ThermometerPlot
extends Plot
implements Serializable,
Cloneable,
ValueAxisPlot,
Zoomable {
    private static final long serialVersionUID = 4087093313147984390L;
    public static final int UNITS_NONE = 0;
    public static final int UNITS_FAHRENHEIT = 1;
    public static final int UNITS_CELCIUS = 2;
    public static final int UNITS_KELVIN = 3;
    public static final int NONE = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BULB = 3;
    public static final int NORMAL = 0;
    public static final int WARNING = 1;
    public static final int CRITICAL = 2;
    protected static final int BULB_RADIUS = 40;
    protected static final int BULB_DIAMETER = 80;
    protected static final int COLUMN_RADIUS = 20;
    protected static final int COLUMN_DIAMETER = 40;
    protected static final int GAP_RADIUS = 5;
    protected static final int GAP_DIAMETER = 10;
    protected static final int AXIS_GAP = 10;
    protected static final String[] UNITS = new String[]{"", "\u00b0F", "\u00b0C", "\u00b0K"};
    protected static final int RANGE_LOW = 0;
    protected static final int RANGE_HIGH = 1;
    protected static final int DISPLAY_LOW = 2;
    protected static final int DISPLAY_HIGH = 3;
    protected static final double DEFAULT_LOWER_BOUND = 0.0;
    protected static final double DEFAULT_UPPER_BOUND = 100.0;
    protected static final int DEFAULT_BULB_RADIUS = 40;
    protected static final int DEFAULT_COLUMN_RADIUS = 20;
    protected static final int DEFAULT_GAP = 5;
    private ValueDataset dataset;
    private ValueAxis rangeAxis;
    private double lowerBound = 0.0;
    private double upperBound = 100.0;
    private int bulbRadius = 40;
    private int columnRadius = 20;
    private int gap = 5;
    private RectangleInsets padding;
    private transient Stroke thermometerStroke = new BasicStroke(1.0f);
    private transient Paint thermometerPaint = Color.black;
    private int units = 2;
    private int valueLocation = 3;
    private int axisLocation = 2;
    private Font valueFont = new Font("SansSerif", 1, 16);
    private transient Paint valuePaint = Color.white;
    private NumberFormat valueFormat = new DecimalFormat();
    private transient Paint mercuryPaint = Color.lightGray;
    private boolean showValueLines = false;
    private int subrange = -1;
    private double[][] subrangeInfo = new double[][]{{0.0, 50.0, 0.0, 50.0}, {50.0, 75.0, 50.0, 75.0}, {75.0, 100.0, 75.0, 100.0}};
    private boolean followDataInSubranges = false;
    private boolean useSubrangePaint = true;
    private transient Paint[] subrangePaint = new Paint[]{Color.green, Color.orange, Color.red};
    private boolean subrangeIndicatorsVisible = true;
    private transient Stroke subrangeIndicatorStroke = new BasicStroke(2.0f);
    private transient Stroke rangeIndicatorStroke = new BasicStroke(3.0f);
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public ThermometerPlot() {
        this(new DefaultValueDataset());
    }

    public ThermometerPlot(ValueDataset valueDataset) {
        this.padding = new RectangleInsets(UnitType.RELATIVE, 0.05, 0.05, 0.05, 0.05);
        this.dataset = valueDataset;
        if (valueDataset != null) {
            valueDataset.addChangeListener(this);
        }
        NumberAxis numberAxis = new NumberAxis(null);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAxisLineVisible(false);
        numberAxis.setPlot(this);
        numberAxis.addChangeListener(this);
        this.rangeAxis = numberAxis;
        this.setAxisRange();
    }

    public ValueDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        ValueDataset valueDataset2 = this.dataset;
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.dataset = valueDataset;
        if (valueDataset != null) {
            this.setDatasetGroup(valueDataset.getGroup());
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        this.rangeAxis.removeChangeListener(this);
        valueAxis.setPlot(this);
        valueAxis.addChangeListener(this);
        this.rangeAxis = valueAxis;
        this.fireChangeEvent();
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d2) {
        this.lowerBound = d2;
        this.setAxisRange();
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d2) {
        this.upperBound = d2;
        this.setAxisRange();
    }

    public void setRange(double d2, double d3) {
        this.lowerBound = d2;
        this.upperBound = d3;
        this.setAxisRange();
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "padding");
        this.padding = rectangleInsets;
        this.fireChangeEvent();
    }

    public Stroke getThermometerStroke() {
        return this.thermometerStroke;
    }

    public void setThermometerStroke(Stroke stroke) {
        if (stroke != null) {
            this.thermometerStroke = stroke;
            this.fireChangeEvent();
        }
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        if (paint != null) {
            this.thermometerPaint = paint;
            this.fireChangeEvent();
        }
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int n2) {
        if (n2 >= 0 && n2 < UNITS.length && this.units != n2) {
            this.units = n2;
            this.fireChangeEvent();
        }
    }

    public void setUnits(String string) {
        if (string == null) {
            return;
        }
        string = string.toUpperCase().trim();
        for (int i2 = 0; i2 < UNITS.length; ++i2) {
            if (!string.equals(UNITS[i2].toUpperCase().trim())) continue;
            this.setUnits(i2);
            i2 = UNITS.length;
        }
    }

    public int getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("Location not recognised.");
        }
        this.valueLocation = n2;
        this.fireChangeEvent();
    }

    public int getAxisLocation() {
        return this.axisLocation;
    }

    public void setAxisLocation(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("Location not recognised.");
        }
        this.axisLocation = n2;
        this.fireChangeEvent();
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        ParamChecks.nullNotPermitted(font, "f");
        if (!this.valueFont.equals(font)) {
            this.valueFont = font;
            this.fireChangeEvent();
        }
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        if (!this.valuePaint.equals(paint)) {
            this.valuePaint = paint;
            this.fireChangeEvent();
        }
    }

    public void setValueFormat(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.valueFormat = numberFormat;
        this.fireChangeEvent();
    }

    public Paint getMercuryPaint() {
        return this.mercuryPaint;
    }

    public void setMercuryPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.mercuryPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getShowValueLines() {
        return this.showValueLines;
    }

    public void setShowValueLines(boolean bl2) {
        this.showValueLines = bl2;
        this.fireChangeEvent();
    }

    public void setSubrangeInfo(int n2, double d2, double d3) {
        this.setSubrangeInfo(n2, d2, d3, d2, d3);
    }

    public void setSubrangeInfo(int n2, double d2, double d3, double d4, double d5) {
        if (n2 >= 0 && n2 < 3) {
            this.setSubrange(n2, d2, d3);
            this.setDisplayRange(n2, d4, d5);
            this.setAxisRange();
            this.fireChangeEvent();
        }
    }

    public void setSubrange(int n2, double d2, double d3) {
        if (n2 >= 0 && n2 < 3) {
            this.subrangeInfo[n2][1] = d3;
            this.subrangeInfo[n2][0] = d2;
        }
    }

    public void setDisplayRange(int n2, double d2, double d3) {
        if (n2 >= 0 && n2 < this.subrangeInfo.length && ThermometerPlot.isValidNumber(d3) && ThermometerPlot.isValidNumber(d2)) {
            if (d3 > d2) {
                this.subrangeInfo[n2][3] = d3;
                this.subrangeInfo[n2][2] = d2;
            } else {
                this.subrangeInfo[n2][3] = d2;
                this.subrangeInfo[n2][2] = d3;
            }
        }
    }

    public Paint getSubrangePaint(int n2) {
        if (n2 >= 0 && n2 < this.subrangePaint.length) {
            return this.subrangePaint[n2];
        }
        return this.mercuryPaint;
    }

    public void setSubrangePaint(int n2, Paint paint) {
        if (n2 >= 0 && n2 < this.subrangePaint.length && paint != null) {
            this.subrangePaint[n2] = paint;
            this.fireChangeEvent();
        }
    }

    public boolean getFollowDataInSubranges() {
        return this.followDataInSubranges;
    }

    public void setFollowDataInSubranges(boolean bl2) {
        this.followDataInSubranges = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseSubrangePaint() {
        return this.useSubrangePaint;
    }

    public void setUseSubrangePaint(boolean bl2) {
        this.useSubrangePaint = bl2;
        this.fireChangeEvent();
    }

    public int getBulbRadius() {
        return this.bulbRadius;
    }

    public void setBulbRadius(int n2) {
        this.bulbRadius = n2;
        this.fireChangeEvent();
    }

    public int getBulbDiameter() {
        return this.getBulbRadius() * 2;
    }

    public int getColumnRadius() {
        return this.columnRadius;
    }

    public void setColumnRadius(int n2) {
        this.columnRadius = n2;
        this.fireChangeEvent();
    }

    public int getColumnDiameter() {
        return this.getColumnRadius() * 2;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n2) {
        this.gap = n2;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        FontMetrics fontMetrics;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double();
        Ellipse2D.Double double_4 = new Ellipse2D.Double();
        Ellipse2D.Double double_5 = new Ellipse2D.Double();
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawBackground(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        this.padding.trim(rectangle2D2);
        int n2 = (int)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
        int n3 = (int)(rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
        int n4 = (int)(rectangle2D2.getMinY() + (double)this.getBulbRadius());
        int n5 = (int)(rectangle2D2.getMaxY() - (double)this.getBulbDiameter());
        Rectangle2D.Double double_6 = new Rectangle2D.Double(n2 - this.getColumnRadius(), n4, this.getColumnRadius(), n5 - n4);
        ((RectangularShape)double_4).setFrame(n2 - this.getBulbRadius(), n5, this.getBulbDiameter(), this.getBulbDiameter());
        ((RoundRectangle2D)double_).setRoundRect(n2 - this.getColumnRadius(), rectangle2D2.getMinY(), this.getColumnDiameter(), n5 + this.getBulbDiameter() - n4, this.getColumnDiameter(), this.getColumnDiameter());
        Area area = new Area(double_4);
        Area area2 = new Area(double_);
        area.add(area2);
        ((RectangularShape)double_5).setFrame(n2 - this.getBulbRadius() + this.getGap(), n5 + this.getGap(), this.getBulbDiameter() - this.getGap() * 2, this.getBulbDiameter() - this.getGap() * 2);
        ((RoundRectangle2D)double_2).setRoundRect(n2 - this.getColumnRadius() + this.getGap(), rectangle2D2.getMinY() + (double)this.getGap(), this.getColumnDiameter() - this.getGap() * 2, n5 + this.getBulbDiameter() - this.getGap() * 2 - n4, this.getColumnDiameter() - this.getGap() * 2, this.getColumnDiameter() - this.getGap() * 2);
        Area area3 = new Area(double_5);
        area2 = new Area(double_2);
        area3.add(area2);
        if (this.dataset != null && this.dataset.getValue() != null) {
            Object object;
            double d2 = this.dataset.getValue().doubleValue();
            double d3 = this.rangeAxis.valueToJava2D(d2, double_6, RectangleEdge.LEFT);
            int n6 = this.getColumnDiameter() - this.getGap() * 2;
            int n7 = this.getColumnRadius() - this.getGap();
            int n8 = n6 / 2;
            int n9 = (int)Math.round(d3);
            if ((double)n9 < (double)this.getGap() + rectangle2D2.getMinY()) {
                n9 = (int)((double)this.getGap() + rectangle2D2.getMinY());
                n8 = this.getBulbRadius();
            }
            Area area4 = new Area(double_5);
            if (n9 < n5 + this.getBulbRadius()) {
                ((RoundRectangle2D)double_3).setRoundRect(n2 - n7, n9, n6, n5 + this.getBulbRadius() - n9, n8, n8);
                area2 = new Area(double_3);
                area4.add(area2);
            }
            graphics2D.setPaint(this.getCurrentPaint());
            graphics2D.fill(area4);
            if (this.subrangeIndicatorsVisible) {
                Line2D.Double double_7;
                double d4;
                double d5;
                graphics2D.setStroke(this.subrangeIndicatorStroke);
                object = this.rangeAxis.getRange();
                double d6 = this.subrangeInfo[0][0];
                if (((Range)object).contains(d6)) {
                    d5 = n2 + this.getColumnRadius() + 2;
                    d4 = this.rangeAxis.valueToJava2D(d6, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d5, d4, d5 + 10.0, d4);
                    graphics2D.setPaint(this.subrangePaint[0]);
                    graphics2D.draw(double_7);
                }
                if (((Range)object).contains(d6 = this.subrangeInfo[1][0])) {
                    d5 = n2 + this.getColumnRadius() + 2;
                    d4 = this.rangeAxis.valueToJava2D(d6, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d5, d4, d5 + 10.0, d4);
                    graphics2D.setPaint(this.subrangePaint[1]);
                    graphics2D.draw(double_7);
                }
                if (((Range)object).contains(d6 = this.subrangeInfo[2][0])) {
                    d5 = n2 + this.getColumnRadius() + 2;
                    d4 = this.rangeAxis.valueToJava2D(d6, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d5, d4, d5 + 10.0, d4);
                    graphics2D.setPaint(this.subrangePaint[2]);
                    graphics2D.draw(double_7);
                }
            }
            if (this.rangeAxis != null && this.axisLocation != 0) {
                int n10 = 10;
                if (this.showValueLines) {
                    n10 += this.getColumnDiameter();
                }
                switch (this.axisLocation) {
                    case 1: {
                        double d7 = n2 + this.getColumnRadius();
                        Rectangle2D.Double double_8 = new Rectangle2D.Double(d7, n4, n10, n5 - n4 + 1);
                        this.rangeAxis.draw(graphics2D, d7, rectangle2D, double_8, RectangleEdge.RIGHT, null);
                        break;
                    }
                    default: {
                        double d8 = n2 - this.getColumnRadius();
                        Rectangle2D.Double double_9 = new Rectangle2D.Double(d8, n4, n10, n5 - n4 + 1);
                        this.rangeAxis.draw(graphics2D, d8, rectangle2D, double_9, RectangleEdge.LEFT, null);
                    }
                }
            }
            graphics2D.setFont(this.valueFont);
            graphics2D.setPaint(this.valuePaint);
            fontMetrics = graphics2D.getFontMetrics();
            switch (this.valueLocation) {
                case 1: {
                    graphics2D.drawString(this.valueFormat.format(d2), n2 + this.getColumnRadius() + this.getGap(), n3);
                    break;
                }
                case 2: {
                    object = this.valueFormat.format(d2);
                    int n11 = fontMetrics.stringWidth((String)object);
                    graphics2D.drawString((String)object, n2 - this.getColumnRadius() - this.getGap() - n11, n3);
                    break;
                }
                case 3: {
                    String string = this.valueFormat.format(d2);
                    n6 = fontMetrics.stringWidth(string) / 2;
                    graphics2D.drawString(string, n2 - n6, n5 + this.getBulbRadius() + this.getGap());
                    break;
                }
            }
        }
        graphics2D.setPaint(this.thermometerPaint);
        graphics2D.setFont(this.valueFont);
        fontMetrics = graphics2D.getFontMetrics();
        int n12 = n2 - this.getColumnRadius() - this.getGap() * 2 - fontMetrics.stringWidth(UNITS[this.units]);
        if ((double)n12 > rectangle2D.getMinX()) {
            graphics2D.drawString(UNITS[this.units], n12, (int)(rectangle2D.getMinY() + 20.0));
        }
        graphics2D.setStroke(this.thermometerStroke);
        graphics2D.draw(area);
        graphics2D.draw(area3);
        this.drawOutline(graphics2D, rectangle2D);
    }

    @Override
    public void zoom(double d2) {
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Thermometer_Plot");
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        Number number;
        if (this.dataset != null && (number = this.dataset.getValue()) != null) {
            double d2 = number.doubleValue();
            this.subrange = this.inSubrange(0, d2) ? 0 : (this.inSubrange(1, d2) ? 1 : (this.inSubrange(2, d2) ? 2 : -1));
            this.setAxisRange();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(this.lowerBound);
    }

    public Number getMaximumVerticalDataValue() {
        return new Double(this.upperBound);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        return new Range(this.lowerBound, this.upperBound);
    }

    protected void setAxisRange() {
        if (this.subrange >= 0 && this.followDataInSubranges) {
            this.rangeAxis.setRange(new Range(this.subrangeInfo[this.subrange][2], this.subrangeInfo[this.subrange][3]));
        } else {
            this.rangeAxis.setRange(this.lowerBound, this.upperBound);
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        return null;
    }

    @Override
    public PlotOrientation getOrientation() {
        return PlotOrientation.VERTICAL;
    }

    protected static boolean isValidNumber(double d2) {
        return !Double.isNaN(d2) && !Double.isInfinite(d2);
    }

    private boolean inSubrange(int n2, double d2) {
        return d2 > this.subrangeInfo[n2][0] && d2 <= this.subrangeInfo[n2][1];
    }

    private Paint getCurrentPaint() {
        Paint paint = this.mercuryPaint;
        if (this.useSubrangePaint) {
            double d2 = this.dataset.getValue().doubleValue();
            if (this.inSubrange(0, d2)) {
                paint = this.subrangePaint[0];
            } else if (this.inSubrange(1, d2)) {
                paint = this.subrangePaint[1];
            } else if (this.inSubrange(2, d2)) {
                paint = this.subrangePaint[2];
            }
        }
        return paint;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ThermometerPlot)) {
            return false;
        }
        ThermometerPlot thermometerPlot = (ThermometerPlot)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxis, thermometerPlot.rangeAxis)) {
            return false;
        }
        if (this.axisLocation != thermometerPlot.axisLocation) {
            return false;
        }
        if (this.lowerBound != thermometerPlot.lowerBound) {
            return false;
        }
        if (this.upperBound != thermometerPlot.upperBound) {
            return false;
        }
        if (!ObjectUtilities.equal(this.padding, thermometerPlot.padding)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.thermometerStroke, thermometerPlot.thermometerStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.thermometerPaint, thermometerPlot.thermometerPaint)) {
            return false;
        }
        if (this.units != thermometerPlot.units) {
            return false;
        }
        if (this.valueLocation != thermometerPlot.valueLocation) {
            return false;
        }
        if (!ObjectUtilities.equal(this.valueFont, thermometerPlot.valueFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.valuePaint, thermometerPlot.valuePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.valueFormat, thermometerPlot.valueFormat)) {
            return false;
        }
        if (!PaintUtilities.equal(this.mercuryPaint, thermometerPlot.mercuryPaint)) {
            return false;
        }
        if (this.showValueLines != thermometerPlot.showValueLines) {
            return false;
        }
        if (this.subrange != thermometerPlot.subrange) {
            return false;
        }
        if (this.followDataInSubranges != thermometerPlot.followDataInSubranges) {
            return false;
        }
        if (!ThermometerPlot.equal(this.subrangeInfo, thermometerPlot.subrangeInfo)) {
            return false;
        }
        if (this.useSubrangePaint != thermometerPlot.useSubrangePaint) {
            return false;
        }
        if (this.bulbRadius != thermometerPlot.bulbRadius) {
            return false;
        }
        if (this.columnRadius != thermometerPlot.columnRadius) {
            return false;
        }
        if (this.gap != thermometerPlot.gap) {
            return false;
        }
        for (int i2 = 0; i2 < this.subrangePaint.length; ++i2) {
            if (PaintUtilities.equal(this.subrangePaint[i2], thermometerPlot.subrangePaint[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Arrays.equals(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        ThermometerPlot thermometerPlot = (ThermometerPlot)super.clone();
        if (thermometerPlot.dataset != null) {
            thermometerPlot.dataset.addChangeListener(thermometerPlot);
        }
        thermometerPlot.rangeAxis = (ValueAxis)ObjectUtilities.clone(this.rangeAxis);
        if (thermometerPlot.rangeAxis != null) {
            thermometerPlot.rangeAxis.setPlot(thermometerPlot);
            thermometerPlot.rangeAxis.addChangeListener(thermometerPlot);
        }
        thermometerPlot.valueFormat = (NumberFormat)this.valueFormat.clone();
        thermometerPlot.subrangePaint = (Paint[])this.subrangePaint.clone();
        return thermometerPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.thermometerStroke, objectOutputStream);
        SerialUtilities.writePaint(this.thermometerPaint, objectOutputStream);
        SerialUtilities.writePaint(this.valuePaint, objectOutputStream);
        SerialUtilities.writePaint(this.mercuryPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.subrangeIndicatorStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeIndicatorStroke, objectOutputStream);
        for (int i2 = 0; i2 < 3; ++i2) {
            SerialUtilities.writePaint(this.subrangePaint[i2], objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.thermometerStroke = SerialUtilities.readStroke(objectInputStream);
        this.thermometerPaint = SerialUtilities.readPaint(objectInputStream);
        this.valuePaint = SerialUtilities.readPaint(objectInputStream);
        this.mercuryPaint = SerialUtilities.readPaint(objectInputStream);
        this.subrangeIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
        this.subrangePaint = new Paint[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            this.subrangePaint[i2] = SerialUtilities.readPaint(objectInputStream);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.resizeRange(d2);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        double d3 = this.getRangeAxis().java2DToValue(point2D.getY(), plotRenderingInfo.getDataArea(), RectangleEdge.LEFT);
        this.rangeAxis.resizeRange(d2, d3);
    }

    @Override
    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.zoomRange(d2, d3);
    }

    @Override
    public boolean isDomainZoomable() {
        return false;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }
}

