/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.PolarAxisLocation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class PolarPlot
extends Plot
implements Serializable,
Cloneable,
RendererChangeListener,
ValueAxisPlot,
Zoomable {
    private static final long serialVersionUID = 3794383185924179525L;
    private static final int DEFAULT_MARGIN = 20;
    private static final double ANNOTATION_MARGIN = 7.0;
    public static final double DEFAULT_ANGLE_TICK_UNIT_SIZE = 45.0;
    public static final double DEFAULT_ANGLE_OFFSET = -90.0;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.gray;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private List angleTicks;
    private ObjectList axes;
    private ObjectList axisLocations;
    private ObjectList datasets;
    private ObjectList renderers;
    private TickUnit angleTickUnit;
    private double angleOffset;
    private boolean counterClockwise;
    private boolean angleLabelsVisible = true;
    private Font angleLabelFont = new Font("SansSerif", 0, 12);
    private transient Paint angleLabelPaint = Color.black;
    private boolean angleGridlinesVisible;
    private transient Stroke angleGridlineStroke;
    private transient Paint angleGridlinePaint;
    private boolean radiusGridlinesVisible;
    private transient Stroke radiusGridlineStroke;
    private transient Paint radiusGridlinePaint;
    private boolean radiusMinorGridlinesVisible;
    private List cornerTextItems = new ArrayList();
    private int margin;
    private LegendItemCollection fixedLegendItems;
    private Map datasetToAxesMap;

    public PolarPlot() {
        this(null, null, null);
    }

    public PolarPlot(XYDataset xYDataset, ValueAxis valueAxis, PolarItemRenderer polarItemRenderer) {
        this.datasets = new ObjectList();
        this.datasets.set(0, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.angleTickUnit = new NumberTickUnit(45.0);
        this.axes = new ObjectList();
        this.datasetToAxesMap = new TreeMap();
        this.axes.set(0, valueAxis);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.axisLocations = new ObjectList();
        this.axisLocations.set(0, PolarAxisLocation.EAST_ABOVE);
        this.axisLocations.set(1, PolarAxisLocation.NORTH_LEFT);
        this.axisLocations.set(2, PolarAxisLocation.WEST_BELOW);
        this.axisLocations.set(3, PolarAxisLocation.SOUTH_RIGHT);
        this.axisLocations.set(4, PolarAxisLocation.EAST_BELOW);
        this.axisLocations.set(5, PolarAxisLocation.NORTH_RIGHT);
        this.axisLocations.set(6, PolarAxisLocation.WEST_ABOVE);
        this.axisLocations.set(7, PolarAxisLocation.SOUTH_LEFT);
        this.renderers = new ObjectList();
        this.renderers.set(0, polarItemRenderer);
        if (polarItemRenderer != null) {
            polarItemRenderer.setPlot(this);
            polarItemRenderer.addChangeListener(this);
        }
        this.angleOffset = -90.0;
        this.counterClockwise = false;
        this.angleGridlinesVisible = true;
        this.angleGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.angleGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.radiusGridlinesVisible = true;
        this.radiusMinorGridlinesVisible = true;
        this.radiusGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.radiusGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.margin = 20;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Polar_Plot");
    }

    public ValueAxis getAxis() {
        return this.getAxis(0);
    }

    public ValueAxis getAxis(int n2) {
        ValueAxis valueAxis = null;
        if (n2 < this.axes.size()) {
            valueAxis = (ValueAxis)this.axes.get(n2);
        }
        return valueAxis;
    }

    public void setAxis(ValueAxis valueAxis) {
        this.setAxis(0, valueAxis);
    }

    public void setAxis(int n2, ValueAxis valueAxis) {
        this.setAxis(n2, valueAxis, true);
    }

    public void setAxis(int n2, ValueAxis valueAxis, boolean bl2) {
        ValueAxis valueAxis2 = this.getAxis(n2);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.axes.set(n2, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public PolarAxisLocation getAxisLocation() {
        return this.getAxisLocation(0);
    }

    public PolarAxisLocation getAxisLocation(int n2) {
        PolarAxisLocation polarAxisLocation = null;
        if (n2 < this.axisLocations.size()) {
            polarAxisLocation = (PolarAxisLocation)this.axisLocations.get(n2);
        }
        return polarAxisLocation;
    }

    public void setAxisLocation(PolarAxisLocation polarAxisLocation) {
        this.setAxisLocation(0, polarAxisLocation, true);
    }

    public void setAxisLocation(PolarAxisLocation polarAxisLocation, boolean bl2) {
        this.setAxisLocation(0, polarAxisLocation, bl2);
    }

    public void setAxisLocation(int n2, PolarAxisLocation polarAxisLocation) {
        this.setAxisLocation(n2, polarAxisLocation, true);
    }

    public void setAxisLocation(int n2, PolarAxisLocation polarAxisLocation, boolean bl2) {
        ParamChecks.nullNotPermitted(polarAxisLocation, "location");
        this.axisLocations.set(n2, polarAxisLocation);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int n2) {
        XYDataset xYDataset = null;
        if (n2 < this.datasets.size()) {
            xYDataset = (XYDataset)this.datasets.get(n2);
        }
        return xYDataset;
    }

    public void setDataset(XYDataset xYDataset) {
        this.setDataset(0, xYDataset);
    }

    public void setDataset(int n2, XYDataset xYDataset) {
        XYDataset xYDataset2 = this.getDataset(n2);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.datasets.set(n2, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset xYDataset) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.datasets.size(); ++i2) {
            if (xYDataset != this.datasets.get(i2)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public PolarItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public PolarItemRenderer getRenderer(int n2) {
        PolarItemRenderer polarItemRenderer = null;
        if (n2 < this.renderers.size()) {
            polarItemRenderer = (PolarItemRenderer)this.renderers.get(n2);
        }
        return polarItemRenderer;
    }

    public void setRenderer(PolarItemRenderer polarItemRenderer) {
        this.setRenderer(0, polarItemRenderer);
    }

    public void setRenderer(int n2, PolarItemRenderer polarItemRenderer) {
        this.setRenderer(n2, polarItemRenderer, true);
    }

    public void setRenderer(int n2, PolarItemRenderer polarItemRenderer, boolean bl2) {
        PolarItemRenderer polarItemRenderer2 = this.getRenderer(n2);
        if (polarItemRenderer2 != null) {
            polarItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n2, polarItemRenderer);
        if (polarItemRenderer != null) {
            polarItemRenderer.setPlot(this);
            polarItemRenderer.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public TickUnit getAngleTickUnit() {
        return this.angleTickUnit;
    }

    public void setAngleTickUnit(TickUnit tickUnit) {
        ParamChecks.nullNotPermitted(tickUnit, "unit");
        this.angleTickUnit = tickUnit;
        this.fireChangeEvent();
    }

    public double getAngleOffset() {
        return this.angleOffset;
    }

    public void setAngleOffset(double d2) {
        this.angleOffset = d2;
        this.fireChangeEvent();
    }

    public boolean isCounterClockwise() {
        return this.counterClockwise;
    }

    public void setCounterClockwise(boolean bl2) {
        this.counterClockwise = bl2;
    }

    public boolean isAngleLabelsVisible() {
        return this.angleLabelsVisible;
    }

    public void setAngleLabelsVisible(boolean bl2) {
        if (this.angleLabelsVisible != bl2) {
            this.angleLabelsVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Font getAngleLabelFont() {
        return this.angleLabelFont;
    }

    public void setAngleLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.angleLabelFont = font;
        this.fireChangeEvent();
    }

    public Paint getAngleLabelPaint() {
        return this.angleLabelPaint;
    }

    public void setAngleLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.angleLabelPaint = paint;
        this.fireChangeEvent();
    }

    public boolean isAngleGridlinesVisible() {
        return this.angleGridlinesVisible;
    }

    public void setAngleGridlinesVisible(boolean bl2) {
        if (this.angleGridlinesVisible != bl2) {
            this.angleGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getAngleGridlineStroke() {
        return this.angleGridlineStroke;
    }

    public void setAngleGridlineStroke(Stroke stroke) {
        this.angleGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getAngleGridlinePaint() {
        return this.angleGridlinePaint;
    }

    public void setAngleGridlinePaint(Paint paint) {
        this.angleGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRadiusGridlinesVisible() {
        return this.radiusGridlinesVisible;
    }

    public void setRadiusGridlinesVisible(boolean bl2) {
        if (this.radiusGridlinesVisible != bl2) {
            this.radiusGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRadiusGridlineStroke() {
        return this.radiusGridlineStroke;
    }

    public void setRadiusGridlineStroke(Stroke stroke) {
        this.radiusGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRadiusGridlinePaint() {
        return this.radiusGridlinePaint;
    }

    public void setRadiusGridlinePaint(Paint paint) {
        this.radiusGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRadiusMinorGridlinesVisible() {
        return this.radiusMinorGridlinesVisible;
    }

    public void setRadiusMinorGridlinesVisible(boolean bl2) {
        this.radiusMinorGridlinesVisible = bl2;
        this.fireChangeEvent();
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n2) {
        this.margin = n2;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    public void addCornerTextItem(String string) {
        ParamChecks.nullNotPermitted(string, "text");
        this.cornerTextItems.add(string);
        this.fireChangeEvent();
    }

    public void removeCornerTextItem(String string) {
        boolean bl2 = this.cornerTextItems.remove(string);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearCornerTextItems() {
        if (this.cornerTextItems.size() > 0) {
            this.cornerTextItems.clear();
            this.fireChangeEvent();
        }
    }

    protected List refreshAngleTicks() {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        for (double d2 = 0.0; d2 < 360.0; d2 += this.angleTickUnit.getSize()) {
            TextAnchor textAnchor = this.calculateTextAnchor(d2);
            NumberTick numberTick = new NumberTick(new Double(d2), this.angleTickUnit.valueToString(d2), textAnchor, TextAnchor.CENTER, 0.0);
            arrayList.add(numberTick);
        }
        return arrayList;
    }

    protected TextAnchor calculateTextAnchor(double d2) {
        double d3;
        TextAnchor textAnchor = TextAnchor.CENTER;
        for (double d4 = this.angleOffset; d4 < 0.0; d4 += 360.0) {
        }
        for (d3 = ((double)(this.counterClockwise ? -1 : 1) * d2 + d4) % 360.0; this.counterClockwise && d3 < 0.0; d3 += 360.0) {
        }
        if (d3 == 0.0) {
            textAnchor = TextAnchor.CENTER_LEFT;
        } else if (d3 > 0.0 && d3 < 90.0) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (d3 == 90.0) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (d3 > 90.0 && d3 < 180.0) {
            textAnchor = TextAnchor.TOP_RIGHT;
        } else if (d3 == 180.0) {
            textAnchor = TextAnchor.CENTER_RIGHT;
        } else if (d3 > 180.0 && d3 < 270.0) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (d3 == 270.0) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (d3 > 270.0 && d3 < 360.0) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        }
        return textAnchor;
    }

    public void mapDatasetToAxis(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n3));
        this.mapDatasetToAxes(n2, arrayList);
    }

    public void mapDatasetToAxes(int n2, List list) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n3 = new Integer(n2);
        this.datasetToAxesMap.put(n3, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n2)));
    }

    private void checkAxisIndices(List list) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = list.get(i2);
            if (!(e2 instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (hashSet.contains(e2)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(e2);
        }
    }

    public ValueAxis getAxisForDataset(int n2) {
        ValueAxis valueAxis;
        List list = (List)this.datasetToAxesMap.get(new Integer(n2));
        if (list != null) {
            Integer n3 = (Integer)list.get(0);
            valueAxis = this.getAxis(n3);
        } else {
            valueAxis = this.getAxis(0);
        }
        return valueAxis;
    }

    public int getAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n2 = this.axes.indexOf(valueAxis);
        if (n2 < 0 && (plot = this.getParent()) instanceof PolarPlot) {
            PolarPlot polarPlot = (PolarPlot)plot;
            n2 = polarPlot.getAxisIndex(valueAxis);
        }
        return n2;
    }

    public int getIndexOf(PolarItemRenderer polarItemRenderer) {
        return this.renderers.indexOf(polarItemRenderer);
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        boolean bl2;
        boolean bl3 = rectangle2D.getWidth() <= 10.0;
        boolean bl4 = bl2 = rectangle2D.getHeight() <= 10.0;
        if (bl3 || bl2) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = rectangle2D;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        int n2 = this.axes.size();
        AxisState axisState = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.getAxis(i2);
            if (object == null) continue;
            PolarAxisLocation polarAxisLocation = (PolarAxisLocation)this.axisLocations.get(i2);
            AxisState axisState2 = this.drawAxis((ValueAxis)object, polarAxisLocation, graphics2D, rectangle2D2);
            if (i2 != 0) continue;
            axisState = axisState2;
        }
        Shape shape = graphics2D.getClip();
        object = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.angleTicks = this.refreshAngleTicks();
        this.drawGridlines(graphics2D, rectangle2D2, this.angleTicks, axisState.getTicks());
        this.render(graphics2D, rectangle2D2, plotRenderingInfo);
        graphics2D.setClip(shape);
        graphics2D.setComposite((Composite)object);
        this.drawOutline(graphics2D, rectangle2D2);
        this.drawCornerTextItems(graphics2D, rectangle2D2);
    }

    protected void drawCornerTextItems(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.cornerTextItems.isEmpty()) {
            return;
        }
        graphics2D.setColor(Color.black);
        double d2 = 0.0;
        double d3 = 0.0;
        for (String string : this.cornerTextItems) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            d2 = Math.max(d2, rectangle2D2.getWidth());
            d3 += rectangle2D2.getHeight();
        }
        double d4 = 14.0;
        double d5 = 7.0;
        double d6 = rectangle2D.getMaxX() - (d2 += d4);
        double d7 = rectangle2D.getMaxY() - (d3 += d5);
        graphics2D.drawRect((int)d6, (int)d7, (int)d2, (int)d3);
        d6 += 7.0;
        for (String string : this.cornerTextItems) {
            Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
            graphics2D.drawString(string, (int)d6, (int)(d7 += rectangle2D3.getHeight()));
        }
    }

    protected AxisState drawAxis(ValueAxis valueAxis, PolarAxisLocation polarAxisLocation, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getCenterX();
        double d3 = rectangle2D.getCenterY();
        double d4 = Math.min(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0) - (double)this.margin;
        double d5 = d2 - d4;
        double d6 = d3 - d4;
        Rectangle2D.Double double_ = null;
        AxisState axisState = null;
        if (polarAxisLocation == PolarAxisLocation.NORTH_RIGHT) {
            double_ = new Rectangle2D.Double(d5, d6, d4, d4);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.RIGHT, null);
        } else if (polarAxisLocation == PolarAxisLocation.NORTH_LEFT) {
            double_ = new Rectangle2D.Double(d2, d6, d4, d4);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.LEFT, null);
        } else if (polarAxisLocation == PolarAxisLocation.SOUTH_LEFT) {
            double_ = new Rectangle2D.Double(d2, d3, d4, d4);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.LEFT, null);
        } else if (polarAxisLocation == PolarAxisLocation.SOUTH_RIGHT) {
            double_ = new Rectangle2D.Double(d5, d3, d4, d4);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.RIGHT, null);
        } else if (polarAxisLocation == PolarAxisLocation.EAST_ABOVE) {
            double_ = new Rectangle2D.Double(d2, d3, d4, d4);
            axisState = valueAxis.draw(graphics2D, d3, rectangle2D, double_, RectangleEdge.TOP, null);
        } else if (polarAxisLocation == PolarAxisLocation.EAST_BELOW) {
            double_ = new Rectangle2D.Double(d2, d6, d4, d4);
            axisState = valueAxis.draw(graphics2D, d3, rectangle2D, double_, RectangleEdge.BOTTOM, null);
        } else if (polarAxisLocation == PolarAxisLocation.WEST_ABOVE) {
            double_ = new Rectangle2D.Double(d5, d3, d4, d4);
            axisState = valueAxis.draw(graphics2D, d3, rectangle2D, double_, RectangleEdge.TOP, null);
        } else if (polarAxisLocation == PolarAxisLocation.WEST_BELOW) {
            double_ = new Rectangle2D.Double(d5, d6, d4, d4);
            axisState = valueAxis.draw(graphics2D, d3, rectangle2D, double_, RectangleEdge.BOTTOM, null);
        }
        return axisState;
    }

    protected void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        boolean bl2 = false;
        int n2 = this.datasets.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            PolarItemRenderer polarItemRenderer;
            XYDataset xYDataset = this.getDataset(i2);
            if (xYDataset == null || (polarItemRenderer = this.getRenderer(i2)) == null || DatasetUtilities.isEmptyOrNull(xYDataset)) continue;
            bl2 = true;
            int n3 = xYDataset.getSeriesCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                polarItemRenderer.drawSeries(graphics2D, rectangle2D, plotRenderingInfo, this, xYDataset, i3);
            }
        }
        if (!bl2) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list, List list2) {
        Paint paint;
        Stroke stroke;
        PolarItemRenderer polarItemRenderer = this.getRenderer();
        if (polarItemRenderer == null) {
            return;
        }
        if (this.isAngleGridlinesVisible()) {
            stroke = this.getAngleGridlineStroke();
            paint = this.getAngleGridlinePaint();
            if (stroke != null && paint != null) {
                polarItemRenderer.drawAngularGridLines(graphics2D, this, list, rectangle2D);
            }
        }
        if (this.isRadiusGridlinesVisible()) {
            stroke = this.getRadiusGridlineStroke();
            paint = this.getRadiusGridlinePaint();
            if (stroke != null && paint != null) {
                List list3 = this.buildRadialTicks(list2);
                polarItemRenderer.drawRadialGridLines(graphics2D, this, this.getAxis(), list3, rectangle2D);
            }
        }
    }

    protected List buildRadialTicks(List list) {
        ArrayList<ValueTick> arrayList = new ArrayList<ValueTick>();
        for (ValueTick valueTick : list) {
            if (!this.isRadiusMinorGridlinesVisible() && !TickType.MAJOR.equals(valueTick.getTickType())) continue;
            arrayList.add(valueTick);
        }
        return arrayList;
    }

    @Override
    public void zoom(double d2) {
        for (int i2 = 0; i2 < this.getAxisCount(); ++i2) {
            ValueAxis valueAxis = this.getAxis(i2);
            if (valueAxis == null) continue;
            if (d2 > 0.0) {
                double d3 = valueAxis.getUpperBound();
                double d4 = d3 * d2;
                valueAxis.setUpperBound(d4);
                valueAxis.setAutoRange(false);
                continue;
            }
            valueAxis.setAutoRange(true);
        }
    }

    private List getDatasetsMappedToAxis(Integer n2) {
        ParamChecks.nullNotPermitted(n2, "axisIndex");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.datasets.size(); ++i2) {
            List list = (List)this.datasetToAxesMap.get(new Integer(i2));
            if (list == null) {
                if (!n2.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(i2));
                continue;
            }
            if (!list.contains(n2)) continue;
            arrayList.add(this.datasets.get(i2));
        }
        return arrayList;
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        int n2 = this.getAxisIndex(valueAxis);
        List list = new ArrayList();
        if (n2 >= 0) {
            list = this.getDatasetsMappedToAxis(new Integer(n2));
        }
        Iterator iterator = list.iterator();
        int n3 = -1;
        while (iterator.hasNext()) {
            ++n3;
            XYDataset xYDataset = (XYDataset)iterator.next();
            if (xYDataset == null) continue;
            range = Range.combine(range, DatasetUtilities.findRangeBounds(xYDataset));
        }
        return range;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        for (int i2 = 0; i2 < this.axes.size(); ++i2) {
            ValueAxis valueAxis = (ValueAxis)this.axes.get(i2);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            super.datasetChanged(datasetChangeEvent);
        }
    }

    @Override
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        this.fireChangeEvent();
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n2 = this.datasets.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYDataset xYDataset = this.getDataset(i2);
            PolarItemRenderer polarItemRenderer = this.getRenderer(i2);
            if (xYDataset == null || polarItemRenderer == null) continue;
            int n3 = xYDataset.getSeriesCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                LegendItem legendItem = polarItemRenderer.getLegendItem(i3);
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PolarPlot)) {
            return false;
        }
        PolarPlot polarPlot = (PolarPlot)object;
        if (!this.axes.equals(polarPlot.axes)) {
            return false;
        }
        if (!this.axisLocations.equals(polarPlot.axisLocations)) {
            return false;
        }
        if (!this.renderers.equals(polarPlot.renderers)) {
            return false;
        }
        if (!this.angleTickUnit.equals(polarPlot.angleTickUnit)) {
            return false;
        }
        if (this.angleGridlinesVisible != polarPlot.angleGridlinesVisible) {
            return false;
        }
        if (this.angleOffset != polarPlot.angleOffset) {
            return false;
        }
        if (this.counterClockwise != polarPlot.counterClockwise) {
            return false;
        }
        if (this.angleLabelsVisible != polarPlot.angleLabelsVisible) {
            return false;
        }
        if (!this.angleLabelFont.equals(polarPlot.angleLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.angleLabelPaint, polarPlot.angleLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.angleGridlineStroke, polarPlot.angleGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.angleGridlinePaint, polarPlot.angleGridlinePaint)) {
            return false;
        }
        if (this.radiusGridlinesVisible != polarPlot.radiusGridlinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.radiusGridlineStroke, polarPlot.radiusGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.radiusGridlinePaint, polarPlot.radiusGridlinePaint)) {
            return false;
        }
        if (this.radiusMinorGridlinesVisible != polarPlot.radiusMinorGridlinesVisible) {
            return false;
        }
        if (!this.cornerTextItems.equals(polarPlot.cornerTextItems)) {
            return false;
        }
        if (this.margin != polarPlot.margin) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, polarPlot.fixedLegendItems)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        PublicCloneable publicCloneable;
        Object object;
        int n2;
        PolarPlot polarPlot = (PolarPlot)super.clone();
        polarPlot.axes = (ObjectList)ObjectUtilities.clone(this.axes);
        for (n2 = 0; n2 < this.axes.size(); ++n2) {
            object = (ValueAxis)this.axes.get(n2);
            if (object == null) continue;
            publicCloneable = (ValueAxis)((ValueAxis)object).clone();
            polarPlot.axes.set(n2, publicCloneable);
            ((Axis)((Object)publicCloneable)).setPlot(polarPlot);
            ((Axis)((Object)publicCloneable)).addChangeListener(polarPlot);
        }
        polarPlot.datasets = (ObjectList)ObjectUtilities.clone(this.datasets);
        for (n2 = 0; n2 < polarPlot.datasets.size(); ++n2) {
            object = this.getDataset(n2);
            if (object == null) continue;
            object.addChangeListener(polarPlot);
        }
        polarPlot.renderers = (ObjectList)ObjectUtilities.clone(this.renderers);
        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
            object = (PolarItemRenderer)this.renderers.get(n2);
            if (!(object instanceof PublicCloneable)) continue;
            publicCloneable = (PublicCloneable)object;
            PolarItemRenderer polarItemRenderer = (PolarItemRenderer)publicCloneable.clone();
            polarPlot.renderers.set(n2, polarItemRenderer);
            polarItemRenderer.setPlot(polarPlot);
            polarItemRenderer.addChangeListener(polarPlot);
        }
        polarPlot.cornerTextItems = new ArrayList(this.cornerTextItems);
        return polarPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.angleGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.angleGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.radiusGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.radiusGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.angleLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        int n2;
        int n3;
        objectInputStream.defaultReadObject();
        this.angleGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.angleGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.radiusGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.radiusGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.angleLabelPaint = SerialUtilities.readPaint(objectInputStream);
        int n4 = this.axes.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Axis axis = (Axis)this.axes.get(n3);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n3 = this.datasets.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Dataset dataset = (Dataset)this.datasets.get(n2);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        n2 = this.renderers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            PolarItemRenderer polarItemRenderer = (PolarItemRenderer)this.renderers.get(i2);
            if (polarItemRenderer == null) continue;
            polarItemRenderer.addChangeListener(this);
        }
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
    }

    @Override
    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoom(d2);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        double d3 = point2D.getX();
        for (int i2 = 0; i2 < this.getAxisCount(); ++i2) {
            ValueAxis valueAxis = this.getAxis(i2);
            if (valueAxis == null) continue;
            if (bl2) {
                double d4 = valueAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), RectangleEdge.BOTTOM);
                valueAxis.resizeRange(d2, d4);
                continue;
            }
            valueAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoom((d3 + d2) / 2.0);
    }

    @Override
    public boolean isDomainZoomable() {
        return false;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    @Override
    public PlotOrientation getOrientation() {
        return PlotOrientation.HORIZONTAL;
    }

    public Point translateToJava2D(double d2, double d3, ValueAxis valueAxis, Rectangle2D rectangle2D) {
        if (this.counterClockwise) {
            d2 = -d2;
        }
        double d4 = Math.toRadians(d2 + this.angleOffset);
        double d5 = rectangle2D.getMinX() + (double)this.margin;
        double d6 = rectangle2D.getMaxX() - (double)this.margin;
        double d7 = rectangle2D.getMinY() + (double)this.margin;
        double d8 = rectangle2D.getMaxY() - (double)this.margin;
        double d9 = (d6 - d5) / 2.0;
        double d10 = (d8 - d7) / 2.0;
        double d11 = d5 + d9;
        double d12 = d7 + d10;
        double d13 = Math.min(d9, d10);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d11, d12, d13, d13);
        double d14 = valueAxis.getLowerBound();
        double d15 = Math.max(d3, d14);
        double d16 = valueAxis.valueToJava2D(d15, double_, RectangleEdge.BOTTOM) - d11;
        float f2 = (float)(d11 + Math.cos(d4) * d16);
        float f3 = (float)(d12 + Math.sin(d4) * d16);
        int n2 = Math.round(f2);
        int n3 = Math.round(f3);
        Point point = new Point(n2, n3);
        return point;
    }

    public Point translateValueThetaRadiusToJava2D(double d2, double d3, Rectangle2D rectangle2D) {
        return this.translateToJava2D(d2, d3, this.getAxis(), rectangle2D);
    }

    public double getMaxRadius() {
        return this.getAxis().getUpperBound();
    }

    public int getSeriesCount() {
        int n2 = 0;
        XYDataset xYDataset = this.getDataset(0);
        if (xYDataset != null) {
            n2 = xYDataset.getSeriesCount();
        }
        return n2;
    }

    protected AxisState drawAxis(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.getAxis().draw(graphics2D, rectangle2D2.getMinY(), rectangle2D, rectangle2D2, RectangleEdge.TOP, null);
    }
}

