/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.MarkerChangeEvent;
import org.jfree.chart.event.MarkerChangeListener;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Align;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public abstract class Plot
implements Serializable,
Cloneable,
LegendItemSource,
AnnotationChangeListener,
AxisChangeListener,
MarkerChangeListener,
DatasetChangeListener,
PublicCloneable {
    private static final long serialVersionUID = -8831571430103671324L;
    public static final Number ZERO = new Integer(0);
    public static final RectangleInsets DEFAULT_INSETS = new RectangleInsets(4.0, 8.0, 4.0, 8.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(0.5f, 1, 1);
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    public static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    public static final Shape DEFAULT_LEGEND_ITEM_BOX = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    private Plot parent = null;
    private DatasetGroup datasetGroup;
    private String noDataMessage = null;
    private Font noDataMessageFont;
    private transient Paint noDataMessagePaint;
    private RectangleInsets insets = DEFAULT_INSETS;
    private boolean outlineVisible = true;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint = DEFAULT_BACKGROUND_PAINT;
    private transient Image backgroundImage = null;
    private int backgroundImageAlignment = 15;
    private float backgroundImageAlpha = 0.5f;
    private float foregroundAlpha = 1.0f;
    private float backgroundAlpha = 1.0f;
    private DrawingSupplier drawingSupplier;
    private transient EventListenerList listenerList;
    private boolean notify = true;

    protected Plot() {
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaint = Color.black;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.listenerList = new EventListenerList();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String string) {
        this.noDataMessage = string;
        this.fireChangeEvent();
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.noDataMessageFont = font;
        this.fireChangeEvent();
    }

    public Paint getNoDataMessagePaint() {
        return this.noDataMessagePaint;
    }

    public void setNoDataMessagePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.noDataMessagePaint = paint;
        this.fireChangeEvent();
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot plot) {
        this.parent = plot;
    }

    public Plot getRootPlot() {
        Plot plot = this.getParent();
        if (plot == null) {
            return this;
        }
        return plot.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets rectangleInsets) {
        this.setInsets(rectangleInsets, true);
    }

    public void setInsets(RectangleInsets rectangleInsets, boolean bl2) {
        ParamChecks.nullNotPermitted(rectangleInsets, "insets");
        if (!this.insets.equals(rectangleInsets)) {
            this.insets = rectangleInsets;
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.fireChangeEvent();
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.fireChangeEvent();
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f2) {
        if (this.backgroundAlpha != f2) {
            this.backgroundAlpha = f2;
            this.fireChangeEvent();
        }
    }

    public DrawingSupplier getDrawingSupplier() {
        Plot plot = this.getParent();
        DrawingSupplier drawingSupplier = plot != null ? plot.getDrawingSupplier() : this.drawingSupplier;
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.drawingSupplier = drawingSupplier;
        this.fireChangeEvent();
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier, boolean bl2) {
        this.drawingSupplier = drawingSupplier;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.fireChangeEvent();
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n2) {
        if (this.backgroundImageAlignment != n2) {
            this.backgroundImageAlignment = n2;
            this.fireChangeEvent();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("The 'alpha' value must be in the range 0.0f to 1.0f.");
        }
        if (this.backgroundImageAlpha != f2) {
            this.backgroundImageAlpha = f2;
            this.fireChangeEvent();
        }
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean bl2) {
        this.outlineVisible = bl2;
        this.fireChangeEvent();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.fireChangeEvent();
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.fireChangeEvent();
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.fireChangeEvent();
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.fireChangeEvent();
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f2) {
        if (this.foregroundAlpha != f2) {
            this.foregroundAlpha = f2;
            this.fireChangeEvent();
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        return null;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl2) {
        this.notify = bl2;
        if (bl2) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.add(PlotChangeListener.class, plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.remove(PlotChangeListener.class, plotChangeListener);
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        if (!this.notify) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PlotChangeListener.class) continue;
            ((PlotChangeListener)objectArray[i2 + 1]).plotChanged(plotChangeEvent);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, Point2D var3, PlotState var4, PlotRenderingInfo var5);

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected void fillBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D, PlotOrientation.VERTICAL);
    }

    protected void fillBackground(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Object object;
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        if (this.backgroundPaint == null) {
            return;
        }
        Paint paint = this.backgroundPaint;
        if (paint instanceof GradientPaint) {
            object = (GradientPaint)paint;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                paint = new GradientPaint((float)rectangle2D.getCenterX(), (float)rectangle2D.getMaxY(), ((GradientPaint)object).getColor1(), (float)rectangle2D.getCenterX(), (float)rectangle2D.getMinY(), ((GradientPaint)object).getColor2());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                paint = new GradientPaint((float)rectangle2D.getMinX(), (float)rectangle2D.getCenterY(), ((GradientPaint)object).getColor1(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getCenterY(), ((GradientPaint)object).getColor2());
            }
        }
        object = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
        graphics2D.setPaint(paint);
        graphics2D.fill(rectangle2D);
        graphics2D.setComposite((Composite)object);
    }

    public void drawBackgroundImage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.backgroundImage == null) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
        Align.align(double_, rectangle2D, this.backgroundImageAlignment);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth() + 1, (int)((RectangularShape)double_).getHeight() + 1, null);
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
    }

    public void drawOutline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.outlineVisible) {
            return;
        }
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            graphics2D.draw(rectangle2D);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        }
    }

    protected void drawNoDataMessage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        String string = this.noDataMessage;
        if (string != null) {
            graphics2D.setFont(this.noDataMessageFont);
            graphics2D.setPaint(this.noDataMessagePaint);
            TextBlock textBlock = TextUtilities.createTextBlock(this.noDataMessage, this.noDataMessageFont, this.noDataMessagePaint, 0.9f * (float)rectangle2D.getWidth(), new G2TextMeasurer(graphics2D));
            textBlock.draw(graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), TextBlockAnchor.CENTER);
        }
        graphics2D.setClip(shape);
    }

    protected void createAndAddEntity(Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, String string, String string2) {
        EntityCollection entityCollection;
        if (plotRenderingInfo != null && plotRenderingInfo.getOwner() != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            entityCollection.add(new PlotEntity(rectangle2D, this, string, string2));
        }
    }

    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
    }

    public void zoom(double d2) {
    }

    @Override
    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        this.fireChangeEvent();
    }

    @Override
    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.fireChangeEvent();
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
        this.notifyListeners(plotChangeEvent);
    }

    @Override
    public void markerChanged(MarkerChangeEvent markerChangeEvent) {
        this.fireChangeEvent();
    }

    protected double getRectX(double d2, double d3, double d4, RectangleEdge rectangleEdge) {
        double d5 = d2;
        if (rectangleEdge == RectangleEdge.LEFT) {
            d5 += d3;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d5 += d4;
        }
        return d5;
    }

    protected double getRectY(double d2, double d3, double d4, RectangleEdge rectangleEdge) {
        double d5 = d2;
        if (rectangleEdge == RectangleEdge.TOP) {
            d5 += d3;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d5 += d4;
        }
        return d5;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Plot)) {
            return false;
        }
        Plot plot = (Plot)object;
        if (!ObjectUtilities.equal(this.noDataMessage, plot.noDataMessage)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.noDataMessageFont, plot.noDataMessageFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.noDataMessagePaint, plot.noDataMessagePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.insets, plot.insets)) {
            return false;
        }
        if (this.outlineVisible != plot.outlineVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, plot.outlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, plot.outlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, plot.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundImage, plot.backgroundImage)) {
            return false;
        }
        if (this.backgroundImageAlignment != plot.backgroundImageAlignment) {
            return false;
        }
        if (this.backgroundImageAlpha != plot.backgroundImageAlpha) {
            return false;
        }
        if (this.foregroundAlpha != plot.foregroundAlpha) {
            return false;
        }
        if (this.backgroundAlpha != plot.backgroundAlpha) {
            return false;
        }
        if (!this.drawingSupplier.equals(plot.drawingSupplier)) {
            return false;
        }
        return this.notify == plot.notify;
    }

    @Override
    public Object clone() {
        Plot plot = (Plot)super.clone();
        if (this.datasetGroup != null) {
            plot.datasetGroup = (DatasetGroup)ObjectUtilities.clone(this.datasetGroup);
        }
        plot.drawingSupplier = (DrawingSupplier)ObjectUtilities.clone(this.drawingSupplier);
        plot.listenerList = new EventListenerList();
        return plot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.noDataMessagePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.noDataMessagePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }

    public static RectangleEdge resolveDomainAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(axisLocation, "location");
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.TOP;
            }
        } else if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.LEFT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.TOP;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.LEFT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            }
        }
        if (rectangleEdge == null) {
            throw new IllegalStateException("resolveDomainAxisLocation()");
        }
        return rectangleEdge;
    }

    public static RectangleEdge resolveRangeAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(axisLocation, "location");
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.TOP;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            }
        } else if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.TOP;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.LEFT;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.LEFT;
            }
        }
        if (rectangleEdge == null) {
            throw new IllegalStateException("resolveRangeAxisLocation()");
        }
        return rectangleEdge;
    }
}

