/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.PaintAlpha;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class PiePlot3D
extends PiePlot
implements Serializable {
    private static final long serialVersionUID = 3408984188945161432L;
    private double depthFactor = 0.12;
    private boolean darkerSides = false;

    public PiePlot3D() {
        this(null);
    }

    public PiePlot3D(PieDataset pieDataset) {
        super(pieDataset);
        this.setCircular(false, false);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setDepthFactor(double d2) {
        this.depthFactor = d2;
        this.fireChangeEvent();
    }

    public boolean getDarkerSides() {
        return this.darkerSides;
    }

    public void setDarkerSides(boolean bl2) {
        this.darkerSides = bl2;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        Object object2;
        Object object3;
        Stroke stroke;
        Paint paint;
        Paint paint2;
        Arc2D.Double double_;
        int n2;
        Serializable serializable;
        Object object522;
        List list;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (this.getShadowGenerator() != null) {
            bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        double d2 = this.getInteriorGap();
        double d3 = 0.0;
        if (this.getLabelGenerator() != null) {
            d3 = this.getLabelGap() + this.getMaximumLabelWidth();
        }
        double d4 = rectangle2D.getWidth() * (d2 + d3) * 2.0;
        double d5 = rectangle2D.getHeight() * d2 * 2.0;
        double d6 = rectangle2D.getX() + d4 / 2.0;
        double d7 = rectangle2D.getY() + d5 / 2.0;
        double d8 = rectangle2D.getWidth() - d4;
        double d9 = rectangle2D.getHeight() - d5;
        if (this.isCircular()) {
            double d10 = Math.min(d8, d9) / 2.0;
            d6 = (d6 + d6 + d8) / 2.0 - d10;
            d7 = (d7 + d7 + d9) / 2.0 - d10;
            d8 = 2.0 * d10;
            d9 = 2.0 * d10;
        }
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d6, d7, d8, d9 * (1.0 - this.depthFactor));
        piePlotState.setLinkArea(double_2);
        double d11 = d8 * this.getLabelLinkMargin();
        double d12 = d9 * this.getLabelLinkMargin();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d6 + d11 / 2.0, d7 + d12 / 2.0, d8 - d11, d9 - d12);
        piePlotState.setExplodedPieArea(double_3);
        double d13 = this.getMaximumExplodePercent();
        double d14 = d13 / (1.0 + d13);
        double d15 = ((RectangularShape)double_3).getWidth() * d14;
        double d16 = ((RectangularShape)double_3).getHeight() * d14;
        Rectangle2D.Double double_4 = new Rectangle2D.Double(((RectangularShape)double_3).getX() + d15 / 2.0, ((RectangularShape)double_3).getY() + d16 / 2.0, ((RectangularShape)double_3).getWidth() - d15, ((RectangularShape)double_3).getHeight() - d16);
        int n3 = (int)(((RectangularShape)double_4).getHeight() * this.depthFactor);
        Rectangle2D.Double double_5 = new Rectangle2D.Double(d6, d7, d8, d9 - (double)n3);
        piePlotState.setLinkArea(double_5);
        piePlotState.setPieArea(double_4);
        piePlotState.setPieCenterX(double_4.getCenterX());
        piePlotState.setPieCenterY(double_4.getCenterY() - (double)n3 / 2.0);
        piePlotState.setPieWRadius(((RectangularShape)double_4).getWidth() / 2.0);
        piePlotState.setPieHRadius((((RectangularShape)double_4).getHeight() - (double)n3) / 2.0);
        PieDataset pieDataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull(this.getDataset())) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            graphics2D.setClip(shape);
            this.drawOutline(graphics2D, rectangle2D);
            return;
        }
        if ((double)pieDataset.getKeys().size() > rectangle2D.getWidth()) {
            String string = localizationResources.getString("Too_many_elements");
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n4 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n4) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d17 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d17, rectangle2D.getCenterY() - d17, 2.0 * d17, 2.0 * d17);
        }
        if ((list = pieDataset.getKeys()).isEmpty()) {
            return;
        }
        double d18 = ((RectangularShape)double_4).getX();
        double d19 = ((RectangularShape)double_4).getY();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d20 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        double d21 = 0.0;
        if (n3 < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        for (Object object522 : list) {
            double d22;
            double d23;
            serializable = pieDataset.getValue((Comparable)object522);
            if (serializable == null) {
                arrayList.add(null);
                continue;
            }
            double d24 = ((Number)serializable).doubleValue();
            if (d24 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            double d25 = this.getStartAngle();
            double d26 = d25 + (d23 = this.getDirection().getFactor()) * (d21 + d24) * 360.0 / d20;
            if (Math.abs(d26 - (d22 = d25 + d23 * (d21 * 360.0) / d20)) > this.getMinimumArcAngleToDraw()) {
                arrayList.add(new Arc2D.Double(d18, d19 + (double)n3, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n3, d22, d26 - d22, 2));
            } else {
                arrayList.add(null);
            }
            d21 += d24;
        }
        object522 = graphics2D.getClip();
        serializable = new Ellipse2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)double_4).getY(), ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n3);
        Ellipse2D.Double double_6 = new Ellipse2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)double_4).getY() + (double)n3, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n3);
        Rectangle2D.Double double_7 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), ((RectangularShape)double_4).getWidth(), double_6.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_8 = new Rectangle2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)((Object)serializable)).getY(), ((RectangularShape)double_4).getWidth(), double_6.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)((Object)serializable));
        area.add(new Area(double_7));
        Area area2 = new Area(double_6);
        area2.add(new Area(double_8));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)((Object)serializable)));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_6));
        int n5 = arrayList.size();
        for (n2 = 0; n2 < n5; ++n2) {
            double_ = (Arc2D.Double)arrayList.get(n2);
            if (double_ == null) continue;
            Comparable object42 = this.getSectionKey(n2);
            paint2 = this.lookupSectionPaint(object42);
            paint = this.lookupSectionOutlinePaint(object42);
            stroke = this.lookupSectionOutlineStroke(object42);
            graphics2D.setPaint(paint2);
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(double_);
            graphics2D.setPaint(paint2);
            object3 = double_.getStartPoint();
            int[] nArray = new int[]{(int)double_.getCenterX(), (int)double_.getCenterX(), (int)((Point2D)object3).getX(), (int)((Point2D)object3).getX()};
            int[] nArray2 = new int[]{(int)double_.getCenterY(), (int)double_.getCenterY() - n3, (int)((Point2D)object3).getY() - n3, (int)((Point2D)object3).getY()};
            object2 = new Polygon(nArray, nArray2, 4);
            graphics2D.setPaint(Color.lightGray);
            graphics2D.fill((Shape)object2);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw((Shape)object2);
            graphics2D.setPaint(paint2);
        }
        graphics2D.setPaint(Color.gray);
        graphics2D.fill(area5);
        graphics2D.fill(area4);
        n2 = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object3 = this.getSectionKey(n2);
                paint2 = this.lookupSectionPaint((Comparable)object3);
                paint = this.lookupSectionOutlinePaint((Comparable)object3);
                stroke = this.lookupSectionOutlineStroke((Comparable)object3);
                this.drawSide(graphics2D, double_4, arc2D, area4, area5, paint2, paint, stroke, false, true);
            }
            ++n2;
        }
        n2 = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object3 = this.getSectionKey(n2);
                paint2 = this.lookupSectionPaint((Comparable)object3);
                paint = this.lookupSectionOutlinePaint((Comparable)object3);
                stroke = this.lookupSectionOutlineStroke((Comparable)object3);
                this.drawSide(graphics2D, double_4, arc2D, area4, area5, paint2, paint, stroke, true, false);
            }
            ++n2;
        }
        graphics2D.setClip((Shape)object522);
        for (int i2 = 0; i2 < n5; ++i2) {
            double_ = (Arc2D.Double)arrayList.get(i2);
            if (double_ == null) continue;
            Arc2D.Double double_9 = new Arc2D.Double(d18, d19, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n3, double_.getAngleStart(), double_.getAngleExtent(), 2);
            object2 = (Comparable)list.get(i2);
            paint2 = this.lookupSectionPaint((Comparable)object2, true);
            paint = this.lookupSectionOutlinePaint((Comparable)object2);
            stroke = this.lookupSectionOutlineStroke((Comparable)object2);
            graphics2D.setPaint(paint2);
            graphics2D.fill(double_9);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_9);
            if (plotRenderingInfo == null || (object = plotRenderingInfo.getOwner().getEntityCollection()) == null) continue;
            String string = null;
            PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
            if (pieToolTipGenerator != null) {
                string = pieToolTipGenerator.generateToolTip(pieDataset, (Comparable)object2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(pieDataset, (Comparable)object2, this.getPieIndex());
            }
            PieSectionEntity pieSectionEntity = new PieSectionEntity(double_9, pieDataset, this.getPieIndex(), i2, (Comparable)object2, string, string2);
            object.add(pieSectionEntity);
        }
        List list2 = pieDataset.getKeys();
        object2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - (double)n3);
        if (this.getSimpleLabels()) {
            this.drawSimpleLabels(graphics2D, list2, d20, (Rectangle2D)object2, double_5, piePlotState);
        } else {
            this.drawLabels(graphics2D, list2, d20, (Rectangle2D)object2, double_5, piePlotState);
        }
        if (this.getShadowGenerator() != null) {
            object = this.getShadowGenerator().createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)object, (int)rectangle2D.getX() + this.getShadowGenerator().calculateOffsetX(), (int)rectangle2D.getY() + this.getShadowGenerator().calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), null);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    protected void drawSide(Graphics2D graphics2D, Rectangle2D rectangle2D, Arc2D arc2D, Area area, Area area2, Paint paint, Paint paint2, Stroke stroke, boolean bl2, boolean bl3) {
        if (this.getDarkerSides()) {
            paint = PaintAlpha.darker(paint);
        }
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        graphics2D.setStroke(stroke);
        if (d3 < 0.0) {
            if (this.isAngleAtFront(d2)) {
                if (!this.isAngleAtBack(d4)) {
                    if (d3 > -180.0) {
                        if (bl2) {
                            Area area3 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                            area3.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area3);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area3);
                        }
                    } else {
                        Area area4 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area4.intersect(area);
                        Area area5 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area5.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl2) {
                            graphics2D.fill(area4);
                            graphics2D.fill(area5);
                        }
                        if (bl3) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl2) {
                            graphics2D.draw(area4);
                            graphics2D.draw(area5);
                        }
                        if (bl3) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area6;
                    if (bl3) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                    if (bl2) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                }
            } else if (!this.isAngleAtFront(d4)) {
                if (d3 > -180.0) {
                    if (bl3) {
                        Area area7 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area7.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area7);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area7);
                    }
                } else {
                    Area area8 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area8.intersect(area2);
                    Area area9 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area9.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl3) {
                        graphics2D.fill(area8);
                        graphics2D.fill(area9);
                    }
                    if (bl2) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl3) {
                        graphics2D.draw(area8);
                        graphics2D.draw(area9);
                    }
                    if (bl2) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area10;
                if (bl3) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
                if (bl2) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
            }
        } else if (d3 > 0.0) {
            if (this.isAngleAtFront(d2)) {
                if (!this.isAngleAtBack(d4)) {
                    if (d3 < 180.0) {
                        if (bl2) {
                            Area area11 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                            area11.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area11);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area11);
                        }
                    } else {
                        Area area12 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area12.intersect(area);
                        Area area13 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area13.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl2) {
                            graphics2D.fill(area12);
                            graphics2D.fill(area13);
                        }
                        if (bl3) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl2) {
                            graphics2D.draw(area12);
                            graphics2D.draw(area13);
                        }
                        if (bl3) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area14;
                    if (bl3) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                    if (bl2) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                }
            } else if (!this.isAngleAtFront(d4)) {
                if (d3 < 180.0) {
                    if (bl3) {
                        Area area15 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area15.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area15);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area15);
                    }
                } else {
                    Area area16 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area16.intersect(area2);
                    Area area17 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area17.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl3) {
                        graphics2D.fill(area16);
                        graphics2D.fill(area17);
                    }
                    if (bl2) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl3) {
                        graphics2D.draw(area16);
                        graphics2D.draw(area17);
                    }
                    if (bl2) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area18;
                if (bl3) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
                if (bl2) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
            }
        }
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double d2) {
        return Math.sin(Math.toRadians(d2)) < 0.0;
    }

    private boolean isAngleAtBack(double d2) {
        return Math.sin(Math.toRadians(d2)) > 0.0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PiePlot3D)) {
            return false;
        }
        PiePlot3D piePlot3D = (PiePlot3D)object;
        if (this.depthFactor != piePlot3D.depthFactor) {
            return false;
        }
        if (this.darkerSides != piePlot3D.darkerSides) {
            return false;
        }
        return super.equals(object);
    }
}

