/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.PaintMap;
import org.jfree.chart.StrokeMap;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.AbstractPieLabelDistributor;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelDistributor;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

public class PiePlot
extends Plot
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -795612466005590431L;
    public static final double DEFAULT_INTERIOR_GAP = 0.08;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = new Color(151, 151, 151, 128);
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private PaintMap sectionPaintMap;
    private transient Paint baseSectionPaint;
    private boolean autoPopulateSectionPaint;
    private boolean sectionOutlinesVisible;
    private PaintMap sectionOutlinePaintMap;
    private transient Paint baseSectionOutlinePaint;
    private boolean autoPopulateSectionOutlinePaint;
    private StrokeMap sectionOutlineStrokeMap;
    private transient Stroke baseSectionOutlineStroke;
    private boolean autoPopulateSectionOutlineStroke;
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private Map explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private boolean simpleLabels = true;
    private RectangleInsets labelPadding;
    private RectangleInsets simpleLabelOffset;
    private double maximumLabelWidth = 0.14;
    private double labelGap = 0.025;
    private boolean labelLinksVisible;
    private PieLabelLinkStyle labelLinkStyle = PieLabelLinkStyle.STANDARD;
    private double labelLinkMargin = 0.025;
    private transient Paint labelLinkPaint = Color.black;
    private transient Stroke labelLinkStroke = new BasicStroke(0.5f);
    private AbstractPieLabelDistributor labelDistributor;
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private PieSectionLabelGenerator legendLabelGenerator;
    private PieSectionLabelGenerator legendLabelToolTipGenerator;
    private PieURLGenerator legendLabelURLGenerator;
    private boolean ignoreNullValues;
    private boolean ignoreZeroValues;
    private transient Shape legendItemShape;
    private double minimumArcAngleToDraw;
    private ShadowGenerator shadowGenerator;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");
    static final boolean DEBUG_DRAW_INTERIOR = false;
    static final boolean DEBUG_DRAW_LINK_AREA = false;
    static final boolean DEBUG_DRAW_PIE_AREA = false;
    private transient Paint sectionPaint;
    private transient Paint sectionOutlinePaint;
    private transient Stroke sectionOutlineStroke;

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset pieDataset) {
        this.dataset = pieDataset;
        if (pieDataset != null) {
            pieDataset.addChangeListener(this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.08;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintMap = new PaintMap();
        this.baseSectionPaint = Color.gray;
        this.autoPopulateSectionPaint = true;
        this.sectionOutlinesVisible = true;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintMap = new PaintMap();
        this.baseSectionOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.autoPopulateSectionOutlinePaint = false;
        this.sectionOutlineStroke = null;
        this.sectionOutlineStrokeMap = new StrokeMap();
        this.baseSectionOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.autoPopulateSectionOutlineStroke = false;
        this.explodePercentages = new TreeMap();
        this.labelGenerator = new StandardPieSectionLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = DEFAULT_LABEL_OUTLINE_STROKE;
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.labelLinksVisible = true;
        this.labelDistributor = new PieLabelDistributor(0);
        this.simpleLabels = false;
        this.simpleLabelOffset = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        this.labelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.toolTipGenerator = null;
        this.urlGenerator = null;
        this.legendLabelGenerator = new StandardPieSectionLabelGenerator();
        this.legendLabelToolTipGenerator = null;
        this.legendLabelURLGenerator = null;
        this.legendItemShape = Plot.DEFAULT_LEGEND_ITEM_CIRCLE;
        this.ignoreNullValues = false;
        this.ignoreZeroValues = false;
        this.shadowGenerator = null;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset pieDataset) {
        PieDataset pieDataset2 = this.dataset;
        if (pieDataset2 != null) {
            pieDataset2.removeChangeListener(this);
        }
        this.dataset = pieDataset;
        if (pieDataset != null) {
            this.setDatasetGroup(pieDataset.getGroup());
            pieDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, pieDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int n2) {
        this.pieIndex = n2;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d2) {
        this.startAngle = d2;
        this.fireChangeEvent();
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        ParamChecks.nullNotPermitted(rotation, "direction");
        this.direction = rotation;
        this.fireChangeEvent();
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d2) {
        if (d2 < 0.0 || d2 > 0.4) {
            throw new IllegalArgumentException("Invalid 'percent' (" + d2 + ") argument.");
        }
        if (this.interiorGap != d2) {
            this.interiorGap = d2;
            this.fireChangeEvent();
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl2) {
        this.setCircular(bl2, true);
    }

    public void setCircular(boolean bl2, boolean bl3) {
        this.circular = bl2;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean bl2) {
        this.ignoreNullValues = bl2;
        this.fireChangeEvent();
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean bl2) {
        this.ignoreZeroValues = bl2;
        this.fireChangeEvent();
    }

    protected Paint lookupSectionPaint(Comparable comparable) {
        return this.lookupSectionPaint(comparable, this.getAutoPopulateSectionPaint());
    }

    protected Paint lookupSectionPaint(Comparable comparable, boolean bl2) {
        Paint paint = this.getSectionPaint();
        if (paint != null) {
            return paint;
        }
        paint = this.sectionPaintMap.getPaint(comparable);
        if (paint != null) {
            return paint;
        }
        if (bl2) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextPaint();
                this.sectionPaintMap.put(comparable, paint);
            } else {
                paint = this.baseSectionPaint;
            }
        } else {
            paint = this.baseSectionPaint;
        }
        return paint;
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
        this.fireChangeEvent();
    }

    protected Comparable getSectionKey(int n2) {
        Comparable<Integer> comparable = null;
        if (this.dataset != null && n2 >= 0 && n2 < this.dataset.getItemCount()) {
            comparable = this.dataset.getKey(n2);
        }
        if (comparable == null) {
            comparable = new Integer(n2);
        }
        return comparable;
    }

    public Paint getSectionPaint(Comparable comparable) {
        return this.sectionPaintMap.getPaint(comparable);
    }

    public void setSectionPaint(Comparable comparable, Paint paint) {
        this.sectionPaintMap.put(comparable, paint);
        this.fireChangeEvent();
    }

    public void clearSectionPaints(boolean bl2) {
        this.sectionPaintMap.clear();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseSectionPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionPaint() {
        return this.autoPopulateSectionPaint;
    }

    public void setAutoPopulateSectionPaint(boolean bl2) {
        this.autoPopulateSectionPaint = bl2;
        this.fireChangeEvent();
    }

    public boolean getSectionOutlinesVisible() {
        return this.sectionOutlinesVisible;
    }

    public void setSectionOutlinesVisible(boolean bl2) {
        this.sectionOutlinesVisible = bl2;
        this.fireChangeEvent();
    }

    protected Paint lookupSectionOutlinePaint(Comparable comparable) {
        return this.lookupSectionOutlinePaint(comparable, this.getAutoPopulateSectionOutlinePaint());
    }

    protected Paint lookupSectionOutlinePaint(Comparable comparable, boolean bl2) {
        Paint paint = this.getSectionOutlinePaint();
        if (paint != null) {
            return paint;
        }
        paint = this.sectionOutlinePaintMap.getPaint(comparable);
        if (paint != null) {
            return paint;
        }
        if (bl2) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextOutlinePaint();
                this.sectionOutlinePaintMap.put(comparable, paint);
            } else {
                paint = this.baseSectionOutlinePaint;
            }
        } else {
            paint = this.baseSectionOutlinePaint;
        }
        return paint;
    }

    public Paint getSectionOutlinePaint(Comparable comparable) {
        return this.sectionOutlinePaintMap.getPaint(comparable);
    }

    public void setSectionOutlinePaint(Comparable comparable, Paint paint) {
        this.sectionOutlinePaintMap.put(comparable, paint);
        this.fireChangeEvent();
    }

    public void clearSectionOutlinePaints(boolean bl2) {
        this.sectionOutlinePaintMap.clear();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.baseSectionOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionOutlinePaint() {
        return this.autoPopulateSectionOutlinePaint;
    }

    public void setAutoPopulateSectionOutlinePaint(boolean bl2) {
        this.autoPopulateSectionOutlinePaint = bl2;
        this.fireChangeEvent();
    }

    protected Stroke lookupSectionOutlineStroke(Comparable comparable) {
        return this.lookupSectionOutlineStroke(comparable, this.getAutoPopulateSectionOutlineStroke());
    }

    protected Stroke lookupSectionOutlineStroke(Comparable comparable, boolean bl2) {
        Stroke stroke = this.getSectionOutlineStroke();
        if (stroke != null) {
            return stroke;
        }
        stroke = this.sectionOutlineStrokeMap.getStroke(comparable);
        if (stroke != null) {
            return stroke;
        }
        if (bl2) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextOutlineStroke();
                this.sectionOutlineStrokeMap.put(comparable, stroke);
            } else {
                stroke = this.baseSectionOutlineStroke;
            }
        } else {
            stroke = this.baseSectionOutlineStroke;
        }
        return stroke;
    }

    public Stroke getSectionOutlineStroke(Comparable comparable) {
        return this.sectionOutlineStrokeMap.getStroke(comparable);
    }

    public void setSectionOutlineStroke(Comparable comparable, Stroke stroke) {
        this.sectionOutlineStrokeMap.put(comparable, stroke);
        this.fireChangeEvent();
    }

    public void clearSectionOutlineStrokes(boolean bl2) {
        this.sectionOutlineStrokeMap.clear();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseSectionOutlineStroke() {
        return this.baseSectionOutlineStroke;
    }

    public void setBaseSectionOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.baseSectionOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionOutlineStroke() {
        return this.autoPopulateSectionOutlineStroke;
    }

    public void setAutoPopulateSectionOutlineStroke(boolean bl2) {
        this.autoPopulateSectionOutlineStroke = bl2;
        this.fireChangeEvent();
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d2) {
        this.shadowXOffset = d2;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d2) {
        this.shadowYOffset = d2;
        this.fireChangeEvent();
    }

    public double getExplodePercent(Comparable comparable) {
        Number number;
        double d2 = 0.0;
        if (this.explodePercentages != null && (number = (Number)this.explodePercentages.get(comparable)) != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public void setExplodePercent(Comparable comparable, double d2) {
        ParamChecks.nullNotPermitted(comparable, "key");
        if (this.explodePercentages == null) {
            this.explodePercentages = new TreeMap();
        }
        this.explodePercentages.put(comparable, new Double(d2));
        this.fireChangeEvent();
    }

    public double getMaximumExplodePercent() {
        if (this.dataset == null) {
            return 0.0;
        }
        double d2 = 0.0;
        for (Comparable comparable : this.dataset.getKeys()) {
            Number number = (Number)this.explodePercentages.get(comparable);
            if (number == null) continue;
            d2 = Math.max(d2, number.doubleValue());
        }
        return d2;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.labelGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double d2) {
        this.labelGap = d2;
        this.fireChangeEvent();
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double d2) {
        this.maximumLabelWidth = d2;
        this.fireChangeEvent();
    }

    public boolean getLabelLinksVisible() {
        return this.labelLinksVisible;
    }

    public void setLabelLinksVisible(boolean bl2) {
        this.labelLinksVisible = bl2;
        this.fireChangeEvent();
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle pieLabelLinkStyle) {
        ParamChecks.nullNotPermitted(pieLabelLinkStyle, "style");
        this.labelLinkStyle = pieLabelLinkStyle;
        this.fireChangeEvent();
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double d2) {
        this.labelLinkMargin = d2;
        this.fireChangeEvent();
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.labelLinkPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getLabelLinkStroke() {
        return this.labelLinkStroke;
    }

    public void setLabelLinkStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.labelLinkStroke = stroke;
        this.fireChangeEvent();
    }

    protected double getLabelLinkDepth() {
        return 0.1;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.labelFont = font;
        this.fireChangeEvent();
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.labelPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        this.labelOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
        this.fireChangeEvent();
    }

    public RectangleInsets getLabelPadding() {
        return this.labelPadding;
    }

    public void setLabelPadding(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "padding");
        this.labelPadding = rectangleInsets;
        this.fireChangeEvent();
    }

    public boolean getSimpleLabels() {
        return this.simpleLabels;
    }

    public void setSimpleLabels(boolean bl2) {
        this.simpleLabels = bl2;
        this.fireChangeEvent();
    }

    public RectangleInsets getSimpleLabelOffset() {
        return this.simpleLabelOffset;
    }

    public void setSimpleLabelOffset(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "offset");
        this.simpleLabelOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public AbstractPieLabelDistributor getLabelDistributor() {
        return this.labelDistributor;
    }

    public void setLabelDistributor(AbstractPieLabelDistributor abstractPieLabelDistributor) {
        ParamChecks.nullNotPermitted(abstractPieLabelDistributor, "distributor");
        this.labelDistributor = abstractPieLabelDistributor;
        this.fireChangeEvent();
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
        this.fireChangeEvent();
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator pieURLGenerator) {
        this.urlGenerator = pieURLGenerator;
        this.fireChangeEvent();
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double d2) {
        this.minimumArcAngleToDraw = d2;
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    public PieSectionLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        ParamChecks.nullNotPermitted(pieSectionLabelGenerator, "generator");
        this.legendLabelGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public PieSectionLabelGenerator getLegendLabelToolTipGenerator() {
        return this.legendLabelToolTipGenerator;
    }

    public void setLegendLabelToolTipGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.legendLabelToolTipGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public PieURLGenerator getLegendLabelURLGenerator() {
        return this.legendLabelURLGenerator;
    }

    public void setLegendLabelURLGenerator(PieURLGenerator pieURLGenerator) {
        this.legendLabelURLGenerator = pieURLGenerator;
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    public void handleMouseWheelRotation(int n2) {
        this.setStartAngle(this.startAngle + (double)n2 * 4.0);
    }

    public PiePlotState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, PiePlot piePlot, Integer n2, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = new PiePlotState(plotRenderingInfo);
        piePlotState.setPassesRequired(2);
        if (this.dataset != null) {
            piePlotState.setTotal(DatasetUtilities.calculatePieDatasetTotal(piePlot.getDataset()));
        }
        piePlotState.setLatestAngle(piePlot.getStartAngle());
        return piePlotState;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            Graphics2D graphics2D2 = graphics2D;
            boolean bl2 = Boolean.TRUE.equals(graphics2D.getRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION));
            BufferedImage bufferedImage = null;
            if (this.shadowGenerator != null && !bl2) {
                bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
                graphics2D = bufferedImage.createGraphics();
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
            }
            this.drawPie(graphics2D, rectangle2D, plotRenderingInfo);
            if (this.shadowGenerator != null && !bl2) {
                BufferedImage bufferedImage2 = this.shadowGenerator.createDropShadow(bufferedImage);
                graphics2D = graphics2D2;
                graphics2D.drawImage((Image)bufferedImage2, (int)rectangle2D.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D.getY() + this.shadowGenerator.calculateOffsetY(), null);
                graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), null);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    protected void drawPie(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d2 = 0.0;
        if (this.labelGenerator != null && !this.simpleLabels) {
            d2 = this.labelGap + this.maximumLabelWidth;
        }
        double d3 = rectangle2D.getWidth() * d2 * 2.0;
        double d4 = rectangle2D.getHeight() * this.interiorGap * 2.0;
        double d5 = rectangle2D.getX() + d3 / 2.0;
        double d6 = rectangle2D.getY() + d4 / 2.0;
        double d7 = rectangle2D.getWidth() - d3;
        double d8 = rectangle2D.getHeight() - d4;
        if (this.circular) {
            double d9 = Math.min(d7, d8) / 2.0;
            d5 = (d5 + d5 + d7) / 2.0 - d9;
            d6 = (d6 + d6 + d8) / 2.0 - d9;
            d7 = 2.0 * d9;
            d8 = 2.0 * d9;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d7, d8);
        piePlotState.setLinkArea(double_);
        double d10 = 0.0;
        if (!this.simpleLabels) {
            d10 = this.labelLinkMargin;
        }
        double d11 = ((RectangularShape)double_).getWidth() * d10 * 2.0;
        double d12 = ((RectangularShape)double_).getHeight() * d10 * 2.0;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d5 + d11 / 2.0, d6 + d12 / 2.0, d7 - d11, d8 - d12);
        piePlotState.setExplodedPieArea(double_2);
        double d13 = this.getMaximumExplodePercent();
        double d14 = d13 / (1.0 + d13);
        double d15 = ((RectangularShape)double_2).getWidth() * d14;
        double d16 = ((RectangularShape)double_2).getHeight() * d14;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(((RectangularShape)double_2).getX() + d15 / 2.0, ((RectangularShape)double_2).getY() + d16 / 2.0, ((RectangularShape)double_2).getWidth() - d15, ((RectangularShape)double_2).getHeight() - d16);
        piePlotState.setPieArea(double_3);
        piePlotState.setPieCenterX(double_3.getCenterX());
        piePlotState.setPieCenterY(double_3.getCenterY());
        piePlotState.setPieWRadius(((RectangularShape)double_3).getWidth() / 2.0);
        piePlotState.setPieHRadius(((RectangularShape)double_3).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List list = this.dataset.getKeys();
            double d17 = DatasetUtilities.calculatePieDatasetTotal(this.dataset);
            int n2 = piePlotState.getPassesRequired();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d18 = 0.0;
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    double d19;
                    Number number = this.dataset.getValue(i3);
                    if (number == null || !((d19 = number.doubleValue()) > 0.0)) continue;
                    d18 += d19;
                    this.drawItem(graphics2D, i3, double_2, piePlotState, i2);
                }
            }
            if (this.simpleLabels) {
                this.drawSimpleLabels(graphics2D, list, d17, rectangle2D, double_, piePlotState);
            } else {
                this.drawLabels(graphics2D, list, d17, rectangle2D, double_, piePlotState);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawItem(Graphics2D graphics2D, int n2, Rectangle2D rectangle2D, PiePlotState piePlotState, int n3) {
        Number number = this.dataset.getValue(n2);
        if (number == null) {
            return;
        }
        double d2 = number.doubleValue();
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            d3 = piePlotState.getLatestAngle();
            d4 = d3 - d2 / piePlotState.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            d3 = piePlotState.getLatestAngle();
            d4 = d3 + d2 / piePlotState.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double d5 = d4 - d3;
        if (Math.abs(d5) > this.getMinimumArcAngleToDraw()) {
            double d6 = 0.0;
            double d7 = this.getMaximumExplodePercent();
            if (d7 > 0.0) {
                d6 = this.getExplodePercent(n2) / d7;
            }
            Rectangle2D rectangle2D2 = this.getArcBounds(piePlotState.getPieArea(), piePlotState.getExplodedPieArea(), d3, d5, d6);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d3, d5, 2);
            if (n3 == 0) {
                if (this.shadowPaint != null && this.shadowGenerator == null) {
                    Shape shape = ShapeUtilities.createTranslatedShape(double_, (float)this.shadowXOffset, (float)this.shadowYOffset);
                    graphics2D.setPaint(this.shadowPaint);
                    graphics2D.fill(shape);
                }
            } else if (n3 == 1) {
                EntityCollection entityCollection;
                Comparable comparable = this.getSectionKey(n2);
                Paint paint = this.lookupSectionPaint(comparable, piePlotState);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_);
                Paint paint2 = this.lookupSectionOutlinePaint(comparable);
                Stroke stroke = this.lookupSectionOutlineStroke(comparable);
                if (this.sectionOutlinesVisible) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
                if (piePlotState.getInfo() != null && (entityCollection = piePlotState.getEntityCollection()) != null) {
                    String string = null;
                    if (this.toolTipGenerator != null) {
                        string = this.toolTipGenerator.generateToolTip(this.dataset, comparable);
                    }
                    String string2 = null;
                    if (this.urlGenerator != null) {
                        string2 = this.urlGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_, this.dataset, this.pieIndex, n2, comparable, string, string2);
                    entityCollection.add(pieSectionEntity);
                }
            }
        }
        piePlotState.setLatestAngle(d4);
    }

    protected void drawSimpleLabels(Graphics2D graphics2D, List list, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Rectangle2D rectangle2D3 = this.simpleLabelOffset.createInsetRectangle(rectangle2D2);
        double d3 = 0.0;
        for (Comparable comparable : list) {
            String string;
            boolean bl2;
            double d4 = 0.0;
            Number number = this.getDataset().getValue(comparable);
            if (number == null) {
                bl2 = !this.getIgnoreNullValues();
            } else {
                d4 = number.doubleValue();
                boolean bl3 = this.getIgnoreZeroValues() ? d4 > 0.0 : (bl2 = d4 >= 0.0);
            }
            if (!bl2) continue;
            double d5 = this.getStartAngle() + this.getDirection().getFactor() * (((d3 += d4) - d4 / 2.0) * 360.0) / d2;
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.getStartAngle(), d5 - this.getStartAngle(), 0);
            int n2 = (int)double_.getEndPoint().getX();
            int n3 = (int)double_.getEndPoint().getY();
            PieSectionLabelGenerator pieSectionLabelGenerator = this.getLabelGenerator();
            if (pieSectionLabelGenerator == null || (string = pieSectionLabelGenerator.generateSectionLabel(this.dataset, comparable)) == null) continue;
            graphics2D.setFont(this.labelFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D4 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            Rectangle2D rectangle2D5 = this.labelPadding.createOutsetRectangle(rectangle2D4);
            Shape shape = ShapeUtilities.createTranslatedShape(rectangle2D5, (double)n2 - rectangle2D4.getCenterX(), (double)n3 - rectangle2D4.getCenterY());
            if (this.labelShadowPaint != null && this.shadowGenerator == null) {
                Shape shape2 = ShapeUtilities.createTranslatedShape(shape, this.shadowXOffset, this.shadowYOffset);
                graphics2D.setPaint(this.labelShadowPaint);
                graphics2D.fill(shape2);
            }
            if (this.labelBackgroundPaint != null) {
                graphics2D.setPaint(this.labelBackgroundPaint);
                graphics2D.fill(shape);
            }
            if (this.labelOutlinePaint != null && this.labelOutlineStroke != null) {
                graphics2D.setPaint(this.labelOutlinePaint);
                graphics2D.setStroke(this.labelOutlineStroke);
                graphics2D.draw(shape);
            }
            graphics2D.setPaint(this.labelPaint);
            graphics2D.setFont(this.labelFont);
            TextUtilities.drawAlignedString(string, graphics2D, n2, n3, TextAnchor.CENTER);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLabels(Graphics2D graphics2D, List list, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        double d3;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        double d4 = 0.0;
        for (Comparable comparable : list) {
            boolean bl2;
            d3 = 0.0;
            Number number = this.dataset.getValue(comparable);
            if (number == null) {
                bl2 = !this.ignoreNullValues;
            } else {
                d3 = number.doubleValue();
                boolean bl3 = this.ignoreZeroValues ? d3 > 0.0 : (bl2 = d3 >= 0.0);
            }
            if (!bl2) continue;
            d4 += d3;
            double d5 = this.startAngle + this.direction.getFactor() * ((d4 - d3 / 2.0) * 360.0) / d2;
            if (Math.cos(Math.toRadians(d5)) < 0.0) {
                defaultKeyedValues.addValue(comparable, new Double(d5));
                continue;
            }
            defaultKeyedValues2.addValue(comparable, new Double(d5));
        }
        graphics2D.setFont(this.getLabelFont());
        double d6 = rectangle2D.getX();
        d3 = rectangle2D.getWidth() * this.labelGap;
        double d7 = rectangle2D2.getX() - d3 - d6;
        float f2 = (float)this.labelPadding.trimWidth(d7);
        if (this.labelGenerator != null) {
            this.drawLeftLabels(defaultKeyedValues, graphics2D, rectangle2D, rectangle2D2, f2, piePlotState);
            this.drawRightLabels(defaultKeyedValues2, graphics2D, rectangle2D, rectangle2D2, f2, piePlotState);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLeftLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f2, PiePlotState piePlotState) {
        this.labelDistributor.clear();
        double d2 = rectangle2D.getWidth() * this.labelGap;
        double d3 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(i2));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock(string, this.labelFont, this.labelPaint, f2, new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            if (this.shadowGenerator == null) {
                textBox.setShadowPaint(this.labelShadowPaint);
            } else {
                textBox.setShadowPaint(null);
            }
            textBox.setInteriorGap(this.labelPadding);
            double d4 = Math.toRadians(keyedValues.getValue(i2).doubleValue());
            double d5 = piePlotState.getPieCenterY() - Math.sin(d4) * d3;
            double d6 = textBox.getHeight(graphics2D);
            this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(i2), d4, d5, textBox, d6, d2 / 2.0 + d2 / 2.0 * -Math.cos(d4), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keyedValues.getKey(i2))));
        }
        double d7 = rectangle2D.getHeight();
        double d8 = d7 * this.getInteriorGap();
        this.labelDistributor.distributeLabels(rectangle2D.getMinY() + d8, d7 - 2.0 * d8);
        for (int i3 = 0; i3 < this.labelDistributor.getItemCount(); ++i3) {
            this.drawLeftLabel(graphics2D, piePlotState, this.labelDistributor.getPieLabelRecord(i3));
        }
    }

    protected void drawRightLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f2, PiePlotState piePlotState) {
        this.labelDistributor.clear();
        double d2 = rectangle2D.getWidth() * this.labelGap;
        double d3 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(i2));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock(string, this.labelFont, this.labelPaint, f2, new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            if (this.shadowGenerator == null) {
                textBox.setShadowPaint(this.labelShadowPaint);
            } else {
                textBox.setShadowPaint(null);
            }
            textBox.setInteriorGap(this.labelPadding);
            double d4 = Math.toRadians(keyedValues.getValue(i2).doubleValue());
            double d5 = piePlotState.getPieCenterY() - Math.sin(d4) * d3;
            double d6 = textBox.getHeight(graphics2D);
            this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(i2), d4, d5, textBox, d6, d2 / 2.0 + d2 / 2.0 * Math.cos(d4), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keyedValues.getKey(i2))));
        }
        double d7 = rectangle2D.getHeight();
        double d8 = 0.0;
        this.labelDistributor.distributeLabels(rectangle2D.getMinY() + d8, d7 - 2.0 * d8);
        for (int i3 = 0; i3 < this.labelDistributor.getItemCount(); ++i3) {
            this.drawRightLabel(graphics2D, piePlotState, this.labelDistributor.getPieLabelRecord(i3));
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset == null) {
            return legendItemCollection;
        }
        List list = this.dataset.getKeys();
        int n2 = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable comparable : list) {
            boolean bl2;
            Number number = this.dataset.getValue(comparable);
            if (number == null) {
                bl2 = !this.ignoreNullValues;
            } else {
                double d2 = number.doubleValue();
                if (d2 == 0.0) {
                    bl2 = !this.ignoreZeroValues;
                } else {
                    boolean bl3 = bl2 = d2 > 0.0;
                }
            }
            if (bl2) {
                String string = this.legendLabelGenerator.generateSectionLabel(this.dataset, comparable);
                if (string != null) {
                    String string2 = string;
                    String string3 = null;
                    if (this.legendLabelToolTipGenerator != null) {
                        string3 = this.legendLabelToolTipGenerator.generateSectionLabel(this.dataset, comparable);
                    }
                    String string4 = null;
                    if (this.legendLabelURLGenerator != null) {
                        string4 = this.legendLabelURLGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    Paint paint = this.lookupSectionPaint(comparable);
                    Paint paint2 = this.lookupSectionOutlinePaint(comparable);
                    Stroke stroke = this.lookupSectionOutlineStroke(comparable);
                    LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, true, paint, true, paint2, stroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(), (Paint)Color.black);
                    legendItem.setDataset(this.getDataset());
                    legendItem.setSeriesIndex(this.dataset.getIndex(comparable));
                    legendItem.setSeriesKey(comparable);
                    legendItemCollection.add(legendItem);
                }
                ++n2;
                continue;
            }
            ++n2;
        }
        return legendItemCollection;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Pie_Plot");
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2, double d3, double d4) {
        if (d4 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d2, d3 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d2, d3 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d5 = (point2D.getX() - point2D2.getX()) * d4;
        double d6 = (point2D.getY() - point2D2.getY()) * d4;
        return new Rectangle2D.Double(rectangle2D.getX() - d5, rectangle2D.getY() - d6, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawLeftLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d2 = piePlotState.getLinkArea().getMinX();
        double d3 = d2 - pieLabelRecord.getGap();
        double d4 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d5;
            double d6 = pieLabelRecord.getAngle();
            double d7 = piePlotState.getPieCenterX() + Math.cos(d6) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterY() - Math.sin(d6) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d9 = piePlotState.getPieCenterX() + Math.cos(d6) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d10 = d5 = piePlotState.getPieCenterY() - Math.sin(d6) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            PieLabelLinkStyle pieLabelLinkStyle = this.getLabelLinkStyle();
            if (pieLabelLinkStyle.equals(PieLabelLinkStyle.STANDARD)) {
                graphics2D.draw(new Line2D.Double(d7, d8, d9, d5));
                graphics2D.draw(new Line2D.Double(d2, d10, d9, d5));
                graphics2D.draw(new Line2D.Double(d2, d10, d3, d4));
            } else if (pieLabelLinkStyle.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float float_ = new QuadCurve2D.Float();
                ((QuadCurve2D)float_).setCurve(d3, d4, d2, d10, d9, d5);
                graphics2D.draw(float_);
                graphics2D.draw(new Line2D.Double(d9, d5, d7, d8));
            } else if (pieLabelLinkStyle.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                ((CubicCurve2D)float_).setCurve(d3, d4, d2, d10, d9, d5, d7, d8);
                graphics2D.draw(float_);
            }
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d3, (float)d4, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d2 = piePlotState.getLinkArea().getMaxX();
        double d3 = d2 + pieLabelRecord.getGap();
        double d4 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d5;
            double d6 = pieLabelRecord.getAngle();
            double d7 = piePlotState.getPieCenterX() + Math.cos(d6) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterY() - Math.sin(d6) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d9 = piePlotState.getPieCenterX() + Math.cos(d6) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d10 = d5 = piePlotState.getPieCenterY() - Math.sin(d6) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            PieLabelLinkStyle pieLabelLinkStyle = this.getLabelLinkStyle();
            if (pieLabelLinkStyle.equals(PieLabelLinkStyle.STANDARD)) {
                graphics2D.draw(new Line2D.Double(d7, d8, d9, d5));
                graphics2D.draw(new Line2D.Double(d2, d10, d9, d5));
                graphics2D.draw(new Line2D.Double(d2, d10, d3, d4));
            } else if (pieLabelLinkStyle.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float float_ = new QuadCurve2D.Float();
                ((QuadCurve2D)float_).setCurve(d3, d4, d2, d10, d9, d5);
                graphics2D.draw(float_);
                graphics2D.draw(new Line2D.Double(d9, d5, d7, d8));
            } else if (pieLabelLinkStyle.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                ((CubicCurve2D)float_).setCurve(d3, d4, d2, d10, d9, d5, d7, d8);
                graphics2D.draw(float_);
            }
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d3, (float)d4, RectangleAnchor.LEFT);
    }

    protected Point2D getArcCenter(PiePlotState piePlotState, Comparable comparable) {
        Point2D.Double double_ = new Point2D.Double(piePlotState.getPieCenterX(), piePlotState.getPieCenterY());
        double d2 = this.getExplodePercent(comparable);
        double d3 = this.getMaximumExplodePercent();
        if (d3 > 0.0) {
            d2 /= d3;
        }
        if (d2 != 0.0) {
            double d4;
            double d5;
            Rectangle2D rectangle2D = piePlotState.getPieArea();
            Rectangle2D rectangle2D2 = piePlotState.getExplodedPieArea();
            Number number = this.dataset.getValue(comparable);
            double d6 = number.doubleValue();
            if (this.direction == Rotation.CLOCKWISE) {
                d5 = piePlotState.getLatestAngle();
                d4 = d5 - d6 / piePlotState.getTotal() * 360.0;
            } else if (this.direction == Rotation.ANTICLOCKWISE) {
                d5 = piePlotState.getLatestAngle();
                d4 = d5 + d6 / piePlotState.getTotal() * 360.0;
            } else {
                throw new IllegalStateException("Rotation type not recognised.");
            }
            double d7 = d4 - d5;
            Arc2D.Double double_2 = new Arc2D.Double(rectangle2D, d5, d7 / 2.0, 0);
            Point2D point2D = double_2.getEndPoint();
            Arc2D.Double double_3 = new Arc2D.Double(rectangle2D2, d5, d7 / 2.0, 0);
            Point2D point2D2 = double_3.getEndPoint();
            double d8 = (point2D.getX() - point2D2.getX()) * d2;
            double d9 = (point2D.getY() - point2D2.getY()) * d2;
            double_ = new Point2D.Double(piePlotState.getPieCenterX() - d8, piePlotState.getPieCenterY() - d9);
        }
        return double_;
    }

    protected Paint lookupSectionPaint(Comparable comparable, PiePlotState piePlotState) {
        Paint paint = this.lookupSectionPaint(comparable, this.getAutoPopulateSectionPaint());
        if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)paint;
            Point2D point2D = this.getArcCenter(piePlotState, comparable);
            float f2 = (float)Math.max(piePlotState.getPieHRadius(), piePlotState.getPieWRadius());
            float[] fArray = radialGradientPaint.getFractions();
            Color[] colorArray = radialGradientPaint.getColors();
            paint = new RadialGradientPaint(point2D, f2, fArray, colorArray);
        }
        return paint;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PiePlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PiePlot piePlot = (PiePlot)object;
        if (this.pieIndex != piePlot.pieIndex) {
            return false;
        }
        if (this.interiorGap != piePlot.interiorGap) {
            return false;
        }
        if (this.circular != piePlot.circular) {
            return false;
        }
        if (this.startAngle != piePlot.startAngle) {
            return false;
        }
        if (this.direction != piePlot.direction) {
            return false;
        }
        if (this.ignoreZeroValues != piePlot.ignoreZeroValues) {
            return false;
        }
        if (this.ignoreNullValues != piePlot.ignoreNullValues) {
            return false;
        }
        if (!PaintUtilities.equal(this.sectionPaint, piePlot.sectionPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.sectionPaintMap, piePlot.sectionPaintMap)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseSectionPaint, piePlot.baseSectionPaint)) {
            return false;
        }
        if (this.sectionOutlinesVisible != piePlot.sectionOutlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.sectionOutlinePaint, piePlot.sectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.sectionOutlinePaintMap, piePlot.sectionOutlinePaintMap)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseSectionOutlinePaint, piePlot.baseSectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.sectionOutlineStroke, piePlot.sectionOutlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.sectionOutlineStrokeMap, piePlot.sectionOutlineStrokeMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseSectionOutlineStroke, piePlot.baseSectionOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.shadowPaint, piePlot.shadowPaint)) {
            return false;
        }
        if (this.shadowXOffset != piePlot.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != piePlot.shadowYOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(this.explodePercentages, piePlot.explodePercentages)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelGenerator, piePlot.labelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, piePlot.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelPaint, piePlot.labelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelBackgroundPaint, piePlot.labelBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelOutlinePaint, piePlot.labelOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelOutlineStroke, piePlot.labelOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelShadowPaint, piePlot.labelShadowPaint)) {
            return false;
        }
        if (this.simpleLabels != piePlot.simpleLabels) {
            return false;
        }
        if (!this.simpleLabelOffset.equals(piePlot.simpleLabelOffset)) {
            return false;
        }
        if (!this.labelPadding.equals(piePlot.labelPadding)) {
            return false;
        }
        if (this.maximumLabelWidth != piePlot.maximumLabelWidth) {
            return false;
        }
        if (this.labelGap != piePlot.labelGap) {
            return false;
        }
        if (this.labelLinkMargin != piePlot.labelLinkMargin) {
            return false;
        }
        if (this.labelLinksVisible != piePlot.labelLinksVisible) {
            return false;
        }
        if (!this.labelLinkStyle.equals(piePlot.labelLinkStyle)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelLinkPaint, piePlot.labelLinkPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelLinkStroke, piePlot.labelLinkStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, piePlot.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlGenerator, piePlot.urlGenerator)) {
            return false;
        }
        if (this.minimumArcAngleToDraw != piePlot.minimumArcAngleToDraw) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendItemShape, piePlot.legendItemShape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendLabelGenerator, piePlot.legendLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendLabelToolTipGenerator, piePlot.legendLabelToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendLabelURLGenerator, piePlot.legendLabelURLGenerator)) {
            return false;
        }
        if (this.autoPopulateSectionPaint != piePlot.autoPopulateSectionPaint) {
            return false;
        }
        if (this.autoPopulateSectionOutlinePaint != piePlot.autoPopulateSectionOutlinePaint) {
            return false;
        }
        if (this.autoPopulateSectionOutlineStroke != piePlot.autoPopulateSectionOutlineStroke) {
            return false;
        }
        return ObjectUtilities.equal(this.shadowGenerator, piePlot.shadowGenerator);
    }

    @Override
    public Object clone() {
        PiePlot piePlot = (PiePlot)super.clone();
        piePlot.sectionPaintMap = (PaintMap)this.sectionPaintMap.clone();
        piePlot.sectionOutlinePaintMap = (PaintMap)this.sectionOutlinePaintMap.clone();
        piePlot.sectionOutlineStrokeMap = (StrokeMap)this.sectionOutlineStrokeMap.clone();
        piePlot.explodePercentages = new TreeMap(this.explodePercentages);
        if (this.labelGenerator != null) {
            piePlot.labelGenerator = (PieSectionLabelGenerator)ObjectUtilities.clone(this.labelGenerator);
        }
        if (piePlot.dataset != null) {
            piePlot.dataset.addChangeListener(piePlot);
        }
        if (this.urlGenerator instanceof PublicCloneable) {
            piePlot.urlGenerator = (PieURLGenerator)ObjectUtilities.clone(this.urlGenerator);
        }
        piePlot.legendItemShape = ShapeUtilities.clone(this.legendItemShape);
        if (this.legendLabelGenerator != null) {
            piePlot.legendLabelGenerator = (PieSectionLabelGenerator)ObjectUtilities.clone(this.legendLabelGenerator);
        }
        if (this.legendLabelToolTipGenerator != null) {
            piePlot.legendLabelToolTipGenerator = (PieSectionLabelGenerator)ObjectUtilities.clone(this.legendLabelToolTipGenerator);
        }
        if (this.legendLabelURLGenerator instanceof PublicCloneable) {
            piePlot.legendLabelURLGenerator = (PieURLGenerator)ObjectUtilities.clone(this.legendLabelURLGenerator);
        }
        return piePlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.sectionPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseSectionPaint, objectOutputStream);
        SerialUtilities.writePaint(this.sectionOutlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseSectionOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.sectionOutlineStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseSectionOutlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.shadowPaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.labelOutlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.labelShadowPaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelLinkPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.labelLinkStroke, objectOutputStream);
        SerialUtilities.writeShape(this.legendItemShape, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.sectionPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseSectionPaint = SerialUtilities.readPaint(objectInputStream);
        this.sectionOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.baseSectionOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.sectionOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.baseSectionOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.labelOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.labelShadowPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelLinkStroke = SerialUtilities.readStroke(objectInputStream);
        this.legendItemShape = SerialUtilities.readShape(objectInputStream);
    }

    public Paint getSectionPaint(int n2) {
        Comparable comparable = this.getSectionKey(n2);
        return this.getSectionPaint(comparable);
    }

    public void setSectionPaint(int n2, Paint paint) {
        Comparable comparable = this.getSectionKey(n2);
        this.setSectionPaint(comparable, paint);
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getSectionOutlinePaint(int n2) {
        Comparable comparable = this.getSectionKey(n2);
        return this.getSectionOutlinePaint(comparable);
    }

    public void setSectionOutlinePaint(int n2, Paint paint) {
        Comparable comparable = this.getSectionKey(n2);
        this.setSectionOutlinePaint(comparable, paint);
    }

    public Stroke getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Stroke stroke) {
        this.sectionOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Stroke getSectionOutlineStroke(int n2) {
        Comparable comparable = this.getSectionKey(n2);
        return this.getSectionOutlineStroke(comparable);
    }

    public void setSectionOutlineStroke(int n2, Stroke stroke) {
        Comparable comparable = this.getSectionKey(n2);
        this.setSectionOutlineStroke(comparable, stroke);
    }

    public double getExplodePercent(int n2) {
        Comparable comparable = this.getSectionKey(n2);
        return this.getExplodePercent(comparable);
    }

    public void setExplodePercent(int n2, double d2) {
        Comparable comparable = this.getSectionKey(n2);
        this.setExplodePercent(comparable, d2);
    }
}

