/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.io.Serializable;
import org.jfree.text.TextBox;

public class PieLabelRecord
implements Serializable,
Comparable {
    private Comparable key;
    private double angle;
    private double baseY;
    private double allocatedY;
    private TextBox label;
    private double labelHeight;
    private double gap;
    private double linkPercent;

    public PieLabelRecord(Comparable comparable, double d2, double d3, TextBox textBox, double d4, double d5, double d6) {
        this.key = comparable;
        this.angle = d2;
        this.baseY = d3;
        this.allocatedY = d3;
        this.label = textBox;
        this.labelHeight = d4;
        this.gap = d5;
        this.linkPercent = d6;
    }

    public double getBaseY() {
        return this.baseY;
    }

    public void setBaseY(double d2) {
        this.baseY = d2;
    }

    public double getLowerY() {
        return this.allocatedY - this.labelHeight / 2.0;
    }

    public double getUpperY() {
        return this.allocatedY + this.labelHeight / 2.0;
    }

    public double getAngle() {
        return this.angle;
    }

    public Comparable getKey() {
        return this.key;
    }

    public TextBox getLabel() {
        return this.label;
    }

    public double getLabelHeight() {
        return this.labelHeight;
    }

    public double getAllocatedY() {
        return this.allocatedY;
    }

    public void setAllocatedY(double d2) {
        this.allocatedY = d2;
    }

    public double getGap() {
        return this.gap;
    }

    public double getLinkPercent() {
        return this.linkPercent;
    }

    public int compareTo(Object object) {
        int n2 = 0;
        if (object instanceof PieLabelRecord) {
            PieLabelRecord pieLabelRecord = (PieLabelRecord)object;
            if (this.baseY < pieLabelRecord.baseY) {
                n2 = -1;
            } else if (this.baseY > pieLabelRecord.baseY) {
                n2 = 1;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieLabelRecord)) {
            return false;
        }
        PieLabelRecord pieLabelRecord = (PieLabelRecord)object;
        if (!this.key.equals(pieLabelRecord.key)) {
            return false;
        }
        if (this.angle != pieLabelRecord.angle) {
            return false;
        }
        if (this.gap != pieLabelRecord.gap) {
            return false;
        }
        if (this.allocatedY != pieLabelRecord.allocatedY) {
            return false;
        }
        if (this.baseY != pieLabelRecord.baseY) {
            return false;
        }
        if (this.labelHeight != pieLabelRecord.labelHeight) {
            return false;
        }
        if (this.linkPercent != pieLabelRecord.linkPercent) {
            return false;
        }
        return this.label.equals(pieLabelRecord.label);
    }

    public String toString() {
        return this.baseY + ", " + this.key.toString();
    }
}

